/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sFyU
 */

// forked from rxheart257's 最終課題：ミニゲーム「さめがめ」
package
{
    import flash.display.Sprite;
    public class Main extends Sprite
    {
        public function Main()
        {
            var panel : Panel = new Panel();
            addChild(panel);
        }
    }
}
import flash.text.*;
import flash.net.*;
import flash.text.TextField;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.BevelFilter;
import flash.geom.Point;
import flash.media.Sound;
import flash.utils.getTimer;
import org.libspark.betweenas3.BetweenAS3;
import net.wonderfl.score.basic.*;
class Panel extends Sprite
{
    public static const WIDTH : int = 10;
    public static const HEIGHT : int = 10;
    private var blocks : Array;
    private var sound : Sound;
    private var stime : int;
    private var ten : int;
    public function Panel()
    {
        createBlocks();
        var soundReq : URLRequest;
        soundReq = new URLRequest("http://www5b.biglobe.ne.jp/~pengin1/mqo/hanabi.mp3");
        sound = new Sound(soundReq);
        sound.play();
        stime = getTimer();
    }
    private function createBlocks() : void
    {
        blocks = [];
        for (var y : int = 0; y < HEIGHT; y++)
        {
            blocks[y] = [];
            for (var x : int = 0; x < WIDTH; x++)
            {
                var block : Block = new Block();
                block.x = x * Block.WIDTH;
                block.y = y * Block.HEIGHT;
                addChild(block);
                blocks[y][x] = block;
            }
        }
    }
    public function searchBlock(block : Block) : Point
    {
        sound.play();
        for (var y : int = 0; y < HEIGHT; y++)
        {
            for (var x : int = 0; x < WIDTH; x++)
            {
                if (blocks[y][x] == block)
                {
                    return new Point(x, y);
                }
            }
        }        
        return null; 
    }
    public function deleteBlock(tx : int, ty : int, color : int) : void
    {
        if (tx < 0 || WIDTH  <= tx || ty < 0 || HEIGHT <= ty) return; 
        if (blocks[ty][tx] == null) return;
        if (blocks[ty][tx].color != color) return;
        removeChild(blocks[ty][tx]);
        blocks[ty][tx] = null;
        deleteBlock(tx - 1, ty, color); 
        deleteBlock(tx + 1, ty, color); 
        deleteBlock(tx, ty - 1, color); 
        deleteBlock(tx, ty + 1, color); 
    }
    public function vPack() : void
    {
        for (var x : int = 0; x < WIDTH; x++)
        {
            for (var y : int = HEIGHT - 1; y >= 0; y--)
            {
                if (blocks[y][x] == null) 
                {
                    for (var yy : int = y - 1; yy >= 0; yy--) 
                    {
                        if (blocks[yy][x] != null)                        {
                            blocks[y][x] = blocks[yy][x]; 
                            blocks[yy][x] = null;    
                            BetweenAS3.tween(blocks[y][x], {y : y * Block.HEIGHT}, null, 0.6).play(); 
                            break;
                        }
                    }
                }
            }
        }
    }
    public function hPack() : void
    {
        var y : int = HEIGHT - 1; 
        for (var x : int = 0; x < WIDTH; x++)
        {
            if (blocks[y][x] == null)
            {
                for (var xx : int = x + 1; xx < WIDTH; xx++)
                {
                    if (blocks[y][xx] != null)
                    {
                        for (var yy : int = HEIGHT - 1; yy >= 0; yy--)
                        {
                            if (blocks[yy][xx] == null) break;
                            blocks[yy][x] = blocks[yy][xx];
                            blocks[yy][xx] = null; 
                            BetweenAS3.tween(blocks[yy][x], {x : x * Block.WIDTH}, null, 0.6).play(); 
                        }
                        break;
                    }
                }
            }
        }
    }
    public function colorCheck(tx : int, ty : int, color : int) : Boolean
    {
        var check : Boolean = false;
        if (0 <= tx - 1 && blocks[ty][tx - 1] != null && blocks[ty][tx - 1].color == color) check = true;
        else if (tx + 1 < WIDTH && blocks[ty][tx + 1] != null && blocks[ty][tx + 1].color == color) check = true;
        else if (0 <= ty - 1 && blocks[ty - 1][tx] != null && blocks[ty - 1][tx].color == color) check = true;
        else if (ty + 1 < HEIGHT && blocks[ty + 1][tx] != null && blocks[ty + 1][tx].color == color) check = true;
        return check;
    }
    public function endCheck() : Boolean
    {
        for (var y : int = 0; y < HEIGHT; y++)
        {
            for (var x : int = 0; x < WIDTH; x++)
            {
                if (blocks[y][x] == null) continue;
                if (colorCheck(x, y, blocks[y][x].color)) return false;
            }
        }
        return true;
    }
    public function zan() : int
    {
        var t : int = 0;
        for (var y : int = 0; y < HEIGHT; y++)
        {
            for (var x : int = 0; x < WIDTH; x++)
            {
                if (blocks[y][x] == null)
                {
                    t++;
                }    
            }
        }
        return t;
    }
    public function endmese() : void
    {
        var txt: TextField = new TextField();
        txt.x = 100;
        txt.y = 50;
        txt.width = 350;
        txt.height = 90;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        var tf: TextFormat = new TextFormat();
        tf.font = "Font Bold";
        tf.size = 60;
        tf.align = TextFormatAlign.CENTER;
        txt.textColor = 0xFF0000;
        txt.defaultTextFormat = tf;
        addChild(txt);
        ten = 100 - Math.floor((getTimer() - stime) / 1000);
        ten += zan();
        txt.text = "end " + ten  + " ten";
        ranking();
    }
    private var _form : BasicScoreForm;
    private function ranking() : void
    {
        _form = new BasicScoreForm(this, (465 - BasicScoreForm.WIDTH) / 2, (465 - BasicScoreForm.HEIGHT) / 2, ten, 'SAVE SCORE', showRanking);
    }
    private function showRanking($didSavedScore : Boolean) : void 
    {
        removeChild(_form);
        var ranking : BasicScoreRecordViewer = new BasicScoreRecordViewer(this, (465 - BasicScoreRecordViewer.WIDTH) / 2, (465 - BasicScoreRecordViewer.HEIGHT) / 2, 'RANKING', 30, true);
    }
}
class Block extends Sprite
{
    public static const COLORS : Array = [0xED1A3D, 0x00B16B, 0x007DC5];
    public static const WIDTH : int = 31; 
    public static const HEIGHT : int = 31; 
    public static const MARGIN_W : int = 1;
    public static const MARGIN_H : int = 1;
    public static const ELLIPSE_WIDTH : int = 15;
    public static const ELLIPSE_HEIGHT : int = 15;
    public var color : int;
    public function Block()
    { 
        graphics.beginFill(0x0, 0);
        graphics.drawRect(0, 0, WIDTH, HEIGHT);
        graphics.endFill();
        color = COLORS[int(Math.random() * COLORS.length)];
        graphics.beginFill(color);
        graphics.drawRoundRect(MARGIN_W, MARGIN_H, WIDTH - MARGIN_W * 2, HEIGHT - MARGIN_H * 2, ELLIPSE_WIDTH, ELLIPSE_HEIGHT);
        graphics.endFill();
        this.filters = [new BevelFilter(4, 45, 0xFFFFFF, 1, 0x0, 1, 20, 20, 1, 3, "inner")];
        addEventListener(MouseEvent.CLICK, onMouseDown);
    }
    private function onMouseDown(event : MouseEvent) : void 
    {
        var panel : Panel = this.parent as Panel
        var point : Point = panel.searchBlock(this);
        if (point)
        {
            if (!panel.colorCheck(point.x, point.y, color)) return;
            panel.deleteBlock(point.x, point.y, this.color);
            panel.vPack();
            panel.hPack();
            if (panel.endCheck())
            {
                panel.endmese()
            }
        }
    }
}
