/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sEnK
 */

// forked from mutantleg's flash on 2015-2-1
package {
    import flash.text.TextField;
    import flash.geom.ColorTransform;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            deb = new TextField();
            deb.width = 320; deb.height=240; deb.mouseEnabled=false;
            deb.textColor=0xFF0000;
            addChild(deb);
            
            var f:int;
            f = 1 | 2 | 4 | 8;
            deb.text = "" + (f & 16);
            
            pic = new BitmapData(128,128, false, 0);
            map = new BitmapData(pic.width, pic.height, false, 0);
            
            canvas = new BitmapData(pic.width, pic.height, false, 0);
            
            customise = new Customiser(stage);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var customise:Customiser;
        
        public var deb:TextField;
        
        public function onMdown(e:MouseEvent):void { mdown = 1; }
        public function onMup(e:MouseEvent):void { mdown = 0; }        
        public var mdown:int = 0;
        
        public var pic:BitmapData;
        public var map:BitmapData;
        public var canvas:BitmapData;
        public var mat:Matrix = new Matrix();
        
        public var gt:int = 0;
        
        public var ct:ColorTransform = new ColorTransform(1,1,1,0.5);
        
        public function onEnter(e:Event):void
        {
            var cw:Number; var ch:Number;
            var mx:Number; var my:Number;
            var tx:int; var ty:int;            

            cw = 8; ch = 8;

            mx = stage.mouseX; my = stage.mouseY;
            tx = Math.floor(mx/cw);  ty = Math.floor(my/ch);
            
            mat.a = cw;        mat.d = ch;

            if (mdown > 0) 
            {
                 pic.setPixel(tx,ty, 0xFF);
                 pic.setPixel(tx+1,ty, 0xFF);
                 pic.setPixel(tx,ty+1, 0xFF);
             }
            
          //  if (gt % 4 ==0 && mdown <= 0)
            {
            var c:int; var t:int;
            var c2:int;
            var i:int; var k:int; var v:int; var f:int;
            var mw:int; var mh:int;
            t = 64;
            mw = pic.width; mh = pic.height;
            map.fillRect(map.rect, 0);
            for (i = 0; i < mh; i++)
            for (k = 0; k < mw; k++)
            {
               c = pic.getPixel(k, i);
               c -= 16; if (c < 16) { c =0; }
               pic.setPixel(k,i, c);
               
               v = 0; f = 0;
               if ( pic.getPixel(k+1, i)>t )  { v += 1; f |= 1; }
               if ( pic.getPixel(k-1, i)>t )  { v += 1; f |= 2; }
               if ( pic.getPixel(k, i+1)>t )  { v += 1; f |= 4; }
               if ( pic.getPixel(k, i-1)>t )  { v += 1; f |= 8; }
               if ( pic.getPixel(k+1, i+1)>t )  { v += 1; f |= 16; }
               if ( pic.getPixel(k-1, i+1)>t )  { v += 1; f |= 32; }
               if ( pic.getPixel(k+1, i-1)>t )  { v += 1; f |= 64; }
               if ( pic.getPixel(k-1, i-1)>t )  { v += 1; f |= 128; }

               if (v == customise.values[1].value || v > customise.values[2].value){ pic.setPixel(k,i, 0xFF);  }
             
             /*
              if (c <255)
              if ((f & 8) > 0) 
              {
                  c2 = pic.getPixel(k,i-1); c2 -= 32; if (c2 <= 0) {c2 = 0; }
                  pic.setPixel(k,i-1,c2);
                  c+=32; if (c >= 255) { c = 255; }
                  pic.setPixel(k,i, c); 
              }
                 */
                 
               //if (c == 0 && (f&15)==15 || (f&240)==240 ) { pic.setPixel(k,i,0xFF); }
               
               if (c <= 0 ) { continue; }
               
               //if (v >= 5) { pic.setPixel(k,i, 0);  }
               //if (v < 2) { pic.setPixel(k,i, 0);  }
               
               map.setPixel(k,i, customise.values[0].value + (0x22000*v));
               
            }//nextk
            }
            canvas.draw(pic);
            canvas.draw(map, null, ct);            
            
            graphics.clear();
            graphics.beginBitmapFill(canvas, mat,false, false);
             graphics.drawRect(0,0,465,465);
            graphics.endFill();

            graphics.lineStyle(2, 0xFF0000,0.5);
            graphics.drawRect(tx*cw,ty*ch,cw,ch);
            
 
             gt += 1;           
        }//onenter
    }//classend
}
import flash.text.TextField;
import flash.events.MouseEvent;
import flash.display.Stage;
import flash.display.Sprite;

Class {
    class Customiser extends Sprite {
        public var values:Vector.<Slider>;
        public function Customiser(stage:Stage) {
            values = new Vector.<Slider>();
            values.push( new Slider(stage.stageWidth/2,0,0xffffff), new Slider(stage.stageWidth/2,0,8),
                new Slider(stage.stageWidth/2,0,8) );
            this.x = stage.stageWidth/2;
            stage.addChild(this);
            this.alpha = 0.5;
            this.graphics.beginFill(0xffffff);
            this.graphics.drawRect(0,0,stage.stageWidth/2,stage.stageHeight/2);
            this.graphics.endFill();
            
            for(var i:int = 0; i<values.length; i++){
                values[i].y = i*30+10;
                addChild(values[i]);
            }
        }
    }
    class Slider extends Sprite {
        public static var colorNow:uint = 0x00ff00;
        public var value:Number;
        private var step:Number;
        private var thumb:Sprite;
        private var field:Sprite;
        private var myColor:uint;
        private var W:Number;
        private var view:TextField;
        private var max:Number;
        private var min:Number;
        private var valIsColor:String = '';
        public function Slider(width:Number, min:Number=0, max:Number=100, useValAsColor:String='') {
            this.alpha = 0.5;
            this.W = width;
            this.view = new TextField();
            this.step = Math.round(max-min/10);
            this.value = min;
            this.max = max;
            this.min = min;
            this.valIsColor = useValAsColor;
            view.autoSize = 'left';
            view.x = width/2;
            view.y = 2;
            view.text = min.toString();
            myColor = colorNow;
            colorNow += 0xff;
            field = new Sprite();
            field.graphics.beginFill(0xffffff);
            field.graphics.drawRect(10,0,width-20,20);
            addChild(field);
            thumb = new Sprite();
            addChild(thumb);
            addChild(view);
            field.addEventListener(MouseEvent.CLICK, changeValue);
            //field.addEventListener(MouseEvent.MOUSE_MOVE, changeValue);
            thumb.addEventListener(MouseEvent.CLICK, changeValue);
            //thumb.addEventListener(MouseEvent.MOUSE_MOVE,changeValue);
        }
        public function changeValue(e:MouseEvent):void {
            var clickTo:Number = e.localX;
            thumb.graphics.clear();
            if(valIsColor == 'red'){
                thumb.graphics.beginFill(value*0x10000);
            } else if(valIsColor == 'green') {
                thumb.graphics.beginFill(value*0x100);
            } else if(valIsColor == 'blue') {
                thumb.graphics.beginFill(value);
            } else {
                thumb.graphics.beginFill(myColor);
            }

            thumb.graphics.drawRect(10,0,clickTo-10,20);
            // calculate new value -- field.width | clickTo | step
            // this.value = надо превраить ширину thumb в конкретное значение сперва нужно поссчитать процент который thumb занимает на field
            var percent:Number = thumb.width/(field.width/100);
            // теперь нужно понять какое значение соответствует этому проценту... значение лежит между min max
            var data:Number = (max - min)/100;    // Один процент... данных
            value = Math.round(percent*data);    // Значение - процент данных умноженный на процент от 
            if(value > max){
                value = max;
            }
            view.text = this.value.toString();
        }

    }
}
