/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sD5Y
 */

// forked from euakast's Mathematics Sketch
package  
{
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class MathematicsVector extends Sprite
    {
        private var _center:Vec2d;
        private var _container:Sprite;
        
        private var _rotateSpeed:Number;
        
        private var _point:PointSprite;
        private var _pointVec:Vec2d;
        
        private var _lineStartPoint:Vec2d;
        private var _lineEndPoint:Vec2d;
        
        private var _circleLabel:Label;
        
        public function MathematicsVector() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            _center = new Vec2d(stage.stageWidth * 0.5, stage.stageHeight * 0.5);
            _rotateSpeed = 0.01;
            _pointVec = new Vec2d(150, 0);
            _lineStartPoint = new Vec2d( -_center.x, -_center.y);
            _lineEndPoint = new Vec2d(_center.x, _center.y);
            
            _container = new Sprite();
            _container.x = _center.x;
            _container.y = _center.y;
            addChild(_container);
            
            _point = new PointSprite(_pointVec.x, _pointVec.y);
            _container.addChild(_point);
            
            drawInterface();
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void 
        {
            // UPDATE
            _lineStartPoint.rotate(_rotateSpeed);
            _lineEndPoint.rotate(_rotateSpeed);
            _pointVec.x = _point.x;
            _pointVec.y = _point.y;
            
            var norm:Vec2d = _lineEndPoint.sub(_lineStartPoint).normalized();
            var connectVec:Vec2d = norm.scale(_pointVec.dot(norm));
            
            // CLEAR
            _container.graphics.clear();
            _container.graphics.lineStyle(1.0);
            
            // DRAW LINE
            _container.graphics.lineStyle(2.0);
            _container.graphics.moveTo(_lineStartPoint.x, _lineStartPoint.y);
            _container.graphics.lineTo(_lineEndPoint.x, _lineEndPoint.y);
            
            // DRAW CIRCLE
            var circleVec:Vec2d = _pointVec.sub(connectVec);
            circleVec = circleVec.scale(0.5);
            _container.graphics.lineStyle(1.0, 0x0000FF);
            _container.graphics.drawCircle(_pointVec.x - circleVec.x, _pointVec.y - circleVec.y, circleVec.length);
            _circleLabel.text = "Circle Radius = " + circleVec.length * 0.5;
            
            // DRAW CONNECT LINE
            _container.graphics.lineStyle(1.0, 0xFF0000);
            _container.graphics.moveTo(_point.x, _point.y);
            _container.graphics.lineTo(connectVec.x, connectVec.y);
            
            // DRAW CONNECT POINT
            _container.graphics.beginFill(0xFF0000);
            _container.graphics.drawCircle(connectVec.x, connectVec.y, 4);
            _container.graphics.endFill();
        }
        
        private function drawInterface():void
        {
            var vBox:VBox = new VBox(this, 10, 10);
            vBox.spacing = 0;
            var fps:FPSMeter = new FPSMeter(vBox);
            var rotateSpeedSlider:HUISlider = new HUISlider(vBox, 0, 0, "Rotate Speed", function():void {
                _rotateSpeed = rotateSpeedSlider.value * 0.1;
            });
            rotateSpeedSlider.minimum = 0;
            rotateSpeedSlider.maximum = 1.0;
            rotateSpeedSlider.value = 0.1;
            
            _circleLabel = new Label(vBox, 0, 0);
        }
    }

}

import flash.events.MouseEvent;
class PointSprite extends flash.display.Sprite {
    public function PointSprite(x:Number, y:Number) {
        this.x = x;
        this.y = y;
        buttonMode = true;
        draw();
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
    }
    private function draw():void {
        graphics.beginFill(0x0);
        graphics.drawCircle(0, 0, 4);
        graphics.endFill();
    }
    private function mouseDownHandler(e:MouseEvent):void {
        startDrag();
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
    }
    private function mouseUpHandler(e:MouseEvent):void {
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        stopDrag();
    }
}

class Vec2d {
    public var x:Number, y:Number;
    public function Vec2d(ax:Number = 0.0, ay:Number = 0.0) { x = ax; y = ay; }
    public function clone():Vec2d { return new Vec2d(x, y); }
    public function set(ax:Number, ay:Number):void { x = ax; y = ay; }
    public function get length():Number { return Math.sqrt(x * x + y * y); }
    public function set length(value:Number):void { var a:Number = angle; x = Math.cos(a) * value; y = Math.sin(a) * value; }
    public function get lengthSqrt():Number { return x * x + y * y; }
    public function get angle():Number { return Math.atan2(y, x); }
    public function normalize():void { var invS:Number = 1 / length; x *= invS; y *= invS; }
    public function normalized():Vec2d { var invS:Number = 1 / length; return new Vec2d(x * invS, y * invS); }
    public function add(rhs:Vec2d):Vec2d { return new Vec2d(x + rhs.x, y + rhs.y); }
    public function sub(rhs:Vec2d):Vec2d { return new Vec2d(x - rhs.x, y - rhs.y); }
    public function mul(rhs:Vec2d):Vec2d { return new Vec2d(x * rhs.x, y * rhs.y); }
    public function div(rhs:Vec2d):Vec2d { return new Vec2d(x / rhs.x, y / rhs.y); }
    public function dot(rhs:Vec2d):Number { return x * rhs.x + y * rhs.y; }
    public function cross(rhs:Vec2d):Number { return x * rhs.y - y * rhs.x; }
    public function scale(s:Number):Vec2d { return new Vec2d(x * s, y * s); }
    public function distance(rhs:Vec2d):Number { var dx:Number = x - rhs.x; var dy:Number = y - rhs.y; return Math.sqrt(dx * dx + dy * dy); }
    public function distanceSqrd(rhs:Vec2d):Number { var dx:Number = x - rhs.x; var dy:Number = y - rhs.y; return dx * dx + dy * dy; }
    public function rotate(angle:Number):void { var cosa:Number = Math.cos(angle); var sina:Number = Math.sin(angle); var rx:Number = x * cosa - y * sina; y = x * sina + y * cosa; x = rx; }
    public function truncate(max:Number):void { this.length = Math.min(max, this.length); }
}
