/**
 * Copyright hacker_961091 ( http://wonderfl.net/user/hacker_961091 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sCiy
 */

package
{
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.Timer;

import mx.utils.ObjectUtil;

public class FlashTest extends Sprite
{

private static const BOX_X_COUNT:int = 46;
private static const BOX_Y_COUNT:int = 43;
private static const BOX_WIDTH:int = 10;
private static const BOX_HEIGHT:int = 10;
private static const BOX_ON_COLOR:int = 0x0033FF;
private static const BOX_OFF_COLOR:int = 0xFFFFFF;
private static const BOX_BORDERLINE_COLOR:int = 0xCCCCCC;
private static const GAME_WIDTH:Number = BOX_WIDTH * BOX_X_COUNT;
private static const GAME_HEIGHT:Number = BOX_HEIGHT * BOX_Y_COUNT;
private static const BOX_Y_LINE:int = 1;
private static const BOX_X_LINE:int = 1;

private var cntGneration:Number = 0;

private var boxArray:Array = new Array();

private var header:Sprite;
private var box:Sprite;
private var line:Sprite;

private var btnEdit:Sprite;
private var btnStart:Sprite;
private var btnStop:Sprite;
private var btnClear:Sprite;
private var lblGeneration:TextField;

private var timer:Timer = new Timer(500);

private var isEditMode:Boolean = false;
private var isEditClick:Boolean = false;

public function FlashTest()
{
	super();

	box = new Sprite();
	box.addEventListener(MouseEvent.CLICK,onBoxClick,false,0,true);
	this.addChild(box);

	header = createHeader();
	this.addChild(header);

	line = createLine();
	this.addChild(line);

	line.y = box.y = 20;
	
	timer.addEventListener(TimerEvent.TIMER,onTimer,false,0,true);
	
	createBoxArray();
	setBox();
}

private function onTimer(event:TimerEvent):void
{
	nextGeneration();
}

public function setBox():void
{
	clear();
	createBg();

	for(var x:Number=1;x<=BOX_X_COUNT;x++){
		for(var y:Number=1;y<=BOX_Y_COUNT;y++){
			if(boxArray[x][y]==1) createBox(x,y);
		}
	}
}

private function createBox(x:int,y:int):void
{
	var x:int = (x-1) * BOX_WIDTH;
	var y:int = (y-1) * BOX_HEIGHT;
	setSquare(box,x,y,BOX_WIDTH,BOX_HEIGHT,BOX_ON_COLOR);
}

private function clear():void
{
	box.graphics.clear();
}

private function createBg():void
{
	setSquare(box,0,0,GAME_WIDTH,GAME_HEIGHT,BOX_OFF_COLOR);
}

private function createBoxArray():void
{
	for(var x:Number=0;x<BOX_X_COUNT + 2;x++){
		for(var y:Number=0;y<BOX_Y_COUNT + 2;y++){
			addBox(x,y);
		}
	}
}

private function addBox(x:int,y:int):void
{
	if(boxArray[x] == null) boxArray[x] = new Array();
	boxArray[x][y] = 0; //初期化
}

private function onBoxClick(event:MouseEvent):void
{
	if(isEditMode == false) return;
	
	var ptX:int;
	var ptY:int;
	var ptFrom:Number;
	var ptTo:Number;

	for(var x:Number=1;x<=BOX_X_COUNT;x++){
		ptFrom = (x-1) * BOX_WIDTH;
		ptTo = (x-1) * BOX_WIDTH + BOX_WIDTH;
		if(ptFrom <= event.localX && event.localX < ptTo){
			ptX = x;
			break;
		}
	}

	for(var y:Number=1;y<=BOX_Y_COUNT;y++){
		ptFrom = (y-1) * BOX_HEIGHT;
		ptTo = (y-1) * BOX_HEIGHT + BOX_HEIGHT;
		if(ptFrom <= event.localY && event.localY < ptTo){
			ptY = y;
			break;
		}
	}

	setReverce(ptX,ptY);
}

private function getGnerationLabel():String
{
	return "第" + cntGneration + "世代";
}

private function resetCountGneration():void
{
	cntGneration = 0;
	updateState();
}

private function setReverce(x:int,y:int):void
{
	boxArray[x][y] = (boxArray[x][y]==1) ? 0:1;
	updateState();
}

private function setBox2(x:int,y:int):Boolean
{
	var count:Number = 0;
	count += boxArray[x-1][y-1]; //LT
	count += boxArray[x][y-1]; //T
	count += boxArray[x+1][y-1]; //RT
	count += boxArray[x-1][y]; //L
	count += boxArray[x+1][y]; //R
	count += boxArray[x-1][y+1]; //LB
	count += boxArray[x][y+1]; //B
	count += boxArray[x+1][y+1]; //RB

	if(boxArray[x][y] == 1){ //自分が生の状態
		return (count == 2 || count == 3);
	}

	return (count == 3); //自分が死の状態
}

private function nextGeneration():void
{
	var tmpArray:Array = ObjectUtil.copy(boxArray) as Array;
	for(var x:int=1;x<=BOX_X_COUNT;x++){
		for(var y:int=1;y<=BOX_Y_COUNT;y++){
			tmpArray[x][y] = setBox2(x,y);
		}
	}
	boxArray = tmpArray;
	cntGneration++;
	updateState();
}

private function reverceEditMode():void
{
	isEditMode = !isEditMode;
	line.visible = isEditMode;

	if(isEditClick) return;

	btnStart.visible = true;
	btnClear.visible = true;
}

private function createLine():Sprite
{
	var sp:Sprite = new Sprite();
	sp.mouseChildren = false;
	sp.mouseEnabled = false;
	sp.visible = false;

	var i:int;
	for(i=0;i<=BOX_X_COUNT;i++){
		var x:Number = i * BOX_WIDTH;
		setLine(sp,x,0,x,GAME_HEIGHT,BOX_BORDERLINE_COLOR);
	}

	for(i=0;i<=BOX_Y_COUNT;i++){
		var y:Number = i * BOX_HEIGHT;
		setLine(sp,0,y,GAME_WIDTH,y,BOX_BORDERLINE_COLOR);
	}

	return sp;
}

private function createHeader():Sprite
{
	var posX:int = 10;
	var header:Sprite = new Sprite();

	var lblTitle:TextField = createText("LIFE GAME",0x333333);
	lblTitle.width = 70;
	lblTitle.x = posX;
	lblTitle.y = 4;
	posX += 70;
	header.addChild(lblTitle);

	posX += 10;

	btnEdit = createButton("EDIT");
	btnEdit.addEventListener(MouseEvent.CLICK,onClick,false,0,true);
	btnEdit.x = posX;
	posX += 50;
	header.addChild(btnEdit);

	posX += 10;

	btnStart = createButton("START");
	btnStart.addEventListener(MouseEvent.CLICK,onClick,false,0,true);
	btnStart.x = posX;
	btnStart.visible = false;
	posX += 50;
	header.addChild(btnStart);

	posX += 10;

	btnStop = createButton("STOP");
	btnStop.addEventListener(MouseEvent.CLICK,onClick,false,0,true);
	btnStop.x = posX;
	btnStop.visible = false;
	posX += 50;
	header.addChild(btnStop);

	posX += 10;

	btnClear = createButton("CLEAR");
	btnClear.addEventListener(MouseEvent.CLICK,onClick,false,0,true);
	btnClear.x = posX;
	btnClear.visible = false;
	posX += 50;
	header.addChild(btnClear);

	posX += 10;

	lblGeneration = createText("　　　　",0x333333);
	lblGeneration.x = posX;
	posX += 50;
	header.addChild(lblGeneration);

	return header;
}

private function btnStartMode(value:Boolean):void
{
	btnEdit.visible = value;
	btnClear.visible = value;
	btnStart.visible = value;
	btnStop.visible = !value;
}

public function changeEditMode(value:Boolean):void
{
	isEditMode = value;
	editChange();
}

private function editChange():void
{
	line.visible = isEditMode;
}

private function updateState():void
{
	lblGeneration.text = getGnerationLabel();
	setBox();
}

private function onClick(event:MouseEvent):void
{
	if(event.currentTarget == btnEdit){
		reverceEditMode();
		isEditClick = true;
		return;
	}

	if(event.currentTarget == btnStart){
		btnStartMode(false);
		changeEditMode(false);
		timer.start();
		return;
	}

	if(event.currentTarget == btnStop){
		btnStartMode(true);
		timer.stop();
		return;
	}

	if(event.currentTarget == btnClear){
		onClickStop(null);
		clearBox();
		return;
	}
}

private function clearBox():void
{
	for(var x:int=1;x<=BOX_X_COUNT;x++){
		for(var y:int=1;y<=BOX_Y_COUNT;y++){
			boxArray[x][y] = false;
		}
	}
	resetCountGneration();
}

private function onClickStop(event:MouseEvent):void
{
	btnStartMode(true);
	timer.stop();
}

private function createButton(value:String):Sprite
{
	var btn:Sprite = new Sprite();
	btn.buttonMode = true;
	setSquare(btn,0,0,50,20,0x333333);

	var txt:TextField = createText(value);
	btn.addChild(txt);
	return btn;
}

private function createText(value:String,color:int=0xFFFFFF):TextField
{
	var txt:TextField = new TextField();
	txt.text = value;
	txt.width = 50;
	txt.height = 20;
	txt.y = 2;
	txt.autoSize = TextFieldAutoSize.CENTER;
	txt.textColor = color;
	txt.mouseEnabled = false;
	setTxtFormat(txt);
	return txt;
}

private function setTxtFormat(txt:TextField):void
{
	var tf:TextFormat = new TextFormat();
	tf.font = "Arial";
	tf.leading = 2;
	txt.defaultTextFormat = tf;
}

private function setSquare(sp:Sprite,x:int,y:int,w:int,h:int,color:int=0xFFFFFF):void
{
	if(sp == null) sp = new Sprite();
	sp.graphics.beginFill(color);
	sp.graphics.drawRect(x,y,w,h);
}

private function setLine(sp:Sprite,x:int,y:int,x2:int,y2:int,color:int=0xFFFFFF,thickness:int=1):void
{
	if(sp == null) sp = new Sprite();
	sp.graphics.lineStyle(thickness,color,1);
	sp.graphics.moveTo(x,y);
	sp.graphics.lineTo(x2,y2);
}

}
}