/**
 * Copyright chiori175 ( http://wonderfl.net/user/chiori175 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sCRH
 */

// forked from shmdmoto's 画像ファイルの表示
package 
{
    import flash.events.KeyboardEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import frocessing.display.F5MovieClip2D;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent; 
    import frocessing.display.F5MovieClip2D;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    /**
     * 画像ファイルの表示と位置の変更
     * @author shmdmoto
     */
    public class miniGame1 extends F5MovieClip2D
    {
    /**
     * マウスをクリックすると円の色が変わる
     * @author shmdmoto
     */
        public var posX:Number; // クリックした場所のx座標
        public var posY:Number; // クリックした場所のY座標
        public var px:int;
        public var py:int;
        public var pw:int;
        public var ph:int;
        public var pw_s:int;
        public var ph_s:int;
        public var pww:int;
        public var phh:int;
        public var fCol:Number;
        public var posColor:Array;
        public var lighton:Number;
        public var lightoff:Number;
        public var imgLoader:Loader;
        public var snd:Sound;
        public function miniGame1() {
            super(false);
        }
        public function setup() : void
        {
            lighton = 500;
            lightoff = 0;
            posColor = new Array(16);
            for(var i:int = 0; i < 16; i++){
                posColor[i] = lightoff;
            }
            
            change(random(3), random(3));
            change(random(3), random(3));
            change(random(3), random(3));
            change(random(3), random(3));
            change(random(3), random(3));
            /*
            posColor[1] = lighton;
            posColor[2] = lighton;
            posColor[4] = lighton;
            posColor[7] = lighton;
            posColor[9] = lighton;
            posColor[10] = lighton;
            */
            
            snd = new Sound();
            snd.load( new URLRequest("http://www.motoike.net/wonderfl/sesample.mp3") );
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        public function draw() : void
        {
            noStroke();
            pw = 80;
            ph = 80;
            pww = 40;
            phh = 40;
            pw_s = 0;
            ph_s = 0;
            for(var i:int = 0; i < 4; i++){
                for(var j:int = 0; j < 4; j++){
                    fill(posColor[(i * 4) + j]);
                    px = ((j % 4) * pw) + pww + pw_s * j;
                    py = i * ph + phh + ph_s * i;
                
                    ellipse(px, py, pw, ph);
                }
            }
        }
        public function colorchange(xxx:int, yyy:int):void
        {
            if((xxx < 0) || (xxx >= 4) || (yyy < 0) || (yyy >= 4)){
                return;
            }

            var pos:int;
            pos = yyy * 4 + xxx;
            if(posColor[pos] == lightoff){
                posColor[pos] = lighton;
            }
            else{
                posColor[pos] = lightoff;
            }
        }
        
        public function change(posx:int, posy:int):void
        {
            colorchange(posx, posy);
            colorchange(posx - 1, posy);
            colorchange(posx + 1, posy);
            colorchange(posx, posy - 1);
            colorchange(posx, posy + 1);
        }


        public function onClick(event:MouseEvent):void 
        {
            posX = event.stageX;
            posY = event.stageY;
            if(posX > pw * 4){
                return;
            }
            if(posY > ph * 4){
                return;
            }

            var pos:int;
            var posx:int;
            var posy:int;
            posx = posX / (pw + pw_s);
            posy = posY / (ph + ph_s);
            change(posx, posy);
            
            snd.play(0);
            
            var endflag:Number = 0;
            for(var i:int = 0; i < 16; i++){
                if(posColor[i] == lightoff){
                    endflag = 1;
                }
            }
            if(endflag == 0){
                
            }


        }
    }
}

// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
        tOffset = 0;
        tElapsed = 0;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                    Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                    Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                    Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                    Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                    Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                    Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}