/**
 * Copyright Etienne.Verhote ( http://wonderfl.net/user/Etienne.Verhote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sCK2
 */

// forked from matacat's forked from: Shining Text
// forked from Kay's Shining Text
/*
 * テキストをアウトライン化してVector.<Point>に保存し
 * テキストの外周から線を引いて光を表現する
 */
package
{
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import flash.events.Event;
    
    public class Main extends Sprite
    {
        public const SW:Number = stage.stageWidth;
        public const SH:Number = stage.stageHeight;
        public const CX:Number = SW / 2;
        public const CY:Number = SH / 2;
        
        //  Vector.<Point> から Vector.<Vector.<Number>> にしちゃいました。
        //  あと fOutline に vOutline を拡大したアウトライン入れてそれを使うようにしました。 matacat
        public var multiX:Number = 16;
        public var multiY:Number = 16;
        public var vOutline:Vector.<Vector.<Number>> = new Vector.<Vector.<Number>>();
        public var fOutline:Vector.<Vector.<Number>> = new Vector.<Vector.<Number>>();
        public var l:int;
        
        public var max:Number;
        public var min:Number;
        public var lx:Number;
        
        public var myStage:Sprite = new Sprite();
        public var g:Graphics = myStage.graphics;
        public var bmpStage:Bitmap = new Bitmap(new BitmapData(SW, SH, false, 0));
        public var bsData:BitmapData = bmpStage.bitmapData;
        public var rect:Rectangle = new Rectangle(0, 0, SW, SH);

        public function Main()
        {
            addChild(bmpStage);
            bmpStage.filters = [new BlurFilter(16, 16)];
            
            var myText:SimpleText = new SimpleText('APPARENCE COUTURE', 'Arial', 32, 0xFFFF99);
            const TW:Number = myText.width;
            const TH:Number = myText.height;
            myText.x = (SW - TW) / 2;
            myText.y = (SH - TH) / 2;
            addChild(myText);
            
            max = SW + TW * multiX;
            min = -max;
            lx = max;
            
            var vTemp:Vector.<Boolean> = new Vector.<Boolean>();
            
            // Text -> BitmapData
            var bmd:BitmapData = new BitmapData(TW, TH, false, 0);
            bmd.draw(myText);
            
            // getColor
            for (var h:uint = 0; h < TH; h++) {
                for (var w:uint = 0; w < TW; w++) {
                    vTemp[h * TW + w] = bmd.getPixel(w, h);
                }
            }
            
            // Gain inner Pixels
            // var cnt:int = 0;
            var nx:Number, ny:Number;
            for (h = 0; h < TH; h++) {
                for (w = 0; w < TW; w++) {
                    var pos:uint = h * TW + w;
                    if (!vTemp[pos]) continue;
                    if (!(h == 0 && h == TH-1 && w == 0 && w == TW-1)) {
                        if (vTemp[pos + TW] && vTemp[pos - TW] && vTemp[pos - 1]  && vTemp[pos + 1])
                            continue;
                    }
                    
                    // if (!(cnt++ & 1)) {  // 1 とか 3 とか 7 で線の本数が 1/2, 1/4, 1/8
                        vOutline[l] = Vector.<Number>([nx = w - TW / 2, ny = h - TH / 2]);
                        fOutline[l] = Vector.<Number>([nx * multiX, ny * multiY]);
                        vOutline[l][0] += CX; vOutline[l][1] += CY;
                        fOutline[l][0] += CX; fOutline[l][1] += CY;
                        l++;
                    // }
                }
            }
            addEventListener(Event.ENTER_FRAME, xAnimation);
        }
        
        public function xAnimation(e:Event):void {
            lx -= 40;
            if (lx < min) lx = max;
            
            // Draw
            g.clear();
            for (var i:uint = 0; i < l; i++) {
                var xx:Number = fOutline[i][0] + lx - vOutline[i][0];
                g.lineStyle(4, 0xFFFFC7, 40 / (xx<0?-xx:xx));
                g.moveTo(vOutline[i][0],       vOutline[i][1]);
                g.lineTo(fOutline[i][0] + lx , fOutline[i][1]);
            }
            bsData.fillRect(rect, 0);
            bsData.draw(myStage);
        }
    }
}


import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;

class SimpleText extends TextField
{
    public function SimpleText(message:String, fontName:String, fontSize:Number, fontColor:uint)
    {
        this.autoSize = TextFieldAutoSize.LEFT;
        this.text = message;
        this.selectable = false;
        this.setTextFormat(new TextFormat(fontName, fontSize, fontColor));
    }
}
