/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sBvm
 */

// forked from siouxcitizen's Away3D Gold Practice08 Cylinder表示実験
// forked from siouxcitizen's Away3D Gold Practice06 Cube 5つ表示
// forked from siouxcitizen's Away3D Gold Practice05 光のあて方よくわからない。。。
// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数Torusを表示してみました
//
//以下サイトを参考にさせていただきました
//
//TorusGeometry
//http://away3d.com/livedocs/away3d/4.0/away3d/primitives/TorusGeometry.html
//
//Away3D test
//http://wonderfl.net/c/wfuC
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.TorusGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.lights.PointLight;
    import away3d.materials.lightpickers.StaticLightPicker;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class TorusSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _torusGeo : PrimitiveBase;
        private var _torusMat : ColorMaterial;
        private var _torus01 : Mesh;
        private var _torus02 : Mesh;
        private var _torus03 : Mesh;
        private var _torus04 : Mesh;
        private var _torus05 : Mesh;
        private var _torus06 : Mesh;
        private var _pointLight : PointLight;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

         public function TorusSample() {

            // wonderfl capture
            Wonderfl.disable_capture();
            //addChild(new Bitmap(_capture)) ;

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x555555;

            _camera.y = 0;
            _camera.z = -700;

            _pointLight = new PointLight();
            _pointLight.ambient = 0.1;
            _pointLight.diffuse = 0.7;
            _pointLight.position = _camera.position;
            _scene.addChild(_pointLight);

            var lightPicker:StaticLightPicker = new StaticLightPicker([_pointLight]);

            _torusMat =  new ColorMaterial(0xff0000, 1);
            _torusGeo = new TorusGeometry(70, 30, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus01 = new Mesh(_torusGeo, _torusMat);
            _torus01.y += 250;
            _scene.addChild(_torus01);

            _torusMat =  new ColorMaterial(0x00ff00, 1);
            _torusGeo = new TorusGeometry(70, 30, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus02 = new Mesh(_torusGeo, _torusMat);
            _torus02.x = -250;
            _scene.addChild(_torus02);

            _torusMat =  new ColorMaterial(0x0000ff, 1);
            _torusGeo = new TorusGeometry(70, 30, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus03 = new Mesh(_torusGeo, _torusMat);
            _torus03.x = 250;
            _scene.addChild(_torus03);

            _torusMat =  new ColorMaterial(0xffff00, 1);
            _torusGeo = new TorusGeometry(70, 30, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus04 = new Mesh(_torusGeo, _torusMat);
            _torus04.y = -250;
            _scene.addChild(_torus04);

            _torusMat =  new ColorMaterial(0xff00ff, 0.5);
            _torusGeo = new TorusGeometry(180, 50, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus05 = new Mesh(_torusGeo, _torusMat);
            _torus05.x = 0;
            _torus05.y = 0;
            _scene.addChild(_torus05);

            _torusMat =  new ColorMaterial(0xffffff, 1);
            _torusGeo = new TorusGeometry(70, 30, 16, 8);
            _torusMat.lightPicker = lightPicker;
            _torus06 = new Mesh(_torusGeo, _torusMat);
            _torus06.x = 0;
            _torus06.y = 0;
            _scene.addChild(_torus06);

            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _torus01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _torus02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _torus03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _torus04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus04.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _torus05.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus05.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _torus06.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _torus06.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}