/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sBhp
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！ Hiiragi流その2
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
    
		//アルファベットから数の連番に変えました。
		//ルール違反ならごめんなさい。
        private var _btn1:MyButton;
        private var _btn2:MyButton;
        private var _btn3:MyButton;
        private var _label:MyTextField;
		
        public function FlashTest() {
            // ボタンを作成
            _build();
            
            // 自分流のイベントハンドラを記述ください
			
			// Hiiragi流その2。連番は割と使ったりする。
			for (var i:int = 1; i <= 3; i++)
			{
				this["_btn" + i].name = i;
				this["_btn" + i].addEventListener(MouseEvent.CLICK, _onMouseClickEvent);
				this["_btn" + i].addEventListener(MouseEvent.ROLL_OVER, _onMouseRollOverEvent);
			}
        }
		
		private function _onMouseClickEvent(e:MouseEvent):void 
		{
			_label.text = e.currentTarget.name + " がクリックされました";
		}
		
        private function _onMouseRollOverEvent(e:MouseEvent):void 
		{
			_label.text = e.currentTarget.name + " がロールオーバーされました";
		}
		
		
        /**
        * インターフェースを作る
        */
        private function _build():void {
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);

            _btn1 = new MyButton();
            _btn1.text = "Button 1"; 
            _btn1.x = 70; _btn1.y = 230;
            addChild(_btn1);
            
            _btn2 = new MyButton();
            _btn2.text = "Button 2";
            _btn2.x = 190; _btn2.y = 230;
            addChild(_btn2);
   
            _btn3 = new MyButton();            
            _btn3.text = "Button 3";
            _btn3.x = 310; _btn3.y = 230;
            addChild(_btn3);
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}