/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sAle
 */

	// forked from h6k's forked from: AtoZ Typing
	// forked from h6k's AtoZ Typing
	// 結果をツイートできる様にしました。
	package {
	    import flash.display.Sprite;
	    import flash.events.Event;
	    import flash.events.KeyboardEvent;
	    import flash.events.MouseEvent;
	    import flash.text.TextField;
	    import flash.text.TextFieldAutoSize;
	    import flash.text.TextFormat;
	    import flash.utils.getTimer;
	    import flash.utils.escapeMultiByte;
	    import flash.net.URLRequest;
	    import flash.net.navigateToURL;
	    
	    public class FlashTest extends Sprite {
	    		private var az:Array = new Array(28);
	    		private var format:TextFormat = new TextFormat();
	    		private var btn:Sprite = new Sprite();
	    		private var CODE:int;
	    		private var S:int = 5;	// 最小サイズ
	    		private var R:int = 200;	// 半径
	    		private var start:uint;
	    		
	        public function FlashTest() {
	            // write as3 code here..
	            init();
	            onGameStart();
	            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
	        }
	        
	        private function onEnterFrame(e:Event):void {
				az[26].text = (String)((getTimer() - start) / 1000) + " sec";
	        }
	        
	        private function fadeOut(i:int):Function {
	        		return function(e:Event):void {
					if (az[i].textColor >= 0xF0F0F0) {
						az[i].textColor = 0xFFFFFF;
						az[i].removeEventListener(Event.ENTER_FRAME, arguments.callee);
					} else {
						az[i].textColor += 0x101010;
					}
	        		}
	        }
	        
	        private function moveAZ(kc:int):void {
				var degree:Number;
				for (var i:int = 0; i < 26; i++) {
					if (i + 65 == kc) {
						az[i].border = false;
						az[i].addEventListener(Event.ENTER_FRAME, fadeOut(i));
						az[i + 1].border = true;
					}
					
					degree = (90 + (360 / 26 * (CODE - 64))) - ((360 / 26) * i);
					setPos(i, degree);
				}
				if(kc < 90) { CODE++; }
	        }
	        
	        private function onKeyDown(e:KeyboardEvent):void {
				if(e.keyCode == CODE) {
					if (e.keyCode == 65) {
						start = getTimer();
						stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
					} else if (e.keyCode == 90) {
						stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
						if(!stage.contains(btn)) {
							stage.addChild(btn);
						}
					}
					moveAZ(e.keyCode);
				} else if (e.keyCode == 32) {
					stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
					onGameStart();
				}
	        }
	        
	        private function setPos(i:int, degree:Number):void {
	        		var sin:Number = Math.sin(Math.PI / 180 * degree);
	        		format.size = (sin + 1) * 10 + S;
	        		
	        		az[i].setTextFormat(format);
	        		az[i].x = R * Math.cos(Math.PI / 180 * degree) + (stage.stageWidth / 2);
	        		az[i].y = R * sin / 2 + (stage.stageHeight / 2);
	        }
	        
	        private function onGameStart():void {
				var degree:Number;
				CODE = 65;
				for (var i:int = 0; i < 26; i++) {
					az[i].border = false;
					az[i].textColor = 1;
					degree = 90 - ((360 / 26) * i);
					setPos(i, degree);
				}
				az[0].border = az[26].border = true;
				az[26].text = "0.000 sec";
				if(stage.contains(btn)) {
					stage.removeChild(btn);
				}
	        }
	        
			private function onClick(e:Event):void {
				var url:String = "http://twitter.com/home?status=";
				url += escapeMultiByte("AtoZ Typing の結果:") + az[26].text + ". http://wonderfl.net/c/p5oi %23wonderfl";
				var req:URLRequest = new URLRequest(url);
				navigateToURL(req);
			}
			
	        private function init():void {
	        		for(var i:int = 0; i < 28; i++) {
	        			az[i] = new TextField();
	        			az[i].text = String.fromCharCode(i + 65);
	        			az[i].autoSize = TextFieldAutoSize.LEFT;
	        			az[i].mouseEnabled = false;
	        			stage.addChild(az[i]);
	        		}
	        		
	        		az[26].x = stage.stageWidth / 2 - 10;
	        		az[26].y = stage.stageHeight / 2 + 20;
	        		az[26].background = true;
	        		az[26].backgroundColor = 0;
	        		az[26].textColor = 0xFFFFFF;
	        		
	        		az[27].text = "Push Space Key to Restart";
	        		az[27].x = stage.stageWidth / 2 - 50;
	        		az[27].y = stage.stageHeight / 2;
	        		
				var fld:TextField = new TextField();
				fld.text = "結果をツイート";
				fld.x = stage.stageWidth / 2 - 25;
				fld.y = stage.stageHeight / 2 + 45;
				fld.autoSize = TextFieldAutoSize.LEFT;
				fld.border = true;
				fld.mouseEnabled = false;
				btn.addChild(fld);
				btn.buttonMode = true;
				btn.addEventListener(MouseEvent.CLICK, onClick);
	        }
	    }
	}