/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sAi6
 */

// forked from 9re's Chat Feature Released!
package {
    import flash.events.IOErrorEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.display.*;
    /*
        chat feature is now avaliable for live coding mode
    */
    
    public class MediaRSSReader extends Sprite {
        private var _feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags=kamakura&format=rss_200";
        private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
        private var container:Sprite = new Sprite;
        private var contents:Array;
        private var mainImage:Loader;
        
        public function MediaRSSReader() {
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                ldr.removeEventListener(Event.COMPLETE, _load);
                var rss:XML = XML(ldr.data);
                
                contents = rss..*.media::content.@url.toXMLString().split('\n');
                onImageLoaded(rss..*.media::thumbnail.@url.toXMLString().split('\n'));
            });
            ldr.load(new URLRequest(_feed));
        }
        
        private function onImageLoaded($images:Array):void {
            var ldr:Loader;
            
            for (var i:int = 0; i < $images.length; ++i) {
                ldr = new Loader;
                ldr.load(new URLRequest($images[i]));
                ldr.x = i * 85;
                container.addChild(ldr);
            }
            
            container.x = container.y = 15;
            addChild(container);
            init();
        }
        
        private function init():void {
            var timer:Timer = new Timer(10000);
            var pos:int = 0;
            var tc:int = 0;
            var tMax:int = 25;
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            onTimer(null);
            timer.start();
            
            function onTimer(e:TimerEvent):void {
                if (tc == 0) {
                    addEventListener(Event.ENTER_FRAME, tween);
                }
                var contentURL:String = contents[pos];
                if (mainImage && mainImage.parent) removeChild(mainImage);
                mainImage = new Loader;
                mainImage.contentLoaderInfo.addEventListener(
                Event.COMPLETE, placeCenter);
                mainImage.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, trace);
                mainImage.load(new URLRequest(contentURL));
                
                ++pos;
                pos = (pos == contents.length) ? 0 : pos;
                
                function placeCenter(e:Event):void {
                    var scale:Number = Math.min(1.0, 360 / mainImage.width,
                         250 / mainImage.height);
                         
                    mainImage.scaleX = mainImage.scaleY = scale;
                    mainImage.x = (465 - mainImage.width) >> 1;
                    mainImage.y = ((425 - mainImage.height) >> 1) + 20;
                    addChild(mainImage);
                }
            }
            function tween(e:Event):void {
                var t:Number = (tc++ % tMax) / tMax;
                if (tc == tMax) {
                    removeEventListener(Event.ENTER_FRAME, tween);
                    tc = 0;
                }
                t = t * (2 - t);
                container.x = -(pos + t - 4 ) * 85 + 20;
            }
        }
    }
}
