/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sANX
 */

package {
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
            stage.addEventListener(MouseEvent.CLICK, onClick);    
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function onClick(e:MouseEvent):void
        {
          camx = wmx-rendw;
          camz = wmz-rendh;  
        }//onclick
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);

            var mx:Number;  var my:Number;
            mx = stage.mouseX;     my = stage.mouseY;         
            mx -= rendw;
            wmz = (2*my - mx)*0.5;  wmx = mx + wmz;
            wmx += camx;      wmz += camz; 

            drawLine(wmx, 0, wmz, wmx, 8, wmz);
            drawCirc(wmx, 0, wmz, 16);

            //drawLine(0,0,0, 256,0,0);
            //drawLine(0,0,0,  0,0,256);            

            drawBox(0,0,0, 64,64,64);
             
            drawBox(0,0,0, 512, 0, 512); 
 
            var i:int;
            for (i = 0; i < 16; i++)
            {
                drawBox(128,0,i*64, 128+64,i*16,64+i*64);                
            }//nexti
            
            drawSphere(256,32,128,32, gt*0.01, gt*0.01);
            
            drawBox(384, 0, 384,   384+64, 64+Math.sin(gt*0.03)*64, 384+64);
            
           // camx = Math.cos(gt*0.02)*128;
           // camz = Math.sin(gt*0.02)*128;
           
           var u:Number;
           var ax:Number; var az:Number;
           for (i = 0; i < 8; i++)
           {
              u = i * 0.8 + gt*0.03;
              ax = Math.cos(u)*64+384;
              az = Math.sin(u)*64+128;
              drawBox2(ax, 32,az , 8,8,8);
              drawBox2(ax,0, az, 8, 0, 8);
           }//nexti           
            
            gt += 1;
        }//onenter

        public var wmx:Number = 0;
        public var wmz:Number = 0;
        

        public var gt:int = 0;
        
        public var rendw:Number = 465 * 0.5;
        public var rendh:Number = 465 * 0.5;

        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0;
        
        
        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
    
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);

            sx = bx - bz + rendw;
            sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
            
        }//drawline

       public function drawCirc(ax:Number, ay:Number, az:Number, r:Number):void
       {
          var u:Number;     var t:Number;    t = 0.314;
          for (u = 0; u < 6.28; u+= t)
          {
           drawLine(ax + Math.cos(u) * r, ay, az + Math.sin(u) * r,
           ax + Math.cos(u+t)*r, ay, az + Math.sin(u+t)*r);   
          }//nextu           
       }//drawcircle

       public function drawBox2(ax:Number, ay:Number, az:Number,
       aw:Number, ah:Number, ad:Number):void
       {
           drawBox(ax,ay,az,ax+aw,ay+ah,az+ad);
       }//drawbox2
        
       public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox        
        
       
       
      public function drawSphere(tx:Number, ty:Number, tz:Number,
       r:Number,v:Number=0, v2:Number=0):void
      {
        var ax:Number;        var ay:Number;        var az:Number;
        var bx:Number;        var by:Number;        var bz:Number;       
        var wo:Number; var wa:Number;
        
        //0-6.28
        var u:Number;
        wo = 3.14;
        u = 0.2;
        for (wo = 0; wo < 3.14; wo += 0.628)
        for (wa = 0; wa < 6.28; wa += u)
        {
          ax = Math.sin(wo+v) * Math.cos(wa);
          ay = Math.sin(wa);
          az = Math.cos(wo+v) * Math.cos(wa); 
          bx = Math.sin(wo+v) * Math.cos(wa+u);
          by = Math.sin(wa+u);
          bz = Math.cos(wo+v) * Math.cos(wa + u);
          ax *= r; ay *= r; az *= r;
          bx *= r; by *= r; bz *= r;          
          drawLine(ax+tx, ay+ty, az+tz, bx+tx, by+ty, bz+tz);
        }//nextwa
        
        for (wa = 0; wa < 6.28; wa += 0.314)
        for (wo = 0; wo < 3.14; wo += u)
        {
          ax = Math.sin(wo) * Math.cos(wa);
          ay = Math.sin(wa);
          az = Math.cos(wo) * Math.cos(wa); 
          bx = Math.sin(wo+u) * Math.cos(wa);
          by = Math.sin(wa);
          bz = Math.cos(wo + u) * Math.cos(wa ); 
          ax *= r; ay *= r; az *= r;
          bx *= r; by *= r; bz *= r;          
          drawLine(ax+tx, ay+ty, az+tz, bx+tx, by+ty, bz+tz);
        }//nextwa
        
      }///drawsph
        
        
        
        
    }//classend
}