/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sAFB
 */

package {
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var vecNode:Array;
        public var vecCar:Array;
        public var debugLayer:Sprite;
        
        public function FlashTest() {
            // write as3 code here..
            
            graphics.clear();
            graphics.lineStyle(1,0x887788);
            graphics.drawCircle(200,200,120);
            
            var i:int;
            var num:int;
            var k:Number;
            var a:Node;
            
            vecNode = new Array();
            
            for (k = 0; k < 6.28; k+= 0.628)
            {
                a = new Node();
                addChild(a);
                a.x = 200 + Math.cos(k) * 120;
                a.y = 200 + Math.sin(k) * 120;
                a.rotation = k * (180/3.1415) + 90;
                
                vecNode.push(a);
                
            }//nextk
            
            var c:Car;
            vecCar = new Array();
            for (i =0; i < 8; i++)
            {
                c = new Car();
                addChild(c);
                c.x = Math.random() * 200;
                c.y = Math.random() * 200;
                c.initCar(this);
                vecCar.push(c);
            }//nexti
            
            debugLayer=  new Sprite();
            addChild(debugLayer);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function onEnter(e:Event):void
        {
            var g:Graphics;
            g = debugLayer.graphics;
            
            g.clear();
            g.lineStyle(2,0);
            g.drawCircle(mouseX, mouseY, 8);
            
            var n:Node;
            n = getClosestNode(mouseX, mouseY);
            if (n != null)
            {
                g.moveTo(mouseX, mouseY);
                g.lineTo(n.x, n.y);
            }//endif
            
            var i:int;
            var num:int;
            var c:Car;
            num = vecCar.length;
            
            for (i =0; i < num; i++)
            {
                c = vecCar[i];
                c.update();
            }//nexti
            
        }//onenter
        
        public function getNextNode(m:Node):Node
        {
            if (m == null) { return null;}
            
            var i:int;
            var num:int;
            var n:Node;
            num = vecNode.length;
            for (i = 0; i < num; i++)
            {
                n = vecNode[i];
                if (n == m) { break;}
            }//nexti 
            i += 1;
            if (i >= num) { i = 0;}
            
            return vecNode[i];
        }//getnext
        
        public function getClosestNode(kx:Number, ky:Number):Node
        {
            var i:int;
            var num:int;
            var n:Node;
            var dist:Number;
            var d:Number;
            var c:Node;
            
            dist = 999999;
            
            num = vecNode.length;
            
            for (i =0; i < num; i++)
            {
                n = vecNode[i];
                d = getMag(n.x -kx, n.y-ky);
                if (d < dist) { c = n; dist = d; }
             }//nexti
             
             return c;
        }//getclosestnode
        
        public function getMag(dx:Number, dy:Number):Number
        {
            return Math.sqrt(dx*dx+dy*dy);
        }//getmag
        
        
    }//classend
}
import flash.display.Sprite;

internal class Node extends Sprite
{
    public function Node()
    {
        graphics.clear();
        graphics.lineStyle(2,0x667788);
        graphics.drawCircle(0,0,16);
        graphics.drawRect(-1,-16,2,32);
        graphics.drawRect(0,-1,8,1);
     }//ctor
    
    
    }//NODE
    
internal class Car extends Sprite
{
    public function Car()
    {
        graphics.clear();
        graphics.lineStyle(2,0x0000FF);
        graphics.drawCircle(0,0,8);
        graphics.drawRect(0,-1,8,1);
        graphics.lineStyle(1,0xFF0000);
        graphics.drawRect(-8,-8,6,3);
        graphics.drawRect(8-3,-8,6,3);
        graphics.drawRect(-8,8-3,6,3);
        graphics.drawRect(8-3,8-3,6,3);
        
     }//ctor
    
    public var game:FlashTest;
     
    public function initCar(ft:FlashTest):void
    { game = ft; init(); }//initcar
    
    public function init():void
    {
        
    }//init
    
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function update():void
    {
        var dx:Number;
        var dy:Number;
        var mag:Number;
        var n:Node;
        n = game.getClosestNode(x, y);
        var a:Number;
        rotation = n.rotation;
        a = n.rotation * (3.1415/180);
        vx += Math.cos(a) *0.1;
        vy += Math.sin(a) *0.1;

        n = game.getNextNode(n);
        dx = n.x - x;
        dy = n.y - y;
        mag = Math.sqrt(dx*dx+dy*dy);
        if (mag != 0)
        {
            dx /= mag;
            dy /= mag;
            vx += dx *0.1;
            vy += dy *0.1;
            //vx *=0.5;
            //vy *= 0.5;
        }//endif
        
        vx *= 0.94;
        vy *= 0.94;
        
        x += vx;
        y += vy;

        
        
    }//update
    
}//CAR    
    