/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sAAu
 */

// forked from hycro's Project Euler #003
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class ProjectEuler extends Sprite {
		private var _textField:TextField;
       
        public function ProjectEuler() {
        		initialize();
        		writeAnswer(new Problem004);
        }
        
        private function writeAnswer(problem:AbstructProblem):void {
        		var answer:String = problem.getAnswer();
        		 _textField.appendText(answer);
        }
        
        private function initialize():void {
        	    _textField = new TextField();
            _textField.width = stage.stageWidth;
            _textField.height = stage.stageHeight;
            addChild(_textField);
        }
    }
}

class AbstructProblem {
	final public function getAnswer():String {
		var answer:String;
		try {
			answer = solve().toString();
		} catch (err:Error) {
			answer = err.name + " : " + err.message;
		}
		return answer;
	}
	
	protected function solve():Number {
		throw new Error("unsolved");
	}
}

class Problem004 extends AbstructProblem {
	override protected function solve():Number {
		var answer:Number = 0;
		
		for (var operand1:uint = 999; operand1 >= 100; operand1--) {
			for (var operand2:uint = operand1; operand2 >= 100; operand2--) {
				if (answer < (operand1 * operand2) && isPalindromic(operand1 * operand2)) {
					answer = operand1 * operand2;
				}
			}
		}
		
		return answer;
	}
	
	private function isPalindromic(n:Number):Boolean {
		var right:uint = 1;
		var left:uint = Utils.disits(n);
		
		while (left > right) {
			if (Utils.numberAt(n, left) != Utils.numberAt(n, right)) {
				return false;
			}
			left--;
			right++;
		}
		return true;
	}
}

class Utils {
	// 整数値の桁数の取得
	static public function disits(n:Number, radix:uint=10):Number {
		var d:Number = 0;
		
		n = Math.abs(n);
		while (n / radix != 0) {
			n = Math.floor(n / radix);
			d++;
		}
		
		return d;
	}
	
	// 指定した桁の値を取得
	static public function numberAt(n:Number, digit:Number, radix:Number=10):Number {
		var number:Number;
		
		while (--digit) {
			n = Math.floor(n / radix);
		}
		
		return n % radix
	}
	
}