/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sA6R
 */

/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 * @since 2012/09/16 02:54:45
 */
package
{
    import a24.tween.Ease24;
    import a24.tween.Tween24;

    import away3d.containers.View3D;
    import away3d.core.base.Geometry;
    import away3d.entities.Mesh;
    import away3d.lights.PointLight;
    import away3d.materials.TextureMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.methods.FogMethod;
    import away3d.primitives.CubeGeometry;
    import away3d.textures.BitmapTexture;

    import frocessing.color.ColorHSV;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.getTimer;

    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]
    /**
     * 
     */
    public class EffectTestWonderfl extends View3D
    {
        private static const DIFFUSE_URL : String = "http://www.romatica.com/dev/samples/away3d/effectTestWonderfl/diffuse.jpg";
        private static const REFLECTION_URL : String = "http://www.romatica.com/dev/samples/away3d/effectTestWonderfl/reflection.jpg";
        private var _bmdDiffuse : BitmapData;
        private var _bmdReflect : BitmapData;
        // [Embed(source="/../assets/testCube/diffuse.jpg")] private static const EmbedDiffuse:Class;
        // [Embed(source="/../assets/testCube/reflection.jpg")] private static const EmbedReflection:Class;
        
        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private static const CUBE_SIZE : int = 64;
        private static const CUBE_NUM_IN_CIRCLE : int = 16;
        private static const CIRCLE_R : int = 300;
        private static const CIRCLE_NUM : int = 16;
        private static const MIN_DISTANCE : int = -400;
        private static const MAX_DISTANCE : int = 2400;
        private static const DISTANCE : int = (MAX_DISTANCE + Math.abs(MIN_DISTANCE));
        private static const Z_SPEED : Number = 20;
        private static const countMax : int = 60;
        private var count : int = 0;
        private var cubes : Vector.<Mesh>;
        private var circles : Vector.<EffectCircle>;
        private var circleSpan : Number  = (DISTANCE / CIRCLE_NUM);
        private var _lightColor0 : PointLight;
        private var _lightColor1 : PointLight;
        private var _lightColor1HSV : ColorHSV;
        private var _lightColor0HSV : ColorHSV;
        private var _lightPicker : StaticLightPicker;
        
        private var _loader0 : Loader;
        private var _loader1 : Loader;
        private var _loadFlag0 : Boolean;
        private var _loadFlag1 : Boolean;

        // wonderfl capture
        private var _capture : Bitmap;
        
        public function EffectTestWonderfl()
        {
            super();
            if (stage) _initialize(null);
            else addEventListener(Event.ADDED_TO_STAGE, _initialize);
        }

        private function _initialize(event : Event) : void
        {
            removeEventListener(flash.events.Event.ADDED_TO_STAGE, _initialize);
            
            // wonderfl capture
            Wonderfl.disable_capture();
             //_capture = addChild(new Bitmap(new BitmapData(465, 465, false, 0x000000))) as Bitmap ;
                       
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            antiAlias = 4;
            backgroundColor = 0x0;
            camera.lens.far = 2400;
            textureLoadStart();
        }

        private function textureLoadStart() : void
        {
            _loader0 = new Loader();
            _loader0.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteDiffuse_Handler);
            _loader0.load(new URLRequest(DIFFUSE_URL), new LoaderContext(true));

            _loader1 = new Loader();
            _loader1.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteReflection_Handler);
            _loader1.load(new URLRequest(REFLECTION_URL), new LoaderContext(true));
        }

        private function loadCompleteReflection_Handler(event : Event) : void
        {
            _loadFlag0 = true;
            _bmdDiffuse = ((event.target as LoaderInfo).content as Bitmap).bitmapData;
            checkLoadTexture();
        }

        private function loadCompleteDiffuse_Handler(event : Event) : void
        {
            _loadFlag1 = true;
            _bmdReflect = ((event.target as LoaderInfo).content as Bitmap).bitmapData;
            checkLoadTexture();
        }

        private function checkLoadTexture() : void
        {
            if (_loadFlag0 && _loadFlag1) textureLoadComplete();
        }

        private function textureLoadComplete() : void
        {
            
            // ----------------------------------
            // light
            // ----------------------------------

            _lightColor0HSV = new ColorHSV(0xcc0000);
            _lightColor0 =scene. addChild(new PointLight()) as PointLight;
            _lightColor0.ambientColor = _lightColor0HSV.value;
            _lightColor0.ambient = 10;
            _lightColor0.specular = 10;
            _lightColor0.diffuse = 10;
          
            _lightColor1HSV= new ColorHSV(0x00cc00);
            _lightColor1 = scene.addChild(new PointLight()) as PointLight;
            _lightColor1.ambientColor = _lightColor1HSV.value;
            _lightColor1.ambient = 100;
            _lightColor1.specular = 100;
            _lightColor1.diffuse = 100;
            
            _lightPicker = new StaticLightPicker([_lightColor0, _lightColor1]);
            
            //----------------------------------
            // material
            // ----------------------------------
            var material : TextureMaterial = new TextureMaterial(new BitmapTexture(_bmdDiffuse));
            material.specularMap = new BitmapTexture(_bmdReflect);
            material.addMethod(new FogMethod(MIN_DISTANCE, MAX_DISTANCE, 0x000000));
            material.lightPicker = _lightPicker;
            material.gloss = 100;


            // ----------------------------------
            // objects
            // ----------------------------------
            circles = new Vector.<EffectCircle>();
            cubes = new Vector.<Mesh>();

            for (var i : int = 0; i < CIRCLE_NUM; i++) 
            {
                // ----------------------------------
                // Circle
                // ----------------------------------
                var circle : EffectCircle = scene.addChild(new EffectCircle()) as EffectCircle;
                circle.z = circleSpan * i;
                circle.id = i;
                circles.push(circle);
                for (var j : int = 0; j < CUBE_NUM_IN_CIRCLE; j++) {
                    // ----------------------------------
                    // Cube
                    // ----------------------------------
                    var cubeGeo : Geometry = new CubeGeometry(CUBE_SIZE, CUBE_SIZE, CUBE_SIZE)
                    var cube : Mesh = circle.addChild(new Mesh(cubeGeo, material)) as Mesh;
                    var rad : Number = (360 / CUBE_NUM_IN_CIRCLE * j) * (Math.PI / 180);
                    cube.x = Math.cos(rad) * CIRCLE_R;
                    cube.y = Math.sin(rad) * CIRCLE_R;
                    cubes.push(cube);
                }
            }
            
            // ----------------------------------
            // render start
            // ----------------------------------
            addEventListener(Event.ENTER_FRAME, update);
        }



        public function update(event : Event) : void
        {
            
            var t : Number = getTimer();
            var max : int = circles.length;
            var half : int = int(max * 0.5);
            var cos : Number = Math.cos(t / 36000) * 720 ;
            for (var i : int = 0; i < max; i++) {
                var circle : EffectCircle = circles[i] as EffectCircle;
                if (!circle) break;
                // ----------------------------------
                // Z回転
                // ----------------------------------
                var val : int;
                if (i == half)      val = half;
                else if (i < half)  val = i % half;
                else                val = half - i % half;
                circle.rotationZ =  cos * val ;
                // ----------------------------------
                // 手前にZ移動
                // ----------------------------------
                circle.z -= Z_SPEED ;
                if (circle.z < MIN_DISTANCE) circle.z = circle.z + DISTANCE;

                if (count >= countMax) {
                    var delay : Number = i * 0.05;
                    var scale : Number = 0.75;
                    Tween24.serial(
                         Tween24.wait(delay)
                       , Tween24.tween(circle,0.45,Ease24._BackIn).scaleX(scale).scaleY(scale).scaleZ(scale)
                       , Tween24.tween(circle, 0.75, Ease24._BackOut).scaleX(1).scaleY(1).scaleZ(1)
                    ).play();
                }
            }

            count = (count + 1 > countMax) ? 0 : count + 1;

            if (_lightColor0) {
                _lightColor0.x = Math.cos(t / 1024) * 800;
                _lightColor0.z = Math.sin(t / 1024) * 800 + 700;
                _lightColor0HSV.h += 2;
                _lightColor0.ambientColor = _lightColor0HSV.value;
            }

            if (_lightColor1) {
                _lightColor1.x = Math.sin(t / 1024) * 400;
                _lightColor1.y = Math.cos(t / 1024) * 200;
                _lightColor1.z = 1800;
                _lightColor1HSV.h += 2;
                _lightColor1.ambientColor = _lightColor1HSV.value;
            }
           
            camera.x = Math.cos(t / 512) * 100;
            camera.y = Math.sin(t / 512) * 100;
            camera.z = -600;
            camera.lookAt(ZERO);
            render();

            // wonderfl capture
             if(_capture) renderer.queueSnapshot(_capture.bitmapData);
        }
    }
    
}
import away3d.containers.ObjectContainer3D;

class EffectCircle extends ObjectContainer3D
{
    public var id : int = 0;

    public function EffectCircle()
    {
        super();
    }
}


