/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s9zn
 */

package {
  import flash.display.*;
  import flash.events.KeyboardEvent;
  import flash.geom.Matrix;
  
  public class ch35ex17 extends Sprite {
    public function ch35ex17() {
      MuseumFoundry.initialize();
      stage.addEventListener(KeyboardEvent.KEY_DOWN, onKey);
    }
    protected function onKey(event:KeyboardEvent):void {
      var key:String = (String.fromCharCode(event.charCode).toLowerCase());
      if (!(key in MuseumFoundry.__motifs)) return;

      var s:Shape = new Shape();
      var m:Matrix = new Matrix();
      m.createGradientBox(100, 100, Math.PI/2);

      var batch:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
      batch.push(new GraphicsGradientFill(GradientType.LINEAR,
        [0xff0000, 0x0000ff], [1, 0.7], [0, 255], m));
      batch.push(Five3DGlyphUtils.convertGlyph(MuseumFoundry, key));
      batch.push(new GraphicsEndFill());
      s.graphics.drawGraphicsData(batch);

      s.blendMode = BlendMode.MULTIPLY;
      s.x = stage.mouseX;
      s.y = stage.mouseY;
      addChild(s);
    }
  }
}

import flash.display.GraphicsPathCommand;
import flash.display.GraphicsPath;

class Five3DGlyphUtils {
  public static function convertGlyph(typo:Object, glyph:String):GraphicsPath {
    var fiveCommands:Array = typo.__motifs[glyph];
    var path:GraphicsPath = new GraphicsPath();
    
    for each (var fiveCmd:Object in fiveCommands) {
      var fiveCmdType:String = fiveCmd[0];
      var fiveCmdCoords:Array = fiveCmd[1];
      switch (fiveCmdType) {
        case "M":
          path.moveTo(fiveCmdCoords[0], fiveCmdCoords[1]);
          break;
        case "L":
          path.lineTo(fiveCmdCoords[0], fiveCmdCoords[1]);
          break;
        case "C":
          path.curveTo(fiveCmdCoords[0], fiveCmdCoords[1],
                       fiveCmdCoords[2], fiveCmdCoords[3]);
          break;
      }
    } 
    
    return path;
  }
}


//MuseumFoundry font by Raph Levien (http://levien.com)
//licensed under Open Font License
//converted to Five3D Typography class
//Five3D by Mathieu Badimon (http://five3d.mathieu-badimon.com/)
class MuseumFoundry {
  static public var __motifs:Object = {};
  static public var __widths:Object = {};
  static public var __heights:Number = 100;
  static public var __initialized:Boolean = false;
  
  static public function initialize():void {
    initializeMotifs();
    initializeWidths();
    __initialized = true;
  }
  
  static private function initializeMotifs():void {
    __motifs["a"] = [['M',[22.9,60.2]],['L',[22.7,67.5]],['C',[22.7,67.55,21.75,68.35]],['C',[20.75,69.1,19.15,69.85]],['C',[17.6,70.65,15.65,70.7]],['C',[13.25,70.65,11.85,69.35]],['C',[10.5,68.05,10.45,66.2]],['C',[10.4,64.95,11.35,63.65]],['C',[12.25,62.35,14.55,61.45]],['C',[16.15,60.9,18.35,60.55]],['C',[20.5,60.2,22.75,60.2]],['C',[22.8,60.2,22.9,60.2]],['M',[7.5,49.05]],['C',[8.3,48.7,10.85,47.7]],['C',[11.5,47.45,11.95,47.1]],['C',[12.4,46.7,12.4,45.9]],['C',[12.4,45.8,12.4,45.55]],['C',[12.4,45.35,12.4,45.05]],['C',[12.25,44.05,12.8,42.8]],['C',[13.35,41.65,15.9,41.5]],['C',[16.95,41.5,18.05,41.9]],['C',[19.2,42.3,20.55,43.4]],['C',[22.1,44.65,22.7,46.2]],['C',[23.3,47.7,23.25,49.65]],['C',[23.25,49.95,23.25,50.45]],['C',[23.2,50.95,23.15,52.4]],['C',[23.1,53.85,23,56.9]],['C',[19.7,57.45,16.3,58.2]],['C',[12.95,58.95,9.65,60.25]],['C',[6.9,61.3,5.2,62.95]],['C',[3.55,64.5,3.5,67.35]],['C',[3.5,68.25,3.75,69.7]],['C',[4.05,71.2,5,72.65]],['C',[5.9,74,7.35,74.65]],['C',[8.9,75.35,11.05,75.35]],['C',[14.35,75.3,17.45,73.85]],['C',[20.5,72.5,23.1,70.3]],['C',[23.45,72.6,24.3,73.65]],['C',[25.2,74.75,26.05,75.1]],['C',[26.95,75.4,27.45,75.35]],['C',[27.95,75.4,28.7,75.1]],['C',[29.5,74.85,31.45,74.05]],['C',[33.4,73.25,37.45,71.6]],['C',[38.15,71.4,38.65,71.05]],['C',[39.15,70.75,39.2,69.9]],['C',[39.2,69.6,39,68.85]],['C',[38.8,68.05,38.05,67.95]],['C',[37.85,67.95,37.55,68.05]],['C',[37.25,68.2,36.45,68.5]],['C',[34.9,69.15,33.95,69.45]],['C',[32.95,69.85,32.15,69.85]],['C',[31.25,69.9,30.35,69.25]],['C',[29.55,68.55,29.5,66.7]],['C',[29.5,65.5,29.65,62.65]],['C',[29.8,59.7,30,56.35]],['C',[30.2,52.9,30.3,50.3]],['C',[30.45,47.65,30.45,47]],['L',[30.4,47]],['C',[30.5,46.25,30,44.1]],['C',[29.4,42,26.8,39.5]],['C',[24.95,37.85,23.65,37.45]],['C',[22.25,37,21.4,37.05]],['C',[20.85,37.05,18.8,37.25]],['C',[16.7,37.5,14.1,38.2]],['C',[11.45,38.95,9.4,40.4]],['C',[7.55,41.8,6.6,43.35]],['C',[5.6,44.95,5.25,46.25]],['C',[4.9,47.5,4.9,47.9]],['C',[4.95,48.55,5.3,48.9]],['C',[5.7,49.3,6.35,49.35]],['C',[6.7,49.35,7.5,49.05]]];
    __motifs["b"] = [['M',[19.6,42.9]],['C',[20.75,42.6,21.9,42.5]],['C',[23.15,42.4,24.3,42.6]],['C',[25.5,42.8,26.55,43.25]],['C',[28.55,44.1,30.15,45.6]],['C',[31.65,47.1,32.65,49]],['C',[33.9,51.2,34.5,53.6]],['C',[35.15,55.95,35.15,58.45]],['C',[35.15,60.95,34.4,63.25]],['C',[33.55,65.6,31.9,67.4]],['C',[30.95,68.4,29.9,69.15]],['C',[28.75,69.85,27.55,70.35]],['C',[26.3,70.8,25,71]],['C',[23.7,71.2,22.35,71.15]],['C',[20.3,71.05,18.35,70.35]],['C',[16.35,69.65,14.7,68.45]],['C',[14.35,68.2,14.1,67.95]],['C',[13.85,67.65,13.75,67.3]],['C',[13.65,66.95,13.6,66.6]],['C',[13.55,66.2,13.55,65.85]],['C',[13.4,61.95,13.3,58.05]],['C',[13.2,52.7,13.3,47.35]],['C',[13.3,47.1,13.35,46.9]],['C',[13.35,46.7,13.45,46.5]],['C',[13.55,46.4,13.65,46.25]],['C',[13.8,46.1,13.95,45.95]],['C',[15.55,44.6,17.4,43.75]],['C',[18.45,43.25,19.6,42.9]],['M',[12.1,9.1]],['C',[11.8,9.3,11.6,9.5]],['C',[10.6,10.55,9.4,11.35]],['C',[8.25,12.2,7,12.85]],['C',[5,13.85,2.8,14.35]],['C',[2.45,14.4,2.15,14.55]],['C',[1.8,14.65,1.55,14.9]],['C',[1.3,15.15,1.2,15.45]],['C',[1.05,15.8,1.1,16.15]],['C',[1.1,16.45,1.2,16.7]],['C',[1.35,17,1.55,17.2]],['C',[1.8,17.35,2.05,17.5]],['C',[2.3,17.65,2.6,17.7]],['L',[4.1,18.25]],['C',[4.4,18.3,4.65,18.45]],['C',[4.95,18.55,5.2,18.7]],['C',[5.65,19,6,19.4]],['C',[6.35,19.9,6.5,20.5]],['C',[6.55,20.8,6.55,21.1]],['C',[6.6,21.35,6.6,21.6]],['C',[6.7,23.6,6.7,25.65]],['C',[6.75,27.65,6.7,29.65]],['C',[6.65,36.4,6.6,43.25]],['C',[6.55,53.75,6.6,64.25]],['C',[6.6,66.35,6.55,68.5]],['C',[6.45,70.65,6.2,72.75]],['C',[6.15,73,6.15,73.3]],['C',[6.1,73.55,6.2,73.8]],['C',[6.25,74.1,6.45,74.3]],['C',[6.65,74.55,6.9,74.65]],['C',[7.1,74.7,7.3,74.65]],['C',[7.5,74.65,7.75,74.55]],['C',[7.95,74.5,8.1,74.35]],['C',[8.3,74.25,8.5,74.1]],['L',[9.4,73.55]],['C',[9.55,73.45,9.75,73.35]],['C',[9.9,73.2,10.1,73.15]],['C',[10.55,73,11,73.05]],['C',[11.4,73.1,11.75,73.25]],['C',[12.2,73.4,12.6,73.55]],['C',[14.05,74.05,15.6,74.55]],['C',[16.45,74.8,17.4,75]],['C',[18.25,75.2,19.2,75.35]],['C',[21.15,75.6,23.1,75.35]],['C',[25.1,75.1,27,74.55]],['C',[28.95,73.95,30.8,73.05]],['C',[32.65,72.15,34.3,70.85]],['C',[35.55,69.75,36.55,68.5]],['C',[37.6,67.25,38.5,65.85]],['C',[39.2,64.75,39.8,63.55]],['C',[40.45,62.4,40.85,61.1]],['C',[42,58.2,42,55]],['C',[42.05,51.9,40.95,48.9]],['C',[40.4,47.25,39.45,45.7]],['C',[38.5,44.2,37.25,42.8]],['C',[36.15,41.6,34.7,40.55]],['C',[33.35,39.6,31.75,38.9]],['C',[30.2,38.2,28.45,37.95]],['C',[26.8,37.65,25.1,37.75]],['C',[22.7,37.9,20.45,38.7]],['C',[18.15,39.55,16.15,40.85]],['L',[16.2,40.85]],['C',[14.6,41.9,13.2,43.15]],['L',[13.9,17.7]],['C',[13.95,16.05,14.05,14.45]],['C',[14.2,12.8,14.5,11.1]],['C',[14.55,10.9,14.6,10.6]],['C',[14.6,10.3,14.55,10.05]],['C',[14.45,9.75,14.3,9.5]],['C',[14.1,9.3,13.9,9.1]],['C',[13.6,8.95,13.35,8.9]],['C',[13,8.8,12.7,8.85]],['C',[12.35,8.95,12.1,9.1]]];
    __motifs["c"] = [['M',[12.95,41.05]],['C',[11,42.5,8.9,45]],['C',[6.8,47.45,5.25,50.85]],['C',[3.8,54.3,3.7,58.65]],['C',[3.7,63.05,5.4,66.85]],['C',[7.1,70.65,10.4,73]],['C',[13.65,75.35,18.55,75.45]],['C',[20.8,75.45,23.5,74.8]],['C',[26.15,74.15,28.85,72.8]],['C',[31.55,71.45,33.8,69.25]],['C',[34.3,68.8,34.55,68.4]],['C',[34.8,68,34.85,67.4]],['C',[34.85,66.8,34.45,66.15]],['C',[34.15,65.5,33.45,65.45]],['C',[33.1,65.45,32.85,65.6]],['C',[32.6,65.8,32.4,66]],['C',[30.25,68.1,27.8,69.15]],['C',[25.3,70.1,22.85,70.1]],['C',[19.3,70.1,16.45,68.25]],['C',[13.55,66.45,11.85,63.15]],['C',[10.2,59.9,10.15,55.5]],['C',[10.15,52.6,11.15,49.55]],['C',[12.1,46.55,14.2,44.5]],['C',[16.25,42.5,19.5,42.4]],['C',[21.15,42.4,23.2,43.15]],['C',[25.25,43.9,28.15,45.55]],['C',[28.8,45.9,29.2,46.1]],['C',[29.6,46.3,30.1,46.3]],['C',[31.1,46.25,32.3,45.35]],['C',[33.45,44.45,34.2,43.7]],['C',[35.25,42.5,35.5,42]],['C',[35.75,41.45,35.7,41.3]],['C',[35.65,40.85,35.4,40.6]],['C',[35.15,40.3,34.95,40.25]],['C',[33.75,39.3,30.85,38.15]],['C',[28,36.9,24.15,36.8]],['C',[22.15,36.75,19.3,37.6]],['C',[16.45,38.4,12.95,41.05]]];
    __motifs["d"] = [['M',[17.55,42.95]],['C',[18.9,42.3,19.9,42.2]],['C',[21,42,21.75,42.05]],['C',[21.9,42,24.75,42.25]],['C',[27.65,42.5,31.75,43.9]],['C',[32.2,44.05,32.55,44.35]],['C',[32.95,44.55,33,45.3]],['C',[33,45.55,32.95,47.55]],['C',[32.85,49.55,32.8,52.5]],['C',[32.7,55.4,32.6,58.4]],['C',[32.55,61.35,32.55,63.5]],['C',[32.55,64.65,32.6,65.7]],['C',[28.5,68.1,26,68.75]],['C',[23.45,69.35,22.45,69.25]],['C',[18.75,69.15,16,67]],['C',[13.35,64.85,11.85,61.55]],['C',[10.4,58.3,10.4,54.85]],['C',[10.45,50.8,12.4,47.7]],['C',[14.3,44.6,17.55,42.95]],['M',[41.35,11.45]],['C',[41.6,10.5,41.8,10.1]],['C',[41.95,9.75,41.95,9.2]],['C',[41.95,8.5,41.45,7.95]],['C',[40.95,7.4,40.35,7.4]],['C',[39.95,7.4,39.7,7.55]],['C',[39.4,7.7,39.2,7.85]],['C',[35.65,10.55,33,11.55]],['C',[30.3,12.6,29.65,12.75]],['C',[28.85,13.1,28.6,13.5]],['C',[28.35,13.95,28.35,14.3]],['C',[28.35,14.65,28.6,15.1]],['C',[28.9,15.5,29.7,15.75]],['C',[30.85,16.05,31.6,16.2]],['C',[32.3,16.4,32.55,17.5]],['C',[32.9,19.05,33,21.5]],['C',[33.1,23.95,33.2,28.05]],['C',[33.25,32.15,33.4,38.7]],['C',[30.85,38,28.7,37.75]],['C',[26.6,37.5,25.05,37.5]],['C',[22.7,37.5,20.7,37.95]],['C',[18.65,38.35,16.3,39.5]],['C',[13.3,40.9,10.4,43.45]],['C',[7.5,46,5.6,49.7]],['C',[3.75,53.4,3.65,58.4]],['C',[3.6,62.5,5.2,65.85]],['C',[6.75,69.25,10.2,71.75]],['C',[12.2,73.15,14.7,74.1]],['C',[17.2,75.1,19.55,75.15]],['C',[20.45,75.15,21.6,74.9]],['C',[22.65,74.65,24.05,73.95]],['C',[25.75,73.25,27.95,72]],['C',[30.1,70.75,32.5,68.95]],['C',[32.45,69,32.55,70.1]],['C',[32.6,71.2,32.75,72.85]],['C',[32.95,74.45,33.25,76]],['C',[33.25,76.2,33.5,76.75]],['C',[33.75,77.25,34.45,77.35]],['C',[34.8,77.3,35.9,76.85]],['C',[36.9,76.4,39.1,75.65]],['C',[41.3,74.8,45.15,73.75]],['C',[45.75,73.65,46.4,73.4]],['C',[47.05,73.05,47.1,72]],['C',[47.1,71.3,46.7,70.7]],['C',[46.25,70.1,45.4,70.1]],['C',[45.15,70.1,44.7,70.2]],['C',[44.2,70.35,42.95,70.7]],['C',[41.7,71.05,41.25,71.15]],['C',[40.8,71.3,40.65,71.25]],['C',[40.3,71.3,39.85,71]],['C',[39.4,70.75,39.25,69.85]],['C',[39.2,69.45,39,67.2]],['C',[38.85,64.95,38.85,61.55]],['C',[38.85,60.15,38.95,56.25]],['C',[39.05,52.35,39.25,46.9]],['C',[39.45,41.45,39.7,35.55]],['C',[39.95,29.6,40.3,24.15]],['C',[40.6,18.75,40.9,14.85]],['C',[41.1,12.45,41.35,11.45]]];
    __motifs["e"] = [['M',[19.65,42.8]],['C',[20.1,43.1,20.5,43.4]],['C',[21.45,44.15,22.2,44.95]],['C',[23.05,45.8,23.75,46.7]],['C',[23.95,47,24.1,47.35]],['C',[24.2,47.5,24.25,47.7]],['C',[24.3,47.9,24.3,48.1]],['C',[24.3,48.25,24.2,48.45]],['C',[24.15,48.6,24,48.7]],['C',[23.9,48.85,23.7,48.9]],['C',[23.5,48.95,23.35,49]],['L',[10.35,52.05]],['C',[10.35,50.35,10.95,48.7]],['C',[11.2,48,11.45,47.3]],['C',[11.75,46.6,12.1,45.95]],['C',[12.5,45.15,12.9,44.45]],['C',[13.35,43.8,13.9,43.2]],['C',[14.5,42.7,15.2,42.35]],['C',[15.85,42.1,16.6,42.05]],['C',[17.15,42,17.7,42.1]],['C',[18.2,42.2,18.7,42.35]],['C',[19.2,42.55,19.65,42.8]],['M',[5.6,47.1]],['C',[4.55,48.9,3.85,50.9]],['C',[3.15,52.9,2.85,55]],['C',[2.35,58.25,2.9,61.45]],['C',[3.35,64.7,4.95,67.5]],['C',[5.9,69.3,7.3,70.7]],['C',[8.6,72.15,10.3,73.2]],['C',[12,74.25,13.9,74.8]],['C',[15.8,75.35,17.8,75.35]],['C',[20.5,75.35,23.1,74.5]],['C',[25.65,73.7,28.05,72.4]],['C',[30.95,70.8,33.6,68.75]],['C',[33.85,68.55,34.05,68.3]],['C',[34.25,68.05,34.3,67.75]],['C',[34.35,67.45,34.3,67.2]],['C',[34.2,66.9,34,66.65]],['C',[33.85,66.35,33.55,66.2]],['C',[33.3,66,32.95,65.95]],['C',[32.65,65.9,32.35,66]],['C',[32.1,66.15,31.8,66.3]],['C',[29.65,67.7,27.2,68.75]],['C',[25.8,69.35,24.3,69.65]],['C',[22.85,70,21.35,70]],['C',[19.45,70,17.7,69.35]],['C',[15.9,68.65,14.55,67.4]],['C',[13.15,66.15,12.2,64.55]],['C',[11.25,62.95,10.75,61.1]],['C',[10.3,59.6,10.1,58.05]],['C',[9.95,56.5,10,54.9]],['L',[33.8,49.95]],['C',[34.05,49.9,34.25,49.8]],['C',[34.45,49.7,34.6,49.55]],['C',[34.75,49.35,34.85,49.15]],['C',[34.95,48.95,35,48.7]],['C',[35.1,48.3,35,47.9]],['C',[34.9,47.7,34.8,47.5]],['C',[34.65,47.35,34.5,47.2]],['C',[34.25,47.05,33.95,47]],['C',[33.6,46.9,33.3,46.8]],['C',[33.05,46.7,32.85,46.5]],['C',[32.65,46.3,32.5,46.05]],['C',[32.25,45.55,31.95,45.1]],['C',[30.6,43.45,29.1,41.95]],['C',[28.35,41.15,27.55,40.45]],['C',[26.7,39.8,25.85,39.2]],['C',[24.95,38.65,24,38.25]],['C',[23.1,37.9,22.1,37.65]],['C',[21.5,37.45,20.85,37.4]],['C',[20.2,37.3,19.55,37.35]],['C',[18.9,37.4,18.25,37.55]],['C',[17.65,37.7,17.05,37.95]],['C',[14.7,38.7,12.65,40.05]],['C',[10.5,41.35,8.7,43.15]],['C',[6.95,44.95,5.6,47.1]]];
    __motifs["f"] = [['M',[41.8,13.15]],['C',[41.8,12.45,41.4,11.65]],['C',[41.05,10.85,39.95,10.2]],['C',[39.6,9.95,37.25,9.15]],['C',[34.9,8.35,31.35,8.25]],['C',[27.1,8.3,23.5,10]],['C',[19.8,11.7,17.05,14.5]],['C',[14.3,17.25,12.8,20.45]],['C',[10.7,25.05,10.35,29.65]],['C',[10,34.15,10,38.9]],['C',[9.9,38.9,8.65,38.8]],['C',[7.4,38.75,6.05,38.65]],['C',[4.75,38.6,4.4,38.6]],['C',[4.25,38.55,3.8,38.7]],['C',[3.4,38.8,3.15,39.3]],['C',[3.15,39.5,3.15,39.85]],['C',[3.15,40.25,3.15,41.15]],['C',[3.1,41.45,3.15,41.95]],['C',[3.3,42.4,3.9,42.65]],['C',[4,42.7,4.35,42.7]],['C',[4.7,42.7,5.95,42.75]],['C',[7.25,42.75,10.1,42.8]],['C',[9.8,53.7,9.75,59.9]],['C',[9.65,66.15,9.65,67.75]],['C',[9.7,68.5,9.4,69.45]],['C',[9.2,70.5,8.05,71.05]],['C',[7.55,71.3,6.95,71.3]],['C',[6.25,71.35,5,71.3]],['C',[4.75,71.25,3.95,71.5]],['C',[3.2,71.7,3.15,73.1]],['C',[3.15,73.65,3.4,74.3]],['C',[3.75,74.95,4.65,75]],['C',[5.1,74.95,7.8,74.8]],['C',[10.55,74.6,15.2,74.55]],['C',[19.3,74.6,21.65,74.75]],['C',[24,74.85,24.45,74.9]],['C',[25.4,74.85,25.8,74.3]],['C',[26.15,73.75,26.15,73.1]],['C',[26.2,72.45,25.8,71.8]],['C',[25.4,71.15,24.25,71.1]],['C',[23.95,71.1,22.7,71.15]],['C',[21.5,71.2,20.2,71.25]],['C',[19,71.3,18.65,71.3]],['C',[18.4,71.35,17.75,71.15]],['C',[17.15,70.9,17,69.8]],['C',[16.95,69.4,16.95,66.65]],['C',[16.9,63.85,16.85,59.85]],['C',[16.8,55.9,16.75,52]],['C',[16.75,48.1,16.7,45.45]],['C',[16.7,42.8,16.7,42.7]],['L',[30.3,42.8]],['C',[31.35,42.8,31.75,42.25]],['C',[32.15,41.7,32.1,40.3]],['C',[32.1,39.85,32.05,39.45]],['C',[32.05,39.05,31.95,38.85]],['C',[31.8,38.35,31.45,38.25]],['C',[31.05,38.15,30.8,38.15]],['C',[30.5,38.15,28.4,38.25]],['C',[26.3,38.35,23.65,38.45]],['C',[20.9,38.55,18.8,38.6]],['C',[16.7,38.7,16.4,38.7]],['C',[16.55,34.2,16.65,31.65]],['C',[16.75,29.05,17,27.15]],['C',[17.2,25.3,17.7,23]],['C',[18.05,21.25,18.9,19.05]],['C',[19.7,16.9,21.35,15.25]],['C',[23,13.7,25.95,13.6]],['C',[27,13.55,28.9,14.05]],['C',[30.8,14.55,34.15,15.95]],['C',[35.3,16.5,36.15,16.8]],['C',[37,17.15,37.85,17.15]],['C',[39.65,17.1,40.7,15.85]],['C',[41.75,14.7,41.8,13.15]]];
    __motifs["g"] = [['M',[11.2,94.25]],['C',[8.05,92.5,7.95,89.35]],['C',[7.95,87.55,9.3,85.6]],['C',[10.65,83.65,13.55,81]],['C',[19.25,81.55,23.55,81.5]],['C',[27.85,81.45,31,81.95]],['C',[33.95,82.55,35.2,83.9]],['C',[36.45,85.25,36.45,86.85]],['C',[36.4,89.4,34.05,91.45]],['C',[31.75,93.5,27.9,94.7]],['C',[24.05,95.95,19.55,96]],['C',[14.35,96,11.2,94.25]],['M',[19.7,40.25]],['C',[22.5,40.25,25.15,42.15]],['C',[27.85,43.95,29.55,46.95]],['C',[31.25,50,31.3,53.55]],['C',[31.35,54.65,30.9,56.3]],['C',[30.45,57.9,28.95,59.65]],['C',[27.45,61.4,24.2,62.95]],['C',[20.55,62.9,17.5,61.35]],['C',[14.4,59.9,12.55,57.1]],['C',[10.7,54.4,10.65,50.6]],['C',[10.75,46.2,13.25,43.25]],['C',[15.75,40.3,19.7,40.25]],['M',[43.3,40.35]],['C',[43.3,39.65,43,39.3]],['C',[42.7,38.95,42.35,38.9]],['C',[42.05,38.8,41.6,38.8]],['C',[41.15,38.75,40.9,38.75]],['C',[38.85,38.8,36.95,39.45]],['C',[35,40.15,33.4,41.4]],['C',[31.15,39,28.2,37.7]],['C',[25.3,36.3,22,36.3]],['C',[17.65,36.35,13.65,38.7]],['C',[9.65,41,7.15,44.8]],['C',[4.6,48.6,4.5,53.15]],['C',[4.55,56.85,6.3,59.8]],['C',[8.1,62.8,11.1,64.7]],['C',[14.1,66.6,17.9,67.05]],['C',[13.45,69.45,10.4,70.85]],['C',[7.4,72.2,5.95,72.8]],['C',[5.65,72.9,5.05,73.4]],['C',[4.45,73.8,4.4,74.9]],['C',[4.35,76.1,5.8,77.75]],['C',[7.3,79.4,10.7,80.2]],['C',[6.1,83.5,3.85,86.35]],['C',[1.6,89.25,1.6,92.1]],['C',[1.55,94.1,2.9,96.05]],['C',[4.25,98,7.7,99.05]],['C',[8.65,99.35,10.7,99.7]],['C',[12.8,100,15.8,100.05]],['C',[16.85,100.05,18.8,99.95]],['C',[20.7,99.85,23.15,99.5]],['C',[25.55,99.15,28,98.45]],['C',[32.55,96.95,35.75,94.55]],['C',[38.9,92.2,40.6,89.4]],['C',[42.25,86.6,42.25,83.95]],['C',[42.25,81.55,40.8,79.55]],['C',[39.35,77.55,36.2,76.4]],['C',[34.5,75.85,32.7,75.65]],['C',[30.85,75.45,29.3,75.35]],['C',[27.8,75.3,27,75.3]],['C',[24.2,75.35,21.95,75.5]],['C',[19.7,75.6,18.05,75.65]],['C',[17.55,75.65,16.2,75.55]],['C',[14.85,75.45,13.5,74.95]],['C',[13.35,74.95,13,74.7]],['C',[12.65,74.5,12.6,74.05]],['C',[12.6,73.4,13.8,72.5]],['C',[15,71.65,17.25,70.4]],['C',[19.5,69.1,20.45,68.55]],['C',[21.45,67.95,21.85,67.8]],['C',[22.15,67.65,22.55,67.45]],['C',[22.95,67.3,24.1,66.8]],['C',[29.6,64,32.4,61.3]],['C',[35.2,58.65,36.15,56.2]],['C',[37.05,53.75,37,51.7]],['C',[37,49.95,36.5,48]],['C',[36.1,46.1,35.2,44.25]],['C',[35.95,44,36.65,44]],['C',[38.25,44.1,39.15,44.6]],['C',[40.1,45.15,40.3,45.35]],['C',[40.4,45.5,40.6,45.6]],['C',[40.7,45.7,40.95,45.7]],['C',[41.4,45.7,41.65,45.4]],['C',[41.95,45.05,42.1,44.8]],['C',[42.9,43.15,43.1,41.95]],['C',[43.35,40.65,43.3,40.35]]];
    __motifs["h"] = [['M',[14.8,8.35]],['C',[11.8,10.05,9.4,11.2]],['C',[6.9,12.4,4.55,13.65]],['C',[4.3,13.75,3.8,14.25]],['C',[3.3,14.7,3.25,15.55]],['C',[3.25,16.15,3.6,16.55]],['C',[4,16.95,4.6,17]],['C',[5.1,16.95,5.65,16.7]],['C',[6.25,16.45,6.8,16.45]],['C',[7.35,16.4,7.95,16.95]],['C',[8.6,17.45,8.85,18.9]],['C',[9.1,20.25,9.1,21.9]],['C',[9.1,23.55,9.1,24.8]],['C',[9.1,31.6,9,38.95]],['C',[8.9,46.35,8.75,52.9]],['C',[8.55,59.45,8.35,63.9]],['C',[8.15,68.3,8,69.15]],['C',[7.55,70.5,6.6,70.75]],['C',[5.65,71.05,4.6,71.1]],['C',[3.55,71.25,3.15,71.75]],['C',[2.85,72.25,2.9,72.8]],['C',[2.9,73.45,3.25,73.95]],['C',[3.7,74.55,4.75,74.6]],['C',[5.1,74.6,7,74.5]],['C',[8.85,74.4,12.05,74.4]],['C',[15.35,74.4,17.2,74.5]],['C',[19.1,74.6,19.45,74.6]],['C',[20.4,74.55,20.8,74]],['C',[21.2,73.5,21.2,72.85]],['C',[21.2,72.2,20.85,71.6]],['C',[20.45,71.05,19.6,70.85]],['C',[19.1,70.8,18,70.7]],['C',[16.95,70.6,16.5,70.55]],['C',[15.55,70.35,15.35,69.7]],['C',[15.15,69.1,15.2,68.65]],['L',[15.4,45.6]],['C',[15.45,45.5,16.95,44.7]],['C',[18.45,43.95,20.8,43.15]],['C',[23.2,42.3,25.8,42.3]],['C',[28.35,42.25,30.5,43.6]],['C',[32.6,44.95,33.7,48.4]],['C',[34.4,51,34.55,54]],['C',[34.75,56.95,34.7,58.85]],['C',[34.7,60.5,34.6,62.5]],['C',[34.45,64.5,34.1,67.6]],['C',[33.75,69.8,32.65,70.45]],['C',[31.65,71.1,30.2,71.5]],['C',[29.35,71.75,29.05,72.3]],['C',[28.75,72.85,28.8,73.3]],['C',[28.8,73.95,29.2,74.45]],['C',[29.65,75,30.5,75]],['C',[31.05,75,33.85,74.8]],['C',[36.6,74.55,41.4,74.55]],['C',[43,74.55,43.95,74.55]],['C',[44.8,74.6,45,74.6]],['C',[46,74.55,46.35,74.05]],['C',[46.7,73.55,46.65,73.1]],['C',[46.7,72.65,46.35,72.15]],['C',[46.05,71.65,45.25,71.5]],['C',[44.85,71.4,44,71.25]],['C',[43.15,71.15,42.7,71.05]],['C',[42.35,71.05,41.8,70.7]],['C',[41.25,70.3,41.2,69.2]],['C',[41.2,68.65,41.35,66.15]],['C',[41.5,63.6,41.55,59.25]],['C',[41.5,53.5,41.25,50.85]],['C',[41,48.25,40.8,47.55]],['C',[39.7,42.3,36.75,39.85]],['C',[33.85,37.4,30,37.45]],['C',[26.3,37.55,22.35,39.1]],['C',[18.45,40.7,15.4,42.45]],['L',[16.8,15.85]],['C',[16.9,13.65,17.25,12.6]],['C',[17.6,11.5,17.8,11]],['C',[18.1,10.4,18.1,9.75]],['C',[18.1,8.95,17.6,8.4]],['C',[17.05,7.85,16.25,7.85]],['C',[15.75,7.85,15.45,8]],['C',[15.05,8.15,14.8,8.35]]];
    __motifs["i"] = [['M',[15.9,36.5]],['C',[15.35,36.5,14.75,36.9]],['C',[14.15,37.3,13,38.15]],['C',[11.75,39,9.4,40.35]],['C',[7.35,41.5,6.05,42.05]],['C',[4.75,42.6,4.4,42.75]],['C',[3.8,43.05,3.6,43.45]],['C',[3.45,43.8,3.45,44.1]],['C',[3.45,44.45,3.7,44.8]],['C',[3.95,45.15,4.4,45.35]],['C',[5.35,45.55,6.35,45.65]],['C',[7.35,45.75,7.8,46.95]],['C',[7.95,47.6,8.05,49.45]],['C',[8.2,51.3,8.3,53.65]],['C',[8.35,56,8.35,57.95]],['C',[8.35,61.45,8.2,64.25]],['C',[8.05,67.05,7.9,68.65]],['C',[7.7,70.25,7,70.7]],['C',[6.2,71.15,4.8,71.45]],['C',[4.2,71.55,3.6,71.85]],['C',[3,72.15,2.95,73.1]],['C',[2.95,73.6,3.25,74.2]],['C',[3.6,74.75,4.45,74.8]],['C',[4.85,74.8,6.7,74.65]],['C',[8.6,74.5,11.85,74.5]],['C',[15.65,74.5,17.8,74.7]],['C',[20,74.9,20.45,74.95]],['C',[21.25,74.9,21.65,74.4]],['C',[22,73.9,22,73.25]],['C',[22.05,72.85,21.8,72.25]],['C',[21.5,71.7,20.6,71.6]],['C',[18.65,71.5,17.65,71.5]],['C',[16.55,71.45,15.85,70.9]],['C',[15,70.1,14.85,68.9]],['C',[14.75,67.65,14.8,65.85]],['C',[14.8,61,15,56]],['C',[15.15,51,15.45,47.15]],['C',[15.7,43.3,16,41.9]],['C',[16.45,40.25,16.95,39.55]],['C',[17.4,38.85,17.45,38.1]],['C',[17.45,37.4,17,36.95]],['C',[16.6,36.5,15.9,36.5]],['M',[18.15,17.85]],['C',[18.1,16.45,17.05,15.55]],['C',[16,14.7,14.6,14.65]],['C',[12.75,14.75,11.75,16.05]],['C',[10.75,17.3,10.75,18.9]],['C',[10.8,20.25,11.55,21.15]],['C',[12.35,21.95,13.6,22]],['C',[15.15,21.95,16.6,20.8]],['C',[18.05,19.55,18.15,17.85]]];
    __motifs["j"] = [['M',[17.55,35.3]],['C',[17.1,35.3,16.75,35.5]],['C',[16.4,35.7,16.15,36]],['C',[12.2,39.2,9.4,40.65]],['C',[6.6,42.15,5.9,42.4]],['C',[5.75,42.45,5.35,42.85]],['C',[5,43.2,4.95,43.85]],['C',[4.95,44.2,5.15,44.45]],['C',[5.25,44.75,5.6,44.95]],['C',[5.9,45.1,6.25,45.15]],['C',[6.6,45.2,6.9,45.2]],['L',[7.6,45.2]],['C',[8.1,45.1,9.1,45.4]],['C',[10,45.7,10.5,47.05]],['C',[10.65,47.4,10.7,48.15]],['C',[10.75,48.85,10.75,50.85]],['C',[10.75,52.8,10.75,56.9]],['C',[10.75,64.35,10.7,69]],['C',[10.65,73.6,10.55,76.2]],['C',[10.5,78.8,10.4,79.95]],['C',[10.35,81.1,10.3,81.5]],['C',[9.85,84.9,9.15,86.85]],['C',[8.35,88.8,7.4,89.95]],['C',[6.5,91.05,5.6,91.85]],['C',[4.65,92.65,3.65,94]],['C',[2.75,95.35,2.65,97.3]],['C',[2.75,99.05,3.45,99.55]],['C',[4.25,100.05,4.8,100]],['C',[5.25,100.05,5.85,99.65]],['C',[6.45,99.3,6.55,98.15]],['C',[6.5,97.3,6.7,96.6]],['C',[6.85,96,7.9,95.2]],['C',[12.05,92.1,14.2,89.4]],['C',[16.3,86.65,17.05,83.9]],['C',[17.75,81.1,17.7,77.8]],['C',[17.7,76.5,17.65,72.8]],['C',[17.6,69.1,17.6,62.35]],['C',[17.6,53.2,17.75,44.05]],['C',[17.85,41.35,18.1,40]],['C',[18.35,38.65,18.6,38]],['C',[18.85,37.35,18.9,36.75]],['C',[18.85,36.05,18.45,35.7]],['C',[18.1,35.3,17.55,35.3]],['M',[18.75,18.15]],['C',[18.7,16.75,17.65,15.85]],['C',[16.6,15,15.2,14.95]],['C',[13.35,15.05,12.35,16.35]],['C',[11.35,17.6,11.35,19.2]],['C',[11.4,20.55,12.15,21.45]],['C',[12.95,22.25,14.2,22.3]],['C',[15.7,22.25,17.2,21.1]],['C',[18.65,19.85,18.75,18.15]]];
    __motifs["k"] = [['M',[41.25,40.15]],['C',[41.25,39.45,40.8,38.95]],['C',[40.4,38.45,39.5,38.45]],['C',[38.95,38.45,36.8,38.7]],['C',[34.65,38.95,30.8,39]],['C',[27.95,39,26.2,38.85]],['C',[24.55,38.7,24.2,38.65]],['C',[23.35,38.7,22.95,39.3]],['C',[22.55,39.9,22.55,40.4]],['C',[22.6,41.15,23.1,41.4]],['C',[23.65,41.65,23.95,41.7]],['C',[24.55,41.8,25.05,42]],['C',[25.6,42.2,25.65,42.7]],['C',[25.65,42.95,25.5,43.15]],['C',[25.25,43.5,23.25,45.35]],['C',[21.3,47.15,18.2,49.35]],['C',[17.1,50.15,16.7,50.35]],['C',[16.3,50.6,16.1,50.6]],['C',[15.85,50.6,15.6,50.4]],['C',[15.3,50.15,15.3,49.45]],['C',[15.3,49.35,15.3,46.95]],['C',[15.35,44.55,15.4,40.7]],['C',[15.45,36.85,15.6,32.45]],['C',[15.65,28.05,15.85,24]],['C',[16.05,19.95,16.3,17.15]],['C',[16.6,14.4,16.85,13.2]],['C',[17.15,12.05,17.35,11.55]],['C',[17.55,11.1,17.55,10.5]],['C',[17.5,9.6,17,9.05]],['C',[16.5,8.55,15.75,8.5]],['C',[14.95,8.5,14.25,9.15]],['C',[13.55,9.8,11.5,11.05]],['C',[9.55,12.4,4.95,14.25]],['C',[4.3,14.45,3.7,14.8]],['C',[3.15,15.15,3.1,16.05]],['C',[3.1,16.7,3.45,17.3]],['C',[3.9,17.95,4.9,18]],['C',[5.25,18,5.9,17.95]],['C',[6.6,17.9,6.95,17.85]],['C',[8,17.95,8.35,18.6]],['C',[8.65,19.3,8.65,19.6]],['C',[8.7,20.1,8.85,23.55]],['C',[9.05,26.95,9.2,32.25]],['C',[9.35,37.6,9.35,43.9]],['C',[9.35,50.8,9.15,56.45]],['C',[9,62.1,8.8,65.45]],['C',[8.6,68.85,8.6,69.1]],['C',[8.45,70.65,7.55,71.15]],['C',[6.75,71.55,5.4,71.85]],['C',[4.95,71.95,4.35,72.25]],['C',[3.75,72.6,3.7,73.55]],['C',[3.65,74.1,4,74.6]],['C',[4.3,75.15,4.95,75.15]],['C',[5.35,75.1,7.45,74.75]],['C',[9.55,74.45,13.25,74.4]],['C',[16.05,74.4,17.65,74.6]],['C',[19.25,74.8,19.65,74.85]],['C',[20.3,74.8,20.65,74.35]],['C',[21,73.9,21,73.35]],['C',[21,72.95,20.75,72.5]],['C',[20.55,72.05,19.8,71.9]],['C',[19.4,71.85,18.35,71.75]],['C',[17.3,71.6,16.9,71.55]],['C',[16.15,71.4,15.95,71]],['C',[15.7,70.55,15.7,70.15]],['C',[15.65,69.85,15.65,68.15]],['C',[15.6,66.4,15.55,63.75]],['C',[15.5,61.15,15.5,58.25]],['C',[15.5,57.6,15.5,56.55]],['C',[15.5,55.4,15.5,55.1]],['C',[15.55,54.7,15.7,54.55]],['C',[15.95,54.35,16.15,54.4]],['C',[16.45,54.4,16.7,54.55]],['C',[16.9,54.7,17.05,54.8]],['C',[19.15,57,22.35,60.9]],['C',[25.55,64.7,29.15,69.8]],['C',[29.35,70.1,29.55,70.4]],['C',[29.7,70.65,29.7,71]],['C',[29.65,71.7,29.1,71.9]],['C',[28.55,72.1,28.2,72.15]],['C',[27.95,72.15,27.4,72.4]],['C',[26.85,72.6,26.8,73.4]],['C',[26.8,73.75,27.15,74.3]],['C',[27.45,74.85,28.4,74.9]],['C',[28.6,74.9,29.7,74.9]],['C',[30.75,74.85,32.55,74.85]],['C',[37.05,74.9,39.75,75]],['C',[42.45,75.1,42.8,75.1]],['C',[43.6,75.1,43.9,74.65]],['C',[44.25,74.2,44.2,73.65]],['C',[44.25,73.25,44,72.75]],['C',[43.75,72.2,42.95,71.95]],['C',[41.95,71.65,41.1,71.45]],['C',[40.3,71.25,39.6,70.75]],['C',[39.4,70.6,38.95,70.15]],['C',[38.5,69.7,36.9,68.1]],['C',[35.35,66.5,31.85,62.85]],['C',[28.3,59.2,21.95,52.75]],['C',[21.5,52.25,21.3,52]],['C',[21.05,51.75,21.05,51.5]],['C',[21,51.2,21.45,50.85]],['C',[21.9,50.55,23.45,49.6]],['C',[25,48.7,28.35,46.7]],['C',[31.2,45,32.6,44.25]],['C',[34,43.4,35.1,43]],['C',[36.55,42.5,37.55,42.45]],['C',[38.55,42.35,38.95,42.35]],['C',[40.25,42.2,40.75,41.5]],['C',[41.25,40.8,41.25,40.15]]];
    __motifs["l"] = [['M',[15.9,9.9]],['C',[15.4,10.3,14.25,11.05]],['C',[13.2,11.85,11,13.05]],['C',[8.8,14.2,7.3,14.8]],['C',[5.85,15.3,5.4,15.45]],['C',[4.65,15.85,4.4,16.35]],['C',[4.15,16.85,4.15,17.25]],['C',[4.15,17.75,4.5,18.2]],['C',[4.9,18.6,5.55,18.65]],['C',[5.9,18.65,6.5,18.55]],['C',[7.1,18.45,7.45,18.45]],['C',[8.2,18.45,8.75,18.9]],['C',[9.3,19.35,9.45,20.4]],['C',[9.6,21.2,9.65,23.5]],['C',[9.7,25.75,9.75,28.5]],['C',[9.8,31.3,9.8,33.5]],['C',[9.8,35.7,9.8,36.35]],['C',[9.8,44.7,9.6,51.55]],['C',[9.4,58.4,9.25,62.6]],['C',[9.05,66.8,9,67.25]],['C',[8.75,69.85,7.5,70.65]],['C',[6.3,71.45,4.75,71.8]],['C',[4.3,71.85,3.7,72.2]],['C',[3.15,72.55,3.15,73.55]],['C',[3.15,74.25,3.45,74.75]],['C',[3.85,75.2,4.45,75.2]],['C',[4.95,75.15,6.65,74.75]],['C',[8.3,74.35,11.5,74.3]],['C',[15.15,74.35,17.9,74.85]],['C',[20.7,75.35,21.4,75.4]],['C',[22.2,75.35,22.65,74.8]],['C',[23.1,74.25,23.1,73.55]],['C',[23.1,73.1,22.8,72.65]],['C',[22.5,72.15,21.75,71.95]],['C',[21.25,71.85,20.2,71.75]],['C',[19.2,71.6,18.6,71.5]],['C',[17.45,71.2,17.05,70.45]],['C',[16.65,69.65,16.6,68.95]],['C',[16.55,68.4,16.45,66.45]],['C',[16.4,64.55,16.35,61.9]],['C',[16.3,59.25,16.3,56.55]],['C',[16.3,52,16.45,47.1]],['C',[16.55,42.25,16.8,36.25]],['C',[17.05,30.25,17.4,22.35]],['C',[17.6,18.05,17.85,15.8]],['C',[18.1,13.55,18.3,12.65]],['C',[18.5,11.65,18.5,11.15]],['C',[18.5,10.4,18.05,9.95]],['C',[17.65,9.5,17.05,9.5]],['C',[16.5,9.5,15.9,9.9]]];
    __motifs["m"] = [['M',[46.8,44.65]],['C',[50.5,44.7,52.2,45.7]],['C',[53.85,46.7,54.4,48.1]],['C',[55.35,50.45,55.55,52.9]],['C',[55.75,55.35,55.7,56.75]],['C',[55.65,63.05,55.25,66.15]],['C',[54.85,69.35,54.55,69.9]],['C',[54.15,70.85,53.25,71.3]],['C',[52.4,71.65,51,72.05]],['C',[50.7,72.1,50,72.5]],['C',[49.35,72.9,49.3,73.9]],['C',[49.3,74.55,49.65,74.95]],['C',[50,75.4,50.65,75.4]],['C',[51.1,75.35,52.85,75]],['C',[54.5,74.65,58.1,74.6]],['C',[59.4,74.6,61.35,74.65]],['C',[63.25,74.75,65,74.8]],['C',[66.75,74.9,67.6,74.9]],['C',[68.5,74.85,68.8,74.3]],['C',[69.15,73.8,69.1,73.35]],['C',[69.15,72.85,68.85,72.35]],['C',[68.55,71.8,67.7,71.6]],['C',[67.4,71.55,66.45,71.5]],['C',[65.5,71.4,64.55,71.3]],['C',[63.55,71.2,63.3,71.15]],['C',[62.4,71,62.25,70.45]],['C',[62.05,69.9,62.1,69.6]],['C',[62.1,69.35,62.1,66.8]],['C',[62.15,64.25,62.2,60.95]],['C',[62.25,57.55,62.25,54.8]],['C',[62.3,52.05,62.3,51.25]],['C',[62.35,49.9,62.15,47.95]],['C',[61.95,45.95,61.15,44]],['C',[60.3,42,58.35,40.65]],['C',[56.45,39.35,53,39.3]],['C',[49.1,39.35,45,40.7]],['C',[40.85,42.1,37.3,44.3]],['C',[36.75,41.9,34.7,40.25]],['C',[32.65,38.6,29.35,38.5]],['C',[28.6,38.45,26.8,38.8]],['C',[25,39.1,21.9,40.35]],['C',[18.85,41.6,14.3,44.4]],['C',[14.6,41.6,14.9,40.2]],['C',[15.25,38.75,15.3,38.4]],['C',[15.25,37.85,14.8,37.5]],['C',[14.35,37.2,13.85,37.2]],['C',[13.55,37.15,12.95,37.55]],['C',[12.3,37.95,10.5,38.95]],['C',[8.7,40.05,4.7,42.1]],['C',[3.8,42.45,3.05,42.9]],['C',[2.25,43.4,2.2,44.25]],['C',[2.2,44.65,2.5,45]],['C',[2.8,45.35,3.35,45.45]],['C',[3.5,45.5,3.75,45.5]],['C',[4,45.5,4.55,45.5]],['C',[5.1,45.4,6.05,45.75]],['C',[7.05,46.15,7.3,48]],['C',[7.3,48.3,7.4,49.75]],['C',[7.45,51.2,7.55,53.4]],['C',[7.6,55.6,7.6,58.1]],['C',[7.6,59.25,7.55,61.75]],['C',[7.5,64.25,7.4,66.6]],['C',[7.3,69,7.05,69.8]],['C',[6.75,70.75,5.95,71.2]],['C',[5.2,71.6,3.95,72.15]],['C',[3.55,72.3,3.15,72.65]],['C',[2.75,73,2.7,73.9]],['C',[2.7,74.6,3.05,74.95]],['C',[3.3,75.25,3.8,75.25]],['C',[4.25,75.2,6.2,74.8]],['C',[8.15,74.4,11.6,74.35]],['C',[14.45,74.4,16,74.65]],['C',[17.6,74.95,18.05,74.95]],['C',[18.75,74.95,19.15,74.55]],['C',[19.5,74.1,19.55,73.55]],['C',[19.55,73.05,19.2,72.55]],['C',[18.85,72.05,18.05,71.8]],['C',[17.65,71.65,16.8,71.5]],['C',[15.95,71.45,15.55,71.3]],['C',[14.55,71,14.35,70.25]],['C',[14.15,69.5,14.2,68.9]],['C',[14.2,68.65,14.2,68.4]],['L',[14.2,47.2]],['C',[14.25,47.1,15.8,46.35]],['C',[17.4,45.55,19.85,44.7]],['C',[22.35,43.95,25.1,43.9]],['C',[26.45,43.8,28.2,44.6]],['C',[30,45.4,31.1,48.45]],['C',[31.5,49.75,31.65,51.4]],['C',[31.75,53.05,31.75,55.8]],['C',[31.75,58.25,31.65,60.95]],['C',[31.55,63.6,31.35,65.75]],['C',[31.15,67.9,30.95,68.7]],['C',[30.4,70.3,29.15,70.9]],['C',[27.9,71.5,26.35,71.85]],['C',[26.05,71.9,25.55,72.25]],['C',[24.95,72.55,24.9,73.5]],['C',[24.9,74,25.25,74.45]],['C',[25.6,74.9,26.3,74.9]],['C',[26.7,74.9,28.45,74.75]],['C',[30.25,74.6,33.4,74.6]],['C',[37.4,74.6,39.75,74.85]],['C',[42.05,75.1,42.5,75.15]],['C',[43.25,75.1,43.65,74.6]],['C',[44,74.15,44,73.5]],['C',[44.05,72.95,43.7,72.45]],['C',[43.4,71.95,42.7,71.8]],['C',[42.3,71.75,41.45,71.7]],['C',[40.65,71.7,40.1,71.6]],['C',[38.55,71.35,38.25,70.4]],['C',[37.95,69.5,38,69.1]],['C',[38,68.5,38.15,65.35]],['C',[38.3,62.25,38.35,56.85]],['C',[38.35,53.25,38.3,51.3]],['C',[38.25,49.35,38.15,48.45]],['C',[38.05,47.5,37.9,46.95]],['C',[39.95,45.85,42.2,45.25]],['C',[44.45,44.65,46.8,44.65]]];
    __motifs["n"] = [['M',[3.45,41.25]],['C',[2.85,41.55,2.8,42.3]],['C',[2.75,42.6,3,43]],['C',[3.2,43.4,4,43.6]],['C',[5.35,43.9,6.35,44.2]],['C',[7.35,44.45,8,45.5]],['C',[8.35,46,8.6,47.35]],['C',[8.8,48.65,8.8,52.15]],['C',[8.8,53.2,8.75,55.6]],['C',[8.75,58.05,8.65,60.9]],['C',[8.55,63.7,8.3,66.05]],['C',[8.1,68.4,7.75,69.35]],['C',[7.3,70.45,6.4,71]],['C',[5.5,71.5,4.45,71.95]],['C',[4.1,72.05,3.6,72.45]],['C',[3.15,72.85,3.1,73.8]],['C',[3.1,74.6,3.4,75]],['C',[3.8,75.4,4.35,75.4]],['C',[4.85,75.35,6.45,74.9]],['C',[8.05,74.5,11.55,74.4]],['C',[13.25,74.45,15.5,74.55]],['C',[17.75,74.65,19.55,74.7]],['C',[20.65,74.65,21.1,74]],['C',[21.5,73.45,21.45,72.95]],['C',[21.5,72.6,21.25,72.15]],['C',[20.95,71.7,20.1,71.5]],['C',[19.8,71.5,19.15,71.4]],['C',[18.4,71.3,17.7,71.2]],['C',[17,71.1,16.75,71.05]],['C',[15.8,70.75,15.65,70.1]],['C',[15.45,69.45,15.5,69]],['L',[15.75,47.4]],['C',[19.25,45.05,21.55,44.55]],['C',[23.85,44.05,24.45,44.15]],['C',[27.2,44.15,29.6,45.7]],['C',[32,47.3,32.85,50.3]],['C',[33.2,51.45,33.35,53.1]],['C',[33.5,54.8,33.5,56.3]],['C',[33.55,57.75,33.55,58.45]],['C',[33.5,62.2,33.2,64.85]],['C',[32.95,67.4,32.8,68.1]],['C',[32.45,70.05,31.55,70.7]],['C',[30.6,71.35,29.2,71.75]],['C',[28.85,71.8,28.25,72.2]],['C',[27.75,72.55,27.65,73.55]],['C',[27.65,74.15,28.05,74.65]],['C',[28.4,75.1,29.15,75.15]],['C',[29.6,75.1,31.7,74.8]],['C',[33.8,74.5,37.45,74.45]],['C',[40.8,74.5,42.7,74.75]],['C',[44.65,75,45.05,75.05]],['C',[45.95,75,46.3,74.3]],['C',[46.7,73.65,46.65,73.1]],['C',[46.7,72.7,46.45,72.3]],['C',[46.2,71.9,45.55,71.7]],['C',[45.3,71.65,44.5,71.55]],['C',[43.65,71.45,42.8,71.35]],['C',[41.95,71.2,41.7,71.15]],['C',[40.9,70.95,40.7,70.35]],['C',[40.55,69.8,40.6,69.4]],['L',[40.65,52.85]],['C',[40.7,50.6,40.35,48.55]],['C',[40,46.5,38.85,44.4]],['C',[37.5,42.05,35.15,40.3]],['C',[32.75,38.6,29.55,38.5]],['C',[26.2,38.6,22.45,40.3]],['C',[18.7,42.05,15.85,44.2]],['C',[15.95,42.3,16,41.4]],['C',[16,40.55,16.1,40.05]],['C',[16.15,39.65,16.2,39.35]],['C',[16.25,39.05,16.25,38.75]],['C',[16.25,38.15,15.9,37.85]],['C',[15.65,37.5,15.15,37.5]],['C',[14.7,37.55,13.65,37.95]],['C',[12.7,38.3,10.55,39.1]],['C',[8.35,39.85,4.5,40.9]],['C',[4.1,40.95,3.45,41.25]]];
    __motifs["o"] = [['M',[26.6,43.9]],['C',[29.7,45.65,31.8,49.4]],['C',[33.9,53.2,34,59.35]],['C',[33.95,63.45,32.55,65.9]],['C',[31.2,68.4,29.1,69.45]],['C',[27,70.6,24.85,70.55]],['C',[21.9,70.55,18.65,68.65]],['C',[15.4,66.8,13.15,63.3]],['C',[10.85,59.85,10.75,55]],['C',[10.75,52,11.8,49.05]],['C',[12.9,46.15,15.1,44.25]],['C',[17.3,42.3,20.65,42.25]],['C',[23.6,42.2,26.6,43.9]],['M',[15.45,39.2]],['C',[12.2,40.75,9.95,42.95]],['C',[5.95,47,4.7,50.65]],['C',[3.45,54.3,3.55,56.9]],['C',[3.55,59.65,4.4,62.6]],['C',[5.25,65.5,7.2,68.15]],['C',[9.1,70.8,12.2,72.6]],['C',[15.15,74.2,17.9,74.7]],['C',[20.65,75.25,22.4,75.2]],['C',[23.3,75.25,25.1,75]],['C',[26.9,74.7,29.4,73.65]],['C',[31.9,72.65,34.85,70.4]],['C',[38.9,67.05,40.35,63.05]],['C',[41.75,59.05,41.65,55.6]],['C',[41.55,50,39,45.95]],['C',[36.45,41.95,32.25,39.75]],['C',[28,37.6,23,37.55]],['C',[18.6,37.65,15.45,39.2]]];
    __motifs["p"] = [['M',[16.2,44.2]],['C',[17.4,43.55,19.35,42.85]],['C',[21.3,42.25,23.65,42.2]],['C',[26.85,42.25,29.3,43.75]],['C',[31.75,45.25,33.4,47.4]],['C',[34.75,49,36.05,51.75]],['C',[37.3,54.5,37.4,57.95]],['C',[37.35,61.9,35.6,64.85]],['C',[33.85,67.75,31.2,69.4]],['C',[28.55,71.05,25.95,71.05]],['C',[24.15,71,21.9,70.3]],['C',[19.6,69.55,17.65,68.8]],['C',[15.65,68,15,67.65]],['L',[15,44.9]],['C',[15.05,44.85,16.2,44.2]],['M',[14.3,35.9]],['C',[13.9,35.6,13.45,35.6]],['C',[12.85,35.65,12.35,36]],['C',[11.85,36.35,11.25,36.8]],['C',[9.6,37.95,7.7,38.75]],['C',[5.8,39.55,3.25,40.95]],['C',[3,41.1,2.7,41.4]],['C',[2.4,41.7,2.35,42.35]],['C',[2.35,42.7,2.55,43.4]],['C',[2.8,44.1,3.55,44.15]],['C',[3.95,44.15,4.6,44]],['C',[5.2,43.85,5.7,43.8]],['C',[6.9,43.9,7.3,44.85]],['C',[7.6,45.8,7.65,46.5]],['C',[7.7,46.95,7.8,48]],['C',[7.9,49,8,51.35]],['C',[8.1,53.7,8.15,58.15]],['C',[8.2,62.6,8.2,69.85]],['C',[8.2,73.1,8.15,76.95]],['C',[8.15,80.8,8.1,84.35]],['C',[8.05,88,7.95,90.45]],['C',[7.9,92.95,7.8,93.55]],['C',[7.5,95.05,6.35,95.55]],['C',[5.2,96.1,3.7,96.5]],['C',[3.15,96.55,2.55,96.9]],['C',[1.85,97.2,1.8,98.15]],['C',[1.8,98.7,2.2,99.25]],['C',[2.6,99.75,3.35,99.75]],['C',[3.95,99.7,7.6,99.2]],['C',[11.3,98.7,18.25,98.65]],['C',[19.7,98.65,20.45,98.65]],['C',[21.25,98.7,21.5,98.7]],['C',[22.85,98.65,23.35,98]],['C',[23.85,97.3,23.85,96.65]],['C',[23.85,96.15,23.45,95.65]],['C',[23.1,95.1,22.1,95]],['C',[21.8,95,20.85,95]],['C',[19.85,95,18.9,95]],['C',[17.95,95,17.6,95]],['C',[16.2,94.8,15.8,94]],['C',[15.45,93.15,15.45,92.6]],['C',[15.25,91.2,15.2,89.25]],['C',[15.1,87.25,15.05,83.55]],['C',[15,79.8,14.9,73.15]],['C',[18.3,74.5,20.45,74.9]],['C',[22.55,75.3,23.6,75.25]],['C',[26.8,75.25,30.25,73.75]],['C',[33.8,72.3,36.8,69.6]],['C',[39.9,66.95,41.8,63.25]],['C',[43.7,59.55,43.75,55.1]],['C',[43.65,51.3,42.35,48.25]],['C',[41,45.2,39.6,43.35]],['C',[37.45,40.35,34.7,38.7]],['C',[32,37.1,28.7,37.05]],['C',[26.4,37,23.35,38.1]],['C',[20.2,39.1,15.1,41.8]],['C',[15,39.65,14.95,38.6]],['C',[14.9,37.65,14.9,37.3]],['C',[14.85,36.95,14.8,36.8]],['C',[14.65,36.2,14.3,35.9]]];
    __motifs["q"] = [['M',[18.65,41.75]],['C',[20.35,41.3,21.5,41.35]],['C',[23.05,41.35,24.75,41.75]],['C',[26.45,42.1,27.7,42.4]],['C',[28.9,42.8,29.1,42.85]],['C',[30,43.2,30.45,43.9]],['C',[30.9,44.5,31,45.65]],['C',[31.1,46.2,31.15,48.2]],['C',[31.25,50.2,31.3,52.95]],['C',[31.35,55.75,31.35,58.8]],['C',[31.35,63.35,31.2,67.9]],['C',[28.7,69.55,26.25,70.35]],['C',[23.85,71.15,21.8,71.15]],['C',[17.7,71.1,15.15,68.75]],['C',[12.5,66.45,11.25,62.85]],['C',[9.95,59.15,9.95,55.1]],['C',[9.95,51.15,11.2,48.45]],['C',[12.45,45.7,14.8,43.85]],['C',[16.95,42.2,18.65,41.75]],['M',[12,41.1]],['C',[8.65,43.4,6.6,46.4]],['C',[4.55,49.4,3.55,52.6]],['C',[2.65,55.8,2.65,58.65]],['C',[2.7,63.4,5,67.25]],['C',[7.25,71.05,10.95,73.25]],['C',[14.7,75.45,19.2,75.5]],['C',[22.6,75.45,25.7,74.3]],['C',[28.7,73.15,31.1,71.45]],['C',[31.1,71.5,31,73.35]],['C',[30.95,75.25,30.8,78.1]],['C',[30.65,80.95,30.5,84]],['C',[30.35,86.95,30.2,89.3]],['C',[30.15,91.65,30.05,92.45]],['C',[29.9,93.45,29.5,94]],['C',[29.05,94.5,28.4,94.75]],['C',[28.1,94.85,27.15,95.2]],['C',[26.15,95.5,25.2,95.85]],['C',[24.25,96.15,23.95,96.3]],['C',[23.7,96.35,23.2,96.65]],['C',[22.7,97.05,22.65,98.05]],['C',[22.65,98.7,23,99.25]],['C',[23.35,99.8,24,99.8]],['C',[24.45,99.75,26.6,99.2]],['C',[28.7,98.65,32.35,98.2]],['C',[36.05,97.65,41.1,97.6]],['C',[41.45,97.6,41.65,97.6]],['C',[41.85,97.6,41.95,97.6]],['C',[43.2,97.55,43.55,96.85]],['C',[43.95,96.2,43.9,95.65]],['C',[43.9,94.95,43.55,94.4]],['C',[43.2,93.9,42.35,93.8]],['C',[41.9,93.8,40.75,93.8]],['C',[39.65,93.8,39.15,93.8]],['C',[38.4,93.75,38.05,93.35]],['C',[37.7,92.95,37.65,92.5]],['C',[37.6,92.4,37.6,92.05]],['C',[37.6,91.7,37.6,90.35]],['C',[37.6,89.05,37.6,86.05]],['C',[37.6,84.9,37.6,81.45]],['C',[37.6,77.9,37.65,73.15]],['C',[37.65,68.4,37.7,63.4]],['C',[37.8,58.45,37.9,54.35]],['C',[38,50.25,38.2,48.05]],['C',[38.55,43.45,39.15,41.45]],['C',[39.8,39.4,40.25,38.7]],['C',[40.7,38.05,40.7,37.45]],['C',[40.7,36.85,40.35,36.5]],['C',[40,36.1,39.4,36.1]],['C',[38.65,36.15,38,36.75]],['C',[37.3,37.35,36.85,37.9]],['C',[36.35,38.6,36.1,39]],['C',[35.8,39.45,35.3,39.45]],['C',[35.05,39.45,34.8,39.35]],['C',[34.55,39.25,34.4,39.15]],['C',[32.25,38.05,30.05,37.55]],['C',[27.8,37,25.5,37]],['C',[22,37,18.5,38.1]],['C',[14.95,39.15,12,41.1]]];
    __motifs["r"] = [['M',[12.8,36.85]],['C',[12,37.35,10,38.5]],['C',[8,39.65,3.85,41.6]],['C',[3.1,41.95,2.5,42.3]],['C',[1.9,42.6,1.9,43.3]],['C',[1.95,44.2,2.8,44.4]],['C',[3.6,44.7,4.05,44.7]],['C',[5.1,44.85,5.8,45.05]],['C',[6.55,45.25,7.1,45.95]],['C',[7.35,46.3,7.55,47.1]],['C',[7.75,47.9,7.85,49.75]],['C',[7.95,51.55,7.95,55.1]],['C',[7.95,57.3,7.9,60.45]],['C',[7.85,63.55,7.65,66.25]],['C',[7.45,69,7.1,70]],['C',[6.6,71.15,5.7,71.55]],['C',[4.85,71.95,3.95,72.15]],['C',[3.55,72.2,3.1,72.55]],['C',[2.55,72.9,2.5,73.9]],['C',[2.55,74.75,2.9,75.1]],['C',[3.15,75.5,3.6,75.5]],['C',[3.95,75.45,4.95,75.25]],['C',[5.9,75,8,74.75]],['C',[10.15,74.5,13.95,74.5]],['C',[15.6,74.5,17.4,74.5]],['C',[19.25,74.55,20.7,74.55]],['C',[22.2,74.6,22.7,74.6]],['C',[23.95,74.55,24.3,73.8]],['C',[24.65,73.15,24.6,72.6]],['C',[24.6,72,24.3,71.5]],['C',[24,71.05,23.25,70.95]],['C',[22.9,70.9,21.6,70.85]],['C',[20.2,70.8,18.6,70.8]],['C',[17.75,70.8,17.3,70.8]],['C',[16.85,70.8,16.65,70.8]],['C',[15.05,70.7,14.75,69.8]],['C',[14.4,68.9,14.5,68.4]],['C',[14.5,65.8,14.55,62.6]],['C',[14.6,59.3,14.65,56.2]],['C',[14.7,53.05,14.75,50.9]],['C',[14.8,48.75,14.8,48.45]],['C',[14.85,47.7,15.1,47.3]],['C',[15.35,46.9,15.75,46.6]],['C',[17.8,45.05,19.05,44.45]],['C',[20.3,43.9,21.2,43.95]],['C',[22.7,44.05,23.3,44.75]],['C',[23.9,45.55,23.95,45.75]],['C',[24,46.2,24.4,46.8]],['C',[24.8,47.45,25.7,47.55]],['C',[25.85,47.55,26.25,47.4]],['C',[26.65,47.3,27.45,46.85]],['C',[28.8,46.15,29.75,45]],['C',[30.7,43.85,30.75,42.3]],['C',[30.7,40.7,29.75,39.55]],['C',[28.75,38.35,27.55,37.65]],['C',[27.05,37.35,26.7,37.2]],['C',[26.4,37.05,26.05,37.05]],['C',[25.75,37.05,25.45,37.2]],['C',[25.15,37.3,24.9,37.45]],['L',[14.8,44]],['C',[14.75,43.25,14.75,42.45]],['C',[14.8,40.4,15,39.3]],['C',[15.15,38.15,15.2,37.7]],['C',[15.2,37.1,14.85,36.75]],['C',[14.5,36.4,14,36.4]],['C',[13.55,36.35,12.8,36.85]]];
    __motifs["s"] = [['M',[9.95,39.15]],['C',[7.2,40.7,5.6,43.1]],['C',[4.05,45.45,4,48]],['C',[4.1,50.8,5.55,52.65]],['C',[7.1,54.5,9,55.6]],['C',[10.95,56.7,12.3,57.2]],['C',[13.75,57.85,16.05,59]],['C',[18.3,60.1,20.1,61.85]],['C',[21.9,63.65,22,66.25]],['C',[22,68.3,20.55,69.65]],['C',[19.15,71.1,16.6,71.15]],['C',[13.85,71.15,10.95,69.3]],['C',[8,67.4,6,63.75]],['C',[5.85,63.4,5.4,62.85]],['C',[5,62.25,4.1,62.2]],['C',[3.45,62.2,3.05,62.65]],['C',[2.65,63.1,2.6,63.85]],['C',[2.7,64.7,3.15,65.95]],['C',[3.7,67.25,3.75,69.6]],['C',[3.75,70.7,3.65,71.25]],['C',[3.55,71.8,3.55,72.05]],['C',[3.6,72.7,4,72.95]],['C',[4.45,73.2,4.65,73.25]],['C',[9.3,74.4,11.7,74.75]],['C',[14.15,75.1,15.25,75.05]],['C',[19.35,75,22.3,73.35]],['C',[25.35,71.65,26.95,69.1]],['C',[28.6,66.5,28.6,63.65]],['C',[28.5,60.25,26.6,58.1]],['C',[24.65,55.95,21.9,54.55]],['C',[19.25,53.15,16.8,52.15]],['C',[15.85,51.8,14.45,50.95]],['C',[13.05,50.2,11.9,48.85]],['C',[10.75,47.6,10.7,45.6]],['C',[10.75,43.7,11.95,42.45]],['C',[13.25,41.2,15.15,41.15]],['C',[17.15,41.2,19.45,42.55]],['C',[21.75,43.9,23.05,45.6]],['C',[23.6,46.45,24.05,47.2]],['C',[24.55,47.95,25.5,48]],['C',[26.05,48,26.45,47.6]],['C',[26.9,47.15,26.95,46.4]],['C',[26.95,46.15,26.85,45.8]],['C',[26.8,45.4,26.55,44.25]],['C',[26.25,43.05,25.75,40.3]],['C',[25.6,39.45,25.15,39]],['C',[24.65,38.6,23.9,38.45]],['C',[22.45,38.15,20.25,37.9]],['C',[18.1,37.6,16.3,37.55]],['C',[12.7,37.6,9.95,39.15]]];
    __motifs["t"] = [['M',[13.25,31.7]],['C',[12.65,31.7,12.2,32]],['C',[11.8,32.35,11.5,32.7]],['C',[8,36.45,5.3,38.45]],['C',[2.65,40.45,2,40.8]],['C',[1.8,40.95,1.5,41.3]],['C',[1.2,41.65,1.15,42.2]],['C',[1.15,42.55,1.5,43]],['C',[1.85,43.4,2.75,43.45]],['C',[2.8,43.45,3.4,43.4]],['C',[4,43.35,6.45,43.2]],['C',[6.45,43.3,6.35,45.4]],['C',[6.3,47.55,6.25,50.7]],['C',[6.15,53.9,6.1,57.2]],['C',[6,60.5,5.95,62.9]],['C',[5.9,65.3,5.9,65.9]],['C',[5.85,67.3,6.2,69.05]],['C',[6.55,70.75,7.8,72.35]],['C',[8.95,73.75,10.7,74.6]],['C',[12.45,75.45,14.8,75.45]],['C',[16.75,75.5,20,74.5]],['C',[23.35,73.55,27.8,70.7]],['C',[28.15,70.5,28.5,70.1]],['C',[28.9,69.7,28.95,69.05]],['C',[28.9,68.35,28.45,67.8]],['C',[28.05,67.3,27.35,67.25]],['C',[26.95,67.25,26.6,67.4]],['C',[26.25,67.55,25.9,67.8]],['C',[23.85,69,22.4,69.45]],['C',[20.95,69.9,19.65,69.9]],['C',[18.85,69.9,17.6,69.7]],['C',[16.25,69.45,15.05,68.75]],['C',[13.85,68,13.45,66.55]],['C',[13.35,66.15,13.3,65.2]],['C',[13.3,64.15,13.3,61.05]],['C',[13.3,56.4,13.4,52.5]],['C',[13.5,48.6,13.55,46.2]],['C',[13.65,43.75,13.7,43.5]],['C',[13.8,42.8,14.2,42.65]],['C',[14.65,42.55,14.85,42.55]],['C',[16.75,42.55,19.3,42.7]],['C',[21.85,42.85,23.8,42.95]],['C',[25.8,43.1,26.1,43.1]],['C',[27.15,43.05,27.45,42.45]],['C',[27.75,41.95,27.7,41.65]],['C',[27.9,40.1,27.9,39.65]],['L',[27.95,39.2]],['C',[27.85,38.2,27.15,38.05]],['C',[26.45,37.85,26.2,37.9]],['C',[26.1,37.95,25.05,38]],['C',[24,38.1,21.35,38.15]],['C',[18.7,38.2,13.8,38.3]],['C',[14.15,36.05,14.3,35]],['C',[14.5,33.95,14.55,33.65]],['C',[14.55,33.3,14.55,33.15]],['C',[14.55,32.4,14.15,32.05]],['C',[13.75,31.7,13.25,31.7]]];
    __motifs["u"] = [['M',[40.95,38.55]],['C',[40.9,37.9,40.55,37.5]],['C',[40.1,37.05,39.3,37.05]],['C',[38.9,37.05,37.95,37.2]],['C',[36.95,37.4,34.5,37.75]],['C',[32.05,38.15,27.1,38.6]],['C',[26.95,38.6,26.35,38.85]],['C',[25.85,39.1,25.8,40.05]],['C',[25.8,40.55,26.05,41.05]],['C',[26.3,41.6,27.05,41.7]],['C',[27.15,41.75,27.4,41.75]],['C',[27.65,41.75,28.15,41.75]],['C',[28.8,41.7,29.6,41.85]],['C',[30.4,42,31.15,42.55]],['C',[32.05,43.45,32.25,44.5]],['C',[32.4,45.6,32.4,46.55]],['C',[32.4,46.9,32.4,47.35]],['C',[32.35,47.8,32.35,49.4]],['C',[32.3,51,32.3,54.95]],['C',[32.3,58.9,32.2,66.25]],['C',[29,68.25,26.3,69.2]],['C',[23.6,70.1,21.65,70.1]],['C',[19.7,70.1,18.05,69.35]],['C',[16.45,68.5,15.5,66.7]],['C',[14.95,65.7,14.65,63.85]],['C',[14.3,62.05,14.3,58.5]],['C',[14.3,54.5,14.45,51]],['C',[14.6,47.55,14.8,45.2]],['C',[14.95,42.85,15.05,42.3]],['C',[15.25,40.7,15.4,40.1]],['C',[15.6,39.45,15.65,38.9]],['C',[15.6,38.2,15.2,37.8]],['C',[14.75,37.4,14.05,37.4]],['C',[13.55,37.4,12.4,37.75]],['C',[11.3,38.15,9,38.65]],['C',[6.75,39.2,2.85,39.75]],['C',[1.95,39.9,1.65,40.3]],['C',[1.35,40.7,1.4,41.15]],['C',[1.4,41.55,1.65,42]],['C',[1.95,42.4,2.75,42.6]],['C',[3.15,42.65,4.15,42.7]],['C',[5.1,42.8,5.55,42.9]],['C',[6.6,43.15,6.95,43.9]],['C',[7.25,44.55,7.25,45.1]],['C',[7.3,45.55,7.3,47.3]],['C',[7.35,49.05,7.4,51.15]],['C',[7.35,55.1,7.25,57.75]],['C',[7.15,60.4,7.1,62.8]],['C',[7.05,65,7.35,67.2]],['C',[7.75,69.4,8.95,71.4]],['C',[10.1,73.2,12.15,74.3]],['C',[14.15,75.4,17,75.45]],['C',[17.9,75.5,19.85,75.15]],['C',[21.85,74.8,24.8,73.5]],['C',[27.85,72.2,32,69.4]],['C',[32,69.8,32,70.2]],['C',[32,72,32.3,73.4]],['C',[32.55,74.7,32.8,75.35]],['C',[32.85,75.55,33.1,75.85]],['C',[33.35,76.2,34.05,76.2]],['C',[34.95,76.15,35.8,75.6]],['C',[36.65,75,37.95,74.5]],['C',[38.6,74.25,40.35,73.75]],['C',[42.1,73.35,44.8,72.8]],['C',[45.1,72.8,45.6,72.5]],['C',[46.15,72.25,46.2,71.25]],['C',[46.2,70.4,45.85,69.9]],['C',[45.5,69.4,44.9,69.4]],['C',[44.75,69.4,44.4,69.45]],['C',[44.05,69.55,43.25,69.85]],['C',[42.3,70.15,41.8,70.3]],['C',[41.35,70.45,41.05,70.45]],['C',[40.6,70.45,40.15,70.15]],['C',[39.7,69.8,39.5,69]],['C',[39.45,68.75,39.25,66.45]],['C',[39.05,64.2,39.05,60.35]],['C',[39.05,59.2,39.1,56.9]],['C',[39.15,54.6,39.25,51.8]],['C',[39.35,48.95,39.55,46.5]],['C',[39.7,43.95,39.95,42.5]],['C',[40.3,40.75,40.65,40]],['C',[40.9,39.2,40.95,38.55]]];
    __motifs["v"] = [['M',[5.3,38.2]],['C',[3.75,38.15,3.35,38.1]],['C',[2.45,38.15,2.05,38.6]],['C',[1.65,39.1,1.65,39.7]],['C',[1.7,40.8,2.65,41.35]],['C',[3.55,41.85,4.5,42.15]],['C',[5.7,42.55,6.25,43.15]],['C',[6.8,43.8,7.2,45.3]],['C',[7.35,45.9,8.2,48.45]],['C',[9.1,50.95,10.35,54.65]],['C',[11.55,58.3,12.9,62.15]],['C',[14.15,66,15.2,69.25]],['C',[16.15,72.4,16.55,73.95]],['C',[16.6,74.55,17.05,75.6]],['C',[17.45,76.6,18.6,76.7]],['C',[19.5,76.65,19.9,76.05]],['C',[20.3,75.5,20.45,75.15]],['C',[21.4,72.95,22.95,69.55]],['C',[24.55,66.15,26.35,62.3]],['C',[28.2,58.45,29.95,54.85]],['C',[31.65,51.3,32.85,48.8]],['C',[34.1,46.35,34.4,45.65]],['C',[35.55,43.55,36.45,42.7]],['C',[37.4,41.85,37.95,41.5]],['C',[38.55,40.9,38.7,40.35]],['C',[38.9,39.9,38.9,39.55]],['C',[38.9,39.1,38.65,38.65]],['C',[38.4,38.2,37.55,38.2]],['C',[36.8,38.2,35.6,38.3]],['C',[34.4,38.4,32.55,38.4]],['C',[29.8,38.4,28.15,38.2]],['C',[26.6,38,26.15,38]],['C',[25.55,38,25.15,38.4]],['C',[24.8,38.85,24.8,39.55]],['C',[24.85,40.7,25.6,41.05]],['C',[26.25,41.35,26.6,41.35]],['C',[27.9,41.4,28.85,41.9]],['C',[29.85,42.3,29.9,44.45]],['C',[29.9,44.5,29.8,45.55]],['C',[29.7,46.6,29.25,48.1]],['C',[29.1,48.45,28.9,48.95]],['C',[28.65,49.55,27.9,51.15]],['C',[27.15,52.8,25.55,56.4]],['C',[23.9,59.9,21,66.2]],['C',[17.7,56.25,14.9,46.1]],['C',[14.65,45.15,14.5,44.55]],['C',[14.35,44,14.35,43.5]],['C',[14.3,42.75,14.7,42.25]],['C',[15.1,41.65,15.95,41.5]],['C',[16.45,41.4,17.2,41.35]],['C',[17.9,41.35,18.4,41.3]],['C',[19.3,41.15,19.65,40.55]],['C',[19.9,40.05,19.9,39.55]],['C',[19.9,38.85,19.55,38.4]],['C',[19.2,37.95,18.4,37.9]],['C',[17.95,37.95,15.75,38.1]],['C',[13.55,38.25,9.7,38.3]],['C',[6.9,38.3,5.3,38.2]]];
    __motifs["w"] = [['M',[46.35,38.7]],['C',[45.15,38.75,44.8,39.3]],['C',[44.55,39.85,44.55,40.2]],['C',[44.55,40.55,44.8,41.05]],['C',[45.1,41.5,45.9,41.75]],['C',[46.25,41.85,46.9,41.95]],['C',[47.5,42.05,47.95,42.2]],['C',[48.95,42.45,49.3,43.05]],['C',[49.65,43.65,49.65,44.15]],['C',[49.65,44.45,49.55,44.75]],['C',[49.5,45.05,49.4,45.35]],['C',[47.7,50.45,45.5,55.25]],['C',[43.3,60.15,40.6,64.75]],['C',[40.6,64.65,39.7,61.8]],['C',[38.8,59,37.5,54.35]],['C',[36.15,49.7,34.7,44.1]],['C',[34.6,43.8,34.6,43.5]],['C',[34.65,42.65,35.25,42.4]],['C',[35.9,42.15,36.2,42.1]],['C',[37.05,41.95,37.75,41.8]],['C',[38.5,41.65,38.8,41.55]],['C',[39.65,41.3,39.9,40.8]],['C',[40.15,40.3,40.15,39.95]],['C',[40.15,39.3,39.75,38.75]],['C',[39.35,38.2,38.55,38.15]],['C',[38.15,38.2,36.05,38.45]],['C',[34,38.7,30.3,38.7]],['C',[27.45,38.7,25.85,38.55]],['C',[24.2,38.4,23.8,38.35]],['C',[22.85,38.4,22.4,38.95]],['C',[21.95,39.55,21.95,40.2]],['C',[21.9,40.6,22.25,41.15]],['C',[22.55,41.65,23.5,41.9]],['C',[24.5,42.05,25.35,42.2]],['C',[26.2,42.3,26.8,42.95]],['C',[27.05,43.2,27.25,43.75]],['C',[27.45,44.35,28,45.95]],['L',[19.2,64.75]],['C',[19.15,64.7,18.15,61.9]],['C',[17.15,59.15,15.8,54.4]],['C',[14.45,49.65,13.4,43.6]],['C',[13.35,43.35,13.35,43.1]],['C',[13.35,42.7,13.55,42.3]],['C',[13.85,41.95,14.55,41.7]],['C',[14.95,41.65,15.75,41.5]],['C',[16.55,41.35,16.9,41.25]],['C',[17.6,41.05,17.8,40.6]],['C',[18.05,40.2,18,39.8]],['C',[18.05,39.25,17.7,38.8]],['C',[17.45,38.3,16.7,38.3]],['C',[16.35,38.3,14.3,38.45]],['C',[12.3,38.6,8.8,38.65]],['C',[6.55,38.65,5.25,38.55]],['C',[4,38.5,3.7,38.5]],['C',[2.8,38.55,2.45,39.1]],['C',[2.1,39.65,2.1,40.25]],['C',[2.1,40.6,2.3,41]],['C',[2.5,41.4,3.05,41.65]],['C',[4.1,42,4.85,42.25]],['C',[5.5,42.45,6,43.6]],['C',[6.15,44.05,7.3,47.4]],['C',[8.4,50.7,9.9,55.6]],['C',[11.45,60.5,12.8,65.65]],['C',[14.2,70.85,14.9,75]],['C',[14.9,75.2,15.2,75.8]],['C',[15.5,76.45,16.4,76.55]],['C',[16.8,76.55,17.3,76.3]],['C',[17.7,76.05,18.15,75.35]],['C',[18.5,74.65,19.7,72]],['C',[20.9,69.4,22.45,65.8]],['C',[24.05,62.2,25.65,58.7]],['C',[27.2,55.1,28.25,52.65]],['C',[29.4,50.15,29.6,49.6]],['C',[32.75,58.65,34.15,65.2]],['C',[35.5,71.65,36.15,75.15]],['C',[36.15,75.4,36.5,76]],['C',[36.85,76.65,38.05,76.75]],['C',[39.35,76.75,39.85,75.85]],['C',[40.4,75,40.85,73.2]],['C',[41.35,71.45,42.7,68.65]],['C',[43,67.95,44.3,65.45]],['C',[45.6,63,47.4,59.5]],['C',[49.2,56.1,51,52.5]],['C',[52.8,48.9,54.15,46.05]],['C',[54.9,44.3,55.5,43.45]],['C',[56.15,42.55,57.55,42.05]],['C',[58.2,41.85,58.75,41.5]],['C',[59.3,41.1,59.3,40.05]],['C',[59.35,39.35,59,38.9]],['C',[58.65,38.4,57.95,38.4]],['C',[57.55,38.4,54.7,38.55]],['C',[51.8,38.7,47,38.7]],['L',[46.35,38.7]]];
    __motifs["x"] = [['M',[5.15,38.35]],['C',[4.25,38.4,3.85,38.95]],['C',[3.45,39.55,3.5,40.2]],['C',[3.55,41.1,4.05,41.4]],['C',[4.55,41.65,4.7,41.65]],['C',[6.3,41.9,7.75,42.3]],['C',[9.3,42.75,10.8,44.65]],['C',[11.05,45,11.5,45.8]],['C',[12,46.55,13.5,49.05]],['C',[15,51.55,18.3,57.1]],['L',[7.45,69.35]],['C',[6.6,70.4,5.9,70.8]],['C',[5.25,71.2,3.45,71.9]],['C',[3.15,72,2.8,72.3]],['C',[2.45,72.55,2.45,73.25]],['C',[2.4,73.5,2.6,74.2]],['C',[2.8,74.95,3.6,75.05]],['C',[3.95,75,5.9,74.8]],['C',[7.85,74.6,11.3,74.55]],['C',[13.3,74.55,14.4,74.65]],['C',[15.55,74.7,15.75,74.7]],['C',[16.4,74.7,16.7,74.3]],['C',[17,73.9,17,73.4]],['C',[17.05,73.05,16.8,72.55]],['C',[16.6,72.1,15.95,71.85]],['C',[15.6,71.75,14.7,71.5]],['C',[13.8,71.35,13.45,71.2]],['C',[12.8,71,12.6,70.6]],['C',[12.4,70.25,12.4,69.95]],['C',[12.4,69.65,12.5,69.4]],['C',[12.65,69.2,12.8,69]],['C',[12.85,68.9,14.3,66.9]],['C',[15.75,64.9,19.5,59.8]],['C',[19.55,59.85,20.3,61.35]],['C',[21.1,62.85,22.15,64.85]],['C',[23.2,66.8,24,68.35]],['C',[24.85,69.95,24.95,70.25]],['C',[25,70.35,25,70.55]],['C',[25,70.8,24.85,71]],['C',[24.7,71.2,24.4,71.3]],['C',[24.1,71.35,23.45,71.35]],['C',[22.7,71.4,22.3,71.45]],['C',[21.6,71.5,21.4,72.05]],['C',[21.2,72.55,21.2,73.35]],['C',[21.2,74.15,21.55,74.45]],['C',[21.9,74.75,22.25,74.75]],['C',[22.6,74.7,24.25,74.5]],['C',[25.95,74.3,28.85,74.25]],['C',[32.65,74.3,34.85,74.65]],['C',[37,75,37.5,75.05]],['C',[38.45,74.95,38.65,74.15]],['C',[38.9,73.35,38.85,72.95]],['C',[38.8,71.7,38.15,71.45]],['C',[37.5,71.15,36.85,71.1]],['C',[34.6,70.75,33.55,70.45]],['C',[32.45,70.2,32,69.55]],['C',[31.55,69,29.8,65.5]],['C',[28,62.05,23.7,55.3]],['C',[23.8,55.2,25.25,53.55]],['C',[26.7,51.95,28.7,49.7]],['C',[30.7,47.5,32.35,45.7]],['C',[34,43.9,34.4,43.45]],['C',[35.45,42.5,36.2,42.3]],['C',[36.95,42.1,37.4,42.05]],['C',[38.45,41.8,38.75,41.1]],['C',[39.05,40.35,39,40]],['C',[39,39.35,38.65,38.9]],['C',[38.35,38.4,37.5,38.35]],['C',[37.15,38.4,35.3,38.5]],['C',[33.45,38.55,30.2,38.6]],['C',[28,38.6,26.65,38.55]],['C',[25.35,38.5,25.1,38.5]],['C',[24.2,38.55,23.95,39.1]],['C',[23.7,39.7,23.75,40.1]],['C',[23.8,40.95,24.2,41.25]],['C',[24.7,41.55,24.85,41.55]],['C',[25.25,41.65,25.95,41.8]],['C',[26.65,41.95,27.05,42.05]],['C',[27.9,42.3,28.15,42.75]],['C',[28.5,43.25,28.45,43.75]],['C',[28.45,44.2,28.3,44.5]],['C',[28.15,44.85,27.95,45.15]],['L',[22.6,52.8]],['C',[22.55,52.75,21.85,51.25]],['C',[21.05,49.75,20,47.8]],['C',[19.05,45.8,18.2,44.2]],['C',[17.45,42.6,17.35,42.3]],['C',[17.3,42.2,17.3,42.05]],['C',[17.35,41.5,17.7,41.35]],['C',[18.1,41.25,18.2,41.3]],['L',[18.5,41.3]],['C',[18.7,41.35,19.3,41.15]],['C',[19.8,40.95,19.9,40]],['C',[19.9,39.4,19.65,38.85]],['C',[19.35,38.3,18.5,38.25]],['C',[18.15,38.3,16.3,38.4]],['C',[14.45,38.55,11.25,38.6]],['C',[8.55,38.55,7,38.5]],['C',[5.45,38.4,5.15,38.35]]];
    __motifs["y"] = [['M',[42.7,41]],['C',[43.15,40.65,43.2,39.75]],['C',[43.2,39.3,42.9,38.8]],['C',[42.7,38.3,41.7,38.25]],['C',[41.6,38.25,41.4,38.25]],['C',[41.15,38.25,40.75,38.25]],['C',[35.45,38.2,32.4,37.85]],['C',[29.35,37.4,28.8,37.35]],['C',[28.25,37.3,27.85,37.75]],['C',[27.45,38.15,27.4,39.25]],['C',[27.4,39.7,27.6,40.25]],['C',[27.8,40.8,28.55,41.05]],['C',[28.9,41.1,29.6,41.15]],['C',[30.25,41.25,30.9,41.35]],['C',[32.1,41.7,32.65,42.45]],['C',[33.25,43.25,33.25,44.35]],['C',[33.25,44.85,33.1,45.4]],['C',[33,45.95,32.8,46.5]],['C',[31.05,51.8,28.85,57.1]],['C',[26.65,62.45,24,67.7]],['C',[23.95,67.65,23.4,65.9]],['C',[22.8,64.2,21.95,61.7]],['C',[21.2,59.2,20.45,56.95]],['C',[19.8,54.8,19.5,53.7]],['C',[18.15,48.75,17.6,46.5]],['C',[17,44.35,16.9,43.7]],['C',[16.75,43.1,16.75,43]],['C',[16.85,41.95,17.75,41.6]],['C',[18.65,41.25,19.35,41.2]],['C',[20.45,41.05,21.05,40.75]],['C',[21.65,40.45,21.6,39.05]],['C',[21.65,38.8,21.5,38.25]],['C',[21.35,37.75,20.55,37.7]],['C',[20.2,37.7,18.1,37.85]],['C',[16.05,38,12.5,38]],['C',[8.95,38,6.85,37.85]],['C',[4.8,37.7,4.4,37.7]],['C',[4.2,37.65,3.7,37.85]],['C',[3.2,38.1,3.15,39.2]],['C',[3.15,40.1,3.4,40.55]],['C',[3.65,41,4.05,41.15]],['C',[4.6,41.2,5.4,41.2]],['C',[6.3,41.2,7.3,41.85]],['C',[8.35,42.4,9.3,44.4]],['C',[9.75,45.35,11.1,48.9]],['C',[12.4,52.5,14.15,57.8]],['C',[15.85,63.15,17.65,69.4]],['C',[18.25,71.85,18.6,73.1]],['C',[18.9,74.25,19,74.75]],['C',[19.1,75.25,19.05,75.45]],['C',[19.05,75.85,18.95,76.25]],['C',[18.85,76.6,18.7,76.95]],['C',[16.6,81.75,14.15,85.55]],['C',[11.65,89.3,9.3,92.05]],['C',[8.7,92.75,7.7,93.55]],['C',[6.8,94.35,5.5,94.4]],['C',[4.8,94.4,4.1,94]],['C',[3.4,93.6,3.1,92.6]],['C',[3.05,92.4,2.85,92.1]],['C',[2.6,91.8,2.05,91.75]],['C',[1.2,91.75,0,92.85]],['C',[-1.15,94.05,-1.3,95.85]],['C',[-1.25,97.5,0.1,98.6]],['C',[1.4,99.75,3.8,99.8]],['C',[5.4,99.75,6.55,99.3]],['C',[7.65,98.8,8.2,98.5]],['C',[10.1,97.25,12.2,94.9]],['C',[14.3,92.5,15.9,90]],['C',[16.5,89.15,19.65,83.5]],['C',[22.8,77.8,27.5,68.55]],['C',[32.15,59.3,37.2,47.65]],['C',[37.9,45.9,38.85,44.2]],['C',[39.85,42.45,41.95,41.5]],['C',[42.2,41.4,42.7,41]]];
    __motifs["z"] = [['M',[4.95,36.6]],['C',[4.65,36.8,4.55,37.4]],['C',[4.55,37.9,4.25,40.05]],['C',[3.95,42.25,2.8,45.4]],['C',[2.5,46.25,2.3,46.6]],['C',[2.1,47.05,2.1,47.4]],['C',[2.15,48,2.5,48.4]],['C',[2.9,48.7,3.4,48.7]],['C',[4.1,48.65,4.5,48.3]],['C',[4.9,47.9,5.05,47.6]],['C',[6.5,45.45,8.25,44.35]],['C',[10.05,43.25,11.65,42.8]],['C',[13.35,42.35,14.4,42.3]],['C',[15.25,42.25,16.45,42.2]],['C',[17.65,42.2,20.2,42.2]],['C',[22.85,42.2,27.9,42.2]],['C',[18.25,54.95,7.6,66.95]],['C',[5.75,69.05,4.9,69.75]],['C',[4.05,70.5,3.65,70.9]],['C',[3.45,71.05,3.15,71.5]],['C',[2.85,72,2.8,72.8]],['C',[2.8,73.55,3.25,74.1]],['C',[3.75,74.7,4.7,74.7]],['C',[5.15,74.7,6.7,74.55]],['C',[8.3,74.35,11.85,74.35]],['C',[12.75,74.35,15.65,74.4]],['C',[18.6,74.45,22.15,74.5]],['C',[25.7,74.55,28.45,74.6]],['C',[31.2,74.7,31.7,74.7]],['C',[33.65,74.9,34.4,75.45]],['C',[35.15,76,36.1,76.1]],['C',[37.15,76,37.5,75.3]],['C',[37.85,74.55,37.85,74.25]],['C',[38.85,69.1,39.4,66.8]],['C',[40,64.45,40.2,63.7]],['C',[40.4,62.95,40.35,62.45]],['C',[40.35,61.55,39.9,61.1]],['C',[39.45,60.7,38.85,60.7]],['C',[38.05,60.75,37.6,61.3]],['C',[37.2,61.9,37.1,62.2]],['C',[36.55,63.5,35.95,65.05]],['C',[35.3,66.6,34.3,67.85]],['C',[32.3,69.95,29.7,70.4]],['C',[27.1,70.9,24.55,70.8]],['L',[13.6,70.8]],['C',[13.65,70.7,15.6,68.3]],['C',[17.5,65.85,20.45,62.1]],['C',[23.45,58.4,26.65,54.4]],['C',[29.9,50.4,32.55,47.1]],['C',[35.25,43.9,36.6,42.4]],['C',[37.65,41.35,38.25,40.7]],['C',[38.8,40.1,38.8,39.35]],['C',[38.8,38.7,38.35,38.2]],['C',[37.9,37.75,36.85,37.7]],['C',[36.45,37.75,35.8,37.8]],['C',[35.05,37.9,33.7,38]],['C',[32.3,38.1,29.7,38.1]],['C',[22.75,38.1,18.75,38.1]],['C',[14.75,38.15,12.8,38.1]],['C',[10.9,38.1,10.1,38.05]],['C',[9.4,38,8.95,37.9]],['C',[7.4,37.5,6.8,36.95]],['C',[6.2,36.4,5.55,36.35]],['C',[5.2,36.35,4.95,36.6]]];
  }
  
  static private function initializeWidths():void {
    __widths["a"] = 40;
    __widths["b"] = 45;
    __widths["c"] = 38;
    __widths["d"] = 48;
    __widths["e"] = 37;
    __widths["f"] = 33;
    __widths["g"] = 44;
    __widths["h"] = 49;
    __widths["i"] = 25;
    __widths["j"] = 26;
    __widths["k"] = 46;
    __widths["l"] = 26;
    __widths["m"] = 71;
    __widths["n"] = 49;
    __widths["o"] = 45;
    __widths["p"] = 48;
    __widths["q"] = 43;
    __widths["r"] = 31;
    __widths["s"] = 31;
    __widths["t"] = 30;
    __widths["u"] = 48;
    __widths["v"] = 41;
    __widths["w"] = 61;
    __widths["x"] = 42;
    __widths["y"] = 45;
    __widths["z"] = 44;
  }
}