/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s9EF
 */

// oops...
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var fv:FieldofView = new FieldofView(this);
            fv.x = stage.stageWidth / 2;
            fv.y = stage.stageHeight / 2;
            addChild(fv);
        }
    }
}
import flash.geom.Point;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.display.Sprite;
import flash.geom.PerspectiveProjection;

class FieldofView extends Sprite
{
    private var mypp:PerspectiveProjection;
    private var myfv:Number;
    private var startY:Number;
    private var sensitivity:Number = 0.5;
    
    public function FieldofView(roo:Sprite)
    {
        this.graphics.beginFill(0xFF0000);
        this.graphics.drawCircle(0, 0, 30);
        this.graphics.endFill();
        
        mypp = roo.transform.perspectiveProjection;
        myfv = mypp.fieldOfView;
        
        this.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
        
    }
    
    private function onMouseDown(e:MouseEvent):void
    {
        this.startDrag(true);
        this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
        e.stopPropagation();
    }
    
    private function onEnterFrame(e:Event):void
    {
        mypp.projectionCenter = new Point(x, y);
    }
    
    private function onStageMouseUp(e:MouseEvent):void
    {
        this.stopDrag();
        this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
    }
    
    private function onStageMouseDown(e:MouseEvent):void
    {
        if(e.shiftKey)
        {
            startY = e.stageY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp2);
        }

    }
    
    private function onMouseMove(e:MouseEvent):void
    {
        var fv:Number = myfv + (e.stageY - startY) * sensitivity;
        mypp.fieldOfView = Math.max(Math.min(179, fv), 1);
    }
    
    private function onStageMouseUp2(e:MouseEvent):void
    {
        myfv = mypp.fieldOfView;
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onStageMouseUp2);
    }



    
}
