/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s8Jj
 */

package  
{
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import frocessing.bmp.FImageLoader;
	import frocessing.display.F5MovieClip2D;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.IObjectTween;
	
	[SWF(width=465,height=465,backgroundColor=0x000000)]
	/**
	 * ...
	 * @author naoto koshikawa
	 */
	public class FrocessingWork4 extends F5MovieClip2D
	{
		private static const COLORS:Number = 24;
		private static const RADIUS:Number = 15;
		private static const EACH_WIDTH:Number = 6;
		private static const EACH_HEIGHT:Number = 2;
		
		
		private var _xs:Array = [];
		private var _ys:Array = [];
		
		private var _clickX:Number = 0;
		private var _clickY:Number = 0;
		
		private var _t:int = 0;
		
		private var _loader:Loader;
		
		private var _loaded:Boolean;
		
		private var _tween:IObjectTween;
		
		private var _easings:Array =
		[
			Back,
			Bounce,
			Circ,
			Circular,
			Cubic,
			Elastic,
			Expo,
			Exponential,
			Linear,
			Quad
		];
		
		public function FrocessingWork4() 
		{
			addChild(_loader = new Loader());
			_loader.contentLoaderInfo.addEventListener(Event.INIT,
			function (event:Event):void
			{
				_loaded = true;
				Object(_loader.content).color = 0xFFFFFF;
			});
			_loader.load(new URLRequest("http://asmple.com/work/avatar3.swf"), new LoaderContext(true));
		}
		
		public function setup():void
		{
			colorMode(HSV, COLORS, 1, 1, 1.0);
			rectMode(CENTER);
		}
		
		public function draw():void
		{
			if (!_loaded)
			{
				loading();
			}
			else
			{
				animation();
			}
			if (++_t == COLORS) _t = 0;
		}
		
		private function loading():void
		{
			translate(stage.stageWidth / 2, stage.stageWidth / 2);
			rotate(Math.PI * 2 * _t / COLORS);
			for (var i:int = 0; i < COLORS; i++)
			{
				rotate(Math.PI * 2  / COLORS);
				fill(i, 1, 1, (i + 1) / COLORS);
				rect(RADIUS, 0, EACH_WIDTH, EACH_HEIGHT, 2, 2);
			}
		}
		
		private function animation():void
		{
			var d:Number = dist(_loader.x, _loader.y, _clickX, _clickY);
			if (d < 3) return;
			
			noLoop();
			
			var easeClass:Class = _easings.shift();
			_easings.push(easeClass);
			
			_tween = BetweenAS3.tween(_loader, 
				{ x:_clickX, y:_clickY }, 
				{ x: _loader.x, y: _loader.y }, 
				d * 0.005, 
				easeClass["easeOut"]
			);
			
			_tween.onComplete = function():void
			{
				_xs = [];
				_ys = [];
				loop();
				Object(_loader.content).stopComplete();
			};
			_tween.onUpdate = function():void
			{
				_xs.push(_loader.x + 16);
				_ys.push(_loader.y + 16);
				
				var i:int;
				var length:int = _xs.length;
				
				for (i= 0; i < length; i++)
				{
					stroke(_t, 1, 1 , 1);
					rect(_xs[i], _ys[i], 2, 2);
				}
				
				beginShape();
				for (i= 0; i < length; i++)
				{
					vertex(_xs[i], _ys[i]);
				}
				endShape();
			};
			_tween.play();
			Object(_loader.content).color = color(_t, 1, 1, 1);
			Object(_loader.content).play();
		}
		
		public function mouseClicked():void
		{
			_clickX = mouseX - 16;
			_clickY = mouseY - 16;
		}
	}
	
}