/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s7EE
 */

package {
	import __AS3__.vec.Vector;
	
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	[SWF(frameRate="60")]
	public class YouTubeScratcher extends Sprite {
		private static const PLAYER_URL:String = "http://www.youtube.com/apiplayer?version=3";
		private static const LIST_ID:Vector.<String> = Vector.<String>(["FMjudPDrE_M","gQ2FB1qpwuA","5Hql31vQYyQ"]);
		
		// objects
		private var player:Object;
		private var loader:Loader;
		private var timerA:Timer;
		private var timerB:Timer;
		private var infoTF:TextField;
		private var idTF:TextField;
		
		// containers
		private var barCont:Sprite
		
		// setting
		private var delayA:Number = 2000;
		private var delayB:Number = 250;
		private var repeatCount:int = 4;
		
		// status
		private var currentIndex:int = 0;
		
		public function YouTubeScratcher() {
			loadPlayer();
		}	
		private function loadPlayer():void{
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener( Event.INIT, loaderInitHandler );
			loader.load( new URLRequest( PLAYER_URL ));
			
			function loaderInitHandler( event:Event ):void{
				loader.contentLoaderInfo.removeEventListener( Event.INIT, loaderInitHandler );
				addChild( loader );
				loader.content.addEventListener("onReady", playerReadyHandler );
			}
			
			function playerReadyHandler( event:Event ):void{
				loader.content.removeEventListener( "onReady", playerReadyHandler );
				player = loader.content;
				player.setSize( stage.stageWidth, stage.stageHeight );
				
				makeBar();
				start();
				setSize();
				
				addEventListeners();
			}
		}
		
		private function addEventListeners():void{
			stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDownHandler );
			stage.addEventListener( Event.RESIZE, setSize );
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		private function start():void{
			loadVideo();
			
			timerA = new Timer( delayA );
			timerA.addEventListener( TimerEvent.TIMER, timerAHandler );
			timerA.start();
		}
		
		private function loadVideo():void{
			player.stopVideo();
			if( idTF.text != "input video ID" ){
				player.loadVideoById( idTF.text );
				idTF.text = "";
			} else { 
				player.loadVideoById( LIST_ID[ currentIndex ] );
			}
			currentIndex++;
			currentIndex %= LIST_ID.length;
		}
		
		private function makeBar():void{
			barCont = new Sprite();
			var base:Shape = new Shape();
			barCont.addChild( base );
			drawBarBase();
			
			infoTF = new TextField();
			infoTF.mouseEnabled = false;
			infoTF.defaultTextFormat = new TextFormat("_ゴシック", 10, 0xFFFFFF );
			infoTF.autoSize = TextFieldAutoSize.LEFT;
			barCont.addChild( infoTF );
			
			idTF = new TextField;
			idTF.type = TextFieldType.INPUT;
			idTF.background = true;
			idTF.backgroundColor = 0xFFFFFF;
			idTF.width = 100;
			idTF.height = 20;
			idTF.y = -21;
			idTF.text = "input video ID";
			barCont.addChild( idTF );
			
			addChild( barCont );
		}
		
		private function drawBarBase():void{
			var base:Shape = Shape( barCont.getChildAt(0) );
			base.graphics.clear();
			base.graphics.beginFill( 0 );
			base.graphics.drawRect( 0, 0, stage.stageWidth, 20 );
		}
		
		private function setSize( event:Event = null ):void{
			drawBarBase();
			barCont.y = stage.stageHeight - 20;
			idTF.x = stage.stageWidth - 100;
		}
		
		// -- Handlers
		
		private function timerAHandler( event:TimerEvent ):void{
			timerB = new Timer( delayB, repeatCount );
			timerB.addEventListener( TimerEvent.TIMER, timerBHandler );
			timerB.start();
		}
		
		private function timerBHandler( event:TimerEvent ):void{
			var time:Number = player.getCurrentTime();
			player.seekTo( time - .5 );
		}
		
		
		private function keyDownHandler( event:KeyboardEvent ):void{
			var currentTime:Number = player.getCurrentTime();
			var offset:Number = 0;
			
			switch( event.keyCode ){
				case 13:	loadVideo();	break;
				case 37:	offset = -5;	break;
				case 39:	offset = +5;	break;
				case 38:	delayB += 30;	break;
				case 40:	delayB -= 30;	break;
			}
			
			if( delayB < 100 ) delayB = 100;
			if( delayB > 500 ) delayB = 500;
			delayA = delayB * 8;
			timerA.delay = delayA;
			
			if( offset ) player.seekTo( currentTime + offset )
		}
		
		private function enterFrameHandler( event:Event ):void{
			var time:String = String( Math.floor( player.getCurrentTime() ));
			infoTF.text = "↑↓：delay, ←→：Rewind/Forward" + "　       Time : " + time + "s" + "         delay : " + delayB + "ms";
		}
	}
}
