/**
 * Copyright Susisu ( http://wonderfl.net/user/Susisu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s6n7
 */

package{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    
    [SWF(width="465",height="465",backgroundColor="0xffffff",frameRate="30")]
    public class Main extends Sprite{
        private var ka:Ka;
        private var net:Net;
        private var noise:Sound;
        private var channel:SoundChannel;
        private var p:Number;
        private var f:Boolean;
        public function Main(){
            var g:Graphics=graphics;
            g.beginFill(0xffffff);
            g.drawRect(0,0,465,465);
            g.endFill();
            
            ka=new Ka();
            ka.x=Math.random()*465;
            ka.y=Math.random()*465;
            addChild(ka);
            
            net=new Net();
            net.x=mouseX;
            net.y=mouseY-10;
            addChild(net);
            
            p=0;
            noise=new Sound();
            noise.addEventListener(SampleDataEvent.SAMPLE_DATA,onSampleData);
            channel=noise.play();
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
            f=false;
            stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        }
        private function onEnterFrame(e:Event):void{
            ka.r+=Math.random()*Math.PI/2-Math.PI/4;
            ka.x+=Math.cos(ka.r)*ka.v;
            ka.y+=Math.sin(ka.r)*ka.v;
            ka.rotation=ka.r*180/Math.PI;
            if(ka.x<36||ka.x>465-36||ka.y<36||ka.y>465-36){
                ka.r=Math.atan2(465/2-ka.y,465/2-ka.x);
            }
            if(ka.v>4){
                ka.v-=4;
            }
            net.x=mouseX;
            net.y=mouseY-10;
            if(f&&net.rotationX>-30){
                net.rotationX-=10;
            }
            if(!f&&net.rotationX<0){
                net.rotationX+=10;
            }
        }
        private function onSampleData(e:SampleDataEvent):void{
            var w:Number=Math.PI*2*(760+Math.random()*20)/44100;
            for(var i:int=0;i<8192;i++){
                var sample:Number=Math.sin(p)-Math.sin(3*p)/9+Math.sin(5*p)/25-Math.sin(7*p)/49+Math.sin(2*p)/2+Math.sin(4*p)/4;
                sample/=128;
                e.data.writeFloat(sample);
                e.data.writeFloat(sample);
                p+=w;
                if(p>Math.PI*2){
                    p-=Math.PI*2;
                }
            }
            
        }
        private function onMouseDown(e:MouseEvent):void{
            if(Math.pow(ka.x-mouseX,2)+Math.pow(ka.y-(mouseY-20),2)<1600){
                ka.v=36;
            }
            f=true;
        }
        private function onMouseUp(e:MouseEvent):void{
            f=false;
        }
        
    }
}
import flash.display.Graphics;
import flash.display.Sprite;
class Ka extends Sprite{
    public var v:Number;
    public var r:Number;
    public function Ka(){
        var g:Graphics=graphics;
        g.lineStyle(1,0x000000);
        g.drawCircle(0,0,1);
        g.moveTo(3,0);
        g.lineTo(-3,0);
        g.moveTo(1,0);
        g.curveTo(-4,8,-1,0);
        g.moveTo(1,0);
        g.curveTo(-4,-8,-1,0);
        
        v=4;
        r=0;
    }
}
class Net extends Sprite{
    public function Net(){
        var g:Graphics=graphics;
        g.lineStyle(1,0x606060,0.5);
        g.drawRect(-10,-20,20,20);
        for(var i:int=-8;i<=8;i+=2){
            g.moveTo(i,-20);
            g.lineTo(i,0);
        }
        for(i=-18;i<=-2;i+=2){
            g.moveTo(-10,i);
            g.lineTo(10,i);
        }
        g.moveTo(0,0);
        g.lineTo(0,30);
    }
}