/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s6XQ
 */

package
{
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.system.LoaderContext;
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.materials.utils.*;
    
    [SWF(width = "720", height = "480", frameRate = "60", backgroundColor = "#000000")]
    
    public class Main extends BasicView 
    {    
        private var remoteImage:String = 
            "http://digitalshop.webasyst.net/shop/products_pictures/360%20Sky_enl.jpg";
            
        private var sphere:Sphere;
        private var wire:Sphere;
        private var sp:Sprite;
        private var centerX:Number;
        private var centerY:Number;

        public function Main()
        {
            function init():void
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE , complete);
                loader.load(new URLRequest(remoteImage), new LoaderContext(true));
            } 
        
            function complete(e:Event):void 
            {
                var loaderInfo:LoaderInfo = e.target as LoaderInfo;    
                loaderInfo.removeEventListener(Event.COMPLETE , complete);           
                var bm:Bitmap = loaderInfo.content as Bitmap;           
                //createMapBM(bm);
                setUpDO(bm);
            }    
            
            function setUpDO(bm:Bitmap):void
            {
                sp = new Sprite();
                sp.addChild(bm);
                centerX = (stage.stageWidth - sp.width) >> 1;
                centerY = (stage.stageHeight - sp.height) >> 1;                
                sp.x = centerX;
                sp.y = centerY;
             // sp.buttonMode = true;
             // sp.addEventListener(MouseEvent.ROLL_OVER, over);
                addChild(sp);
            }
 
 
            super(0, 0, true, false, CameraType.FREE);
            stage.quality = StageQuality.LOW;
            camera.x = camera.y = camera.z = 0;
            camera.focus = 300;
            camera.zoom = 1;

            var size :Number = 25000;
            var quality :Number = 30;            
            var sphereMaterial:BitmapFileMaterial = new BitmapFileMaterial(remoteImage, false);       
            sphereMaterial.opposite = true;
            sphereMaterial.smooth = true;
            
            var wireMaterial:WireframeMaterial = new WireframeMaterial(0xFF0000);
            wireMaterial.opposite = true;
            
            sphere = new Sphere(
                sphereMaterial,
                size, 
                quality, 
                quality);
            wire = new Sphere(
                wireMaterial,
                size,
                quality,
                quality);
            wire.visible = false;
            
            scene.addChild(sphere);
            scene.addChild(wire);

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseHandler);
            
            startRendering();
        }

        private function enterFrameHandler(event:Event):void
        {
            // Pan
            camera.rotationY += (480 * mouseX/(stage.stageWidth) - camera.rotationY) * .1;
            camera.rotationX += (180 * mouseY/(stage.stageHeight) - 90 - camera.rotationX) * .1;
        }
        
        private function mouseHandler(event:MouseEvent):void 
        {
            wire.visible = !wire.visible;
        }
    }
}