/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s5CR
 */

package {
    import flash.display.Sprite;
    import flash.text.*;

    public class Test extends Sprite {
        private var _tf : TextField;
  
        public function Test() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            _tf.defaultTextFormat = new TextFormat("Courier New");
            addChild(_tf);
            
            solve();
        }
        
        private function solve() : void
        {
        		var base : uint = 0;
        		for(var a : uint = 0;a < 25;a++){
        			var pa : uint = base | paint(a);
        			for(var b : uint = a + 1;b < 25;b++){
	        			var pb : uint = pa | paint(b);
        				for(var c : uint = b + 1;c < 25;c++){
		        			var pc : uint = pb | paint(c);
        					if(countbit(pc) <= 20){
        						tr(a, b, c, countbit(pc));
        						printbit(pc, a, b, c);
        					}
        				}
        			}
        		} 
        }
        
        private function printbit(u : uint, ...o : Array) : void
        {
        		var str : String = "";
        		for(var i : uint = 0;i < 25;i++){
        			if(o.indexOf(i) > -1){
        				str += "@";
        			}else{
	        			if(((u >> i) & 1) == 1){
	        				str += "O";
	        			}else{
	        				str += ".";
	        			}
        			}
        			if(i % 5 == 4)str += "\n";
        		} 
        		tr(str);
        }
        
        private function countbit(u : uint) : uint
        {
        		u = ((u & 0xaaaaaaaa) >> 1) + (u & 0x55555555);
        		u = ((u & 0xcccccccc) >> 2) + (u & 0x33333333);
        		u = ((u & 0xf0f0f0f0) >> 4) + (u & 0x0f0f0f0f);
        		u = ((u & 0xff00ff00) >> 8) + (u & 0x00ff00ff);
        		u = ((u & 0xffff0000) >> 16) + (u & 0x0000ffff);
        		return u;
        }
        
        private function paint(p : uint) : uint
        {
        		var px : uint = p % 5;
        		var py : uint = p / 5;
        		var ret : uint = 0;
        		for each(var m : Array in [[0, 1], [0, -1], [1, 0], [-1, 0], [1, 1], [1, -1], [-1, 1], [-1, -1]]){
        			for(var x : int = px, y : int = py;x >= 0 && y >= 0 && x < 5 && y < 5;x += m[0], y += m[1]){
        				ret |= 1 << (y * 5 + x);
        			}
        		}
        		return ret;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}