/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s4vH
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	
	[SWF(backgroundColor="0x000000")]
	public class Main extends Sprite{
		private var _red:Sample2;
		private var _blue:Sample2;
		private var _bitmapData:BitmapData;
		public function Main(){
			_red = new Sample2(-50);
			this.addChild(_red);
			_blue = new Sample2(50);
			this.addChild(_blue);
			
			_bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
			addChild(new Bitmap(_bitmapData));
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			_red.loop(null);
			_blue.loop(null);
			
			_bitmapData.lock();
			_bitmapData.fillRect(new Rectangle(0,0,stage.stageWidth,stage.stageHeight), 0x000000);
			_bitmapData.draw(_red, null,new ColorTransform(1,0,0,1,0,0,0,0));
			_bitmapData.draw(_blue, null,new ColorTransform(0,1,1,1,0,0,0,0), "add");
			_bitmapData.unlock();
		}
		
	}
}

import flash.events.Event;
import org.papervision3d.materials.WireframeMaterial;
import org.papervision3d.objects.primitives.*;
import org.papervision3d.view.BasicView;

class Sample2 extends BasicView {
	private var sphere:Sphere; // 球面のインスタンス
	public function Sample2(dX:Number):void {
		// マテリアルを作成
		var material:WireframeMaterial = new WireframeMaterial(0xFFFFFF);
		
		// 3Dオブジェクトを作成
		sphere = new Sphere(material, 300, 10, 10);
		sphere.x = -dX/6;
		camera.x = dX;
		// 3Dシーンに追加して、表示させる
		scene.addChild(sphere);
		
		// レンダリングを開始
		startRendering();
		
		// エンターフレームを設定
		//addEventListener(Event.ENTER_FRAME, loop);
	}
	
	public function loop(e:Event):void {
		// 球面をY軸方向に回転
		sphere.rotationY += 1;
	}
}
