/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s4fU
 */

// forked from t2421's particle_dot
package {
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class Main extends Sprite {
        private const HEIGHT:Number = 465;
        private const WIDTH:Number = 465;
        private var _canvas:BitmapData;
        private var _particle:Particle;
        private var _cavnasBM:Bitmap;
        public function Main() {
            stage.frameRate = 60;
            _canvas = new BitmapData(WIDTH,HEIGHT,false,0x000000);
            _cavnasBM = new Bitmap(_canvas);
            addChild(_cavnasBM);
            _particle = new Particle(100,100);
            _particle.vx = 3;
            _particle.y = 200;
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function update(e:Event):void{
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect,new ColorTransform(0,0 ,0));
            _particle.x += _particle.vx;
            _particle.y += _particle.vy;
            _canvas.setPixel(_particle.x,_particle.y,_particle.color);
            checkBounce();
            _canvas.unlock();
        }
        
        private function checkBounce():void{
            if(_particle.x > WIDTH){
                _particle.vx *= -1;
                _particle.x = WIDTH;
            }
            
            if(_particle.x < 0){
                _particle.vx *= -1;
                _particle.x = 0;
            }
            
            if(_particle.y > HEIGHT){
                _particle.vy *= -1;
                _particle.y = HEIGHT;
            }
            
            if(_particle.y < 0){
                _particle.vy *= -1;
                _particle.y = 0;
            }



        }


    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var color:uint;
    
    public function Particle(x:Number=0,y:Number=0,color:uint=0xfff000){
        this.x = x;
        this.y = y;
        this.color = color;
    }

}
