/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s4NH
 */

/*
　簡易お絵かきテンプレート
　　＋セーブ機能を追加したもの

　キーボードのsでセーブ可能
*/

package {
    import flash.display.Sprite;
	import flash.events.*;
 
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            addChild(new GameMain());
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;
import mx.graphics.codec.*;

internal class GameMain extends Sprite{
	//==Const==

	static public const LINE_W:int = 2;
	static public const LINE_COLOR:uint = 0x000000;
	static public const LINE_ALPHA:Number = 1.0;

	//==Var==

	public var m_Bitmap:Bitmap;

	public var m_Shape:Shape;


	//==Func==

	public function GameMain(){
		//Init Later (for Using "stage" etc.)
		addEventListener(Event.ADDED_TO_STAGE, Init );
	}
	
	public function Init(e:Event = null):void{
		//Init Once Only
		{
			removeEventListener(Event.ADDED_TO_STAGE, Init );
		}

		//Create Bitmap
		{
			var bmp_data:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			m_Bitmap = new Bitmap(bmp_data);
			addChild(m_Bitmap);
		}

		//Create Shape
		{
			m_Shape = new Shape();
			addChild(m_Shape);
		}
		
		//Draw By Mouse
		{
			var draw_flag:Boolean = false;

			var g:Graphics = m_Shape.graphics;

			//Down
			stage.addEventListener(
				MouseEvent.MOUSE_DOWN,
				function(e:MouseEvent):void{
					//Flag On
					{
						draw_flag = true;
					}

					//Clear Setting
					{
						g.clear();
					}

					//Draw Dot
					{
						g.lineStyle(0, LINE_COLOR, LINE_ALPHA);
						g.drawCircle(mouseX, mouseY, LINE_W/2);
					}

					//Start Line
					{
						g.lineStyle(LINE_W, LINE_COLOR, LINE_ALPHA);
						g.moveTo(mouseX, mouseY);
					}
				}
			);
			
			//Move
			stage.addEventListener(
				MouseEvent.MOUSE_MOVE,
				function(e:MouseEvent):void{
					//Check
					{
						if(! draw_flag){
							return;
						}
					}

					//Draw Line
					{
						g.lineTo(mouseX, mouseY);
					}
				}
			);

			//Up
			stage.addEventListener(
				MouseEvent.MOUSE_UP,
				function(e:MouseEvent):void{
					//Flag Off
					{
						draw_flag = false;
					}

					//Refresh
					{
						m_Bitmap.bitmapData.draw(m_Shape);

						g.clear();
					}
				}
			);

			//S:Save
			stage.addEventListener(
				KeyboardEvent.KEY_DOWN,
				function(e:KeyboardEvent):void{
					if(e.keyCode == 83){//S
						(new FileReference).save((new PNGEncoder()).encode(m_Bitmap.bitmapData), "Result.png");
					}
				}
			);
		}

		//Call "Update"
		{
			addEventListener(Event.ENTER_FRAME, Update);
		}
	}
	
	public function Update(e:Event):void{
	}
}

