/**
 * Copyright pego451 ( http://wonderfl.net/user/pego451 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s489
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.special.ParticleField;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quart;
    import org.libspark.betweenas3.tweens.ITween;
    
    /**
     * @author pego451 * kentaro
     */
    
    [SWF(width = "465", height = "465", backgroundColor = "0", fps = "30")] 
    
    public class Main extends Sprite{
        
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var render:BasicRenderEngine;
        private var particle_do3d:DisplayObject3D;
        private var particles:ParticleField
        private var sphere:Sphere;
        
        private const FIELDS_W:uint = 1500;
        
        private var nPoint:uint;
        private var sphereObj:Object = { };
        
        private var tween:ITween;
        private var tweensArray:Array = [];
        
        public function Main():void {
            
            var bmd:BitmapData = new BitmapData(465,465,false,0x000000);
            var bitmap:Bitmap = new Bitmap(bmd);
            addChild(bitmap);
            
            Wonderfl.capture_delay(20);
            
            initScene();
            initCamera();
            initSphere();
            initRender();
            
            onRenderEvent();
            onPlayEvent();
        };
        
        //init - scene
        private function initScene():void {
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, true);
            addChild(viewport);
            
            particle_do3d = new DisplayObject3D();
            scene.addChild(particle_do3d);
        };
        
        //init - camera
        private function initCamera():void {        
            camera = new Camera3D();
            camera.z = -1000;
            camera.focus = 100;
            camera.zoom = 10;
        };
        
        //init - Sphere
        private function initSphere():void {
            
            var wire_mat:WireframeMaterial = new WireframeMaterial();
            sphere = new Sphere(wire_mat, 120, 24, 24);
            sphereObj = sphere.geometry.vertices;
            nPoint = sphereObj.length - 1;
            
            var mat:ParticleMaterial = new ParticleMaterial(0xFFFFFF, 6, 1);
            particles = new ParticleField(mat, nPoint, 2, FIELDS_W, FIELDS_W, FIELDS_W);
            
            particle_do3d.addChild(particles)
        };
        
        //init - render
        private function initRender():void {
            render = new BasicRenderEngine();
        };
        
        private function onRenderEvent():void {
            addEventListener(Event.ENTER_FRAME, render3D);
        };
        
        private function render3D(evt:Event):void {
            render.renderScene(scene, camera, viewport);
            
            particle_do3d.rotationY+=0.5;
            particle_do3d.rotationX+=0.4;
            particle_do3d.rotationZ+=0.3;
        };
        
        //play
        private function onPlayEvent():void {
            for (var i:uint = 0;  i < nPoint; i++) {
                var posX:Number = sphereObj[i].x;
                var posY:Number = sphereObj[i].y;
                var posZ:Number = sphereObj[i].z;
                
                tweensArray.push (
                    BetweenAS3.delay(
                        BetweenAS3.tween(particles.geometry.vertices[i],
                        {
                            x : posX,
                            y : posY,
                            z : posZ
                        },
                        null, 
                        4,
                        Quart.easeInOut),
                        Math.random() * 1.2
                    )
                );
            };
                    
            tween = BetweenAS3.parallelTweens(tweensArray);
            tween.play();
        };
    };
};