/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s3Pj
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import mx.utils.ObjectUtil;
    // @see http://projecteuler.net/index.php?section=problems&id=86
    public class Euler86 extends Sprite {
        private var _tf : TextField;
  
        public function Euler86() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            // 1回1回はそんなに時間かからないので2分探索で
            _tf.appendText(binaryAttack(1, 3000, function(x : int) : Boolean {
                return solve(x) > 1000000;
            }).toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private static function binaryAttack(start : int, end : int, f : Function) : int
        {
            var s : int = start;
            var e : int = end;
            var m : int = (s + e) >> 1;
            while(s < m){
                if(f.apply(null, [m])){
                    e = m;
                }else{
                    s = m;
                }
                m = (s + e) >> 1;
            }
            return m + 1;
        }
        
        private function solve(M : int) : int
        {
            var i : int, j : int;
            var ct : int = 0;
            for(var m : int = 1;m <= M / 2;m++){
                for(var n : int = 1;n < m;n++){
                    // ピタゴラス数の生成
                    if(((m & 1) == 1 && (n & 1) == 1) || GCD(m, n) != 1)continue;
                    var x : int = m * m - n * n;
                    var y : int = 2 * m * n;
                    var xj : int, yj : int;
                    // x > y - i > i
                    for(j = 1;x * j <= M;j++){
                        xj = x * j;
                        yj = y * j;
                        if(xj > yj / 2){
                            for(i = 1;i <= yj / 2;i++){
                                if(yj - i <= xj){
                                    ct++;
                                }
                            }
                        }
                    }
                    // y > x - i > i
                    for(j = 1;y * j <= M;j++){
                        xj = x * j;
                        yj = y * j;
                        if(yj > xj / 2){
                            for(i = 1;i <= xj / 2;i++){
                                if(xj - i <= yj){
                                    ct++;
                                }
                            }
                        }
                    }
                }
            }
            return ct;
        }
        
        private static function GCD(a : int, b : int) : int
        {
            return b == 0 ? a : GCD(b, a % b);
        }
    }
}