/**
 * Copyright darman ( http://wonderfl.net/user/darman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s35T
 */

package {
    import com.greensock.TimelineMax;
    import com.greensock.TweenMax;
    import com.greensock.easing.*;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth, stage.stageWidth);
            graphics.endFill();
                        
            
            var red:Sprite = new Sprite();
            red.graphics.beginFill(0xff0000);
            red.graphics.drawRect(-50, -50, 100,100);
            red.graphics.endFill();
            addChild(red);
            
            var yellow:Sprite = new Sprite();
            yellow.graphics.beginFill(0xffff00);
            yellow.graphics.drawRect(-50, -50, 100,100);
            yellow.graphics.endFill();
            addChild(yellow);
            
            var green:Sprite = new Sprite();
            green.graphics.beginFill(0x00ff00);
            green.graphics.drawRect(-50, -50, 100,100);
            green.graphics.endFill();
            addChild(green);
            
            var format:TextFormat = new TextFormat();
            format.size = 30;
            format.color = 0xffffff;
            
            var title:TextField = new TextField();
            title.autoSize = "center";
            title.defaultTextFormat = format;
            title.text = "【 TweenMax Sample 】";
            addChild(title);
            
            red.x = 80;
            yellow.x = 220;
            green.x = 360;
            red.y = yellow.y = green.y = 220;
            
            red.scaleX = red.scaleY = 0;
            yellow.scaleX = yellow.scaleY = 0;
            green.scaleX = green.scaleY = 0;
            
            title.alpha = 0;
            title.x = stage.stageWidth / 2 - title.width / 2;
            
            var timeline:TimelineMax = new TimelineMax({repeat:-1, yoyo:true});
            timeline.append(TweenMax.to(title, 1, { alpha:1, y:50, ease:Quint.easeOut}));
            timeline.appendMultiple(TweenMax.allTo([red, yellow, green], 0.7, { scaleX:1, scaleY:1, rotation:180, ease:Back.easeOut},0.2));
            timeline.append(TweenMax.to(title, 1.5, { scaleX:3, scaleY:3, alpha:0, ease:Quint.easeOut}));
            timeline.appendMultiple(TweenMax.allTo([red, yellow, green], 1.5, { scaleX:3, scaleY:3, alpha:0, rotation:180, ease:Quint.easeOut}),-1.0);
            
        }
    }
}