/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s2ty
 */

// forked from mimshwright's HelloKitchenSync

package {
	import flash.text.*;
	import flash.filters.*;
	import flash.display.Sprite;
	
	import org.as3lib.kitchensync.KitchenSync;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.easing.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.action.tween.*;
	
	[SWF(width="500", height="500", frameRate="50", backgroundColor="#FFFFFF")]
	
	public class HelloKitchenSync extends Sprite {
		
		private var hello:TextField;
		private var world:TextField;
		
		public function HelloKitchenSync()
		{
			super();
			KitchenSync.initialize(this);
			
			var textFormat:TextFormat = new TextFormat( "courier", 72);
			
			hello = new TextField();
			hello.defaultTextFormat = textFormat;
			hello.autoSize = TextFieldAutoSize.LEFT;
			hello.text = "Hello,";
			hello.x = -200;
			hello.y = 150;
			addChild(hello);
			
			world = new TextField();
			world.defaultTextFormat = textFormat;
			world.autoSize = TextFieldAutoSize.LEFT;
			world.text = "world!";
			world.x = -200;
			world.y = 230;
			addChild(world);
			
			var centerX:int = (stage.stageWidth - hello.width) / 2;
			
			var helloTween:KSTween = TweenFactory.newTweenFromObject( {
				target: hello, 
				xFrom:AUTO_TWEEN_VALUE, xTo:centerX, 
				easingFunction:Elastic.easeOut, mod1:0.01,
				duration: "5s", delay: "0.5s"
			}) as KSTween;
			
			
			var worldTween:KSTween = TweenFactory.newTween(
				world, "x", 
				AUTO_TWEEN_VALUE, centerX,
				"5s", 0,
				Elastic.easeOut
			); 
			worldTween.easingMod1 = 0.01; 
			

			var animateIn:IActionGroup = new KSStaggeredGroup (
				800,
				helloTween,
				worldTween
			);
			
			animateIn.start();
		}
	}
}