/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s2qZ
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GraphicsPath;
    import flash.display.GraphicsSolidFill;
    import flash.display.GraphicsStroke;
    import flash.display.IGraphicsData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;

    [SWF (width = '512', height = '512', backgroundColor = '0x000000', frameRate = '64')]
    public class Terraces extends Sprite {
        private var bmd : BitmapData = new BitmapData(512, 512);
        private var fmap : BitmapData = new BitmapData(512, 1);
        private var src : Shape = new Shape();
        private var ct : ColorTransform = new ColorTransform(1, 1, 1, 0.99);
        private var color : ColorHSV = new ColorHSV(Math.random() * 360, 0.075, 1.0);
        private var g_val : Vector.<IGraphicsData> = new <IGraphicsData>[];
        private var g_dat : Vector.<Number> = new <Number>[];
        private var g_com : Vector.<int> = new <int>[1];
        private var g_str : GraphicsStroke = new GraphicsStroke(1);
        private var g_pat : GraphicsPath;
        private var ox : Number = 2.0;
        private var oy : Number = 2.0;
        private var o0 : Point = new Point();
        private var o1 : Point = new Point();

        public function Terraces() {
            var bm : Bitmap = new Bitmap(bmd);
            bm.opaqueBackground = 0x0;
            addChild(bm);

            var c : int = fmap.width + 1;
            while (c-- != 0) {
                g_com.push(2);
            }

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            o0.x = - (o1.x += ox);
            o0.y = - (o1.y += oy);

            fmap.perlinNoise(256, 256, 2, 8, false, true, 1, true, [o0, o1]);

            color.h += 0.5;
            g_str.fill = new GraphicsSolidFill(color.getRGB);

            for (var i : int = 0; i < fmap.width; i++) {
                g_dat.push(i, ((512 / 1.75) - 0xE8) + ((fmap.getPixel(i, 0) & 0xE8) << 1));
            }

            g_dat.push(512, 512);
            g_dat.push(0, 512);
            g_pat = new GraphicsPath(g_com, g_dat);
            g_val.push(g_str.fill);
            g_val.push(g_str, g_pat);

            src.graphics.clear();
            src.graphics.drawGraphicsData(g_val);

            g_dat.length = g_val.length = 0;

            bmd.lock();
            bmd.colorTransform(bmd.rect, ct);
            bmd.scroll(0, -1);
            bmd.draw(src);
            bmd.unlock();
        }
    }
}

internal class ColorHSV {
    public var h : Number;
    public var s : Number;
    public var l : Number;
    private var _r : uint;
    private var _g : uint;
    private var _b : uint;

    function ColorHSV(h : Number, s : Number, v : Number) {
        this.h = h;
        this.s = s;
        this.l = v;
    }

    public function get getRGB() : uint {
        if (s > 0) {
            var h : Number = ((h < 0) ? (h % 360 + 360) : (h % 360) / 60);
            if (h < 1) {
                _r = (255 * l) >> 0;
                _g = (255 * l * (1 - s * (1 - h))) >> 0;
                _b = (255 * l * (1 - s)) >> 0;
            } else if (h < 2) {
                _r = (255 * l * (1 - s * (h - 1))) >> 0;
                _g = (255 * l) >> 0;
                _b = (255 * l * (1 - s)) >> 0;
            } else if (h < 3) {
                _r = (255 * l * (1 - s)) >> 0;
                _g = (255 * l) >> 0;
                _b = (255 * l * (1 - s * (3 - h))) >> 0;
            } else if (h < 4) {
                _r = (255 * l * (1 - s)) >> 0;
                _g = (255 * l * (1 - s * (h - 3))) >> 0;
                _b = (255 * l) >> 0;
            } else if (h < 5) {
                _r = (255 * l * (1 - s * (5 - h))) >> 0;
                _g = (255 * l * (1 - s)) >> 0;
                _b = (255 * l) >> 0;
            } else {
                _r = (255 * l) >> 0;
                _g = (255 * l * (1 - s)) >> 0;
                _b = (255 * l * (1 - s * (h - 5))) >> 0;
            }
        }
        return _r << 16 | _g << 8 | _b;
    }
}