/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s2lb
 */

// forked from jozefchutka's forked from: Guide
// forked from jozefchutka's Guide
package
{
    import __AS3__.vec.Vector;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#FFFFFF")]
    
    public class GiudeApp extends Sprite
    {
        private var car1:Car = new Car();
        private var car2:Car = new Car();
        private var bitmapData:BitmapData = new BitmapData(465, 465, true, 0x0);
        private var bitmap:Bitmap = new Bitmap(bitmapData);
        
        public function GiudeApp()
        {
            var guide:Guide = new Guide();
            guide.add(465 / 2, 465 / 2);
            
            car1.guide = guide;
            car2.guide = guide.copy();
            
            addChild(bitmap);
            addChild(car1);
            addChild(car2);
            addChild(new Stats());
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
        }
        
        private function enterFrame(event:Event):void
        {
            for(var i:uint = 0; i < 20; i++)
                move();
        }
        
        private function move():void
        {
            car1.move(0.15);
            car2.move(0.3);
            drawBitmap();
        }
        
        private function drawBitmap():void
        {
            if(car1.x == car2.x && car1.y == car2.y)
                return;
            
            var distance:Number = Point.distance(
                car1.guide.firstPoint, 
                car2.guide.firstPoint);
            graphics.clear();
            graphics.lineStyle(0, distance * 0xffff, 3 / (distance + 20));
            graphics.moveTo(car1.x, car1.y);
            graphics.lineTo(car2.x, car2.y);
            car1.visible = false;
            car2.visible = false;
            bitmap.visible = false;
            bitmapData.draw(this);
            car1.visible = true;
            car2.visible = true;
            bitmap.visible = true;
            graphics.clear();
        }
        
        private function add(x:Number, y:Number):void
        {
            car1.guide.add(x, y);
            car2.guide.add(465 - y, 465 - x);
        }
        
        private function mouseDown(event:MouseEvent):void
        {
            add(mouseX, mouseY);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            add(mouseX, mouseY);
        }
        
        private function mouseUp(event:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);
        }
    }
}

import __AS3__.vec.Vector;

import flash.display.Shape;
import flash.geom.Point;

class Guide extends Object
{
    public var points:Vector.<Point> = new Vector.<Point>();
    
    public function Guide():void
    {
    }
    
    public function add(x:Number, y:Number):void
    {
        points.push(new Point(x, y));
    }
    
    public function shift():void
    {
        points.shift()
    }
    
    public function get firstPoint():Point
    {
        return points.length ? points[0] : null;
    }
    
    public function get nextPoint():Point
    {
        return points.length > 1 ? points[1] : null;
    }
    
    public function copy():Guide
    {
        var guide:Guide = new Guide();
        for each(var point:Point in points)
            guide.add(point.x, point.y);
        return guide;
    }
}

class Car extends Shape
{
    private var _guide:Guide;
    
    public function Car():void
    {
        graphics.beginFill(0x0, 0.2);
        graphics.drawCircle(0, 0, 1);
        graphics.endFill();
    }
    
    public function set guide(value:Guide):void
    {
        _guide = value;
        x = guide.firstPoint.x;
        y = guide.firstPoint.y;
    }
    
    public function get guide():Guide
    {
        return _guide;
    }
    
    public function move(speed:Number):void
    {
        var p0:Point = guide.firstPoint;
        var p1:Point = guide.nextPoint;
        if(!p1)
            return;
        
        var distance:Number = Point.distance(p0, p1);
        var coeff:Number = Math.min(speed / distance, 1);
        p0.x = x = p0.x + (p1.x - p0.x) * coeff;
        p0.y = y = p0.y + (p1.y - p0.y) * coeff;
        if(p0.x == p1.x && p0.y == p1.y)
            guide.shift();
            
        if(guide.nextPoint && speed > distance)
            move(speed - distance);
    }
}