/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s2Je
 */

// forked from chependuk's flash on 2010-8-19
﻿package {

    import flash.display.*;



    public class SkinDefaults {



        public static function get values():Object{

            return ({

                bottom:0,

                left:"50%",

                height:26,

                width:"100%",

                zIndex:2,

                backgroundColor:"rgba(0, 0, 0, 0.7)",

                backgroundGradient:[0.5, 0, 0.3],

                border:"0px",

                borderRadius:"0px",

                timeColor:"#ffffff",

                durationColor:"#a3a3a3",

                sliderColor:"#000000",

                sliderGradient:"none",

                volumeColor:"#ffffff",

                volumeSliderColor:"#ffffff",

                volumeSliderGradient:"none",

                buttonColor:"#ffffff",

                buttonOverColor:"#ffffff",

                progressColor:"#ffffff",

                progressGradient:"none",

                bufferColor:"#a3a3a3",

                bufferGradient:"none",

                tooltipColor:"#000000",

                tooltipTextColor:"#ffffff",

                timeBgColor:"rgb(0, 0, 0, 0)",

                timeBorder:"0px solid rgba(0, 0, 0, 0.3)",

                timeBorderRadius:20,

                scrubberHeightRatio:0.6,

                scrubberBarHeightRatio:0.3,

                volumeSliderHeightRatio:0.6,

                volumeBarHeightRatio:0.3,

                timeBgHeightRatio:0.8,

                timeSeparator:" ",

                timeFontSize:12,

                volumeBorder:"1px solid rgba(128, 128, 128, 0.7)",

                sliderBorder:"1px solid rgba(128, 128, 128, 0.7)",

                autoHide:{

                    enabled:true,

                    fullscreenOnly:false,

                    delay:2000,

                    duration:1000,

                    style:"fade"

                }

            });

        }

        public static function getSpaceAfterWidget(_arg1:DisplayObject, _arg2:Boolean):Number{

            var _local3 = 2;

            if (_arg2){

                _local3 = 6;

            } else {

                if (_arg1.name == "volume"){

                    _local3 = 8;

                } else {

                    if (_arg1.name == "time"){

                        _local3 = 6;

                    };

                };

            };

            return (_local3);

        }

        public static function getSpaceBeforeFirstWidget():Number{

            return (12);

        }

        public static function getScrubberRightEdgeWidth(_arg1:DisplayObject):Number{

            return (0);

        }

        public static function getVolumeSliderWidth():Number{

            return (57);

        }

        public static function get margins():Array{

            return ([2, 6, 2, 6]);

        }



    }

}//package 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class PrevOver_23 extends MovieClip {



        public function PrevOver_23(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class UnMuteOver_35 extends MovieClip {



        public function UnMuteOver_35(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class SlowMotionFwdOver_54 extends MovieClip {



        public function SlowMotionFwdOver_54(){

            addFrameScript(0, frame1, 9, frame10, 18, frame19);

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }

        function frame19(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class SlowMotionBwdOver_57 extends MovieClip {



        public function SlowMotionBwdOver_57(){

            addFrameScript(0, frame1, 9, frame10, 18, frame19);

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }

        function frame19(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class DraggerOver_44 extends MovieClip {



        public function DraggerOver_44(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class SlowMotionFFwdOver_32 extends MovieClip {



        public function SlowMotionFFwdOver_32(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class StopOver_41 extends MovieClip {



        public function StopOver_41(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class MuteOver_38 extends MovieClip {



        public function MuteOver_38(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class PlayOver_51 extends MovieClip {



        public function PlayOver_51(){

            addFrameScript(0, frame1, 9, frame10, 18, frame19);

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }

        function frame19(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class FullScreenOnOver_47 extends MovieClip {



        public function FullScreenOnOver_47(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class PauseOver_20 extends MovieClip {



        public function PauseOver_20(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class SlowMotionFBwdOver_26 extends MovieClip {



        public function SlowMotionFBwdOver_26(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package buttons_modern_fla {

    import flash.display.*;



    public dynamic class NextOver_29 extends MovieClip {



        public function NextOver_29(){

            addFrameScript(0, frame1, 9, frame10, 19, frame20);

        }

        function frame20(){

            stop();

        }

        function frame10(){

            stop();

        }

        function frame1(){

            stop();

        }



    }

}//package buttons_modern_fla 

﻿package org.flowplayer.ui {



    public class AutoHideConfig {



        private var _enabled:Boolean = true;

        private var _fullscreenOnly:Boolean = true;

        private var _hideDelay:Number = 4000;

        private var _hideDuration:Number = 800;

        private var _hideStyle:String = "move";

        private var _mouseOutDelay:Number = 500;



        public function set state(_arg1:String):void{

            this._enabled = (((_arg1) && (!((_arg1 == "never")))) as Boolean);

            this._fullscreenOnly = (_arg1 == "fullscreen");

        }

        public function get state():String{

            if (!this._enabled){

                return ("never");

            };

            return ((this._fullscreenOnly) ? "fullscreen" : "always");

        }

        public function get hideDelay():Number{

            return (this._hideDelay);

        }

        public function set hideDelay(_arg1:Number):void{

            this._hideDelay = _arg1;

        }

        public function set delay(_arg1:Number):void{

            this._hideDelay = _arg1;

        }

        public function set hideDuration(_arg1:Number):void{

            this._hideDuration = _arg1;

        }

        public function set duration(_arg1:Number):void{

            this._hideDuration = _arg1;

        }

        public function get hideStyle():String{

            return (this._hideStyle);

        }

        public function set hideStyle(_arg1:String):void{

            this._hideStyle = _arg1;

        }

        public function set mouseOutDelay(_arg1:Number):void{

            this._mouseOutDelay = _arg1;

        }

        public function get mouseOutDelay():Number{

            return (this._mouseOutDelay);

        }

        public function setStyle(_arg1:String):void{

            this._hideStyle = _arg1;

        }

        public function get hideDuration():Number{

            return (this._hideDuration);

        }

        public function get enabled():Boolean{

            return (this._enabled);

        }

        public function set enabled(_arg1:Boolean):void{

            this._enabled = _arg1;

        }

        public function get fullscreenOnly():Boolean{

            return (this._fullscreenOnly);

        }

        public function set fullscreenOnly(_arg1:Boolean):void{

            this._fullscreenOnly = _arg1;

        }



    }

}//package org.flowplayer.ui 

﻿package org.flowplayer.ui {

    import flash.events.*;

    import org.flowplayer.view.*;

    import org.flowplayer.model.*;

    import flash.display.*;

    import flash.geom.*;

    import flash.utils.*;

    import org.flowplayer.util.*;



    public class AutoHide {



        private var log:Log;

        private var _disp:DisplayObject;

        private var _hideTimer:Timer;

        private var _mouseOutTimer:Timer;

        private var _stage:Stage;

        private var _playList:Playlist;

        private var _config:AutoHideConfig;

        private var _player:Flowplayer;

        private var _originalPos:Object;

        private var _mouseOver:Boolean = false;

        private var _hwFullScreen:Boolean;

        private var _model:DisplayPluginModel;

        private var _hideListener:Function;

        private var _showListener:Function;



        public function AutoHide(_arg1:DisplayPluginModel, _arg2:AutoHideConfig, _arg3:Flowplayer, _arg4:Stage, _arg5:DisplayObject){

            this.log = new Log(this);

            super();

            Assert.notNull(_arg2, "config cannot be null");

            Assert.notNull(_arg3, "player cannot be null");

            Assert.notNull(_arg4, "stage cannot be null");

            Assert.notNull(_arg5, "displayObject cannot be null");

            this._model = _arg1;

            this._config = _arg2;

            this._playList = _arg3.playlist;

            this._player = _arg3;

            this._stage = _arg4;

            this._disp = _arg5;

            this._originalPos = this.getDisplayProperties();

            if (this._config.state != "fullscreen"){

                this.startTimerAndInitializeListeners();

            };

            this._stage.addEventListener(FullScreenEvent.FULL_SCREEN, this.onFullScreen);

        }

        public function onHide(_arg1:Function):void{

            this._hideListener = _arg1;

        }

        public function onShow(_arg1:Function):void{

            this._showListener = _arg1;

        }

        public function stop(_arg1:Boolean=true):void{

            this.log.debug(("stop(), leaveVisible? " + _arg1));

            if (((!(this.isShowing())) && (_arg1))){

                this.show();

            };

            if (!_arg1){

                this.hide(null, true);

            };

            this.stopHideTimer();

            this.stopMouseOutTimer();

            this._stage.removeEventListener(FullScreenEvent.FULL_SCREEN, this.onFullScreen);

            this._stage.removeEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

            this._stage.removeEventListener(Event.RESIZE, this.onStageResize);

            this._stage.removeEventListener(Event.MOUSE_LEAVE, this.startMouseOutTimer);

            this._disp.removeEventListener(MouseEvent.ROLL_OVER, this.onMouseOver);

            this._disp.removeEventListener(MouseEvent.ROLL_OUT, this.onMouseOut);

        }

        public function start():void{

            this.show();

            this.log.debug(("start(), autoHide is " + this._config.state));

            if (this._config.state == "fullscreen"){

                this.fullscreenStart();

                return;

            };

            if (this._config.state == "always"){

                this.startTimerAndInitializeListeners();

                return;

            };

        }

        public function cancelAnimation():void{

            this.log.debug("cancelAnimation");

            this._player.animationEngine.cancel(this._disp);

        }

        public function showAndUpdate():void{

            this.cancelAnimation();

            this.show(function ():void{

                _originalPos = getDisplayProperties();

            });

        }

        private function getDisplayProperties():Object{

            if (((this._model) && ((this._model.getDisplayObject() == this._disp)))){

                return ((DisplayProperties(this._player.pluginRegistry.getPlugin(this._model.name)).clone() as DisplayProperties));

            };

            return ({

                top:this._disp.y,

                left:this._disp.x,

                width:this._disp.width,

                height:this._disp.height,

                alpha:this._disp.alpha

            });

        }

        private function clone(_arg1:Object):Object{

            var _local2:Object;

            var _local3:String;

            if ((_arg1 is DisplayProperties)){

                return ((_arg1.clone() as DisplayProperties));

            };

            _local2 = {};

            for (_local3 in _arg1) {

                _local2[_local3] = _arg1[_local3];

            };

            return (_local2);

        }

        private function get hiddenPos():Object{

            var _local1:Object = this.clone(this._originalPos);

            if (this.useFadeOut){

                this._hwFullScreen = true;

                _local1.alpha = 0;

            } else {

                this._hwFullScreen = false;

                _local1.top = this.getHiddenPosition();

            };

            return (_local1);

        }

        private function onFullScreen(_arg1:FullScreenEvent):void{

            if (_arg1.fullScreen){

                this.startTimerAndInitializeListeners();

                this.showAndUpdate();

            } else {

                if (this._config.state != "always"){

                    this.stop();

                };

                this._disp.alpha = 0;

                this.cancelAnimation();

                this.showAndUpdate();

            };

        }

        private function fullscreenStart():void{

            if (this.isInFullscreen()){

                this.startTimerAndInitializeListeners();

            } else {

                this.stopHideTimer();

                this.stopMouseOutTimer();

                this._stage.addEventListener(FullScreenEvent.FULL_SCREEN, this.onFullScreen);

            };

        }

        private function startTimerAndInitializeListeners():void{

            this.startHideTimer();

            this._stage.addEventListener(Event.MOUSE_LEAVE, this.startMouseOutTimer);

            this._stage.addEventListener(FullScreenEvent.FULL_SCREEN, this.onFullScreen);

            this._stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

            this._stage.addEventListener(Event.RESIZE, this.onStageResize);

            this._disp.addEventListener(MouseEvent.ROLL_OVER, this.onMouseOver);

            this._disp.addEventListener(MouseEvent.ROLL_OUT, this.onMouseOut);

        }

        private function onMouseOver(_arg1:MouseEvent):void{

            this._mouseOver = true;

        }

        private function onMouseOut(_arg1:MouseEvent):void{

            this._mouseOver = false;

        }

        private function mouseLeave(_arg1:Event=null):void{

            this._stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

            this.stopHideTimer();

            this.stopMouseOutTimer();

            this.cancelAnimation();

            this.hide();

        }

        private function startMouseOutTimer(_arg1:Event=null):void{

            this.log.debug(("startMouseOutTimer(), delay is " + this._config.mouseOutDelay));

            if (this._config.mouseOutDelay == 0){

                this.mouseLeave();

                return;

            };

            if (!this._mouseOutTimer){

                this._mouseOutTimer = new Timer(this._config.mouseOutDelay);

            } else {

                if (this._config.mouseOutDelay != this._mouseOutTimer.delay){

                    this.log.debug(("startMouseOutTimer(), using new delay " + this._config.mouseOutDelay));

                    this._mouseOutTimer.stop();

                    this._mouseOutTimer = new Timer(this._config.mouseOutDelay);

                };

            };

            this._mouseOutTimer.addEventListener(TimerEvent.TIMER, this.mouseLeave);

            this._mouseOutTimer.start();

        }

        private function stopMouseOutTimer():void{

            if (!this._mouseOutTimer){

                return;

            };

            this._mouseOutTimer.stop();

            this._mouseOutTimer = null;

        }

        private function onMouseMove(_arg1:MouseEvent):void{

            this._stage.removeEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

            this.cancelAnimation();

            this.show();

            if (((this.isShowing()) && (this._hideTimer))){

                this._hideTimer.stop();

                this._hideTimer.start();

                return;

            };

        }

        private function isShowing():Boolean{

            return ((((this._disp.alpha > 0)) && ((this._disp.y < this.getHiddenPosition()))));

        }

        private function onStageResize(_arg1:Event):void{

            if (!this._hideTimer){

                return;

            };

            this._hideTimer.stop();

            this._hideTimer.start();

        }

        private function startHideTimer():void{

            if (this._config.hideDelay == 0){

                this.hide();

                return;

            };

            if (!this._hideTimer){

                this._hideTimer = new Timer(this._config.hideDelay);

            } else {

                if (this._config.hideDelay != this._hideTimer.delay){

                    this._hideTimer.stop();

                    this._hideTimer = new Timer(this._config.hideDelay);

                };

            };

            this._hideTimer.addEventListener(TimerEvent.TIMER, this.hide);

            this._hideTimer.start();

        }

        private function stopHideTimer():void{

            if (!this._hideTimer){

                return;

            };

            this._hideTimer.stop();

            this._hideTimer = null;

        }

        private function isInFullscreen():Boolean{

            return ((this._stage.displayState == StageDisplayState.FULL_SCREEN));

        }

        public function hide(_arg1:TimerEvent=null, _arg2:Boolean=false):void{

            if (!this.isShowing()){

                if (this._hideTimer){

                    this._hideTimer.stop();

                };

                return;

            };

            this.log.warn((("HIDING ? " + (_arg2) ? "true " : "false ") + (this._mouseOver) ? "true " : "false "));

            if (((!(_arg2)) && (this._mouseOver))){

                return;

            };

            this.log.debug("dispatching onBeforeHidden");

            if (((this._model) && (!(this._model.dispatchBeforeEvent(PluginEventType.PLUGIN_EVENT, "onBeforeHidden"))))){

                this.log.debug("hide() onHidden event was prevented, not hiding");

                return;

            };

            if (((!((this._hideListener == null))) && (!(this._hideListener())))){

                this.log.debug("hideListener callback function prevented hiding");

                return;

            };

            this.log.debug("animating to hidden position");

            this._player.animationEngine.animate(this._disp, this.hiddenPos, this._config.hideDuration, this.onHidden);

            if (this._hideTimer){

                this._hideTimer.stop();

            };

        }

        private function onHidden():void{

            this.log.debug("onHidden()");

            this.dispatchEvent("onHidden");

        }

        public function show(_arg1:Function=null):void{

            var callback = _arg1;

            var currentProps:* = this.getDisplayProperties();

            if (this._hwFullScreen){

                currentProps.alpha = this._originalPos.alpha;

            } else {

                if ((this._originalPos is DisplayProperties)){

                    if (this._originalPos.position.top.hasValue()){

                        this.log.debug(("restoring to top " + this._originalPos.position.top));

                        currentProps.top = this._originalPos.position.top;

                    };

                    if (this._originalPos.position.bottom.hasValue()){

                        this.log.debug(("restoring to bottom " + this._originalPos.position.bottom));

                        currentProps.bottom = this._originalPos.position.bottom;

                    };

                } else {

                    this.log.debug(("restoring to y " + this._originalPos.y));

                    currentProps.y = this._originalPos.y;

                };

            };

            if (((this._model) && (!(this._model.dispatchBeforeEvent(PluginEventType.PLUGIN_EVENT, "onBeforeShowed"))))){

                this.log.debug("show() onShowed event was prevented, not showing");

                return;

            };

            if (((!((this._showListener == null))) && (!(this._showListener())))){

                this.log.debug("showListener returned false, will not show");

                return;

            };

            var onShowCallback:* = this.onShowed;

            if (callback != null){

                onShowCallback = function ():void{

                    onShowed();

                    callback();

                };

            };

            this._player.animationEngine.animate(this._disp, currentProps, 400, onShowCallback);

        }

        private function dispatchEvent(_arg1:String):void{

            if (!this._model){

                return;

            };

            this._model.dispatch(PluginEventType.PLUGIN_EVENT, _arg1);

        }

        private function onShowed():void{

            this.dispatchEvent("onShowed");

            this._stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

            if (this._config.state == "fullscreen"){

                this.fullscreenStart();

            };

            if (this._config.state == "always"){

                this.startTimerAndInitializeListeners();

            };

        }

        private function get useFadeOut():Boolean{

            if (this._config.hideStyle == "fade"){

                return (true);

            };

            return (((((this.isInFullscreen()) && (this._stage.hasOwnProperty("fullScreenSourceRect")))) && (!((this._stage.fullScreenSourceRect == null)))));

        }

        private function getHiddenPosition():Object{

            var _local1:Rectangle;

            if ((((this._stage.displayState == StageDisplayState.FULL_SCREEN)) && (this._stage.hasOwnProperty("fullScreenSourceRect")))){

                _local1 = this._stage.fullScreenSourceRect;

                if (_local1){

                    return (_local1.height);

                };

            };

            return (this._stage.stageHeight);

        }



    }

}//package org.flowplayer.ui 

﻿package org.flowplayer.controls {

    import org.flowplayer.util.*;



    public class Style {



        private var log:Log;

        private var _bgStyle:Object;

        private var _style:Object;



        public function Style(){

            this.log = new Log(this);

            this._style = new Object();

            super();

        }

        public function addStyleProps(_arg1:Object):Object{

            var _local2:String;

            for (_local2 in this._style) {

                _arg1[_local2] = this._style[_local2];

            };

            return (_arg1);

        }

        public function set bgStyle(_arg1:Object):void{

            this.log.debug("setting bgStyle");

            this._bgStyle = _arg1;

        }

        public function get bgStyle():Object{

            this.log.debug("getting bgStyle");

            return (this._bgStyle);

        }

        public function get durationColor():Number{

            return (StyleSheetUtil.colorValue(this._style["durationColor"]));

        }

        public function get durationAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["durationColor"]));

        }

        public function setDurationColor(_arg1:String):void{

            this._style["durationColor"] = _arg1;

        }

        public function setTimeColor(_arg1:String):void{

            this._style["timeColor"] = _arg1;

        }

        public function get timeColor():Number{

            return (StyleSheetUtil.colorValue(this._style["timeColor"]));

        }

        public function get timeAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["timeColor"]));

        }

        public function get bufferColor():Number{

            return (StyleSheetUtil.colorValue(this._style["bufferColor"]));

        }

        public function get bufferAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["bufferColor"]));

        }

        public function setBufferColor(_arg1:String):void{

            this._style["bufferColor"] = _arg1;

        }

        public function setBufferGradient(_arg1:Object):void{

            this._style["bufferGradient"] = _arg1;

        }

        public function get bufferGradient():Array{

            return (this.decodeGradient(this._style["bufferGradient"]));

        }

        public function get buttonColor():Number{

            return (StyleSheetUtil.colorValue(this._style["buttonColor"]));

        }

        public function get buttonAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["buttonColor"]));

        }

        public function get buttonColorRGB():Array{

            return (StyleSheetUtil.rgbValue(this.buttonColor));

        }

        public function get buttonColorRGBA():Array{

            var _local1:Array = this.buttonColorRGB;

            _local1.push(this.buttonAlpha);

            return (_local1);

        }

        public function setButtonColor(_arg1:String):void{

            this._style["buttonColor"] = _arg1;

        }

        public function setButtonOverColor(_arg1:String):void{

            this._style["buttonOverColor"] = _arg1;

        }

        public function get buttonOverColor():Number{

            return (StyleSheetUtil.colorValue(this._style["buttonOverColor"]));

        }

        public function get buttonOverAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["buttonOverColor"]));

        }

        public function get buttonOverColorRGB():Array{

            return (StyleSheetUtil.rgbValue(this.buttonOverColor));

        }

        public function get buttonOverColorRGBA():Array{

            var _local1:Array = this.buttonOverColorRGB;

            _local1.push(this.buttonOverAlpha);

            return (_local1);

        }

        public function get sliderColor():Number{

            return (StyleSheetUtil.colorValue(this._style["sliderColor"]));

        }

        public function get sliderAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["sliderColor"]));

        }

        public function get sliderGradient():Array{

            return (this.decodeGradient(this._style["sliderGradient"]));

        }

        public function get volumeSliderColor():Number{

            return (StyleSheetUtil.colorValue(this._style["volumeSliderColor"]));

        }

        public function get volumeSliderAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["volumeSliderColor"]));

        }

        public function get volumeColor():Number{

            return (StyleSheetUtil.colorValue(this._style["volumeColor"], -2));

        }

        public function get volumeAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["volumeColor"], -2));

        }

        public function get volumeSliderGradient():Array{

            return (this.decodeGradient(this._style["volumeSliderGradient"]));

        }

        public function setSliderColor(_arg1:String):void{

            this._style["sliderColor"] = _arg1;

        }

        public function setSliderGradient(_arg1:Object):void{

            this._style["sliderGradient"] = _arg1;

        }

        public function setVolumeSliderColor(_arg1:String):void{

            this._style["volumeSliderColor"] = _arg1;

        }

        public function setVolumeColor(_arg1:String):void{

            this._style["volumeColor"] = _arg1;

        }

        public function setVolumeSliderGradient(_arg1:Object):void{

            this._style["volumeSliderGradient"] = _arg1;

        }

        public function set volumeBorder(_arg1:String):void{

            this._style["volumeBorder"] = _arg1;

        }

        public function get volumeBorderWidth():Number{

            return (StyleSheetUtil.borderWidth("volumeBorder", this._style, 0));

        }

        public function set volumeBorderWidth(_arg1:Number):void{

            this._style["volumeBorderWidth"] = _arg1;

        }

        public function get volumeBorderColor():Number{

            return (StyleSheetUtil.borderColor("volumeBorder", this._style));

        }

        public function get volumeBorderAlpha():Number{

            return (StyleSheetUtil.borderAlpha("volumeBorder", this._style));

        }

        public function setVolumeBorderColor(_arg1:String):void{

            this._style["volumeBorderColor"] = _arg1;

        }

        public function get progressColor():Number{

            return (StyleSheetUtil.colorValue(this._style["progressColor"]));

        }

        public function get progressAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["progressColor"]));

        }

        public function setProgressColor(_arg1:String):void{

            this._style["progressColor"] = _arg1;

        }

        public function get tooltipColor():Number{

            return (StyleSheetUtil.colorValue(this._style["tooltipColor"]));

        }

        public function get tooltipAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["tooltipColor"]));

        }

        public function setTooltipColor(_arg1:String):void{

            this._style["tooltipColor"] = _arg1;

        }

        public function get tooltipTextColor():Number{

            return (StyleSheetUtil.colorValue(this._style["tooltipTextColor"]));

        }

        public function get tooltipTextAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["tooltipTextColor"]));

        }

        public function setTooltipTextColor(_arg1:String):void{

            this._style["tooltipTextColor"] = _arg1;

        }

        public function setProgressGradient(_arg1:Object):void{

            this._style["progressGradient"] = _arg1;

        }

        public function get progressGradient():Array{

            return (this.decodeGradient(this._style["progressGradient"]));

        }

        public function set sliderBorder(_arg1:String):void{

            this._style["sliderBorder"] = _arg1;

        }

        public function get sliderBorderWidth():Number{

            return (StyleSheetUtil.borderWidth("sliderBorder", this._style, 0));

        }

        public function set sliderBorderWidth(_arg1:Number):void{

            this._style["sliderBorderWidth"] = _arg1;

        }

        public function get sliderBorderColor():Number{

            return (StyleSheetUtil.borderColor("sliderBorder", this._style));

        }

        public function get sliderBorderAlpha():Number{

            return (StyleSheetUtil.borderAlpha("sliderBorder", this._style));

        }

        public function setSliderBorderColor(_arg1:String):void{

            this._style["sliderBorderColor"] = _arg1;

        }

        public function get timeBorderRadius():Number{

            return (this._style["timeBorderRadius"]);

        }

        public function set timeBorderRadius(_arg1:Number):void{

            this._style["timeBorderRadius"] = _arg1;

        }

        public function set timeBorder(_arg1:String):void{

            this._style["timeBorder"] = _arg1;

        }

        public function get timeBorderWidth():Number{

            return (StyleSheetUtil.borderWidth("timeBorder", this._style, 0));

        }

        public function set timeBorderWidth(_arg1:Number):void{

            this._style["timeBorderWidth"] = _arg1;

        }

        public function get timeBorderColor():Number{

            return (StyleSheetUtil.borderColor("timeBorder", this._style));

        }

        public function get timeBorderAlpha():Number{

            return (StyleSheetUtil.borderAlpha("timeBorder", this._style));

        }

        public function setTimeBorderColor(_arg1:String):void{

            this._style["timeBorderColor"] = _arg1;

        }

        public function get scrubberBorderRadius():Number{

            return (this._style["scrubberBorderRadius"]);

        }

        public function set scrubberBorderRadius(_arg1:Number):void{

            this._style["scrubberBorderRadius"] = _arg1;

        }

        public function get volumeBorderRadius():Number{

            return (this._style["volumeBorderRadius"]);

        }

        public function set volumeBorderRadius(_arg1:Number):void{

            this._style["volumeBorderRadius"] = _arg1;

        }

        public function get timeBgColor():Number{

            return (StyleSheetUtil.colorValue(this._style["timeBgColor"]));

        }

        public function get timeBgAlpha():Number{

            return (StyleSheetUtil.colorAlpha(this._style["timeBgColor"]));

        }

        public function setTimeBgColor(_arg1:String):void{

            this._style["timeBgColor"] = _arg1;

        }

        public function get scrubberHeightRatio():Number{

            return (this._style["scrubberHeightRatio"]);

        }

        public function set scrubberHeightRatio(_arg1:Number):void{

            this._style["scrubberHeightRatio"] = _arg1;

        }

        public function get scrubberBarHeightRatio():Number{

            return (this._style["scrubberBarHeightRatio"]);

        }

        public function set scrubberBarHeightRatio(_arg1:Number):void{

            this._style["scrubberBarHeightRatio"] = _arg1;

        }

        public function get volumeSliderHeightRatio():Number{

            return (this._style["volumeSliderHeightRatio"]);

        }

        public function set volumeSliderHeightRatio(_arg1:Number):void{

            this._style["volumeSliderHeightRatio"] = _arg1;

        }

        public function get volumeBarHeightRatio():Number{

            return (this._style["volumeBarHeightRatio"]);

        }

        public function set volumeBarHeightRatio(_arg1:Number):void{

            this._style["volumeBarHeightRatio"] = _arg1;

        }

        public function get timeBgHeightRatio():Number{

            return (this._style["timeBgHeightRatio"]);

        }

        public function set timeBgHeightRatio(_arg1:Number):void{

            this._style["timeBgHeightRatio"] = _arg1;

        }

        public function get timeSeparator():String{

            return (this._style["timeSeparator"]);

        }

        public function set timeSeparator(_arg1:String):void{

            this._style["timeSeparator"] = _arg1;

        }

        public function get timeFontSize():Number{

            return (this._style["timeFontSize"]);

        }

        public function set timeFontSize(_arg1:Number):void{

            this._style["timeFontSize"] = _arg1;

        }

        private function decodeGradient(_arg1:Object, _arg2:String="medium"):Array{

            if (!_arg1){

                return (this.decodeGradient(_arg2));

            };

            if ((_arg1 is Array)){

                return ((_arg1 as Array));

            };

            if (_arg1 == "none"){

                return (null);

            };

            if (_arg1 == "high"){

                return ([0.1, 0.5, 0.1]);

            };

            if (_arg1 == "medium"){

                return ([0, 0.25, 0]);

            };

            return (this.decodeGradient(_arg2));

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls {

    import org.flowplayer.controls.config.*;

    import flash.display.*;



    public class NullToolTip implements ToolTip {



        public function redraw(_arg1:Config):void{

        }

        public function show(_arg1:DisplayObject, _arg2:String, _arg3:Boolean=false, _arg4:String=null):void{

        }

        public function hide():void{

        }

        public function set text(_arg1:String):void{

        }

        public function get visible():Boolean{

            return (true);

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls.config {

    import org.flowplayer.util.*;



    public class ToolTips {



        private var _buttons:Boolean = false;

        private var _scrubber:Boolean = true;

        private var _volume:Boolean = true;

        private var _marginBottom:Number = 5;

        private var _play:String = "Play";

        private var _pause:String = "Pause";

        private var _stop:String = "Stop";

        private var _mute:String = "Mute";

        private var _unmute:String = "Unmute";

        private var _next:String = "Next";

        private var _previous:String = "Previous";

        private var _slowMotionFwd:String = "Slow forward";

        private var _slowMotionBwd:String = "Slow backward";

        private var _slowMotionFFwd:String = "Fast forward";

        private var _slowMotionFBwd:String = "Fast backward";

        private var _fullscreen:String = "Fullscreen";

        private var _fullscreenExit:String = "Exit fullscreen";



        public function get props():Object{

            return (new ObjectConverter(this).convert());

        }

        public function get buttons():Boolean{

            return (this._buttons);

        }

        public function set buttons(_arg1:Boolean):void{

            this._buttons = _arg1;

        }

        public function get scrubber():Boolean{

            return (this._scrubber);

        }

        public function set scrubber(_arg1:Boolean):void{

            this._scrubber = _arg1;

        }

        public function get marginBottom():Number{

            return (this._marginBottom);

        }

        public function set marginBottom(_arg1:Number):void{

            this._marginBottom = _arg1;

        }

        public function get volume():Boolean{

            return (this._volume);

        }

        public function set volume(_arg1:Boolean):void{

            this._volume = _arg1;

        }

        public function get play():String{

            return (this.label(this._play));

        }

        private function label(_arg1:String):String{

            return ((this._buttons) ? _arg1 : null);

        }

        public function set play(_arg1:String):void{

            this._play = _arg1;

        }

        public function get stop():String{

            return (this.label(this._stop));

        }

        public function set stop(_arg1:String):void{

            this._stop = _arg1;

        }

        public function get mute():String{

            return (this.label(this._mute));

        }

        public function set mute(_arg1:String):void{

            this._mute = _arg1;

        }

        public function get unmute():String{

            return (this.label(this._unmute));

        }

        public function set unmute(_arg1:String):void{

            this._unmute = _arg1;

        }

        public function get next():String{

            return (this.label(this._next));

        }

        public function set next(_arg1:String):void{

            this._next = _arg1;

        }

        public function get previous():String{

            return (this.label(this._previous));

        }

        public function set previous(_arg1:String):void{

            this._previous = _arg1;

        }

        public function get slowMotionFwd():String{

            return (this.label(this._slowMotionFwd));

        }

        public function set slowMotionFwd(_arg1:String):void{

            this._slowMotionFwd = _arg1;

        }

        public function get slowMotionBwd():String{

            return (this.label(this._slowMotionBwd));

        }

        public function set slowMotionBwd(_arg1:String):void{

            this._slowMotionBwd = _arg1;

        }

        public function get slowMotionFFwd():String{

            return (this.label(this._slowMotionFFwd));

        }

        public function set slowMotionFFwd(_arg1:String):void{

            this._slowMotionFFwd = _arg1;

        }

        public function get slowMotionFBwd():String{

            return (this.label(this._slowMotionFBwd));

        }

        public function set slowMotionFBwd(_arg1:String):void{

            this._slowMotionFBwd = _arg1;

        }

        public function get fullscreen():String{

            return (this.label(this._fullscreen));

        }

        public function set fullscreen(_arg1:String):void{

            this._fullscreen = _arg1;

        }

        public function get fullscreenExit():String{

            return (this.label(this._fullscreenExit));

        }

        public function set fullscreenExit(_arg1:String):void{

            this._fullscreenExit = _arg1;

        }

        public function get pause():String{

            return (this.label(this._pause));

        }

        public function set pause(_arg1:String):void{

            this._pause = _arg1;

        }



    }

}//package org.flowplayer.controls.config 

﻿package org.flowplayer.controls.config {



    public class WidgetEnabledStates extends WidgetBooleanStates {



        override public function get stop():Boolean{

            return (value("stop", true));

        }

        override public function get playlist():Boolean{

            return (value("playlist", true));

        }



    }

}//package org.flowplayer.controls.config 

﻿package org.flowplayer.controls.config {

    import org.flowplayer.util.*;



    public class WidgetBooleanStates {



        protected var log:Log;

        private var _values:Object;

        private var _properties:Array;



        public function WidgetBooleanStates(){

            this.log = new Log(this);

            this._values = new Object();

            this._properties = ["play", "stop", "mute", "volume", "time", "scrubber", "playlist", "slowBackward", "fastBackward", "slowForward", "fastForward", "fullscreen"];

            super();

        }

        public function reset():void{

            this._values = new Object();

        }

        protected function value(_arg1:String, _arg2:Boolean=true):Boolean{

            if (this._values[_arg1] == undefined){

                return (_arg2);

            };

            return (this._values[_arg1]);

        }

        public function get play():Boolean{

            return (this.value("play"));

        }

        public function set play(_arg1:Boolean):void{

            this._values["play"] = _arg1;

        }

        public function get volume():Boolean{

            return (this.value("volume"));

        }

        public function set volume(_arg1:Boolean):void{

            this._values["volume"] = _arg1;

        }

        public function get mute():Boolean{

            return (this.value("mute"));

        }

        public function set mute(_arg1:Boolean):void{

            this._values["mute"] = _arg1;

        }

        public function get time():Boolean{

            return (this.value("time"));

        }

        public function set time(_arg1:Boolean):void{

            this._values["time"] = _arg1;

        }

        public function get scrubber():Boolean{

            return (this.value("scrubber"));

        }

        public function set scrubber(_arg1:Boolean):void{

            this._values["scrubber"] = _arg1;

        }

        public function get stop():Boolean{

            return (this.value("stop", false));

        }

        public function set stop(_arg1:Boolean):void{

            this._values["stop"] = _arg1;

        }

        public function get playlist():Boolean{

            return (this.value("playlist", false));

        }

        public function get next():Boolean{

            return (this.playlist);

        }

        public function get prev():Boolean{

            return (this.playlist);

        }

        public function set playlist(_arg1:Boolean):void{

            this._values["playlist"] = _arg1;

        }

        public function set slowForward(_arg1:Boolean):void{

            this._values["slowForward"] = _arg1;

        }

        public function get slowForward():Boolean{

            return (this.value("slowForward", true));

        }

        public function set slowBackward(_arg1:Boolean):void{

            this._values["slowBackward"] = _arg1;

        }

        public function get slowBackward():Boolean{

            return (this.value("slowBackward", false));

        }

        public function set fastForward(_arg1:Boolean):void{

            this._values["fastForward"] = _arg1;

        }

        public function get fastForward():Boolean{

            return (this.value("fastForward", true));

        }

        public function set fastBackward(_arg1:Boolean):void{

            this._values["fastBackward"] = _arg1;

        }

        public function get fastBackward():Boolean{

            return (this.value("fastBackward", false));

        }

        public function get fullscreen():Boolean{

            return (this.value("fullscreen"));

        }

        public function set fullscreen(_arg1:Boolean):void{

            this._values["fullscreen"] = _arg1;

        }

        public function set all(_arg1:Boolean):void{

            var _local2:Number = 0;

            while (_local2 < this._properties.length) {

                if (this._values[this._properties[_local2]] == undefined){

                    this._values[this._properties[_local2]] = _arg1;

                };

                _local2++;

            };

        }



    }

}//package org.flowplayer.controls.config 

﻿package org.flowplayer.controls.config {

    import org.flowplayer.ui.*;

    import org.flowplayer.view.*;

    import org.flowplayer.controls.*;

    import org.flowplayer.util.*;



    public class Config {



        private var log:Log;

        private var _player:Flowplayer;

        private var _skin:String;

        private var _style:Style;

        private var _autoHide:AutoHideConfig;

        private var _visible:WidgetBooleanStates;

        private var _enabled:WidgetBooleanStates;

        private var _tooltips:ToolTips;



        public function Config(){

            this.log = new Log(this);

            this._autoHide = new AutoHideConfig();

            this._visible = new WidgetBooleanStates();

            this._enabled = new WidgetEnabledStates();

            this._tooltips = new ToolTips();

            super();

        }

        public function get style():Style{

            return (((this._style) || (new Style())));

        }

        public function addStyleProps(_arg1:Object):void{

            this._style = (new PropertyBinder(this.style, "bgStyle").copyProperties(_arg1) as Style);

        }

        public function get visible():WidgetBooleanStates{

            return (this._visible);

        }

        public function set visible(_arg1:WidgetBooleanStates):void{

            this._visible = _arg1;

        }

        public function get enabled():WidgetBooleanStates{

            return (this._enabled);

        }

        public function set enabled(_arg1:WidgetBooleanStates):void{

            this._enabled = _arg1;

        }

        public function get skin():String{

            return (this._skin);

        }

        public function set skin(_arg1:String):void{

            this._skin = _arg1;

        }

        public function get tooltips():ToolTips{

            return (this._tooltips);

        }

        public function set tooltips(_arg1:ToolTips):void{

            this._tooltips = _arg1;

        }

        public function get player():Flowplayer{

            return (this._player);

        }

        public function set player(_arg1:Flowplayer):void{

            this._player = _arg1;

        }

        public function get autoHide():AutoHideConfig{

            return (this._autoHide);

        }

        public function setAutoHide(_arg1:Object):void{

            if ((_arg1 is String)){

                this._autoHide.state = (_arg1 as String);

            };

            if ((_arg1 is Boolean)){

                this._autoHide.enabled = (_arg1 as Boolean);

                this._autoHide.fullscreenOnly = !(_arg1);

            };

        }

        public function set hideDelay(_arg1:Number):void{

            this._autoHide.hideDelay = _arg1;

        }

        public function get hideDelay():Number{

            return (this._autoHide.hideDelay);

        }



    }

}//package org.flowplayer.controls.config 

﻿package org.flowplayer.controls {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.ui.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import org.flowplayer.model.*;

    import org.flowplayer.controls.button.*;

    import flash.display.*;

    import flash.system.*;

    import org.flowplayer.controls.slider.*;

    import flash.utils.*;

    import org.flowplayer.util.*;



    public class Controls extends StyleableSprite implements Plugin {



        private static const DEFAULT_HEIGHT:Number = 28;



        private var _playButton:AbstractToggleButton;

        private var _fullScreenButton:AbstractToggleButton;

        private var _muteVolumeButton:AbstractToggleButton;

        private var _volumeSlider:VolumeScrubber;

        private var _progressTracker:DisplayObject;

        private var _prevButton:DisplayObject;

        private var _nextButton:DisplayObject;

        private var _slowMotionFwdButton:DisplayObject;

        private var _slowMotionBwdButton:DisplayObject;

        private var _slowMotionFFwdButton:DisplayObject;

        private var _slowMotionFBwdButton:DisplayObject;

        private var _stopButton:DisplayObject;

        private var _scrubber:Scrubber;

        private var _timeView:TimeView;

        private var _widgetMaxHeight:Number = 0;

        private var _config:Config;

        private var _timeUpdateTimer:Timer;

        private var _floating:Boolean = false;

        private var _controlBarMover:AutoHide;

        private var _immediatePositioning:Boolean = true;

        private var _animationTimer:Timer;

        private var _player:Flowplayer;

        private var _pluginModel:PluginModel;

        private var _initialized:Boolean;

        private var _currentControlsConfig:Object;

        private var _originalConfig:Object;

        private var _durationReached:Boolean;

        private var _bgFill:Sprite;



        public function Controls(){

            log.debug("creating ControlBar");

            this.visible = false;

            this._bgFill = new Sprite();

            addChild(this._bgFill);

            height = DEFAULT_HEIGHT;

            addEventListener(Event.ADDED_TO_STAGE, this.onAddedToStage);

        }

        public function get config():Config{

            return (this._config);

        }

        public function setTooltips(_arg1:Object):void{

            this.initTooltipConfig(this._config, _arg1);

            this.redraw(_arg1);

        }

        public function getTooltips():ToolTips{

            return (this._config.tooltips);

        }

        public function setAutoHide(_arg1:Object=null):void{

            log.debug("autoHide()");

            if (_arg1){

                new PropertyBinder(this._config.autoHide).copyProperties(_arg1);

            };

            this._pluginModel.config.autoHide = this._config.autoHide.state;

            if (this._controlBarMover){

                this._controlBarMover.stop();

            };

            this.createControlBarMover();

            this._controlBarMover.start();

        }

        public function getAutoHide():AutoHideConfig{

            return (this._config.autoHide);

        }

        public function setWidgets(_arg1:Object=null):Object{

            log.debug("widgets()");

            if (!_arg1){

                return (this._config.visible);

            };

            if (((this._animationTimer) && (this._animationTimer.running))){

                return (this._config.visible);

            };

            this.setConfigBooleanStates("visible", _arg1);

            this.recreateWidgets();

            return (this._config.visible);

        }

        public function getWidgets():WidgetBooleanStates{

            return (this._config.visible);

        }

        public function enable(_arg1:Object):void{

            this.setEnabled(_arg1);

        }

        public function setEnabled(_arg1:Object):void{

            log.debug("enable()");

            this.setConfigBooleanStates("enabled", _arg1);

            this.enableWidgets();

            this.enableFullscreenButton(this._player.playlist.current);

        }

        public function getEnabled():WidgetBooleanStates{

            return (this._config.enabled);

        }

        private function recreateWidgets():void{

            this.immediatePositioning = false;

            this.createChildren();

            this.onResize();

            this.immediatePositioning = true;

        }

        private function enableWidgets():void{

            var _local2:DisplayObject;

            var _local1:int;

            while (_local1 < numChildren) {

                _local2 = getChildAt(_local1);

                log.debug((("enabledWidget " + _local2.name) + ":"));

                if (((_local2.hasOwnProperty("enabled")) && (this._config.enabled.hasOwnProperty(_local2.name)))){

                    log.debug(("enabled " + this._config.enabled[_local2.name]));

                    _local2["enabled"] = this._config.enabled[_local2.name];

                };

                _local1++;

            };

        }

        private function setConfigBooleanStates(_arg1:String, _arg2:Object):void{

            log.debug("setConfigBooleanStates");

            if (_arg2.hasOwnProperty("all")){

                this._config[_arg1].reset();

            };

            new PropertyBinder(this._config[_arg1]).copyProperties(_arg2);

        }

        private function set immediatePositioning(_arg1:Boolean):void{

            this._immediatePositioning = _arg1;

            if (!_arg1){

                return;

            };

            this._animationTimer = new Timer(500, 1);

            this._animationTimer.start();

        }

        override public function onBeforeCss(_arg1:Object=null):void{

            if (this._controlBarMover){

                this._controlBarMover.cancelAnimation();

            };

        }

        override public function css(_arg1:Object=null):Object{

            var _local2:Object = super.css(_arg1);

            if (this._controlBarMover){

                this._controlBarMover.showAndUpdate();

            };

            var _local3:Object = this._config.style.addStyleProps(_local2);

            if (!_arg1){

                return (_local3);

            };

            this.redraw(_arg1);

            return (_local3);

        }

        private function setAutoHideFullscreenOnly(_arg1:Config, _arg2:Object):void{

            if (_arg2.hasOwnProperty("fullscreenOnly")){

                this._config.autoHide.fullscreenOnly = _arg2.fullscreenOnly;

            } else {

                if (_arg1.autoHide.state == "never"){

                    this._config.autoHide.state = "fullscreen";

                };

            };

        }

        override public function animate(_arg1:Object):Object{

            var _local2:Object = super.animate(_arg1);

            return (this._config.style.addStyleProps(_local2));

        }

        override protected function onResize():void{

            if (!this._initialized){

                return;

            };

            log.debug(("arranging, width is " + width));

            this._bgFill.graphics.clear();

            this._bgFill.graphics.beginFill(0, 0);

            this._bgFill.graphics.drawRect(0, 0, width, height);

            this._bgFill.graphics.endFill();

            var _local1:Number = this.arrangeLeftEdgeControls();

            this.arrangeRightEdgeControls(_local1);

            this.initializeVolume();

            log.debug(((("arranged to x " + this.x) + ", y ") + this.y));

        }

        override protected function onRedraw():void{

            log.debug("onRedraw, making controls visible");

            this.visible = true;

        }

        public function getDefaultConfig():Object{

            if (!SkinClasses.defaults){

                return (null);

            };

            return (SkinClasses.defaults);

        }

        private function initTooltipConfig(_arg1:Config, _arg2:Object):void{

            new PropertyBinder(_arg1.tooltips).copyProperties(_arg2);

        }

        private function redraw(_arg1:Object=null):void{

            var _local3:DisplayObject;

            if (_arg1){

                this._config.addStyleProps(_arg1);

            };

            if (this._scrubber){

                this._scrubber.redraw(this._config);

            };

            if (this._volumeSlider){

                this._volumeSlider.redraw(this._config);

            };

            if (this._timeView){

                this._timeView.redraw(this._config);

            };

            var _local2:int;

            while (_local2 < numChildren) {

                _local3 = getChildAt(_local2);

                if ((_local3 is AbstractButton)){

                    AbstractButton(_local3).redraw(this._config);

                };

                _local2++;

            };

        }

        private function onAddedToStage(_arg1:Event):void{

            log.debug(("addedToStage, config is " + this._config));

            this.createControlBarMover();

            this.enableWidgets();

        }

        private function createControlBarMover():void{

            if (((!((this._config.autoHide.state == "never"))) && (!(this._controlBarMover)))){

                this._controlBarMover = new AutoHide(DisplayPluginModel(this._pluginModel), this._config.autoHide, this._player, stage, this);

            };

        }

        public function onLoad(_arg1:Flowplayer):void{

            log.info(("received player API! autohide == " + this._config.autoHide.state));

            this._player = _arg1;

            if (this._config.skin){

                this.initSkin();

            };

            this._config.player = _arg1;

            this.createChildren();

            loader = _arg1.createLoader();

            this.createTimeView();

            this.addListeners(_arg1.playlist);

            if (this._playButton){

                this._playButton.down = _arg1.isPlaying();

            };

            log.debug(("setting root style to " + this._config.style.bgStyle));

            rootStyle = this._config.style.bgStyle;

            if (this._muteVolumeButton){

                this._muteVolumeButton.down = _arg1.muted;

            };

            this._pluginModel.dispatchOnLoad();

        }

        private function initSkin():void{

            Security.allowDomain("*");

            var _local1:PluginModel = (this._player.pluginRegistry.getPlugin(this._config.skin) as PluginModel);

            log.debug(("using skin " + _local1));

            SkinClasses.skinClasses = (_local1.pluginObject as ApplicationDomain);

            log.debug("skin has defaults", SkinClasses.defaults);

            Arrange.fixPositionSettings((this._pluginModel as DisplayPluginModel), SkinClasses.defaults);

            new PropertyBinder(this._pluginModel, "config").copyProperties(SkinClasses.defaults, false);

            this._config = this.createConfig(this._pluginModel.config);

        }

        public function onConfig(_arg1:PluginModel):void{

            log.info("received my plugin config ", _arg1.config);

            this._pluginModel = _arg1;

            this.storeOriginalConfig(_arg1);

            log.debug("-");

            this._config = this.createConfig(_arg1.config);

            log.debug("config created");

        }

        private function storeOriginalConfig(_arg1:PluginModel):void{

            var _local2:String;

            this._originalConfig = new Object();

            for (_local2 in _arg1.config) {

                this._originalConfig[_local2] = _arg1.config[_local2];

            };

        }

        private function createConfig(_arg1:Object):Config{

            var _local2:Config = (new PropertyBinder(new Config()).copyProperties(_arg1) as Config);

            new PropertyBinder(_local2.autoHide).copyProperties(_arg1.autoHide);

            new PropertyBinder(_local2.visible).copyProperties(_arg1);

            new PropertyBinder(_local2.enabled).copyProperties(_arg1.enabled);

            _local2.addStyleProps(_arg1);

            this.initTooltipConfig(_local2, _arg1["tooltips"]);

            return (_local2);

        }

        public function set floating(_arg1:Boolean):void{

            this._floating = _arg1;

        }

        private function hasSlowMotion():Boolean{

            return (!((this._player.pluginRegistry.getPlugin("slowmotion") == null)));

        }

        private function createSlowmotionButtons(_arg1:AnimationEngine):void{

            var animationEngine:* = _arg1;

            var slomo:* = ((this.hasSlowMotion()) && (!((SkinClasses.getSlowMotionBwdButton() == null))));

            log.debug(("createSlowmotionButtons(), hasSlowMotion? " + slomo));

            if (slomo){

                this._slowMotionFwdButton = this.addChildWidget(this.createWidget(this._slowMotionFwdButton, "slowForward", SlowMotionFwdButton, this._config, animationEngine), ButtonEvent.CLICK, function (_arg1:ButtonEvent):void{

                    onSlowMotionClicked(false, true);

                });

                this._slowMotionBwdButton = this.addChildWidget(this.createWidget(this._slowMotionBwdButton, "slowBackward", SlowMotionBwdButton, this._config, animationEngine), ButtonEvent.CLICK, function (_arg1:ButtonEvent):void{

                    onSlowMotionClicked(false, false);

                });

                this._slowMotionFFwdButton = this.addChildWidget(this.createWidget(this._slowMotionFFwdButton, "fastForward", SlowMotionFFwdButton, this._config, animationEngine), ButtonEvent.CLICK, function (_arg1:ButtonEvent):void{

                    onSlowMotionClicked(true, true);

                });

                this._slowMotionFBwdButton = this.addChildWidget(this.createWidget(this._slowMotionFBwdButton, "fastBackward", SlowMotionFBwdButton, this._config, animationEngine), ButtonEvent.CLICK, function (_arg1:ButtonEvent):void{

                    onSlowMotionClicked(true, false);

                });

            };

        }

        private function createChildren():void{

            log.debug("creating fullscren ", this._config);

            var _local1:AnimationEngine = this._player.animationEngine;

            this._fullScreenButton = (this.addChildWidget(this.createWidget(this._fullScreenButton, "fullscreen", ToggleFullScreenButton, this._config, _local1)) as AbstractToggleButton);

            log.debug("creating play");

            this._playButton = (this.addChildWidget(this.createWidget(this._playButton, "play", TogglePlayButton, this._config, _local1), ButtonEvent.CLICK, this.onPlayClicked) as AbstractToggleButton);

            log.debug("creating stop");

            this._stopButton = this.addChildWidget(this.createWidget(this._stopButton, "stop", StopButton, this._config, _local1), ButtonEvent.CLICK, this.onStopClicked);

            this._nextButton = this.addChildWidget(this.createWidget(this._nextButton, "playlist", NextButton, this._config, _local1), ButtonEvent.CLICK, "next");

            this._prevButton = this.addChildWidget(this.createWidget(this._prevButton, "playlist", PrevButton, this._config, _local1), ButtonEvent.CLICK, "previous");

            this.createSlowmotionButtons(_local1);

            this._muteVolumeButton = (this.addChildWidget(this.createWidget(this._muteVolumeButton, "mute", ToggleVolumeMuteButton, this._config, _local1), ButtonEvent.CLICK, this.onMuteVolumeClicked) as AbstractToggleButton);

            this._volumeSlider = (this.addChildWidget(this.createWidget(this._volumeSlider, "volume", VolumeScrubber, this._config, _local1, this), VolumeSlider.DRAG_EVENT, this.onVolumeSlider) as VolumeScrubber);

            this._scrubber = (this.addChildWidget(this.createWidget(this._scrubber, "scrubber", Scrubber, this._config, _local1, this), Scrubber.DRAG_EVENT, this.onScrubbed) as Scrubber);

            this.createTimeView();

            this.createScrubberUpdateTimer();

            this._initialized = true;

        }

        private function createTimeView():void{

            if (!this._player){

                return;

            };

            if (this._config.visible.time){

                if (this._timeView){

                    return;

                };

                this._timeView = (this.addChildWidget(new TimeView(this._config, this._player), TimeView.EVENT_REARRANGE, this.onTimeViewRearranged) as TimeView);

                this._timeView.visible = false;

            } else {

                if (this._timeView){

                    this.removeChildAnimate(this._timeView);

                    this._timeView = null;

                };

            };

        }

        private function onTimeViewRearranged(_arg1:Event):void{

            this.onResize();

        }

        private function createWidget(_arg1:DisplayObject, _arg2:String, _arg3:Class, _arg4:Object, _arg5:Object=null, _arg6:Object=null):DisplayObject{

            var _local8:DisplayObject;

            var _local7:Boolean = this._config.visible[_arg2];

            if (!_local7){

                log.debug(("not showing widget " + _arg3));

                if (_arg1){

                    this.removeChildAnimate(_arg1);

                };

                return (null);

            };

            if (_arg1){

                return (_arg1);

            };

            log.debug(("creating " + _arg3));

            if (_arg6){

                _local8 = new _arg3(_arg4, _arg5, _arg6);

            } else {

                if (_arg5){

                    _local8 = new _arg3(_arg4, _arg5);

                } else {

                    _local8 = (_arg4) ? new _arg3(_arg4) : new (_arg3);

                };

            };

            this._widgetMaxHeight = Math.max(this._widgetMaxHeight, _local8.height);

            _local8.visible = false;

            _local8.name = _arg2;

            return (_local8);

        }

        private function removeChildAnimate(_arg1:DisplayObject):DisplayObject{

            var child:* = _arg1;

            if (((!(this._player)) || (this._immediatePositioning))){

                removeChild(child);

                return (child);

            };

            this._player.animationEngine.fadeOut(child, 1000, function ():void{

                removeChild(child);

            });

            return (child);

        }

        private function addChildWidget(_arg1:DisplayObject, _arg2:String=null, _arg3:Object=null):DisplayObject{

            var widget:* = _arg1;

            var eventType = _arg2;

            var listener = _arg3;

            if (!widget){

                return (null);

            };

            addChild((widget as DisplayObject));

            if (eventType){

                widget.addEventListener(eventType, ((listener is Function)) ? (listener as Function) : function ():void{

    var _local1 = _player;

    _local1[listener]();

});

            };

            log.debug(("added control bar child widget  " + widget));

            return (widget);

        }

        private function createScrubberUpdateTimer():void{

            this._timeUpdateTimer = new Timer(100);

            this._timeUpdateTimer.addEventListener(TimerEvent.TIMER, this.onTimeUpdate);

            this._timeUpdateTimer.start();

        }

        private function initializeVolume():void{

            if (!this._volumeSlider){

                return;

            };

            var _local1:Number = this._player.volume;

            log.info(("initializing volume to " + _local1));

            this._volumeSlider.value = _local1;

        }

        private function onTimeUpdate(_arg1:TimerEvent):void{

            var duration:* = NaN;

            var event:* = _arg1;

            if (!((this._scrubber) || (this._timeView))){

                return;

            };

            if (!this._player){

                return;

            };

            var status:* = this.getPlayerStatus();

            if (!status){

                return;

            };

            duration = (status.clip) ? status.clip.duration : 0;

            if (this._scrubber){

                if (duration > 0){

                    this._scrubber.value = ((status.time / duration) * 100);

                    this._scrubber.setBufferRange((status.bufferStart / duration), (status.bufferEnd / duration));

                    this._scrubber.allowRandomSeek = status.allowRandomSeek;

                } else {

                    this._scrubber.value = 0;

                    this._scrubber.setBufferRange(0, 0);

                    this._scrubber.allowRandomSeek = false;

                };

                if (status.clip){

                    this._scrubber.tooltipTextFunc = function (_arg1:Number):String{

                        if (duration == 0){

                            return (null);

                        };

                        if (_arg1 < 0){

                            _arg1 = 0;

                        };

                        if (_arg1 > 100){

                            _arg1 = 100;

                        };

                        return (TimeUtil.formatSeconds(((_arg1 / 100) * duration)));

                    };

                };

            };

            if (this._timeView){

                this._timeView.duration = (((status.clip.live) && ((duration == 0)))) ? -1 : duration;

                this._timeView.time = (this._durationReached) ? duration : status.time;

            };

        }

        private function getPlayerStatus():Status{

            try {

                return (this._player.status);

            } catch(e:Error) {

                log.error(("error querying player status, will stop query timer, error message: " + e.message));

                _timeUpdateTimer.stop();

                throw (e);

            };

            return (null);

        }

        private function addListeners(_arg1:Playlist):void{

            _arg1.onConnect(this.onPlayStarted);

            _arg1.onBeforeBegin(this.onPlayStarted);

            _arg1.onBegin(this.onPlayBegin);

            _arg1.onMetaData(this.onPlayStarted);

            _arg1.onStart(this.onPlayStarted);

            _arg1.onPause(this.onPlayPaused);

            _arg1.onResume(this.onPlayResumed);

            _arg1.onStop(this.onPlayStopped);

            _arg1.onBufferStop(this.onPlayStopped);

            _arg1.onFinish(this.onPlayStopped);

            _arg1.onBeforeFinish(this.durationReached);

            this._player.onFullscreen(this.onPlayerFullscreenEvent);

            this._player.onFullscreenExit(this.onPlayerFullscreenEvent);

            this._player.onMute(this.onPlayerMuteEvent);

            this._player.onUnmute(this.onPlayerMuteEvent);

            this._player.onVolume(this.onPlayerVolumeEvent);

        }

        private function durationReached(_arg1:ClipEvent):void{

            this._durationReached = true;

        }

        private function onPlayerVolumeEvent(_arg1:PlayerEvent):void{

            if (!this._volumeSlider){

                return;

            };

            this._volumeSlider.value = (_arg1.info as Number);

        }

        private function onPlayerMuteEvent(_arg1:PlayerEvent):void{

            log.info(("onPlayerMuteEvent, _muteButton " + this._muteVolumeButton));

            if (!this._muteVolumeButton){

                return;

            };

            this._muteVolumeButton.down = (_arg1.eventType == PlayerEventType.MUTE);

        }

        private function onPlayBegin(_arg1:ClipEvent):void{

            log.debug(("onPlayBegin(): received " + _arg1));

            this._durationReached = false;

            var _local2:Clip = (_arg1.target as Clip);

            this.handleClipConfig(_local2);

        }

        private function handleClipConfig(_arg1:Clip):void{

            var _local2:Object = _arg1.getCustomProperty("controls");

            if (_local2){

                if (_local2 == this._currentControlsConfig){

                    return;

                };

                log.debug("onPlayBegin(): clip has controls configuration, reconfiguring");

                this.reconfigure(_local2);

            } else {

                if (this._currentControlsConfig){

                    log.debug("onPlayBegin(): reverting to original configuration");

                    this._config = this.createConfig(this._originalConfig);

                    this._config.player = this._player;

                    rootStyle = this._config.style.bgStyle;

                    this.recreateWidgets();

                    this.enableWidgets();

                    this.redraw();

                };

            };

        }

        private function reconfigure(_arg1:Object):void{

            this._currentControlsConfig = _arg1;

            this.setWidgets(_arg1);

            if (_arg1.hasOwnProperty("tooltips")){

                this.initTooltipConfig(this._config, _arg1["tooltips"]);

            };

            this.css(_arg1);

            if (_arg1.hasOwnProperty("enabled")){

                this.setEnabled(_arg1["enabled"]);

            };

        }

        private function onPlayStarted(_arg1:ClipEvent):void{

            log.debug(("received " + _arg1));

            if (this._playButton){

                this._playButton.down = ((!(_arg1.isDefaultPrevented())) && (this._player.isPlaying()));

            };

            this._durationReached = false;

            this.enableFullscreenButton((_arg1.target as Clip));

        }

        private function enableFullscreenButton(_arg1:Clip):void{

            if (!this._fullScreenButton){

                return;

            };

            var _local2:Boolean = ((((_arg1) && ((((_arg1.originalWidth > 0)) || (!(_arg1.accelerated)))))) && (this._config.enabled.fullscreen));

            this._fullScreenButton.enabled = _local2;

            if (_local2){

                this._fullScreenButton.addEventListener(ButtonEvent.CLICK, this.toggleFullscreen);

            } else {

                this._fullScreenButton.removeEventListener(ButtonEvent.CLICK, this.toggleFullscreen);

            };

        }

        private function enableScrubber(_arg1:Boolean):void{

            if (!this._scrubber){

                return;

            };

            this._scrubber.enabled = _arg1;

            if (_arg1){

                this._scrubber.addEventListener(Scrubber.DRAG_EVENT, this.onScrubbed);

            } else {

                this._scrubber.removeEventListener(Scrubber.DRAG_EVENT, this.onScrubbed);

            };

        }

        private function toggleFullscreen(_arg1:ButtonEvent):void{

            this._player.toggleFullscreen();

        }

        private function onPlayPaused(_arg1:ClipEvent):void{

            log.info(("received " + _arg1));

            if (!this._playButton){

                return;

            };

            this._playButton.down = false;

            var _local2:Clip = (_arg1.target as Clip);

            log.info(("clip.seekableOnBegin: " + _local2.seekableOnBegin));

            if ((((this._player.status.time == 0)) && (!(_local2.seekableOnBegin)))){

                this.enableScrubber(false);

            };

        }

        private function onPlayStopped(_arg1:ClipEvent):void{

            log.debug(("received " + _arg1));

            var _local2:Clip = (_arg1.target as Clip);

            if (_local2.isMidroll){

                this.handleClipConfig(_local2.parent);

            };

            if (!this._playButton){

                return;

            };

            log.debug("setting playButton to up state");

            this._playButton.down = false;

        }

        private function onPlayResumed(_arg1:ClipEvent):void{

            this._durationReached = false;

            log.info(("received onResume, time " + this._player.status.time));

            if (!this._playButton){

                return;

            };

            this._playButton.down = true;

            if (this._player.status.time < 0.5){

                this.enableScrubber(true);

            };

        }

        private function onPlayerFullscreenEvent(_arg1:PlayerEvent):void{

            log.debug("onPlayerFullscreenEvent");

            if (!this._fullScreenButton){

                return;

            };

            this._fullScreenButton.down = (_arg1.eventType == PlayerEventType.FULLSCREEN);

        }

        private function onPlayClicked(_arg1:ButtonEvent):void{

            this._player.toggle();

        }

        private function onStopClicked(_arg1:ButtonEvent):void{

            this._player.stop();

        }

        private function onMuteVolumeClicked(_arg1:ButtonEvent):void{

            this._player.muted = !(this._player.muted);

        }

        private function onSlowMotionClicked(_arg1:Boolean, _arg2:Boolean):void{

            if (!this.hasSlowMotion()){

                return;

            };

            var _local3:* = this._player.pluginRegistry.getPlugin("slowmotion").pluginObject;

            var _local4:Number = _local3.getNextSpeed(_arg1, _arg2);

            if (_local4 == 0){

                _local3.normal();

            } else {

                if (_arg2){

                    _local3.forward(_local4);

                } else {

                    _local3.backward(_local4);

                };

            };

        }

        private function onVolumeSlider(_arg1:Event):void{

            log.debug(("volume slider changed to pos " + VolumeSlider(_arg1.target).value));

            this._player.volume = VolumeSlider(_arg1.target).value;

        }

        private function onScrubbed(_arg1:Event):void{

            this._player.seekRelative(ScrubberSlider(_arg1.target).value);

        }

        private function arrangeLeftEdgeControls():Number{

            var _local1:Number = this.getSpaceBeforeFirstWidget();

            var _local2:Array = [this._stopButton];

            if (((this.hasSlowMotion()) && (this._slowMotionFBwdButton))){

                _local2.push(this._slowMotionFBwdButton);

            };

            if (((this.hasSlowMotion()) && (this._slowMotionBwdButton))){

                _local2.push(this._slowMotionBwdButton);

            };

            _local2.push(this._playButton);

            if (((this.hasSlowMotion()) && (this._slowMotionFwdButton))){

                _local2.push(this._slowMotionFwdButton);

            };

            if (((this.hasSlowMotion()) && (this._slowMotionFFwdButton))){

                _local2.push(this._slowMotionFFwdButton);

            };

            _local2.push(this._prevButton);

            _local2.push(this._nextButton);

            _local1 = this.arrangeControls(_local1, _local2, this.arrangeToLeftEdge);

            return (_local1);

        }

        private function arrangeRightEdgeControls(_arg1:Number):void{

            var _local3:Array;

            var _local2:Number = (this._config.visible.scrubber) ? (width - this.margins[1]) : _arg1;

            if (this._volumeSlider){

                this._volumeSlider.width = this.getVolumeSliderWidth();

            };

            if (this._config.visible.scrubber){

                _local3 = [this._fullScreenButton, this._volumeSlider, this._muteVolumeButton, this._timeView];

                _local2 = this.arrangeControls(_local2, _local3, this.arrangeToRightEdge);

                _local2 = this.arrangeScrubber(_arg1, _local2, this.firstNonNull(_local3.reverse(), 0));

            } else {

                _local3 = [this._timeView, this._muteVolumeButton, this._volumeSlider, this._fullScreenButton];

                _local2 = this.arrangeControls(_local2, _local3, this.arrangeToLeftEdge);

            };

            this.arrangeVolumeControl();

        }

        private function firstNonNull(_arg1:Array, _arg2:int):DisplayObject{

            var _local3:Number = _arg2;

            while (_local3 < _arg1.length) {

                if (_arg1[_local3]){

                    return ((_arg1[_local3] as DisplayObject));

                };

                _local3++;

            };

            return (null);

        }

        private function arrangeControls(_arg1:Number, _arg2:Array, _arg3:Function):Number{

            var _local5:DisplayObject;

            var _local4:Number = 0;

            while (_local4 < _arg2.length) {

                if (_arg2[_local4]){

                    _local5 = (_arg2[_local4] as DisplayObject);

                    this.arrangeYCentered(_local5);

                    _arg1 = (_arg3(_arg1, this.getSpaceAfterWidget(_local5), _local5) as Number);

                };

                _local4++;

            };

            return (_arg1);

        }

        private function get margins():Array{

            return (SkinClasses.margins);

        }

        private function arrangeVolumeControl():void{

            if (!this._config.visible.volume){

                return;

            };

            this._volumeSlider.height = ((height - this.margins[0]) - this.margins[2]);

            this._volumeSlider.y = this.margins[0];

        }

        private function arrangeScrubber(_arg1:Number, _arg2:Number, _arg3:DisplayObject):Number{

            if (!this._config.visible.scrubber){

                return (_arg2);

            };

            this._scrubber.setRightEdgeWidth(this.getScrubberRightEdgeWidth(_arg3));

            this.arrangeX(this._scrubber, _arg1);

            var _local4:Number = ((_arg2 - _arg1) - (2 * this.getSpaceAfterWidget(this._scrubber)));

            if (((!(this._player)) || (this._immediatePositioning))){

                this._scrubber.width = _local4;

            } else {

                this._player.animationEngine.animateProperty(this._scrubber, "width", _local4);

            };

            this._scrubber.height = ((height - this.margins[0]) - this.margins[2]);

            this._scrubber.y = ((_height - this.margins[2]) - this._scrubber.height);

            return (((_arg2 - this.getSpaceAfterWidget(this._scrubber)) - _local4));

        }

        private function arrangeToRightEdge(_arg1:Number, _arg2:Number, _arg3:DisplayObject):Number{

            if (!_arg3){

                return (_arg1);

            };

            _arg1 = ((_arg1 - _arg3.width) - _arg2);

            this.arrangeX(_arg3, _arg1);

            return (_arg1);

        }

        private function arrangeX(_arg1:DisplayObject, _arg2:Number):void{

            _arg1.visible = true;

            if (((!(this._player)) || (this._immediatePositioning))){

                _arg1.x = _arg2;

                return;

            };

            if (_arg1.x == 0){

                _arg1.x = _arg2;

                this.fadeIn(_arg1);

            };

            this._player.animationEngine.animateProperty(_arg1, "x", _arg2);

        }

        private function fadeIn(_arg1:DisplayObject):void{

            var _local2:Number = _arg1.alpha;

            _arg1.alpha = 0;

            this._player.animationEngine.animateProperty(_arg1, "alpha", _local2);

        }

        private function arrangeToLeftEdge(_arg1:Number, _arg2:Number, _arg3:DisplayObject):int{

            if (!_arg3){

                return (_arg1);

            };

            this.arrangeX(_arg3, _arg1);

            return (((_arg1 + _arg3.width) + _arg2));

        }

        private function arrangeYCentered(_arg1:DisplayObject):void{

            _arg1.y = this.margins[0];

            _arg1.height = ((height - this.margins[0]) - this.margins[2]);

            _arg1.scaleX = _arg1.scaleY;

            Arrange.center(_arg1, 0, height);

        }

        private function getSpaceBeforeFirstWidget():int{

            return (SkinClasses.getSpaceBeforeFirstWidget());

        }

        private function getSpaceAfterWidget(_arg1:DisplayObject):int{

            return (SkinClasses.getSpaceAfterWidget(_arg1, (_arg1 == this.lastOnRight)));

        }

        private function getScrubberRightEdgeWidth(_arg1:DisplayObject):int{

            return (SkinClasses.getScrubberRightEdgeWidth(_arg1));

        }

        private function getVolumeSliderWidth():int{

            return (SkinClasses.getVolumeSliderWidth());

        }

        private function get lastOnRight():DisplayObject{

            if (this._fullScreenButton){

                return (this._fullScreenButton);

            };

            if (this._volumeSlider){

                return (this._volumeSlider);

            };

            if (this._muteVolumeButton){

                return (this._muteVolumeButton);

            };

            if (this._timeView){

                return (this._timeView);

            };

            return (null);

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls {



    class TimeUtil {



        public static function formatSeconds(_arg1:Number):String{

            if (isNaN(_arg1)){

                return ("00:00");

            };

            var _local2 = "";

            var _local3:Number = Math.floor((_arg1 / 60));

            var _local4:int = (int(_arg1) % 60);

            _local2 = two(_local4);

            var _local5:Number = Math.floor((_local3 / 60));

            _local3 = (_local3 % 60);

            _local2 = ((two(_local3) + ":") + _local2);

            if (_local5 == 0){

                return (_local2);

            };

            var _local6:Number = Math.floor((_local5 / 60));

            _local5 = (_local5 % 60);

            _local2 = ((two(_local5) + ":") + _local2);

            if (_local6 == 0){

                return (_local2);

            };

            _local2 = ((_local6 + ":") + _local2);

            return (_local2);

        }

        private static function two(_arg1:Number):String{

            return ((((_arg1)>9) ? "" : "0" + _arg1));

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import flash.display.*;

    import flash.text.*;

    import flash.geom.*;

    import flash.utils.*;

    import org.flowplayer.util.*;

    import flash.filters.*;



    public class DefaultToolTip extends Sprite implements ToolTip {



        private var _stage:Stage;

        private var _parentObject:DisplayObject;

        private var _tf:TextField;

        private var _titleFormat:TextFormat;

        private var _contentFormat:TextFormat;

        private var _defaultWidth:Number = 60;

        private var _buffer:Number = 1;

        private var _align:String = "center";

        private var _cornerRadius:Number = 4;

        private var _autoSize:Boolean = true;

        private var _hookEnabled:Boolean = true;

        private var _delay:Number = 0;

        private var _hookSize:Number = 5;

        private var _offSet:Number;

        private var _hookOffSet:Number;

        private var _timer:Timer;

        private var _animationEngine:AnimationEngine;

        private var _tween:Animation;

        private var _config:Config;

        private var log:Log;



        public function DefaultToolTip(_arg1:Config, _arg2:AnimationEngine):void{

            this.log = new Log(this);

            super();

            this._config = _arg1;

            this._animationEngine = _arg2;

            this.mouseEnabled = false;

            this.buttonMode = false;

            this.mouseChildren = false;

            this._timer = new Timer(this._delay, 1);

            this._timer.addEventListener("timer", this.timerHandler);

            this.initTitleFormat();

            this.initContentFormat();

        }

        public function set text(_arg1:String):void{

            if (!this._tf){

                return;

            };

            this._tf.htmlText = _arg1;

            this.setDefaultWidth();

            this.drawBG();

        }

        public function redraw(_arg1:Config):void{

            this._config = _arg1;

            this.drawBG();

        }

        public function show(_arg1:DisplayObject, _arg2:String, _arg3:Boolean=false, _arg4:String=null):void{

            if (this._tween){

                this._tween.cancel();

                this.alpha = this._config.style.tooltipAlpha;

            };

            if (this.parent == _arg1.stage){

                if (((((this._tf) && (!((this._tf.htmlText == ""))))) && (!((this._tf.htmlText == _arg2))))){

                    this.cleanUp();

                } else {

                    return;

                };

            };

            this._stage = _arg1.stage;

            this._parentObject = _arg1;

            this.addCopy(_arg2, _arg4);

            this.setOffset();

            this.drawBG();

            this.bgGlow();

            var _local5:Point = new Point(this._parentObject.x, this._parentObject.y);

            var _local6:Point = _arg1.localToGlobal(_local5);

            this.x = (_local6.x + this._offSet);

            this.y = ((_local6.y - this.height) - 5);

            this.alpha = 0;

            this._stage.addChild(this);

            if (_arg3){

                this.follow(true);

            } else {

                this.position();

            };

            this._timer.start();

        }

        public function hide():void{

            if (!this.parent){

                return;

            };

            if (this._tween){

                this._tween.cancel();

                this.alpha = this._config.style.tooltipAlpha;

            };

            this.animate(false);

        }

        private function timerHandler(_arg1:TimerEvent):void{

            this.animate(true);

        }

        private function follow(_arg1:Boolean):void{

            if (_arg1){

                addEventListener(Event.ENTER_FRAME, this.eof);

            } else {

                removeEventListener(Event.ENTER_FRAME, this.eof);

            };

        }

        private function eof(_arg1:Event):void{

            this.position(true);

        }

        private function position(_arg1:Boolean=false):void{

            var _local2:Number = 1;

            var _local3:Point = (_arg1) ? this.parentMousePos() : new Point((this._parentObject.width / 2), 0);

            var _local4:Point = this._parentObject.localToGlobal(_local3);

            var _local5:Number = (_local4.x + this._offSet);

            var _local6:Number = ((_local4.y - this.height) - this._config.tooltips.marginBottom);

            var _local7:Number = (this._defaultWidth + _local5);

            if (_local7 > stage.stageWidth){

                _local5 = (stage.stageWidth - this._defaultWidth);

            } else {

                if (_local5 < 0){

                    _local5 = 0;

                };

            };

            if (_local6 < 0){

                _local6 = 0;

            };

            this.x = (this.x + ((_local5 - this.x) / _local2));

            this.y = (this.y + ((_local6 - this.y) / _local2));

        }

        private function parentMousePos():Point{

            var _local1:Number = this._parentObject.mouseX;

            if (_local1 < 0){

                return (new Point(0, 0));

            };

            if (_local1 > this._parentObject.width){

                return (new Point(this._parentObject.width, 0));

            };

            return (new Point(_local1, 0));

        }

        private function addCopy(_arg1:String, _arg2:String):void{

            if (this._tf){

                removeChild(this._tf);

            };

            var _local3:Boolean = this.isDeviceFont(this._titleFormat);

            this._tf = this.createField(_local3);

            this._tf.defaultTextFormat = this._titleFormat;

            this._tf.htmlText = _arg1;

            this._tf.alpha = this._config.style.tooltipTextAlpha;

            if (this._autoSize){

                this.setDefaultWidth();

                if (((this._parentObject.x + (this._parentObject.width / 2)) + (this._defaultWidth / 2)) > this._parentObject.stage.stageWidth){

                    this._align = "left";

                } else {

                    if (((this._parentObject.x + (this._parentObject.width / 2)) - (this._defaultWidth / 2)) < 0){

                        this._align = "right";

                    } else {

                        this._align = "center";

                    };

                };

            } else {

                this._tf.width = (this._defaultWidth - (this._buffer * 2));

            };

            this._tf.x = (this._tf.y = this._buffer);

            this.textGlow(this._tf);

            addChild(this._tf);

        }

        private function setDefaultWidth():void{

            this._defaultWidth = ((this._tf.textWidth + 4) + (this._buffer * 2));

        }

        private function createField(_arg1:Boolean):TextField{

            var _local2:TextField = new TextField();

            _local2.embedFonts = !(_arg1);

            _local2.gridFitType = "pixel";

            _local2.autoSize = TextFieldAutoSize.LEFT;

            _local2.blendMode = BlendMode.LAYER;

            _local2.selectable = false;

            if (!this._autoSize){

                _local2.multiline = true;

                _local2.wordWrap = true;

            };

            return (_local2);

        }

        private function drawBG():void{

            var _local9:Number;

            var _local10:Number;

            var _local11:Number;

            var _local12:Number;

            graphics.clear();

            this._titleFormat.color = this._config.style.tooltipTextColor;

            var _local1:Rectangle = this.getBounds(this);

            var _local2:String = GradientType.LINEAR;

            var _local3:Array = [this._config.style.tooltipAlpha, this._config.style.tooltipAlpha];

            var _local4:Array = [0, 0xFF];

            var _local5:Matrix = new Matrix();

            var _local6:Number = ((90 * Math.PI) / 180);

            _local5.createGradientBox(this._defaultWidth, (_local1.height + (this._buffer * 2)), _local6, 0, 0);

            var _local7:String = SpreadMethod.PAD;

            var _local8:Array = [this.lighten(this._config.style.tooltipColor), this._config.style.tooltipColor];

            this.graphics.beginGradientFill(_local2, _local8, _local3, _local4, _local5, _local7);

            if (this._hookEnabled){

                _local9 = 0;

                _local10 = 0;

                _local11 = this._defaultWidth;

                _local12 = (_local1.height + (this._buffer * 2));

                this.graphics.moveTo((_local9 + this._cornerRadius), _local10);

                this.graphics.lineTo(((_local9 + _local11) - this._cornerRadius), _local10);

                this.graphics.curveTo((_local9 + _local11), _local10, (_local9 + _local11), (_local10 + this._cornerRadius));

                this.graphics.lineTo((_local9 + _local11), ((_local10 + _local12) - this._cornerRadius));

                this.graphics.curveTo((_local9 + _local11), (_local10 + _local12), ((_local9 + _local11) - this._cornerRadius), (_local10 + _local12));

                this.graphics.lineTo(((_local9 + this._hookOffSet) + this._hookSize), (_local10 + _local12));

                this.graphics.lineTo((_local9 + this._hookOffSet), ((_local10 + _local12) + this._hookSize));

                this.graphics.lineTo(((_local9 + this._hookOffSet) - this._hookSize), (_local10 + _local12));

                this.graphics.lineTo((_local9 + this._cornerRadius), (_local10 + _local12));

                this.graphics.curveTo(_local9, (_local10 + _local12), _local9, ((_local10 + _local12) - this._cornerRadius));

                this.graphics.lineTo(_local9, (_local10 + this._cornerRadius));

                this.graphics.curveTo(_local9, _local10, (_local9 + this._cornerRadius), _local10);

                this.graphics.endFill();

            } else {

                this.graphics.drawRoundRect(0, 0, this._defaultWidth, (_local1.height + (this._buffer * 2)), this._cornerRadius, this._cornerRadius);

            };

        }

        private function lighten(_arg1:Number):Number{

            var _local2:Array = [((_arg1 >> 16) & 0xFF), ((_arg1 >> 8) & 0xFF), (_arg1 & 0xFF)];

            var _local3:Number = 60;

            _local2 = [Math.min((_local2[0] + _local3), 0xFF), Math.min((_local2[1] + _local3), 0xFF), Math.min((_local2[2] + _local3), 0xFF)];

            return ((((_local2[0] << 16) | (_local2[1] << 8)) | _local2[2]));

        }

        private function animate(_arg1:Boolean):void{

            if (_arg1){

                this._animationEngine.fadeIn(this, 500);

                this._timer.reset();

            } else {

                this._timer.stop();

                this._tween = this._animationEngine.fadeOut(this, 500, this.onComplete);

            };

        }

        private function onComplete():void{

            if (((this._tween) && (this._tween.canceled))){

                this._tween = null;

                return;

            };

            this._tween = null;

            this.cleanUp();

        }

        private function textGlow(_arg1:TextField):void{

            var _local2:Number = 0;

            var _local3:Number = 0.35;

            var _local4:Number = 2;

            var _local5:Number = 2;

            var _local6:Number = 1;

            var _local7:Boolean;

            var _local8:Boolean;

            var _local9:Number = BitmapFilterQuality.HIGH;

            var _local10:GlowFilter = new GlowFilter(_local2, _local3, _local4, _local5, _local6, _local9, _local7, _local8);

            var _local11:Array = new Array();

            _local11.push(_local10);

            _arg1.filters = _local11;

        }

        private function bgGlow():void{

            var _local1:Number = 0;

            var _local2:Number = 0.2;

            var _local3:Number = 5;

            var _local4:Number = 5;

            var _local5:Number = 1;

            var _local6:Boolean;

            var _local7:Boolean;

            var _local8:Number = BitmapFilterQuality.HIGH;

            var _local9:GlowFilter = new GlowFilter(_local1, _local2, _local3, _local4, _local5, _local8, _local6, _local7);

            var _local10:Array = new Array();

            _local10.push(_local9);

            filters = _local10;

        }

        private function initTitleFormat():void{

            this._titleFormat = new TextFormat();

            this._titleFormat.font = "_sans";

            this._titleFormat.bold = true;

            this._titleFormat.size = 10;

            this._titleFormat.color = this._config.style.tooltipTextColor;

        }

        private function initContentFormat():void{

            this._contentFormat = new TextFormat();

            this._contentFormat.font = "_sans";

            this._contentFormat.bold = false;

            this._contentFormat.size = 12;

            this._contentFormat.color = 0x333333;

        }

        private function isDeviceFont(_arg1:TextFormat):Boolean{

            var _local2:String = _arg1.font;

            var _local3 = "_sans _serif _typewriter";

            return ((_local3.indexOf(_local2) > -1));

        }

        private function setOffset():void{

            switch (this._align){

                case "left":

                    this._offSet = ((-(this._defaultWidth) + (this._buffer * 6)) + this._hookSize);

                    this._hookOffSet = ((this._defaultWidth - (this._buffer * 6)) - this._hookSize);

                    break;

                case "right":

                    this._offSet = ((0 - (this._buffer * 6)) - this._hookSize);

                    this._hookOffSet = ((this._buffer * 6) + this._hookSize);

                    break;

                case "center":

                    this._offSet = -((this._defaultWidth / 2));

                    this._hookOffSet = (this._defaultWidth / 2);

                    break;

                default:

                    this._offSet = -((this._defaultWidth / 2));

                    this._hookOffSet = (this._defaultWidth / 2);

            };

        }

        private function cleanUp():void{

            this.follow(false);

            this.filters = [];

            if (this._tf){

                this._tf.filters = [];

                removeChild(this._tf);

                this._tf = null;

            };

            this.graphics.clear();

            if (((parent) && ((this.parent == parent)))){

                parent.removeChild(this);

            };

        }

        override public function get visible():Boolean{

            if (super.visible){

                return (false);

            };

            return ((this.alpha < this._config.style.tooltipAlpha));

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import org.flowplayer.controls.button.*;

    import flash.display.*;

    import flash.text.*;

    import org.flowplayer.util.*;



    public class TimeView extends AbstractSprite {



        public static const EVENT_REARRANGE:String = "onRearrange";



        private var _config:Config;

        private var _top:DisplayObject;

        private var _bottom:DisplayObject;

        private var _left:DisplayObject;

        private var _right:DisplayObject;

        private var _timeText:TextField;

        private var _durationText:TextField;

        private var _prevTextLength:Number;

        private var _player:Flowplayer;



        public function TimeView(_arg1:Config, _arg2:Flowplayer){

            this._prevTextLength = "00:00".length;

            super();

            this._config = _arg1;

            this._player = _arg2;

            this.createTimeText();

            this.createDurationText();

            this._left = addChild(SkinClasses.getTimeLeft());

            this._right = addChild(SkinClasses.getTimeRight());

            this._top = addChild(SkinClasses.getTimeTop());

            this._bottom = addChild(SkinClasses.getTimeBottom());

            this.duration = 0;

            this.time = 0;

        }

        private function get borderRadius():Number{

            return (((this._config.style.timeBorderRadius >= 0)) ? this._config.style.timeBorderRadius : Math.floor((height / 2)));

        }

        override public function get name():String{

            return ("time");

        }

        public function redraw(_arg1:Config):void{

            this._timeText.textColor = _arg1.style.timeColor;

            this._timeText.alpha = _arg1.style.timeAlpha;

            if (this._durationText){

                this._durationText.textColor = _arg1.style.durationColor;

                this._durationText.alpha = _arg1.style.durationAlpha;

            };

            this.drawBackground();

        }

        public function set time(_arg1:Number):void{

            this._timeText.text = TimeUtil.formatSeconds(_arg1);

            if (this._durationText){

                this._timeText.appendText((this._config.style.timeSeparator) ? this._config.style.timeSeparator : "/");

            };

            this.onResize();

            var _local2:Number = (this._timeText.text.length + (this._durationText) ? this._durationText.text.length : 0);

            if (_local2 != this._prevTextLength){

                dispatchEvent(new Event(EVENT_REARRANGE));

            };

            this._prevTextLength = _local2;

        }

        public function set duration(_arg1:Number):void{

            var _local2:String;

            if ((((_arg1 == -1)) && (this._durationText))){

                removeChild(this._durationText);

                this._durationText = null;

                this.onResize();

                dispatchEvent(new Event(EVENT_REARRANGE));

                return;

            };

            if ((((_arg1 > 0)) && (!(this._durationText)))){

                this.createDurationText();

                this.onResize();

                dispatchEvent(new Event(EVENT_REARRANGE));

            };

            if (this._durationText){

                _local2 = TimeUtil.formatSeconds(_arg1);

                if (_local2 == this._durationText.text){

                    return;

                };

                this.resizeFont(_local2.length);

                this._durationText.text = _local2;

            };

        }

        private function resizeFont(_arg1:int):void{

            var _local2:Number = ((_arg1 > "00:00".length)) ? 9 : 11;

            _local2 = (this._config.style.timeFontSize) ? this._config.style.timeFontSize : _local2;

            this.initField(this._durationText, this._config.style.durationColor, this._config.style.durationAlpha, _local2);

            this.initField(this._timeText, this._config.style.timeColor, this._config.style.timeAlpha, _local2);

            this.onResize();

        }

        override protected function onResize():void{

            this._left.y = this._top.height;

            this._left.height = ((height - this._top.height) - this._bottom.height);

            this._timeText.x = ((this._left.width - (this.borderRadius / 2)) + Math.max(this.borderRadius, 2));

            Arrange.center(this._timeText, 0, height);

            if (this._durationText){

                this._durationText.x = ((this._timeText.x + this._timeText.textWidth) + 2);

                Arrange.center(this._durationText, 0, height);

            };

            this.drawBackground();

            this._top.x = 0;

            this._top.width = width;

            this._right.x = (width - this._right.width);

            this._right.y = this._top.height;

            this._right.height = ((height - this._top.height) - this._bottom.height);

            this._bottom.x = 0;

            this._bottom.width = width;

            this._bottom.y = (height - this._bottom.height);

        }

        private function drawBackground():void{

            graphics.clear();

            if ((((this._config.style.timeBorderWidth > 0)) && ((this._config.style.timeBorderAlpha > 0)))){

                graphics.lineStyle(this._config.style.timeBorderWidth, this._config.style.timeBorderColor, this._config.style.timeBorderAlpha);

            };

            graphics.beginFill(this._config.style.timeBgColor, ((this._config.style.timeBgColor >= 0)) ? this._config.style.timeBgAlpha : 0);

            var _local1:Number = ((this._timeText.textWidth + (Math.max(this.borderRadius, 2) * 2)) + 6);

            if (this._durationText){

                _local1 = (_local1 + this._durationText.textWidth);

            };

            var _local2:Number = (height * this._config.style.timeBgHeightRatio);

            graphics.drawRoundRect(this._left.width, ((height / 2) - (_local2 / 2)), (_local1 - this.borderRadius), _local2, this.borderRadius, this.borderRadius);

            graphics.endFill();

            _width = (((_local1 - this.borderRadius) + this._left.width) + this._right.width);

        }

        private function createDurationText():void{

            this._durationText = this._player.createTextField();

            this.initField(this._durationText, this._config.style.durationColor, this._config.style.durationAlpha);

            addChild(this._durationText);

        }

        private function createTimeText():void{

            this._timeText = this._player.createTextField();

            this.initField(this._timeText, this._config.style.timeColor, this._config.style.timeAlpha);

            addChild(this._timeText);

        }

        private function initField(_arg1:TextField, _arg2:Number, _arg3:Number, _arg4:Number=13):void{

            if (!_arg1){

                return;

            };

            _arg1.textColor = _arg2;

            _arg1.selectable = false;

            _arg1.autoSize = TextFieldAutoSize.LEFT;

            _arg1.blendMode = BlendMode.LAYER;

            _arg1.alpha = _arg3;

            var _local5:TextFormat = _arg1.defaultTextFormat;

            _local5.size = _arg4;

            _arg1.defaultTextFormat = _local5;

        }



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class TogglePlayButton extends AbstractToggleButton {



        public function TogglePlayButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("play");

        }

        override protected function createUpStateFace():DisplayObjectContainer{

            return (DisplayObjectContainer(SkinClasses.getPlayButton()));

        }

        override protected function createDownStateFace():DisplayObjectContainer{

            return (DisplayObjectContainer(SkinClasses.getPauseButton()));

        }

        override protected function get tooltipLabel():String{

            if (!config.tooltips){

                return (null);

            };

            return ((isDown) ? config.tooltips.pause : config.tooltips.play);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import flash.display.*;

    import org.flowplayer.controls.*;

    import flash.geom.*;



    public class AbstractButton extends AbstractSprite {



        protected static const HIGHLIGHT_INSTANCE_NAME:String = "mOver";



        private var _config:Config;

        private var _top:DisplayObject;

        private var _bottom:DisplayObject;

        private var _left:DisplayObject;

        private var _right:DisplayObject;

        private var _face:DisplayObjectContainer;

        private var _tooltip:ToolTip;

        private var _animationEngine:AnimationEngine;



        public function AbstractButton(_arg1:Config, _arg2:AnimationEngine){

            this._config = _arg1;

            this._animationEngine = _arg2;

            this._face = DisplayObjectContainer(this.addFaceIfNotNull(this.createFace()));

            this._left = DisplayObjectContainer(this.addFaceIfNotNull(this.getButtonLeft()));

            this._right = DisplayObjectContainer(this.addFaceIfNotNull(this.getButtonRight()));

            this._top = DisplayObjectContainer(this.addFaceIfNotNull(this.getButtonTop()));

            this._bottom = DisplayObjectContainer(this.addFaceIfNotNull(this.getButtonBottom()));

            this.enabled = true;

            addEventListener(Event.ADDED_TO_STAGE, this.onAddedToStage);

        }

        protected function getButtonLeft():DisplayObject{

            return (SkinClasses.getButtonLeft());

        }

        protected function getButtonRight():DisplayObject{

            return (SkinClasses.getButtonRight());

        }

        protected function getButtonTop():DisplayObject{

            return (SkinClasses.getButtonTop());

        }

        protected function getButtonBottom():DisplayObject{

            return (SkinClasses.getButtonBottom());

        }

        public function addFaceIfNotNull(_arg1:DisplayObject):DisplayObject{

            if (!_arg1){

                return (_arg1);

            };

            return (addChild(_arg1));

        }

        override protected function onResize():void{

            this.resizeFace();

            this._left.x = 0;

            this._left.y = this._top.height;

            this._left.height = ((height - this._top.height) - this._bottom.height);

            this._top.x = 0;

            this._top.y = 0;

            this._top.width = ((this.faceWidth + this._left.width) + this._right.width);

            this._right.x = (this._left.width + this.faceWidth);

            this._right.y = this._top.height;

            this._right.height = ((height - this._top.height) - this._bottom.height);

            this._bottom.x = 0;

            this._bottom.y = (height - this.bottomEdge);

            this._bottom.width = ((this.faceWidth + this._left.width) + this._right.width);

            _height = ((this.topEdge + this.faceHeight) + this.bottomEdge);

            _width = ((this.leftEdge + this.faceWidth) + this.rightEdge);

        }

        protected function resizeFace():void{

            if (!this._face){

                return;

            };

            this._face.x = this._left.width;

            this._face.y = this._top.height;

            this._face.height = ((height - this.topEdge) - this.bottomEdge);

            this._face.scaleX = this._face.scaleY;

        }

        protected function get faceWidth():Number{

            return (this._face.width);

        }

        protected function get faceHeight():Number{

            return (this._face.height);

        }

        protected function get rightEdge():Number{

            return (this._right.width);

        }

        protected function get leftEdge():Number{

            return (this._left.width);

        }

        protected function get topEdge():Number{

            return (this._top.height);

        }

        protected function get bottomEdge():Number{

            return (this._bottom.height);

        }

        private function onAddedToStage(_arg1:Event):void{

            this.toggleTooltip();

            this.onMouseOut();

        }

        private function toggleTooltip():void{

            if (this.tooltipLabel){

                if (((this._tooltip) && ((this._tooltip is DefaultToolTip)))){

                    return;

                };

                log.debug("enabling tooltip");

                this._tooltip = new DefaultToolTip(this._config, this._animationEngine);

            } else {

                log.debug("tooltip disabled");

                this._tooltip = new NullToolTip();

            };

        }

        public function redraw(_arg1:Config):void{

            this._config = _arg1;

            this.onMouseOut();

            this.toggleTooltip();

            this._tooltip.redraw(_arg1);

        }

        public function set enabled(_arg1:Boolean):void{

            buttonMode = _arg1;

            var _local2:String = (_arg1) ? "addEventListener" : "removeEventListener";

            var _local3 = this;

            _local3[_local2](MouseEvent.ROLL_OVER, this.onMouseOver);

            _local3 = this;

            _local3[_local2](MouseEvent.ROLL_OUT, this.onMouseOut);

            _local3 = this;

            _local3[_local2](Event.MOUSE_LEAVE, this.onMouseOut);

            _local3 = this;

            _local3[_local2](MouseEvent.MOUSE_DOWN, this.onMouseDown);

            _local3 = this;

            _local3[_local2](MouseEvent.CLICK, this.onClicked);

            alpha = (_arg1) ? 1 : 0.5;

            this.doEnable(_arg1);

        }

        protected function doEnable(_arg1:Boolean):void{

        }

        private function transformColor(_arg1:DisplayObject, _arg2:Number, _arg3:Number, _arg4:Number, _arg5:Number):void{

            log.debug("transformColor");

            if (!_arg1){

                return;

            };

            var _local6:ColorTransform = new ColorTransform(0, 0, 0, _arg5, _arg2, _arg3, _arg4, 0);

            _arg1.transform.colorTransform = _local6;

        }

        protected function onMouseOut(_arg1:MouseEvent=null):void{

            log.debug("onMouseOut");

            this.hideTooltip();

            this.showMouseOutState(this._face);

            this.resetDispColor(this._face.getChildByName(HIGHLIGHT_INSTANCE_NAME));

        }

        protected function onMouseOver(_arg1:MouseEvent):void{

            log.debug(("onMouseOver" + this._face.getChildByName(HIGHLIGHT_INSTANCE_NAME)));

            this.showTooltip();

            this.showMouseOverState(this._face);

            this.transformDispColor(this._face.getChildByName(HIGHLIGHT_INSTANCE_NAME));

        }

        protected function showMouseOverState(_arg1:DisplayObjectContainer):void{

            log.debug(("showMouseOverState " + _arg1));

            if ((_arg1 is MovieClip)){

                log.debug(("calling play() on " + _arg1));

                if (MovieClip(_arg1).currentFrame == 1){

                    MovieClip(_arg1).play();

                };

            };

            var _local2:DisplayObject = _arg1.getChildByName(HIGHLIGHT_INSTANCE_NAME);

            if (((_local2) && ((_local2 is MovieClip)))){

                MovieClip(_local2).gotoAndPlay("over");

            };

        }

        protected function showMouseOutState(_arg1:DisplayObjectContainer):void{

            if ((_arg1 is MovieClip)){

                log.debug(("calling gotoAndStop(1) on " + _arg1));

                MovieClip(_arg1).gotoAndStop(1);

            };

            var _local2:DisplayObject = _arg1.getChildByName(HIGHLIGHT_INSTANCE_NAME);

            if (((_local2) && ((_local2 is MovieClip)))){

                MovieClip(_local2).gotoAndStop(1);

            };

        }

        protected function hideTooltip():void{

            this._tooltip.hide();

        }

        protected function showTooltip():void{

            if (!this.tooltipLabel){

                this.hideTooltip();

            };

            this.toggleTooltip();

            this._tooltip.show(this, this.tooltipLabel);

        }

        protected function get tooltipLabel():String{

            return (null);

        }

        protected function transformDispColor(_arg1:DisplayObject):void{

            log.debug("mouse over colors", this._config.style.buttonOverColorRGBA);

            this.transformColor(_arg1, this._config.style.buttonOverColorRGBA[0], this._config.style.buttonOverColorRGBA[1], this._config.style.buttonOverColorRGBA[2], this._config.style.buttonOverColorRGBA[3]);

        }

        protected function resetDispColor(_arg1:DisplayObject):void{

            log.debug("normal colors", this._config.style.buttonColorRGBA);

            this.transformColor(_arg1, this._config.style.buttonColorRGBA[0], this._config.style.buttonColorRGBA[1], this._config.style.buttonColorRGBA[2], this._config.style.buttonColorRGBA[3]);

        }

        protected function createFace():DisplayObjectContainer{

            return (null);

        }

        final protected function get config():Config{

            return (this._config);

        }

        protected function onClicked(_arg1:MouseEvent):void{

            log.debug("clicked!");

            dispatchEvent(new ButtonEvent(ButtonEvent.CLICK));

            this.showTooltip();

        }

        protected function onMouseDown(_arg1:MouseEvent):void{

            var _local2:DisplayObject = this._face.getChildByName(HIGHLIGHT_INSTANCE_NAME);

            if (((_local2) && ((_local2 is MovieClip)))){

                MovieClip(_local2).gotoAndPlay("down");

            };

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class DraggerButton extends AbstractButton {



        public function DraggerButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        protected function isToolTipEnabled():Boolean{

            return (false);

        }

        override public function get name():String{

            return ("dragger");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getDragger());

        }

        override protected function getButtonLeft():DisplayObject{

            return (new Sprite());

        }

        override protected function getButtonRight():DisplayObject{

            return (new Sprite());

        }

        override protected function getButtonTop():DisplayObject{

            return (new Sprite());

        }

        override protected function getButtonBottom():DisplayObject{

            return (new Sprite());

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import flash.display.*;

    import flash.system.*;

    import flash.utils.*;

    import org.flowplayer.util.*;

    import fp.*;



    public class SkinClasses {



        private static var log:Log = new Log("org.flowplayer.controls.button::SkinClasses");

        private static var _skinClasses:ApplicationDomain;



        private var slowMotionFwd:SlowMotionFwdButton;

        private var slowMotionBwd:SlowMotionBwdButton;

        private var slowMotionFFwd:SlowMotionFFwdButton;

        private var slowMotionFBwd:SlowMotionFBwdButton;

        private var foo:FullScreenOnButton;

        private var bar:FullScreenOffButton;

        private var next:NextButton;

        private var prev:PrevButton;

        private var dr:Dragger;

        private var pause:PauseButton;

        private var play:PlayButton;

        private var stop:StopButton;

        private var vol:MuteButton;

        private var volOff:UnMuteButton;

        private var scrubberLeft:ScrubberLeftEdge;

        private var scrubberRight:ScrubberRightEdge;

        private var scrubberTop:ScrubberTopEdge;

        private var scrubberBottom:ScrubberBottomEdge;

        private var buttonLeft:ButtonLeftEdge;

        private var buttomRight:ButtonRightEdge;

        private var buttomTop:ButtonTopEdge;

        private var buttonBottom:ButtonBottomEdge;

        private var timeLeft:TimeLeftEdge;

        private var timeRight:TimeRightEdge;

        private var timeTop:TimeTopEdge;

        private var timeBottom:TimeBottomEdge;

        private var volumeLeft:VolumeLeftEdge;

        private var volumeRight:VolumeRightEdge;

        private var volumeTop:VolumeTopEdge;

        private var volumeBottom:VolumeBottomEdge;

        private var defaults:SkinDefaults;



        public static function getDisplayObject(_arg1:String):DisplayObject{

            var _local2:Class = getClass(_arg1);

            return ((new (_local2) as DisplayObject));

        }

        public static function getClass(_arg1:String):Class{

            log.debug((("creating skin class " + _arg1) + (_skinClasses) ? "from skin swf" : ""));

            if (_skinClasses){

                return ((_skinClasses.getDefinition(_arg1) as Class));

            };

            return ((getDefinitionByName(_arg1) as Class));

        }

        public static function get defaults():Object{

            var clazz:* = null;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["values"]);

            } catch(e:Error) {

            };

            return (null);

        }

        public static function getSpaceBeforeFirstWidget():Number{

            var clazz:* = null;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["getSpaceBeforeFirstWidget"]());

            } catch(e:Error) {

            };

            return (0);

        }

        public static function get margins():Array{

            var clazz:* = null;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["margins"]);

            } catch(e:Error) {

            };

            return ([0, 0, 0, 0]);

        }

        public static function getSpaceAfterWidget(_arg1:DisplayObject, _arg2:Boolean):Number{

            var clazz:* = null;

            var widget:* = _arg1;

            var lastOnRight:* = _arg2;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["getSpaceAfterWidget"](widget, lastOnRight));

            } catch(e:Error) {

            };

            return (0);

        }

        public static function getScrubberRightEdgeWidth(_arg1:DisplayObject):Number{

            var clazz:* = null;

            var nextWidgetToRight:* = _arg1;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["getScrubberRightEdgeWidth"](nextWidgetToRight));

            } catch(e:Error) {

            };

            return (0);

        }

        public static function getVolumeSliderWidth():Number{

            var clazz:* = null;

            try {

                clazz = getClass("SkinDefaults");

                return (clazz["getVolumeSliderWidth"]());

            } catch(e:Error) {

            };

            return (40);

        }

        public static function set skinClasses(_arg1:ApplicationDomain):void{

            log.debug(("received skin classes " + _arg1));

            _skinClasses = _arg1;

        }

        public static function getScrubberLeftEdge():DisplayObject{

            return (getDisplayObject("fp.ScrubberLeftEdge"));

        }

        public static function getScrubberRightEdge():DisplayObject{

            return (getDisplayObject("fp.ScrubberRightEdge"));

        }

        public static function getScrubberTopEdge():DisplayObject{

            return (getDisplayObject("fp.ScrubberTopEdge"));

        }

        public static function getScrubberBottomEdge():DisplayObject{

            return (getDisplayObject("fp.ScrubberBottomEdge"));

        }

        public static function getFullScreenOnButton():DisplayObject{

            return (getDisplayObject("fp.FullScreenOnButton"));

        }

        public static function getFullScreenOffButton():DisplayObject{

            return (getDisplayObject("fp.FullScreenOffButton"));

        }

        public static function getPlayButton():DisplayObject{

            return (getDisplayObject("fp.PlayButton"));

        }

        public static function getPauseButton():DisplayObject{

            return (getDisplayObject("fp.PauseButton"));

        }

        public static function getMuteButton():DisplayObject{

            return (getDisplayObject("fp.MuteButton"));

        }

        public static function getUnmuteButton():DisplayObject{

            return (getDisplayObject("fp.UnMuteButton"));

        }

        public static function getNextButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.NextButton")));

        }

        public static function getPrevButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.PrevButton")));

        }

        public static function getSlowMotionFwdButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.SlowMotionFwdButton")));

        }

        public static function getSlowMotionBwdButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.SlowMotionBwdButton")));

        }

        public static function getSlowMotionFFwdButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.SlowMotionFFwdButton")));

        }

        public static function getSlowMotionFBwdButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.SlowMotionFBwdButton")));

        }

        public static function getStopButton():DisplayObjectContainer{

            return (DisplayObjectContainer(getDisplayObject("fp.StopButton")));

        }

        public static function getButtonLeft():DisplayObject{

            return (getDisplayObject("fp.ButtonLeftEdge"));

        }

        public static function getButtonRight():DisplayObject{

            return (getDisplayObject("fp.ButtonRightEdge"));

        }

        public static function getButtonTop():DisplayObject{

            return (getDisplayObject("fp.ButtonTopEdge"));

        }

        public static function getButtonBottom():DisplayObject{

            return (getDisplayObject("fp.ButtonBottomEdge"));

        }

        public static function getTimeLeft():DisplayObject{

            return (getDisplayObject("fp.TimeLeftEdge"));

        }

        public static function getTimeRight():DisplayObject{

            return (getDisplayObject("fp.TimeRightEdge"));

        }

        public static function getTimeTop():DisplayObject{

            return (getDisplayObject("fp.TimeTopEdge"));

        }

        public static function getTimeBottom():DisplayObject{

            return (getDisplayObject("fp.TimeBottomEdge"));

        }

        public static function getVolumeLeft():DisplayObject{

            return (getDisplayObject("fp.VolumeLeftEdge"));

        }

        public static function getVolumeRight():DisplayObject{

            return (getDisplayObject("fp.VolumeRightEdge"));

        }

        public static function getVolumeTop():DisplayObject{

            return (getDisplayObject("fp.VolumeTopEdge"));

        }

        public static function getVolumeBottom():DisplayObject{

            return (getDisplayObject("fp.VolumeBottomEdge"));

        }

        public static function getDragger():DisplayObjectContainer{

            return ((getDisplayObject("fp.Dragger") as DisplayObjectContainer));

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import flash.events.*;



    public class ButtonEvent extends Event {



        public static const CLICK:String = "flowclick";



        public function ButtonEvent(_arg1:String, _arg2:Boolean=false, _arg3:Boolean=true){

            super(_arg1, _arg2, _arg3);

        }

        override public function clone():Event{

            return (new ButtonEvent(type, bubbles, cancelable));

        }

        override public function toString():String{

            return (formatToString("ButtonEvent", "type"));

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class ToggleFullScreenButton extends AbstractToggleButton {



        public function ToggleFullScreenButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("fullscreen");

        }

        override protected function createUpStateFace():DisplayObjectContainer{

            log.debug("createUpStateFace");

            return (DisplayObjectContainer(SkinClasses.getFullScreenOnButton()));

        }

        override protected function createDownStateFace():DisplayObjectContainer{

            log.debug("createDownStateFace");

            return (DisplayObjectContainer(SkinClasses.getFullScreenOffButton()));

        }

        override protected function onClicked(_arg1:MouseEvent):void{

            super.onClicked(_arg1);

            onMouseOut();

        }

        override protected function get tooltipLabel():String{

            if (!config.tooltips){

                return (null);

            };

            return ((isDown) ? config.tooltips.fullscreenExit : config.tooltips.fullscreen);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class SlowMotionBwdButton extends AbstractButton {



        public function SlowMotionBwdButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("slowMotionBwd");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getSlowMotionBwdButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.slowMotionBwd);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class ToggleVolumeMuteButton extends AbstractToggleButton {



        public function ToggleVolumeMuteButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

            addEventListener(Event.ADDED_TO_STAGE, this.onAddedToStage);

        }

        override public function get name():String{

            return ("mute");

        }

        private function onAddedToStage(_arg1:Event):void{

            log.debug("adding hit area");

            var _local2:Sprite = new Sprite();

            _local2.graphics.beginFill(0, 0);

            _local2.graphics.drawRect(0, 0, _upStateFace.width, _upStateFace.height);

            _local2.graphics.endFill();

            _local2.mouseEnabled = false;

            addChild(_local2);

            hitArea = _local2;

        }

        override protected function createUpStateFace():DisplayObjectContainer{

            return (DisplayObjectContainer(SkinClasses.getMuteButton()));

        }

        override protected function createDownStateFace():DisplayObjectContainer{

            return (DisplayObjectContainer(SkinClasses.getUnmuteButton()));

        }

        override protected function get tooltipLabel():String{

            if (!config.tooltips){

                return (null);

            };

            return ((isDown) ? config.tooltips.unmute : config.tooltips.mute);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class SlowMotionFBwdButton extends AbstractButton {



        public function SlowMotionFBwdButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("slowMotionFBwd");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getSlowMotionFBwdButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.slowMotionFBwd);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class PrevButton extends AbstractButton {



        public function PrevButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("prev");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getPrevButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.previous);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class SlowMotionFwdButton extends AbstractButton {



        public function SlowMotionFwdButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("slowMotionFwd");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getSlowMotionFwdButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.slowMotionFwd);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class StopButton extends AbstractButton {



        public function StopButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("stop");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getStopButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.stop);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class AbstractToggleButton extends AbstractButton {



        protected var _upStateFace:DisplayObjectContainer;

        protected var _downStateFace:DisplayObjectContainer;



        public function AbstractToggleButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

            this._downStateFace = this.createDownStateFace();

            this._upStateFace = this.createUpStateFace();

            addChild(this._upStateFace);

        }

        override protected function resizeFace():void{

            this.resize(this._downStateFace);

            this.resize(this._upStateFace);

        }

        override protected function get faceWidth():Number{

            return (this._upStateFace.width);

        }

        override protected function get faceHeight():Number{

            return (this._upStateFace.height);

        }

        private function resize(_arg1:DisplayObject):void{

            _arg1.x = leftEdge;

            _arg1.y = topEdge;

            _arg1.height = ((height - topEdge) - bottomEdge);

            _arg1.scaleX = _arg1.scaleY;

        }

        override protected function onMouseOut(_arg1:MouseEvent=null):void{

            resetDispColor(this._upStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME));

            resetDispColor(this._downStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME));

            hideTooltip();

            showMouseOutState(this._upStateFace);

            showMouseOutState(this._downStateFace);

        }

        override protected function onMouseOver(_arg1:MouseEvent):void{

            transformDispColor(this._upStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME));

            transformDispColor(this._downStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME));

            showTooltip();

            showMouseOverState(this._upStateFace);

            showMouseOverState(this._downStateFace);

        }

        override protected function onMouseDown(_arg1:MouseEvent):void{

            var _local2:DisplayObject = this._upStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME);

            if (((_local2) && ((_local2 is MovieClip)))){

                MovieClip(_local2).gotoAndPlay("down");

            };

            _local2 = this._downStateFace.getChildByName(HIGHLIGHT_INSTANCE_NAME);

            if (((_local2) && ((_local2 is MovieClip)))){

                MovieClip(_local2).gotoAndPlay("down");

            };

        }

        public function get isDown():Boolean{

            return (!((getChildByName(this._downStateFace.name) == null)));

        }

        public function set down(_arg1:Boolean):void{

            if (this.isDown == _arg1){

                return;

            };

            removeChild((_arg1) ? this._upStateFace : this._downStateFace);

            addChild((_arg1) ? this._downStateFace : this._upStateFace);

        }

        protected function createUpStateFace():DisplayObjectContainer{

            return (null);

        }

        protected function createDownStateFace():DisplayObjectContainer{

            return (null);

        }

        override protected function createFace():DisplayObjectContainer{

            return (null);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class SlowMotionFFwdButton extends AbstractButton {



        public function SlowMotionFFwdButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("slowMotionFFwd");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getSlowMotionFFwdButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.slowMotionFFwd);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls.button {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class NextButton extends AbstractButton {



        public function NextButton(_arg1:Config, _arg2:AnimationEngine){

            super(_arg1, _arg2);

        }

        override public function get name():String{

            return ("next");

        }

        override protected function createFace():DisplayObjectContainer{

            return (SkinClasses.getNextButton());

        }

        override protected function get tooltipLabel():String{

            return (config.tooltips.next);

        }



    }

}//package org.flowplayer.controls.button 

﻿package org.flowplayer.controls {

    import org.flowplayer.controls.config.*;

    import flash.display.*;



    public interface ToolTip {



        function set text(_arg1:String):void;

        function redraw(_arg1:Config):void;

        function show(_arg1:DisplayObject, _arg2:String, _arg3:Boolean=false, _arg4:String=null):void;

        function hide():void;

        function get visible():Boolean;



    }

}//package org.flowplayer.controls 

﻿package org.flowplayer.controls.slider {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import org.flowplayer.model.*;

    import flash.display.*;

    import flash.utils.*;

    import org.flowplayer.util.*;



    public class ScrubberSlider extends AbstractSlider {



        private var _bufferEnd:Number;

        private var _bufferBar:Sprite;

        private var _allowRandomSeek:Boolean;

        private var _seekInProgress:Boolean;

        private var _progressBar:Sprite;

        private var _bufferStart:Number;

        private var _enabled:Boolean = true;

        private var _startDetectTimer:Timer;

        private var _trickPlayTrackTimer:Timer;

        private var _slowMotionInfo:Object;

        private var _currentClip:Clip;



        public function ScrubberSlider(_arg1:Config, _arg2:AnimationEngine, _arg3:DisplayObject){

            super(_arg1, _arg2, _arg3);

            this.lookupPluginAndBindEvent(_arg1.player, "slowmotion", this.onSlowMotionEvent);

            this.lookupPluginAndBindEvent(_arg1.player, "audio", this.onAudioEvent);

            this.createBars();

            this.addPlaylistListeners(_arg1.player.playlist);

        }

        private function lookupPluginAndBindEvent(_arg1:Flowplayer, _arg2:String, _arg3:Function):void{

            var _local4:PluginModel = (_arg1.pluginRegistry.getPlugin(_arg2) as PluginModel);

            if (_local4){

                log.debug(("found plugin " + _local4));

                _local4.onPluginEvent(_arg3);

            };

        }

        public function addPlaylistListeners(_arg1:Playlist):void{

            var playlist:* = _arg1;

            playlist.onStart(this.setSeekDone);

            playlist.onBeforeSeek(this.setSeekBegin);

            playlist.onSeek(this.setSeekDone);

            playlist.onBegin(function (_arg1:ClipEvent):void{

                _currentClip = (_arg1.target as Clip);

            });

            playlist.onStart(this.start);

            playlist.onResume(this.resume);

            playlist.onPause(this.stop);

            playlist.onBufferEmpty(this.stop);

            playlist.onBufferFull(this.start);

            playlist.onStop(this.stopAndRewind);

            playlist.onFinish(this.stopAndRewind);

            playlist.onBeforeSeek(this.beforeSeek);

            playlist.onSeek(this.seek);

        }

        private function onSlowMotionEvent(_arg1:PluginEvent):void{

            log.debug("onSlowMotionEvent()");

            this._slowMotionInfo = _arg1.info2;

            this.stop();

            if (!this.isTrickPlay){

                this.stopTrickPlayTracking();

                this.doStart(this._slowMotionInfo["clip"], this.adjustedTime(_config.player.status.time));

            } else {

                this.startTrickPlayTracking();

            };

        }

        private function onAudioEvent(_arg1:PluginEvent):void{

            log.debug("onAudioEvent()");

            this.stop();

            this.doStart(_config.player.playlist.current);

        }

        private function stopTrickPlayTracking():void{

            if (this._trickPlayTrackTimer){

                this._trickPlayTrackTimer.stop();

            };

        }

        private function startTrickPlayTracking():void{

            this.stopTrickPlayTracking();

            this._trickPlayTrackTimer = new Timer(200);

            this._trickPlayTrackTimer.addEventListener(TimerEvent.TIMER, this.onTrickPlayProgress);

            this._trickPlayTrackTimer.start();

        }

        private function onTrickPlayProgress(_arg1:TimerEvent):void{

            this.updateDraggerPos(_config.player.status.time, (this._slowMotionInfo["clip"] as Clip));

        }

        override protected function onResize():void{

            super.onResize();

            this.drawBufferBar(0, 0);

            this.drawProgressBar(0, 0);

            if (this._currentClip){

                this.stop();

                this.updateDraggerPos(_config.player.status.time, this._currentClip);

                this.doStart(this._currentClip, _config.player.status.time);

            };

        }

        private function beforeSeek(_arg1:ClipEvent):void{

            log.debug("beforeSeek()");

            if (_arg1.isDefaultPrevented()){

                log.debug("Default prevented ");

                this.stop();

                this.updateDraggerPos(_config.player.status.time, (_arg1.target as Clip));

                this.doStart((_arg1.target as Clip), _config.player.status.time);

                return;

            };

            this.updateDraggerPos((_arg1.info as Number), (_arg1.target as Clip));

            this.stop();

            this.drawBufferBar(0, 0);

            this.drawProgressBar(0, 0);

        }

        private function updateDraggerPos(_arg1:Number, _arg2:Clip):void{

            _dragger.x = ((_arg1 / _arg2.duration) * (width - _dragger.width));

        }

        private function seek(_arg1:ClipEvent):void{

            log.debug(((("seek(), isPlaying: " + _config.player.isPlaying()) + ", seek target time is ") + _arg1.info));

            if (!_config.player.isPlaying()){

                return;

            };

            this._currentClip = (_arg1.target as Clip);

            this.doStart(this._currentClip, (_arg1.info as Number));

        }

        private function start(_arg1:ClipEvent):void{

            this._currentClip = (_arg1.target as Clip);

            log.debug(("start() " + this._currentClip));

            if ((((this._currentClip.duration == 0)) && ((this._currentClip.type == ClipType.IMAGE)))){

                return;

            };

            this.stop();

            this.doStart(this._currentClip);

        }

        private function resume(_arg1:ClipEvent):void{

            this._currentClip = (_arg1.target as Clip);

            this.stop();

            this.doStart(this._currentClip);

        }

        private function doStart(_arg1:Clip, _arg2:Number=0):void{

            var time:* = NaN;

            var clip:* = _arg1;

            var startTime:int = _arg2;

            log.debug("doStart()");

            if (this.isTrickPlay){

                return;

            };

            var status:* = _config.player.status;

            time = ((startTime > 0)) ? startTime : status.time;

            if (!_config.player.isPlaying()){

                return;

            };

            if (((this._startDetectTimer) && (this._startDetectTimer.running))){

                return;

            };

            if (animationEngine.hasAnimationRunning(_dragger)){

                return;

            };

            this._startDetectTimer = new Timer(200);

            this._startDetectTimer.addEventListener(TimerEvent.TIMER, function (_arg1:TimerEvent):void{

                var endPos:* = NaN;

                var duration:* = NaN;

                var event:* = _arg1;

                var currentTime:* = _config.player.status.time;

                if (Math.abs((currentTime - time)) > 0.2){

                    _startDetectTimer.stop();

                    endPos = (width - _dragger.width);

                    duration = ((clip.duration - time) * 1000);

                    log.debug(((((("doStart(), starting an animation to x pos " + endPos) + ", the duration is ") + clip.duration) + ", current pos is ") + _dragger.x));

                    updateDraggerPos(currentTime, clip);

                    animationEngine.animateProperty(_dragger, "x", endPos, duration, null, function (_arg1:Number, _arg2:Number, _arg3:Number, _arg4:Number):Number{

                        return ((((_arg3 * _arg1) / _arg4) + _arg2));

                    });

                };

            });

            this._startDetectTimer.start();

        }

        private function adjustedTime(_arg1:Number):Number{

            if (!this._slowMotionInfo){

                return (_arg1);

            };

            if (this._slowMotionInfo){

                log.debug(("adjustedTime: " + this._slowMotionInfo["adjustedTime"](_arg1)));

                return (this._slowMotionInfo["adjustedTime"](_arg1));

            };

            return (_arg1);

        }

        private function get isTrickPlay():Boolean{

            return (((this._slowMotionInfo) && (this._slowMotionInfo["isTrickPlay"])));

        }

        private function stop(_arg1:ClipEvent=null):void{

            log.debug("stop()");

            if (this._startDetectTimer){

                this._startDetectTimer.stop();

            };

            animationEngine.cancel(_dragger);

        }

        private function stopAndRewind(_arg1:ClipEvent=null):void{

            log.debug("stopAndRewind()");

            animationEngine.cancel(_dragger);

            animationEngine.animateProperty(_dragger, "x", 0, 300);

        }

        override protected function get dispatchOnDrag():Boolean{

            return (false);

        }

        override protected function getClickTargets(_arg1:Boolean):Array{

            this._enabled = _arg1;

            var _local2:Array = [this._bufferBar, this._progressBar];

            if (((!(_arg1)) || (this._allowRandomSeek))){

                _local2.push(this);

            };

            return (_local2);

        }

        override protected function isToolTipEnabled():Boolean{

            return (((_config.tooltips) && (_config.tooltips.scrubber)));

        }

        private function drawBufferBar(_arg1:Number, _arg2:Number):void{

            drawBar(this._bufferBar, _config.style.bufferColor, _config.style.bufferAlpha, _config.style.bufferGradient, _arg1, _arg2);

        }

        private function drawProgressBar(_arg1:Number, _arg2:Number=0):void{

            drawBar(this._progressBar, _config.style.progressColor, _config.style.progressAlpha, _config.style.progressGradient, ((_arg1) || (0)), ((_arg2) || (((_dragger.x + _dragger.width) - 2))));

        }

        override protected function get sliderAlpha():Number{

            return (_config.style.sliderAlpha);

        }

        override protected function get borderWidth():Number{

            return (_config.style.sliderBorderWidth);

        }

        override protected function get borderColor():Number{

            return (_config.style.sliderBorderColor);

        }

        override protected function get borderAlpha():Number{

            return (_config.style.sliderBorderAlpha);

        }

        private function createBars():void{

            this._progressBar = new Sprite();

            addChild(this._progressBar);

            this._bufferBar = new Sprite();

            addChild(this._bufferBar);

            swapChildren(_dragger, this._bufferBar);

        }

        public function set allowRandomSeek(_arg1:Boolean):void{

            this._allowRandomSeek = _arg1;

            if (this._enabled){

                if (_arg1){

                    addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown);

                } else {

                    removeEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown);

                };

                buttonMode = this._allowRandomSeek;

            };

        }

        override function get maxDrag():Number{

            if (this._allowRandomSeek){

                return ((width - _dragger.width));

            };

            return ((this._bufferEnd * (width - _dragger.width)));

        }

        public function setBufferRange(_arg1:Number, _arg2:Number):void{

            this._bufferStart = _arg1;

            this._bufferEnd = Math.min(_arg2, 1);

            this.drawBars();

        }

        override protected function canDragTo(_arg1:Number):Boolean{

            if (this._allowRandomSeek){

                return (true);

            };

            return ((_arg1 < (this._bufferBar.x + this._bufferBar.width)));

        }

        override protected function onDispatchDrag():void{

            this.drawBars();

            this._seekInProgress = true;

        }

        private function drawBars():void{

            if (this._seekInProgress){

                log.debug("drawBars(): seek in progress");

                return;

            };

            if ((_dragger.x + (_dragger.width / 2)) > (this._bufferStart * width)){

                this.drawBufferBar((this._bufferStart * width), (this._bufferEnd * width));

                this.drawProgressBar((this._bufferStart * width));

            } else {

                this._bufferBar.graphics.clear();

                GraphicsUtil.removeGradient(this._bufferBar);

                this._progressBar.graphics.clear();

                GraphicsUtil.removeGradient(this._progressBar);

            };

        }

        private function setSeekBegin(_arg1:ClipEvent):void{

            log.debug("onBeforeSeek");

            this._seekInProgress = !(_arg1.isDefaultPrevented());

        }

        private function setSeekDone(_arg1:ClipEvent):void{

            log.debug(("seek done! target " + _arg1.info));

            this._seekInProgress = false;

        }

        override protected function get allowSetValue():Boolean{

            return (!(this._seekInProgress));

        }

        override public function redraw(_arg1:Config):void{

            super.redraw(_arg1);

            drawBar(this._progressBar, _config.style.progressColor, _config.style.progressAlpha, _config.style.progressGradient, this._progressBar.x, this._progressBar.width);

            drawBar(this._bufferBar, _config.style.bufferColor, _config.style.bufferAlpha, _config.style.bufferGradient, this._bufferBar.x, this._bufferBar.width);

        }

        override protected function get barHeight():Number{

            return (Math.ceil((height * _config.style.scrubberBarHeightRatio)));

        }

        override protected function get sliderGradient():Array{

            return (_config.style.sliderGradient);

        }

        override protected function get sliderColor():Number{

            return (_config.style.sliderColor);

        }

        override protected function get barCornerRadius():Number{

            if (isNaN(_config.style.scrubberBorderRadius)){

                return (super.barCornerRadius);

            };

            return (_config.style.scrubberBorderRadius);

        }

        override protected function onMouseDown(_arg1:MouseEvent):void{

            this.stop();

            super.onMouseDown(_arg1);

        }



    }

}//package org.flowplayer.controls.slider 

﻿package org.flowplayer.controls.slider {

    import org.flowplayer.controls.config.*;

    import flash.events.*;

    import org.flowplayer.view.*;

    import org.flowplayer.controls.button.*;

    import flash.display.*;

    import org.flowplayer.controls.*;

    import flash.utils.*;

    import org.flowplayer.util.*;



    public class AbstractSlider extends AbstractSprite {



        public static const DRAG_EVENT:String = "onDrag";



        protected var _dragger:DraggerButton;

        private var _dragTimer:Timer;

        private var _previousDragEventPos:Number;

        protected var _config:Config;

        private var _animationEngine:AnimationEngine;

        private var _currentPos:Number;

        private var _tooltip:ToolTip;

        private var _tooltipTextFunc:Function;

        private var _controlbar:DisplayObject;

        private var _mouseOver:Boolean;

        private var _border:Sprite;



        public function AbstractSlider(_arg1:Config, _arg2:AnimationEngine, _arg3:DisplayObject){

            this._config = _arg1;

            this._animationEngine = _arg2;

            this._controlbar = _arg3;

            this._dragTimer = new Timer(50);

            this.createDragger();

            this.toggleTooltip();

            addEventListener(Event.ADDED_TO_STAGE, this.onAddedToStage);

            addEventListener(MouseEvent.ROLL_OVER, this.onMouseOver);

            addEventListener(MouseEvent.ROLL_OUT, this.onMouseOut);

        }

        private function onMouseMove(_arg1:MouseEvent):void{

            if (!this._mouseOver){

                return;

            };

            var _local2:String = this.tooltipText;

            if (!this.tooltipText){

                this._tooltip.hide();

            } else {

                if (this._tooltip.visible){

                    this.showTooltip();

                } else {

                    this._tooltip.text = this.tooltipText;

                };

            };

        }

        private function get tooltipText():String{

            if (this._tooltipTextFunc == null){

                return (null);

            };

            return (this._tooltipTextFunc((((mouseX - (this._dragger.width / 2)) / (width - this._dragger.width)) * 100)));

        }

        protected function onMouseOut(_arg1:MouseEvent=null):void{

            log.debug("onMouseOut");

            this.hideTooltip();

            this._mouseOver = false;

            removeEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

        }

        protected function onMouseOver(_arg1:MouseEvent):void{

            log.debug("onMouseOver");

            this.showTooltip();

            this._mouseOver = true;

            addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove);

        }

        protected function hideTooltip():void{

            this._tooltip.hide();

        }

        protected function showTooltip():void{

            if (this.tooltipText){

                this._tooltip.show(this, this.tooltipText, true);

            };

        }

        private function toggleTooltip():void{

            if (this.isToolTipEnabled()){

                if (((this._tooltip) && ((this._tooltip is DefaultToolTip)))){

                    return;

                };

                log.debug("enabling tooltip");

                this._tooltip = new DefaultToolTip(this._config, this._animationEngine);

            } else {

                log.debug("tooltip disabled");

                this._tooltip = new NullToolTip();

            };

        }

        protected function isToolTipEnabled():Boolean{

            return (false);

        }

        public function set enabled(_arg1:Boolean):void{

            log.debug(("setting enabled to " + _arg1));

            this._dragTimer.addEventListener(TimerEvent.TIMER, this.dragging);

            var _local2:String = (_arg1) ? "addEventListener" : "removeEventListener";

            var _local3 = this;

            _local3[_local2](MouseEvent.MOUSE_UP, this.onMouseUp);

            _local3 = this._dragger;

            _local3[_local2](MouseEvent.MOUSE_DOWN, this.onMouseDown);

            _local3 = this._dragger;

            _local3[_local2](MouseEvent.MOUSE_UP, this.onMouseUp);

            _local3 = stage;

            _local3[_local2](MouseEvent.MOUSE_UP, this.onMouseUpStage);

            _local3 = stage;

            _local3[_local2](Event.MOUSE_LEAVE, this.onMouseLeaveStage);

            this.toggleClickListeners(_arg1);

            alpha = (_arg1) ? 1 : 0.5;

            this._dragger.buttonMode = _arg1;

        }

        public function get enabled():Boolean{

            return (this._dragger.buttonMode);

        }

        private function onAddedToStage(_arg1:Event):void{

            this.enabled = true;

        }

        private function toggleClickListeners(_arg1:Boolean):void{

            var _local2:Array = this.getClickTargets(_arg1);

            log.debug("click targets", _local2);

            var _local3:Number = 0;

            while (_local3 < _local2.length) {

                if (_arg1){

                    EventDispatcher(_local2[_local3]).addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown);

                } else {

                    EventDispatcher(_local2[_local3]).removeEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown);

                };

                if (_local2[_local3].hasOwnProperty("buttonMode")){

                    _local2[_local3]["buttonMode"] = _arg1;

                };

                _local3++;

            };

        }

        protected function getClickTargets(_arg1:Boolean):Array{

            return ([this]);

        }

        protected function createDragger():void{

            this._dragger = new DraggerButton(this._config, this._animationEngine);

            this._dragger.buttonMode = true;

            addChild(this._dragger);

        }

        private function onMouseUpStage(_arg1:MouseEvent):void{

            if (this._dragTimer.running){

                this.onMouseUp();

            };

            this._dragTimer.stop();

        }

        private function onMouseLeaveStage(_arg1:Event):void{

            this._tooltip.hide();

            if (this._dragTimer.running){

                this.onMouseUp();

            };

            this._dragTimer.stop();

        }

        protected function onMouseUp(_arg1:MouseEvent=null):void{

            log.debug("onMouseUp");

            if (((_arg1) && (!((_arg1.target == this))))){

                return;

            };

            if (((!(this.canDragTo(mouseX))) && ((this._dragger.x > 0)))){

                return;

            };

            this._dragTimer.stop();

            this.dragging();

            this.updateCurrentPosFromDragger();

            if (!this.dispatchOnDrag){

                this.dispatchDragEvent();

            };

        }

        protected function canDragTo(_arg1:Number):Boolean{

            return (true);

        }

        private function updateCurrentPosFromDragger():void{

            this._currentPos = ((this._dragger.x / (width - this._dragger.width)) * 100);

        }

        final protected function get isDragging():Boolean{

            return (this._dragTimer.running);

        }

        protected function onMouseDown(_arg1:MouseEvent):void{

            if (!(_arg1.target) == this){

                return;

            };

            this._dragTimer.start();

        }

        private function dragging(_arg1:TimerEvent=null):void{

            var _local2:Number = (mouseX - (this._dragger.width / 2));

            if (_local2 < 0){

                _local2 = 0;

            };

            if (_local2 > this.maxDrag){

                _local2 = this.maxDrag;

            };

            this._dragger.x = _local2;

            if (Math.abs((this._previousDragEventPos - this._dragger.x)) < 1){

                return;

            };

            this._previousDragEventPos = this._dragger.x;

            if (this.dispatchOnDrag){

                this.updateCurrentPosFromDragger();

                this.dispatchDragEvent();

            };

        }

        private function dispatchDragEvent():void{

            log.debug("dispatching drag event");

            this.onDispatchDrag();

            dispatchEvent(new Event(DRAG_EVENT));

        }

        protected function get dispatchOnDrag():Boolean{

            return (true);

        }

        protected function onDispatchDrag():void{

        }

        function get maxDrag():Number{

            return ((width - this._dragger.width));

        }

        public function get value():Number{

            return (this._currentPos);

        }

        final public function set value(_arg1:Number):void{

            if (_arg1 > 100){

                _arg1 = 100;

            };

            this._currentPos = _arg1;

            this.onSetValue();

        }

        protected function onSetValue():void{

        }

        protected function get allowSetValue():Boolean{

            return (true);

        }

        override protected function onResize():void{

            log.debug("onResize");

            super.onResize();

            this._dragger.height = height;

            this._dragger.scaleX = this._dragger.scaleY;

            this.drawBackground();

            this.drawBorder();

        }

        private function drawBackground():void{

            graphics.clear();

            graphics.beginFill(this.sliderColor, this.sliderAlpha);

            graphics.drawRoundRect(0, ((height / 2) - (this.barHeight / 2)), width, this.barHeight, this.barCornerRadius, this.barCornerRadius);

            graphics.endFill();

            if (this.sliderGradient){

                GraphicsUtil.addGradient(this, 1, this.sliderGradient, this.barCornerRadius, 0, ((height / 2) - (this.barHeight / 2)), this.barHeight);

            };

        }

        private function drawBorder():void{

            if (((this._border) && ((this._border.parent == this)))){

                removeChild(this._border);

            };

            if (!(this.borderWidth) > 0){

                return;

            };

            this._border = new Sprite();

            addChild(this._border);

            swapChildren(this._border, this._dragger);

            log.info(((((("border weight is " + this.borderWidth) + ", color is ") + String(this.borderColor)) + ", alpha ") + String(this.borderAlpha)));

            this._border.graphics.lineStyle(this.borderWidth, this.borderColor, this.borderAlpha);

            GraphicsUtil.drawRoundRectangle(this._border.graphics, 0, ((height / 2) - (this.barHeight / 2)), width, this.barHeight, this.barCornerRadius);

        }

        protected function get borderWidth():Number{

            return (0);

        }

        protected function get borderColor():Number{

            return (0xFFFFFF);

        }

        protected function get borderAlpha():Number{

            return (0);

        }

        protected function get barCornerRadius():Number{

            return ((this.barHeight / 1.5));

        }

        protected function get sliderGradient():Array{

            return (null);

        }

        protected function get sliderColor():Number{

            return (0);

        }

        protected function get sliderAlpha():Number{

            return (1);

        }

        protected function get barHeight():Number{

            return (height);

        }

        protected function drawBar(_arg1:Sprite, _arg2:Number, _arg3:Number, _arg4:Array, _arg5:Number, _arg6:Number):void{

            _arg1.graphics.clear();

            if (_arg5 > _arg6){

                return;

            };

            _arg1.scaleX = 1;

            _arg1.graphics.beginFill(_arg2, _arg3);

            _arg1.graphics.drawRoundRect(_arg5, ((height / 2) - (this.barHeight / 2)), (_arg6 - _arg5), this.barHeight, this.barCornerRadius, this.barCornerRadius);

            _arg1.graphics.endFill();

            if (_arg4){

                GraphicsUtil.addGradient(_arg1, 0, _arg4, this.barCornerRadius, _arg5, ((height / 2) - (this.barHeight / 2)), this.barHeight);

            } else {

                GraphicsUtil.removeGradient(_arg1);

            };

        }

        final protected function get animationEngine():AnimationEngine{

            return (this._animationEngine);

        }

        public function redraw(_arg1:Config):void{

            this._config = _arg1;

            this.drawBackground();

            this.drawBorder();

            this.toggleTooltip();

            this._tooltip.redraw(_arg1);

        }

        public function set tooltipTextFunc(_arg1:Function):void{

            this._tooltipTextFunc = _arg1;

        }



    }

}//package org.flowplayer.controls.slider 

﻿package org.flowplayer.controls.slider {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import flash.display.*;



    public class VolumeSlider extends AbstractSlider {



        public static const DRAG_EVENT:String = "onDrag";



        private var _volumeBar:Sprite;



        public function VolumeSlider(_arg1:Config, _arg2:AnimationEngine, _arg3:DisplayObject){

            var config:* = _arg1;

            var animationEngine:* = _arg2;

            var controlbar:* = _arg3;

            super(config, animationEngine, controlbar);

            tooltipTextFunc = function (_arg1:Number):String{

                if (_arg1 > 100){

                    return ("100%");

                };

                if (_arg1 < 0){

                    return ("0%");

                };

                return ((Math.round(_arg1) + "%"));

            };

            this.createBars();

        }

        override public function get name():String{

            return ("volume");

        }

        private function createBars():void{

            this._volumeBar = new Sprite();

            addChild(this._volumeBar);

            swapChildren(_dragger, this._volumeBar);

        }

        override public function redraw(_arg1:Config):void{

            super.redraw(_arg1);

            this.onSetValue();

        }

        override protected function onSetValue():void{

            var _local1:Number = ((value / 100) * (width - _dragger.width));

            animationEngine.animateProperty(_dragger, "x", _local1, 200);

            drawBar(this._volumeBar, this.volumeColor, this.volumeAlpha, _config.style.bufferGradient, 0, (_local1 + (_dragger.width / 2)));

        }

        override protected function isToolTipEnabled():Boolean{

            return (((_config.tooltips) && (_config.tooltips.volume)));

        }

        override protected function get barHeight():Number{

            log.debug(("bar height ratio is " + _config.style.volumeSliderHeightRatio));

            return ((height * _config.style.volumeBarHeightRatio));

        }

        override protected function get sliderGradient():Array{

            return (_config.style.volumeSliderGradient);

        }

        override protected function get sliderColor():Number{

            return (_config.style.volumeSliderColor);

        }

        override protected function get sliderAlpha():Number{

            return (_config.style.volumeSliderAlpha);

        }

        override protected function get borderWidth():Number{

            return (_config.style.volumeBorderWidth);

        }

        override protected function get borderColor():Number{

            return (_config.style.volumeBorderColor);

        }

        override protected function get borderAlpha():Number{

            return (_config.style.volumeBorderAlpha);

        }

        protected function get volumeColor():Number{

            if (((isNaN(_config.style.volumeColor)) || ((_config.style.volumeColor == -2)))){

                return (this.sliderColor);

            };

            return (_config.style.volumeColor);

        }

        protected function get volumeAlpha():Number{

            if (((isNaN(_config.style.volumeAlpha)) || ((_config.style.volumeAlpha == -2)))){

                return (this.sliderAlpha);

            };

            return (_config.style.volumeAlpha);

        }

        override protected function get barCornerRadius():Number{

            if (isNaN(_config.style.volumeBorderRadius)){

                return (super.barCornerRadius);

            };

            return (_config.style.volumeBorderRadius);

        }



    }

}//package org.flowplayer.controls.slider 

﻿package org.flowplayer.controls.slider {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import org.flowplayer.controls.button.*;

    import flash.display.*;

    import org.flowplayer.util.*;



    public class Scrubber extends AbstractSprite {



        public static const DRAG_EVENT:String = AbstractSlider.DRAG_EVENT;



        private var _scrubber:ScrubberSlider;

        private var _controlbar:DisplayObject;

        private var _config:Config;

        private var _leftEdge:DisplayObject;

        private var _bottomEdge:DisplayObject;

        private var _rightEdge:DisplayObject;

        private var _topEdge:DisplayObject;



        public function Scrubber(_arg1:Config, _arg2:AnimationEngine, _arg3:DisplayObject){

            this._config = _arg1;

            this._controlbar = _arg3;

            this._leftEdge = addChild(SkinClasses.getScrubberLeftEdge());

            this._bottomEdge = addChild(SkinClasses.getScrubberBottomEdge());

            this._topEdge = addChild(SkinClasses.getScrubberTopEdge());

            this._rightEdge = addChild(SkinClasses.getScrubberRightEdge());

            addChild(this._bottomEdge);

            this._scrubber = new ScrubberSlider(_arg1, _arg2, _arg3);

            addChild(this._scrubber);

        }

        public function setRightEdgeWidth(_arg1:Number):void{

            log.debug(("setRightEdgeWidth() " + _arg1));

            this._rightEdge.width = _arg1;

        }

        override public function addEventListener(_arg1:String, _arg2:Function, _arg3:Boolean=false, _arg4:int=0, _arg5:Boolean=false):void{

            if (_arg1 == DRAG_EVENT){

                this._scrubber.addEventListener(_arg1, _arg2, _arg3, _arg4, _arg5);

            } else {

                super.addEventListener(_arg1, _arg2, _arg3, _arg4, _arg5);

            };

        }

        override protected function onResize():void{

            this._leftEdge.height = ((height - this._topEdge.height) - this._bottomEdge.height);

            this._leftEdge.x = 0;

            this._leftEdge.y = this._topEdge.height;

            this._rightEdge.height = ((height - this._topEdge.height) - this._bottomEdge.height);

            this._rightEdge.x = (width - this._rightEdge.width);

            this._rightEdge.y = this._topEdge.height;

            this._scrubber.x = this._leftEdge.width;

            this._scrubber.setSize(((width - this._leftEdge.width) - this._rightEdge.width), ((height - this._bottomEdge.height) * this._config.style.scrubberHeightRatio));

            Arrange.center(this._scrubber, 0, height);

            this._bottomEdge.y = (height - this._bottomEdge.height);

            this._bottomEdge.width = width;

            this._topEdge.y = 0;

            this._topEdge.width = width;

        }

        override public function get name():String{

            return ("scrubber");

        }

        public function set allowRandomSeek(_arg1:Boolean):void{

            this._scrubber.allowRandomSeek = _arg1;

        }

        public function setBufferRange(_arg1:Number, _arg2:Number):void{

            this._scrubber.setBufferRange(_arg1, _arg2);

        }

        public function redraw(_arg1:Config):void{

            this.onResize();

            this._scrubber.redraw(_arg1);

        }

        public function set enabled(_arg1:Boolean):void{

            this._scrubber.enabled = _arg1;

        }

        public function get enabled():Boolean{

            return (this._scrubber.enabled);

        }

        public function get value():Number{

            return (this._scrubber.value);

        }

        final public function set value(_arg1:Number):void{

            this._scrubber.value = _arg1;

        }

        public function set tooltipTextFunc(_arg1:Function):void{

            this._scrubber.tooltipTextFunc = _arg1;

        }



    }

}//package org.flowplayer.controls.slider 

﻿package org.flowplayer.controls.slider {

    import org.flowplayer.controls.config.*;

    import org.flowplayer.view.*;

    import org.flowplayer.controls.button.*;

    import flash.display.*;

    import org.flowplayer.util.*;



    public class VolumeScrubber extends AbstractSprite {



        public static const DRAG_EVENT:String = AbstractSlider.DRAG_EVENT;



        private var _scrubber:VolumeSlider;

        private var _leftEdge:DisplayObject;

        private var _controlbar:DisplayObject;

        private var _config:Config;

        private var _bottomEdge:DisplayObject;

        private var _topEdge:DisplayObject;

        private var _rightEdge:DisplayObject;



        public function VolumeScrubber(_arg1:Config, _arg2:AnimationEngine, _arg3:DisplayObject){

            log.debug("creating VolumeScrubber");

            this._config = _arg1;

            this._controlbar = _arg3;

            this._leftEdge = addChild(SkinClasses.getVolumeLeft());

            this._bottomEdge = addChild(SkinClasses.getVolumeBottom());

            this._topEdge = addChild(SkinClasses.getVolumeTop());

            this._rightEdge = addChild(SkinClasses.getVolumeRight());

            this._scrubber = new VolumeSlider(_arg1, _arg2, _arg3);

            addChild(this._scrubber);

        }

        override public function addEventListener(_arg1:String, _arg2:Function, _arg3:Boolean=false, _arg4:int=0, _arg5:Boolean=false):void{

            if (_arg1 == DRAG_EVENT){

                this._scrubber.addEventListener(_arg1, _arg2, _arg3, _arg4, _arg5);

            } else {

                super.addEventListener(_arg1, _arg2, _arg3, _arg4, _arg5);

            };

        }

        override protected function onResize():void{

            this._leftEdge.height = height;

            this._leftEdge.x = 0;

            this._leftEdge.y = 0;

            this._scrubber.x = this._leftEdge.width;

            this._scrubber.setSize(((width - this._leftEdge.width) - this._rightEdge.width), (height * this._config.style.volumeSliderHeightRatio));

            Arrange.center(this._scrubber, 0, height);

            this._bottomEdge.y = (height - this._bottomEdge.height);

            this._bottomEdge.width = width;

            this._topEdge.width = width;

            this._rightEdge.x = (width - this._rightEdge.width);

            this._rightEdge.height = height;

        }

        override public function get name():String{

            return ("volume");

        }

        public function redraw(_arg1:Config):void{

            this._scrubber.redraw(_arg1);

        }

        public function set enabled(_arg1:Boolean):void{

            this._scrubber.enabled = _arg1;

        }

        public function get value():Number{

            return (this._scrubber.value);

        }

        final public function set value(_arg1:Number):void{

            this._scrubber.value = _arg1;

        }

        public function set tooltipTextFunc(_arg1:Function):void{

            this._scrubber.tooltipTextFunc = _arg1;

        }



    }

}//package org.flowplayer.controls.slider 

﻿package fp {

    import flash.display.*;



    public dynamic class ButtonBottomEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class TimeRightEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class UnMuteButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class TimeLeftEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ScrubberLeftEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ScrubberBottomEdge extends MovieClip {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class TimeBottomEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ScrubberTopEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ButtonTopEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class SlowMotionBwdButton extends MovieClip {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ButtonRightEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class SlowMotionFBwdButton extends MovieClip {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class PrevButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class VolumeLeftEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class SlowMotionFwdButton extends MovieClip {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class MuteButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class VolumeTopEdge extends MovieClip {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class StopButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class FullScreenOnButton extends MovieClip {



        public var mOver:MovieClip;



        public function FullScreenOnButton(){

            addFrameScript(9, frame10);

        }

        function frame10(){

            stop();

        }



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class VolumeRightEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ScrubberRightEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class SlowMotionFFwdButton extends MovieClip {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class PlayButton extends MovieClip {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class Dragger extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class VolumeBottomEdge extends MovieClip {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class NextButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class ButtonLeftEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class TimeTopEdge extends Sprite {



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class FullScreenOffButton extends MovieClip {



        public var mOver:MovieClip;



        public function FullScreenOffButton(){

            addFrameScript(9, frame10);

        }

        function frame10(){

            stop();

        }



    }

}//package fp 

﻿package fp {

    import flash.display.*;



    public dynamic class PauseButton extends Sprite {



        public var mOver:MovieClip;



    }

}//package fp