/**
 * Copyright beginners_high ( http://wonderfl.net/user/beginners_high )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s27s
 */

// forked from 9re's 車が動くアニメーション
package {
    import flash.display.Sprite;
    import flash.events.Event;
    


     public class AnimationExample extends Sprite
    {
        // 車のクラス
        //　★「private」はクラスの内部でのみ扱える。ローカル感。varやfunctionの前につける
        private var _car:Car;　//　★「pravate」関数の名前には最初に「_」をつけて分類をわかりやすく
        private var _car2:Car;
        //　★「public」はクラスの外に提供している。グローバル感。varやfunctionの前につける
        public function AnimationExample() 
        {
            // 車のクラスのインスタンスを作る
            // 色は赤にする
            _car = new Car(0x2010dc);　//★キミの青い車で～
            _car.putGas(70)        // ガソリンを50入れる　★70にしちゃった
            _car.y = 260;          // 車のy座標を200に　★260にしちゃった
            addChild(_car);        // 表示リストに追加

            _car2 = new Car(0xd00000);
            _car2.putGas(50)        // ガソリンを50入れる
            _car2.y = 200;          // 車のy座標を200に
            addChild(_car2);        // 表示リストに追加
            
            // 1フレーム毎に実行する処理にmoveCarを追加する
            addEventListener(Event.ENTER_FRAME, moveCar);
        }
        
        private function moveCar(e:Event):void 
        {
            _car.move();           // 車を動かす
            _car2.move()
        }
    }
}

//★ここから　Carクラス

import flash.display.Sprite;

class Car extends  Sprite {
    // ガソリンの量最初は入っていない = 0
    private var _gas:int = 0;
    
    // コンストラクタ
    //　★【＠wikipe】新たなオブジェクトを生成する際に呼び出され、内容の初期化などを行なう関数、メソッド。
    //　★ ここでは、車インスタンスを作るにあたりまず描画するメソッドだから、らしい。そう書けよコーダー脳め。
    // 製造時に車の色は決まる
    public function Car(_fillColor:uint) {
        // 描画
        _draw(_fillColor);
    }
    
    // ガソリンを入れる。
    public function putGas(_amount:int):void {
        if (_amount < 0) {     // もしガソリンの量が0以下だったら
            return;            // 何もしないで、ここで終了
        }
        
        _gas += _amount;       // $amountだけ_gasの量を増やす
    }
    
    // 車を動かす
    public function move():void {
        if (_gas > 10) {        // ガスの残量が10より大きい場合
            x += 5 + (80/_gas);             // x座標を5だけ増やす　★残量が少ないほど加速させてみた
        } else {                // ガスの量が10以下の場合
            x += 2- _gas * 0.6;      // 残りのガスの量によって動きが変わる　★いろいろいじって変なうごきになった
        }
        
        _gas--;                 // 車が動くとガスは減る
        if (_gas < 0) {         // もしガスの量が0より小さいなら
            _gas = 0;           // ガスの量を0にセットする
        }                       // ガスの量はマイナスにはならない

        // ★せっかくなので、画面外に出た後は戻ってきて適当にループ
        if (x > 550){
            x=　0;
            y= 425 * Math.random();
            _gas += 20+(45 * Math.random());
            } 
            
    }
    
    // 描画メソッド。privateなので外からは見えない
    // 車の形や色は製造される時に決まってしまうので外部からは
    // 呼べない 
    //★これ、色を引数に使う意味は何なんだろう？
    private function _draw(_fillColor:uint):void
    {
        // 車輪を書く
        graphics.beginFill(0x333333);
        graphics.drawCircle(10, 20, 5);
        graphics.drawCircle(45, 20, 5);
        graphics.endFill();
        // 車体を書く
        graphics.beginFill(_fillColor);
        graphics.moveTo(0, 10);
        graphics.lineTo(15, 0);
        graphics.lineTo(30, 0);
        graphics.lineTo(40, 10);
        graphics.lineTo(50, 10);
        graphics.lineTo(55, 15);
        graphics.lineTo(55, 20);
        graphics.lineTo(0, 20);
        graphics.endFill();
    }
}
