/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s1fm
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;

    public class FlashTest extends Sprite {

        private var _bmp:Bitmap;
        private var _bmpData:BitmapData;
        private var _bearTickles:Vector.<BearTickle>;
        
        private static const targetX:int = 30;
        private static const targetY:int = 20;
        
        public function FlashTest() {
            // write as3 code here..
            _bmpData = new BitmapData(500, 300);
            addChild(_bmp = new Bitmap(_bmpData));
            
            stage.addEventListener(Event.ENTER_FRAME, frameUpdate);
            
            _bearTickles = new Vector.<BearTickle>();
            for(var i:int = 0;i<3000;++i) {
                _bearTickles.push(new BearTickle(_bmp.width, _bmp.height));
            }
        }
        
        private function frameUpdate(e:Event):void 
        {
            try {
            const l:int = _bearTickles.length;
            _bmpData.lock();
            _bmpData.fillRect(new Rectangle(0,0,_bmp.width,_bmp.height), 0xFFFFFFFF);
            for(var i:int=0;i<l;i++) {
                var bearTickle:BearTickle = _bearTickles[i];
                const x:int = targetX+(bearTickle.xStart-targetX)*Math.sin(bearTickle.distance) + bearTickle.explodeX * Math.sin(bearTickle.distance);
                const y:int = targetY+(bearTickle.yStart-targetY)*Math.sin(bearTickle.distance) + bearTickle.explodeY * Math.sin(bearTickle.distance);
                bearTickle.distance -= 0.01;
                if(bearTickle.distance < 0) {
                    bearTickle.distance = 0;
                }
                _bmpData.setPixel(int(x), int(y), 0xFFFF0000);
            }
            trace(_bearTickles[0].explodeX)
            _bmpData.unlock();
            _bmp.bitmapData = _bmpData;
            } catch(e:Error) {
                trace(e);
            }

        }

    }
}

final class BearTickle {
    public var xStart:Number;
    public var yStart:Number;
    public var distance:Number = 1.0;
    public var explodeX:Number;
    public var explodeY:Number; 
    public function BearTickle(width:Number, height:Number) {
        this.xStart = width * Math.random();
        this.yStart = height * Math.random();
        var explodePower:Number = 20+30*Math.random();
        var angle:Number = 2*Math.PI*Math.random();
        explodeX = Math.cos(angle)*explodePower;
        explodeY = Math.sin(angle)*explodePower;
    }

}

const trace:* = Wonderfl.log;