/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s0bw
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.ui.*;

  public class MeasureBrightness extends Sprite {
    private var arduino:Arduino;

    // 光センサに接続したピン（A0）
    private var sensorPin:Pin;

    // LED（D9ピンに接続）
    private var led:LED;

    public function MeasureBrightness() {
      // LEDに接続したピンのモードをPWMにセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, PWM);
      arduino = new Arduino(config);

      // 光センサとLEDを表す変数を初期化
      sensorPin = arduino.analogPin(0);
      led = new LED(arduino.digitalPin(9));

      // 0〜1の入力を1〜0の出力に変換するスケーラをセット
      sensorPin.addFilter(new Scaler(0, 1, 1, 0));

      // 光センサの値が変化した時に発生するイベントに対してリスナをセット
      sensorPin.addEventListener(PinEvent.CHANGE, onChange);
    }

    // 光センサの値が変化したら以下を実行
    private function onChange(e:PinEvent):void {
      // LEDの輝度を光センサの値に応じてセット
      led.intensity = sensorPin.value;
    }
  }
}
