/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/s0Jf
 */

package  
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	public class Bomb extends Sprite
	{
		private var w:int = 10;
		private var h:int = 10;
		private var numBomb:int = 20;
		private var data:Vector.<Vector.<Cell>>;//0未探索
		private var vw:int = 25;
		public function Bomb() 
		{
			data = new Vector.<Vector.<Cell>>;
			for (var x:int = 0; x < w;x++ ) {
				data[x] = new Vector.<Cell>;
				for (var y:int = 0; y < h; y++ ) {
					var cell:Cell = new Cell;
					cell.tf.width = cell.tf.height = vw-1;
					var tfm:TextFormat = new TextFormat;
					tfm.align = TextFormatAlign.CENTER;
					cell.tf.selectable = cell.tf.mouseWheelEnabled = false;
					cell.tf.background = true;
					cell.tf.defaultTextFormat = tfm;
					addChild(cell.tf);
					cell.tf.x = x * vw;
					cell.tf.y = y * vw;
					cell.x = x;
					cell.y = y;
					data[x][y] = cell;
				}
			}
			var count:int = 0;
			while (count<numBomb) {
				var i:int = Math.random() * w * h;
				x = i % w;
				y = i / w;
				cell = data[x][y];
				if (!cell.isHaveBomb) {
					cell.isHaveBomb = true;
					count++;
				}
			}
			for (x = 0; x < w;x++ ) {
				for (y = 0; y < h; y++ ) {
					cell = data[x][y];
					for (var ax:int = -1; ax < 2;ax++ ) {
						for (var ay:int = -1; ay < 2; ay++ ) {
							var acell:Cell = getCell(x + ax, y + ay);
							if (acell&&acell!=cell) {
								cell.aronds.push(acell);
								if (acell.isHaveBomb) cell.numBombAround++;
								update(cell);
							}
						}
					}
				}
			}
			stage.addEventListener(MouseEvent.CLICK, stage_click);
		}
		
		private function stage_click(e:MouseEvent):void 
		{
			var x:int = mouseX / vw;
			var y:int = mouseY / vw;
			hit(getCell(x, y));
		}
		
		private function hit(cell:Cell):void {
			if (cell&&!cell.hited) {
				cell.hited = true;
				if (cell.numBombAround==0) {
					for each(var acell:Cell in cell.aronds) {
						hit(acell);
					}
				}
				update(cell);
			}
		}
		
		private function getCell(x:int, y:int):Cell {
			if (x<0||x>=data.length) {
				return null;
			}
			if (y<0||y>=data[x].length) {
				return null;
			}
			return data[x][y];
		}
		
		private function update(cell:Cell):void {
			if (!cell.hited) {
				cell.tf.text = "";
				cell.tf.backgroundColor = 0x999999;
			}else {
				if (cell.isHaveBomb) {
					cell.tf.text = "*";
					cell.tf.backgroundColor = 0xff0000;
				}else {
					if (cell.numBombAround == 0) {
						cell.tf.text = "";
						cell.tf.backgroundColor = 0xaa00;
					}else {
						cell.tf.text = cell.numBombAround + "";
						cell.tf.backgroundColor = 0xff00;
					}
				}
			}
		}
		
	}

}
import flash.text.TextField;

class Cell {
	public var tf:TextField = new TextField;
	public var x:int = 0;
	public var y:int = 0;
	public var hited:Boolean = false;
	public var numBombAround:int = 0;
	public var isHaveBomb:Boolean = false;
	public var aronds:Vector.<Cell> = new Vector.<Cell>;
}