/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rztl
 */

package

{

    import flash.display.Sprite;

    import flash.events.Event;



    import org.papervision3d.cameras.Camera3D;

    import org.papervision3d.events.InteractiveScene3DEvent;

    import org.papervision3d.materials.special.Letter3DMaterial;

    import org.papervision3d.render.BasicRenderEngine;

    import org.papervision3d.scenes.Scene3D;

    import org.papervision3d.typography.Text3D;

    import org.papervision3d.typography.VectorLetter3D;

    import org.papervision3d.typography.fonts.HelveticaMedium;

    import org.papervision3d.view.Viewport3D;



    public class Papervision3DText3D extends Sprite

    {

        private var scene    :Scene3D;

        private var camera   :Camera3D;

        private var viewport :Viewport3D;

        private var renderer :BasicRenderEngine;

        private var material :Letter3DMaterial

        private var text     :Text3D;



        public function Papervision3DText3D()

        {

            scene = new Scene3D();



            camera   = new Camera3D();

            camera.z = -250;



            viewport                  = new Viewport3D();

            viewport.autoScaleToStage = true;

            viewport.interactive      = true;

            addChild(viewport);



            renderer = new BasicRenderEngine();



            material             = new Letter3DMaterial(0x000000, 0.5);

            material.doubleSided = true;

            material.interactive = true;



            text = new Text3D("Papervision3D", new HelveticaMedium(), material);

            scene.addChild(text);



            for each(var letter:VectorLetter3D in text.letters) {

                letter.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, handleObjectOver);

                letter.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, handleObjectOut);

                letter.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, handleObjectPress);

            }



            addEventListener(Event.ENTER_FRAME, handleEnterFrame);

        }



        private function handleEnterFrame(e:Event):void

        {

            text.yaw(1);



            renderer.renderScene(scene, camera, viewport);

        }



        private function handleObjectOver(e:InteractiveScene3DEvent):void

        {

            viewport.containerSprite.buttonMode = true;

        }



        private function handleObjectOut(e:InteractiveScene3DEvent):void

        {

            viewport.containerSprite.buttonMode = false;

        }



        private function handleObjectPress(e:InteractiveScene3DEvent):void

        {

            material.fillColor = Math.random() * 0xFFFFFF;

        }

    }

}