/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rzQZ
 */

// forked from beinteractive's 9. Physical tween with BetweenAS3
package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	
	public class Sample extends Sprite
	{
		public function Sample()
		{
			var box1:Box = addNewBox(25);
			var box15:Box = addNewBox(75);
			var box17:Box = addNewBox(125);
			var box2:Box = addNewBox(250);
			var box25:Box = addNewBox(300); 
			var box3:Box = addNewBox(400);
			var box35:Box = addNewBox(450); 
			
			// Create a tween
			_t = BetweenAS3.parallel(
				 BetweenAS3.physical(box1, {x: 400}, null, Physical.uniform(10.0)),//一定の速度で
				 BetweenAS3.to(box15,{x:400},1.0), 
			     BetweenAS3.tween(box17,{x:400},null,1.0),
			    //初速度、加速度を指定
				 BetweenAS3.physical(box2, {x: 400}, null, Physical.accelerate(2.5, 1.0)), 
				 BetweenAS3.physical(box25,{x:400}, null,Physical.accelerate(1.0,2.5)),			
				//指数関数
				 BetweenAS3.physical(box3, {x: 400}, null, Physical.exponential(0.1)),
				 BetweenAS3.physical(box35, {x: 400}, null, Physical.exponential(0.4))
			);
			
			
			// Set to be never stop
			_t.stopOnComplete = false;
			
			// Start the tween
			_t.play();
			
			// MouseUp listener
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		
		private var _t:ITween;
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			// Stop the tween if playing
			// Start the tween if stopping
			_t.togglePause();
			
			// Note: You can use gotoAndPlay(time) or gotoAndStop(time) too.
		}
		
		private function addNewBox(y:Number):Box
		{
			var box:Box = new Box();
			box.x = 20;
			box.y = y;
			addChild(box);
			return box;
		}
	}
}

import flash.display.Sprite;

internal class Box extends Sprite
{
	public function Box()
	{
		graphics.beginFill(0);
		graphics.drawRect(-10, -10, 20, 20);
		graphics.endFill();
	}
}