/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rz3s
 */

package {
    import flash.display.Sprite;
    import flash.display.GraphicsPathCommand;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;

    [SWF(width = 465, height = 465, backgroundColor = 0xcccccc, frameRate = 30)]

    public class StarButton extends Sprite {
        private var colorIndex:int = 0;
        
        public function StarButton() {
            var button:Sprite = createButton();
            button.x = 10;
            button.y = 10;
            this.stage.addChild(button);
            button.addEventListener(MouseEvent.CLICK, onMouseClickHandler);
        }
        
        private function onMouseClickHandler(event:MouseEvent):void 
	{
		var button:Sprite = event.target as Sprite;
		button.transform.colorTransform = new ColorTransform(1, 1, 1, 1,
                    (colorIndex % 3 == 0)? 255: 0,
                    (colorIndex % 3 == 1)? 255: 0,
                    (colorIndex % 3 == 2)? 255: 0);
                colorIndex++;
	}

        
	public function createButton():Sprite
	{
		var commands:Vector.<int>=new Vector.<int>();
		commands.push(GraphicsPathCommand.MOVE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);
		commands.push(GraphicsPathCommand.LINE_TO);

                var index:int = -1;
		var data:Vector.<Number> = new Vector.<Number>();
		data.push(100,0);
                var r:Number = 0.4523806965569285;
		var t:Number = Math.PI * -3.0 / 10.0;
		data.push((1 + Math.cos(t) * r) * 100, (1 + Math.sin(t) * r) * 100);
		t = Math.PI * -1.0 / 10.0;
		data.push((1 + Math.cos(t)) * 100, (1 + Math.sin(t)) * 100);
		t = Math.PI * 1.0 / 10.0;
		data.push((1 + Math.cos(t) * r) * 100, (1 + Math.sin(t) * r) * 100);
		t = Math.PI * 3.0 / 10.0;
		data.push((1 + Math.cos(t)) * 100, (1 + Math.sin(t)) * 100);
		t = Math.PI * 5.0 / 10.0;
		data.push((1 + Math.cos(t) * r) * 100, (1 + Math.sin(t) * r) * 100);
		t = Math.PI * 7.0 / 10.0;
		data.push((1 + Math.cos(t)) * 100, (1 + Math.sin(t)) * 100);
		t = Math.PI * 9.0 / 10.0;
		data.push((1 + Math.cos(t) * r) * 100, (1 + Math.sin(t) * r) * 100);
		t = Math.PI * 11.0 / 10.0;
		data.push((1 + Math.cos(t)) * 100, (1 + Math.sin(t)) * 100);
		t = Math.PI * 13.0 / 10.0;
		data.push((1 + Math.cos(t) * r) * 100, (1 + Math.sin(t) * r) * 100);
		data.push(100,0);
		
		var button:Sprite = new Sprite();
		button.graphics.lineStyle(5, 0xFFFFFF);
		button.graphics.beginGradientFill("linear",
                    [0xAAAAFF, 0x3333FF],
                    [100, 100],
                    [127, 255],
                    null, "reflect");
		
		button.graphics.drawPath(commands, data);
		
		button.graphics.endFill();
		button.buttonMode = true;
		return button;
	}
    }
}
