/**
 * Copyright chima ( http://wonderfl.net/user/chima )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ryhw
 */

// forked from set0's flash on 2009-7-8
package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
	
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xffffff)]
    public class FlashTest27 extends Sprite
	{
		private const MAX_SPARK:int = 50;
		private const CIRCLE_D:Number = 360 / MAX_SPARK;
		private const CENTER_X:Number = 30;
		private const CENTER_Y:Number = 30;
		private const COLOR_TRANSFORM:ColorTransform = new ColorTransform(1.2, 1.2, 1.2, 1.0);
		private const BLUR_FILTER:BlurFilter = new BlurFilter(2, 2);
		private const DEST_POINT:Point = new Point(0, 0);
		private const BUFFER_RECT:Rectangle = new Rectangle(0, 0, 465, 465);

		private var spark_list:Array = [];
		private var line_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0xffffff);
		private var screen:Bitmap = new Bitmap(buffer);
		private var old_x_list:Array = [];
		private var old_y_list:Array = [];
		private var count:int = 0;

		public function FlashTest27()
		{
			var init_x:Number = -100;
			var init_y:Number = -100;
			
			for (var i:int = 0; i < MAX_SPARK; i++) {
				spark_list.push(new Spark(init_x, init_y, CIRCLE_D));
				old_x_list[i] = 0;
				old_y_list[i] = 0;
			}
			
			addChild(screen);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function init(e:Event):void
		{
			for (var i:int = 0; i < MAX_SPARK; i++) {
				spark_list[i].flag = 1;
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			var shape:Shape = new Shape();
			var max:int = spark_list.length;
			var target:int;
			
			buffer.lock();
			buffer.applyFilter(buffer, BUFFER_RECT, DEST_POINT, BLUR_FILTER);
			buffer.colorTransform(BUFFER_RECT, COLOR_TRANSFORM);
			
			for (var i:int = 0; i < max; i++) {
				spark_list[i].move(stage.mouseX, stage.mouseY, i, count);
			}
						
			for (i = 0; i < MAX_SPARK; i++) {
				line_list.push(new Line(old_x_list[i], old_y_list[i], spark_list[i].x + CENTER_X, spark_list[i].y + CENTER_Y));
				old_x_list[i] = spark_list[i].x + CENTER_X;
				old_y_list[i] = spark_list[i].y + CENTER_Y;
			}
			
			max = line_list.length;
			for (i = 0; i < max; i++) {
				if (line_list[i].move() === false) {
					line_list.splice(i, 1);
					i--;
					max--;
					continue;
				}

				shape.graphics.lineStyle(8, 0x330000, 1, false, "normal", CapsStyle.ROUND);
				shape.graphics.moveTo(line_list[i].from_x, line_list[i].from_y);
				shape.graphics.lineTo(line_list[i].to_x , line_list[i].to_y);
				
				shape.graphics.lineStyle(1, 0x660000);
				shape.graphics.moveTo(line_list[i].from_x - 3, line_list[i].from_y - 3);
				shape.graphics.lineTo(line_list[i].to_x - 3, line_list[i].to_y - 3);
				shape.filters = [BLUR_FILTER];
			}

			count++;
			
			if (count >= 360) {
				count = 0;
			}
			buffer.draw(shape);
			buffer.unlock();
		}
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

const G:Number = 9.8;
const DT:Number = 0.1;
const MAX_T:Number = 18;
const T_RAD:Number = Math.PI / 180;
const BLUR_FILTER:BlurFilter = new BlurFilter(2, 2);

class Spark
{
	public var x:Number;
	public var y:Number;
	public var tmp_x:Number;
    public var tmp_y:Number;
	public var init_x:Number;
    public var init_y:Number;
	public var d:Number;
	public var flag:uint = 0;
	public var x0:Number;
	public var y0:Number;
	public var vx0:Number;
	public var vy0:Number;
	public var t:Number;
	public var tmp_target_x:Number;
	public var tmp_target_y:Number;
		
    public function Spark(x:int, y:int, d:Number)
    {
		this.d = d;
		this.x = x;
		this.y = y;
		this.tmp_x = x;
		this.tmp_y = y;
		this.init_x = x;
		this.init_y = y;
    }
	
	public function move(x:Number, y:Number, i:int, count:int):Boolean
	{
		var target_x:Number;
		var target_y:Number;
		
		if(this.flag == 0) {
			target_x = x + Math.random() * 80 * (Math.round(Math.random()) * 2 - 1);
			target_y = y + Math.random() * 80 * (Math.round(Math.random()) * 2 - 1);
			
			this.tmp_x += (Math.cos((this.d * i + count * 5) * T_RAD) * 25 + target_x - 30 - this.x) / 100;
			this.tmp_y += (Math.sin((this.d * i + count * 5) * T_RAD) * 25 + target_y - 30 - this.y) / 100;
			this.tmp_x *= 0.92;
			this.tmp_y *= 0.92;
	   
			this.x += this.tmp_x;
			this.y += this.tmp_y;
		
        } else if(this.flag == 1) {
			target_x = -500;
			target_y = -500;
			
			this.x0 = this.x;
			this.y0 = this.y;
			this.vx0 = Math.random() * 10 * (Math.round(Math.random()) * 2 - 1);
			this.vy0 = 0;
			this.t = 0;
			this.tmp_target_x = this.vx0 * MAX_T + this.x0;
			this.tmp_target_y = this.vy0 * MAX_T + 0.5 * G * MAX_T * MAX_T + this.y0
			
			this.flag = 2;
		} else {
			target_x = this.tmp_target_x;
			target_y = this.tmp_target_y;
			
			this.t += DT;
			this.x = this.vx0 * this.t + this.x0;
			this.y = this.vy0 * this.t + 0.5 * G * this.t * this.t + this.y0;
		}
		
		if (target_x >= this.x - 50 && target_x <= this.x + 50 && target_y >= this.y - 50 && target_y <= this.y + 50) {
			this.flag = 0;
			this.t = 0;
		}
	
		return true;
	}
}

class Line
{
	public var life:Number = 40;
	public var from_x:Number;
	public var from_y:Number;
	public var to_x:Number;
	public var to_y:Number;

    public function Line(old_x:Number, old_y:Number, x:Number, y:Number)
    {
		this.from_x = x;
		this.from_y = y;
		this.to_x = old_x;
		this.to_y = old_y;
    }
	
	public function move():Boolean
	{
		this.life--;
		
		if (this.life <= 0) {
			return false;
		}
		
		return true;
	}
}
