/**
 * Copyright ic_yas ( http://wonderfl.net/user/ic_yas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ryIb
 */

// forked from Saqoosha's Pixels
package {
    
    import flash.display.*;
    import flash.events.*;
    //import flash.filters.BlurFilter;
    //import flash.filters.GlowFilter;
    
    //import flash.text.TextField;
    //import flash.utils.getTimer;
    import net.hires.debug.Stats;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    
    
    [SWF(backgroundColor="#000000", frameRate="60", width="475", height="475")]
    
    public class Main extends Sprite {
        private var _stats:Stats;
        public function Main() {
            _stats = new Stats();
            stage.addChild(_stats);
            //inittrace(stage);
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            stage.align = StageAlign.TOP;
            stage.quality = StageQuality.BEST;

            stage.addEventListener(MouseEvent.MOUSE_DOWN, _onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
            addEventListener(Event.ENTER_FRAME,_onEnterFrame);
        }
 
        private function _onMouseDown(e:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _onMouseMove);
            //trace(mouseX);
            addKirakira();
        }
        
        private function _onMouseMove(e:MouseEvent):void {
            addKirakira();
        }
         
        private function _onMouseUp(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, _onMouseMove);
        }
        
        private function _onEnterFrame(e:Event):void{ 
            // _statsを常に最前面に表示しておく
            stage.setChildIndex(_stats,stage.numChildren-1);
        }

        
        private function addKirakira():void{
            var k:Number = 10+rand(5);
            var krkr:Kirakira = new Kirakira(k,k,30+k+rand(20));
            krkr.x = mouseX+rand(25);
            krkr.y = mouseY+rand(25);
            //krkr.rotation = rand(60);
            stage.addChild(krkr);
            var time:Number = 0.2+Math.random()*4;
            var t:ITween = BetweenAS3.tween(
                krkr,
                {rotation: 60, alpha:0, scaleX:0.2, scaleY:0.2},
                {rotation:  0, alpha:1, scaleX:1.0, scaleY:1.0},
                time,
                Cubic.easeOut
            );
            t.onComplete = function():void{
                stage.removeChild(krkr);
            };
            t.play();
            //rotationプロパティ設定してるはずなのに、なぜか回転されない？
        }
        
        //±nの乱数を返す ex: rand(10) -> -10 〜 +10
        private function rand(n:Number):Number{
            return (2*n*Math.random()-n);
        }

    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.display.Sprite;

class Kirakira extends Sprite{
    
    /*
    Kw : Kirakira width
    Kh : Kirakira height
    KStrength : Kirakira strength
    */
    public var Kw:Number; 
    public var Kh:Number;
    public var KStrength:Number;
    
    public function Kirakira(Kw_:Number = 20,Kh_:Number = 20, KStrength_:Number =5) {
        Kw=Kw_;
        Kh=Kh_;
        KStrength = KStrength_;
        
        var sp:Sprite = new Sprite();
        var bmd:BitmapData = new BitmapData(1,1,false,0xFFFFFFFF);
        var bm:Bitmap = new Bitmap(bmd,"never",false);
        var bm2:Bitmap = new Bitmap(bmd,"never",false);
        bm.filters  =[new GlowFilter(0xFFFFFF, 1.0, Kw, 0, KStrength),
                      new BlurFilter(Kw,0)];
        bm2.filters =[new GlowFilter(0xFFFFFF, 1.0, 0, Kh, KStrength),
                      new BlurFilter(0,Kh)];
        sp.addChild(bm);
        sp.addChild(bm2);
        //sp.filters =[new GlowFilter(0xFFFFFF, 1.0, Kw/3, Kh/3, KStrength/3)];
        this.addChild(sp);
    }

}

//以下未使用
///////////////////////////
/////  WONDERFL TRACE /////
///////////////////////////
/*
import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}

*/
