/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ryEg
 */

// forked from sliz's flash on 2010-11-24
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;

    /**
     * 对http://wonderfl.net/c/bPbw做了点改动
     * @author sliz http://game-develop.net/blog/
     */
    public class FlashTest extends Sprite {
        public function FlashTest(){
            w = 200;
            vectormap = new BitmapData(w, w);

            bmpdata = new BitmapData(w, w, false, 0xffffff);
            addChild(new Bitmap(bmpdata));

            stage.addEventListener(Event.ENTER_FRAME, reset);

        }

        private var vectormap:BitmapData;
        private var bmpdata:BitmapData;
        private var oy:int = 0;
        private var w:int;

        private function reset(e:Event):void {
            vectormap.perlinNoise(w * .5, w * .5, 3, 1, false, true, 7, false, [new Point(0, oy++)]);

            bmpdata.fillRect(bmpdata.rect, 1);

            for (var y:int = 0; y < vectormap.height; y++){
                for (var x:int = 0; x < vectormap.width; x++){
                    var px:uint = vectormap.getPixel(x, y);
                    var r:int = px >> 16 & 0x00;
                    var g:int = px >> 8 & 0x00;
                    var b:int = px & 0x00;

                    var tx:int = x + (g / 0x00 - .5) * w;
                    var ty:int = y + (b / 0x00 - .5) * w;

                    if (ty < 0 || ty >= bmpdata.height || tx < 0 || tx >= bmpdata.width)
                        continue;
                    var col:uint = bmpdata.getPixel(tx, ty);
                    col += 0x010101 * (int)(r * .2);
                    if (col > 0x000000)
                        col = 0x000000;
                    bmpdata.setPixel(tx, ty, col);
                }
            }

        }
    }
}