/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rxmK
 */

// forked from ProjectNya's BitmapData.draw() + Bitmap.smoothing
////////////////////////////////////////////////////////////////////////////////
// BitmapData.draw() + Bitmap.smoothing
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.geom.Rectangle;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
     import flash.display.StageQuality;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://farm4.static.flickr.com/3487/";
        private static var filePath:String = "3997481344_c8401a29d5.jpg";
        private var content:Bitmap;
        private var slider:Slider;
        private var wheel:Wheel;
        private var check1:CheckBox;
        private var check2:CheckBox;
        private var scale:Number = 1;
        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        private var smoothing1:Boolean = false;
        private var smoothing2:Boolean = false;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            //stage.quality = StageQuality.LOW;
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(72, 72, 320, 240);
            graphics.endFill();
            //
            var label:Label = new Label(300, 20, 16, Label.CENTER);
            addChild(label);
            label.textColor = 0x333333;
            label.x = 82;
            label.y = 5;
            label.text = "BitmapData.draw() + Bitmap.smoothing";
            //
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
            
            //
            bitmapData = new BitmapData(320, 240, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            bitmap.x = 72;
            bitmap.y = 72;
            bitmap.scrollRect = new Rectangle(0, 0, 320, 240);
            //
            slider = new Slider();
            addChild(slider);
            slider.x = 82;
            slider.y = 350;
            slider.init({label: "scale", width: 200, unit: 0.01, min: 0, max: 1, grid: 10, init: 1});
            slider.addEventListener(CompoEvent.CHANGE, change1, false, 0, true);
            slider.enabled = false;
            //
            wheel = new Wheel();
            addChild(wheel);
            wheel.x = 302;
            wheel.y = 350;
            wheel.init({label: "rotation", zero: 90, angle: 0});
            wheel.addEventListener(CompoEvent.CHANGE, change2, false, 0, true);
            wheel.enabled = false;
            //
            check1 = new CheckBox();
            addChild(check1);
            check1.x = 82;
            check1.y = 320;
            check1.init({label: "BitmapData.draw()", width: 120});
            check1.addEventListener(CompoEvent.CHANGE, change3, false, 0, true);
            check1.enabled = false;
            //
            check2 = new CheckBox();
            addChild(check2);
            check2.x = 247;
            check2.y = 320;
            check2.init({label: "Bitmap.smoothing", width: 110});
            check2.addEventListener(CompoEvent.CHANGE, change4, false, 0, true);
            check2.enabled = false;
        }
        private function complete(evt:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, complete);
            //
            content = Bitmap(loader.content);
            slider.enabled = true;
            wheel.enabled = true;
            check1.enabled = true;
            check2.enabled = true;
            draw();
        }
        
        private var rot:Number = 0;
        private function change1(evt:CompoEvent):void {
            scale = evt.value;
            draw();
        }
        private function change2(evt:CompoEvent):void {
            rot = evt.value;
            draw();
        }
        private function change3(evt:CompoEvent):void {
            smoothing1 = evt.value;
            draw();
        }
        private function change4(evt:CompoEvent):void {
            smoothing2 = evt.value;
            draw();
        }
        private function draw():void {
            if (scale == 0) return;
            var matrix:Matrix = new Matrix();
            matrix.scale(scale, scale);
            matrix.rotate(rot * Math.PI/180);
            bitmapData = new BitmapData(content.width*scale, content.height*scale, true, 0x00000000);
            bitmapData.draw(content.bitmapData, matrix, null, null, null, smoothing1);
            bitmap.bitmapData = bitmapData;
            bitmap.smoothing = smoothing2;
        }
        
    }

}


//////////////////////////////////////////////////
// Sliderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.events.Event;
import flash.events.MouseEvent;

class Slider extends Sprite {
    private var hole:Shape;
    private var line:Sprite;
    private var thumb:Sprite;
    private var light:Shape;
    private var shade:Shape;
    private var base:Shape;
    private var title:TextField;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 100;
    private static var tHeight:uint = 20;
    private static var bHeight:uint = 35;
    private var grid:uint = 5;
    private static var bColor:uint = 0xFFFFFF;
    private static var tColor:uint = 0x666666;
    private static var gColor:uint = 0x999999;
    private static var mColor:uint = 0x333333;
    private static var bgColor:uint = 0x0099FF;
    private static var sColor:uint = 0x000000;
    private static var offColor:uint = 0x999999;
    private var unit:Number = 0.1;
    private var digit:int;
    private var min:Number = 0;
    private var max:Number = 100;
    private var initValue:Number = 0;
    private var blueGlow:GlowFilter;
    private var shadeDrop:DropShadowFilter;
    private var value:Number;
    private var _enabled:Boolean = true;

    public function Slider() {
    }

    public function init(option:Object):void {
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.unit != undefined) unit = option.unit;
        if (option.min != undefined) min = option.min;
        if (option.max != undefined) max = option.max;
        if (option.grid != undefined) grid = option.grid;
        if (option.init != undefined) initValue = option.init;
        digit = - Math.floor(Math.log(unit)*Math.LOG10E);
        draw();
    }
    private function draw():void {
        shadeDrop = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        blueGlow = new GlowFilter(bgColor, 0.6, 5, 5, 2, 3, false, true);
        hole = new Shape();
        line = new Sprite();
        title = new TextField();
        txt = new TextField();
        thumb = new Sprite();
        shade = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(hole);
        addChild(line);
        addChild(title);
        addChild(txt);
        addChild(thumb);
        thumb.addChild(shade);
        thumb.addChild(light);
        thumb.addChild(base);
        hole.y = bHeight;
        createGradientHole(hole, _width, 3);
        line.y = bHeight;
        createGrid(line);
        title.height = tHeight-1;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        //title.embedFonts = true;
        //title.antiAliasType = AntiAliasType.ADVANCED;
        title.textColor = tColor;
        title.autoSize = TextFieldAutoSize.LEFT;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 14;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.text = label;
        txt.x = 25;
        txt.width = 50;
        txt.height = tHeight-1;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 14;
        tfr.align = TextFormatAlign.RIGHT;
        txt.defaultTextFormat = tfr;
        reset();
        thumb.y = bHeight;
        createThumb(shade, 8, 20, 12, sColor);
        shade.filters = [shadeDrop];
        createThumb(light, 8, 20, 12, bgColor);
        light.filters = [blueGlow];
        createThumb(base, 8, 20, 12, bColor);
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        var rect:Rectangle = new Rectangle(0, bHeight, _width, 0);
        thumb.startDrag(false, rect);
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        thumb.addEventListener(Event.ENTER_FRAME, change, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    private function leave(evt:Event):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    private function _up():void {
        light.visible = false;
    }
    private function _over():void {
        light.visible = true;
    }
    private function _down():void {
        light.visible = true;
    }
    private function _off():void {
        light.visible = false;
        txt.textColor = offColor;
    }
    private function change(evt:Event):void {
        _down();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, text);
        dispatchEvent(e);
    }
    private function checkValue():void {
        value = min + thumb.x/_width*(max-min);
        text = value;
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        }
    }
    public function reset():void {
        thumb.x = _width*(initValue-min)/(max-min);
        value = initValue;
        text = value;
    }
    public function get text():Number {
        return Number(txt.text);
    }
    public function set text(param:Number):void {
        value = param;
        txt.text = Number(value.toFixed(digit)).toFixed(digit);
    }
    private function createGrid(target:Sprite):void {
        for (var n:uint = 0; n <= grid; n++) {
            var w:Number = _width/grid;
            if (n == 0 || n == grid*0.5 || n == grid) {
                createGridLine(target, w*n, mColor);
                var _txt:TextField = new TextField();
                target.addChild(_txt);
                _txt.x = w*n - 20;
                _txt.y = 13;
                _txt.width = 40;
                _txt.height = 14;
                _txt.selectable = false;
                //_txt.embedFonts = true;
                //_txt.antiAliasType = AntiAliasType.ADVANCED;
                _txt.textColor = mColor;
                var tfc:TextFormat = new TextFormat();
                tfc.font = fontType;
                tfc.size = 10;
                tfc.align = TextFormatAlign.CENTER;
                _txt.defaultTextFormat = tfc;
                if (n == 0) _txt.text = String(min);
                if (n == grid*0.5) _txt.text = String(min+(max-min)*0.5);
                if (n == grid) _txt.text = String(max);
            } else {
                createGridLine(target, w*n, gColor);
            }
        }
    }
    private function createThumb(target:Shape, w:uint, h:uint, y:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -y, w, h, w);
        target.graphics.endFill();
    }
    private function createGradientHole(target:Shape, w:uint, c:Number):void {
        var colors:Array = [0x000000, 0x000000];
        var alphas:Array = [0.4, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w+c*2, c*2, 0.5*Math.PI, -c, -c);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
    }
    private function createGridLine(target:Sprite, x:uint, color:uint):void {
        target.graphics.lineStyle(0, color);
        target.graphics.moveTo(x, 8);
        target.graphics.lineTo(x, 12);
    }

}


//////////////////////////////////////////////////
// Wheelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class Wheel extends Sprite {
    private var base:Sprite;
    private var thumb:Sprite;
    private var point:Shape;
    private var hit:Shape;
    private var title:TextField;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private static var __width:uint = 90;
    private static var _height:uint = 85;
    private static var tHeight:uint = 20;
    private static var bColor:uint = 0xFFFFFF;
    private static var cColor:uint = 0x999999;
    private static var sColor:uint = 0x000000;
    private static var tColor:uint = 0x666666;
    private static var pColor:uint = 0x666666;
    private static var offColor:uint = 0xCCCCCC;
    private static var cColorTrans:ColorTransform;
    private static var pColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var zero:Number = 0;
    private var angle:Number = 0;
    private var shade:DropShadowFilter;
    private var initValue:Number;
    private var value:Number;
    private var _enabled:Boolean = true;

    public function Wheel() {
    }

    public function init(option:Object):void {
        if (option.label != undefined) label = option.label;
        if (option.zero != undefined) zero = option.zero;
        if (option.angle != undefined) angle = option.angle;
        value = initValue = angle;
        draw();
    }
    private function draw():void {
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false);
        cColorTrans = new ColorTransform();
        cColorTrans.color = cColor;
        pColorTrans = new ColorTransform();
        pColorTrans.color = pColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        base = new Sprite();
        thumb = new Sprite();
        point = new Shape();
        hit = new Shape();
        title = new TextField();
        txt = new TextField();
        addChild(base);
        base.addChild(thumb);
        thumb.addChild(point);
        thumb.addChild(hit);
        addChild(title);
        addChild(txt);
        addChild(thumb);
        base.x = thumb.x = 50;
        base.y = thumb.y = 55;
        createDonut(base, 30, 10);
        base.filters = [shade];
        point.x = 20;
        createCircle(point, 5, bColor, 1);
        hit.x = 20;
        createCircle(hit, 10, bColor, 0);
        title.height = tHeight-1;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        //title.embedFonts = true;
        //title.antiAliasType = AntiAliasType.ADVANCED;
        title.textColor = tColor;
        title.autoSize = TextFieldAutoSize.LEFT;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 14;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.text = label;
        txt.x = 50;
        txt.width = 40;
        txt.height = tHeight-1;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 14;
        tfr.align = TextFormatAlign.RIGHT;
        txt.defaultTextFormat = tfr;
        reset();
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, change, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    private function releaseOutside(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    private function leave(evt:Event):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    private function _up():void {
        point.transform.colorTransform = cColorTrans;
    }
    private function _over():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _down():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _off():void {
        point.transform.colorTransform = offColorTrans;
        txt.textColor = offColor;
    }
    private function change(evt:MouseEvent):void {
        _down();
        thumb.rotation = Math.round(Math.atan2(base.mouseY, base.mouseX)/Math.PI*180);
        evt.updateAfterEvent();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, value);
        dispatchEvent(e);
    }
    private function checkValue():void {
        value = (thumb.rotation + 360 + 90 - zero)%360;
        txt.text = String(value);
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
        }
    }
    public function reset():void {
        value = initValue;
        thumb.rotation = value - 90 + zero;
        txt.text = String(value);
    }
    private function createCircle(target:Shape, r:uint, color:uint, alpha:Number):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawCircle(0, 0, r);
        target.graphics.endFill();
    }
    private function createDonut(target:Sprite, outer:uint, inner:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawCircle(0, 0, outer);
        target.graphics.drawCircle(0, 0, inner);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// CheckBoxクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class CheckBox extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var mark:TextField;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private static var checkmark:String = String.fromCharCode(10003);
    private var checked:Boolean = false;
    private var _enabled:Boolean = true;

    public function CheckBox() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        mark = new TextField();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(mark);
        addChild(txt);
        createBase(shade, _height, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _height, _height, corner, sColor, 0.3);
        createBase(light, _height, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _height, _height, corner, bColor);
        mark.x = 0;
        mark.y = -2;
        mark.width = _height;
        mark.height = _height - 1;
        mark.type = TextFieldType.DYNAMIC;
        mark.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfc:TextFormat = new TextFormat();
        tfc.font = fontType;
        tfc.size = 16;
        tfc.align = TextFormatAlign.CENTER;
        mark.defaultTextFormat = tfc;
        mark.text = checkmark;
        mark.visible = false;
        txt.x = _height + 5;
        txt.y = 1;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.LEFT;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
        checked = !checked;
        if (checked) {
            mark.visible = true;
        } else {
            mark.visible = false;
        }
        dispatchEvent(new CompoEvent(CompoEvent.CHANGE, checked));
    }
    private function _up():void {
        txt.textColor = upColor;
        light.visible = false;
    }
    private function _over():void {
        txt.textColor = overColor;
        light.visible = true;
    }
    private function _down():void {
        txt.textColor = overColor;
        light.visible = true;
    }
    private function _off():void {
        txt.textColor = offColor;
        light.visible = false;
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(0, 0, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
