/**
 * Copyright abtky ( http://wonderfl.net/user/abtky )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rxUe
 */

/*
* SoundMixer.computerSpectrum + DisplacementMapFilter
* 今イチcomputerSpectrumの挙動が掴めない。。
* 
*/
package {
    
    import flash.display.*;
    import flash.events.*;
    import flash.filters.DisplacementMapFilter;
    import flash.media.*;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    public class Main extends Sprite {
        /*
        http://freemusicarchive.org/
        */
        private static const _SOUND_FILE:String = "http://harmonic.me/wonderfl/101009/Michael_Winkle_-_03_-_I_Guess_I_Knew.mp3";
        private static const _CROSS_DOMAIN:String = "http://harmonic.me/crossdomain.xml";
        private static const _WIDTH:int = 465;
        
        private var _filter:DisplacementMapFilter;
        private var _map:SpectrumMap;
        private var _sound:Sound;
        private var _video:Video;
        private var _camera:Camera;
        private var _channel:SoundChannel;
        
        public function Main(){
            addEventListener( Event.ADDED_TO_STAGE , _added );
        }
        
        private function _added( event:Event ):void {
            _camera = Camera.getCamera();
            _video = new Video( _WIDTH , int( _WIDTH * .75 ) );
            _video.attachCamera( _camera );
            _video.x = ( stage.stageWidth - _WIDTH ) * .5;
            _video.y = ( stage.stageHeight - _video.height ) * .5;
            _camera.addEventListener( ActivityEvent.ACTIVITY, _activity );
            
            addChild( _video );
        }
        
        private function _activity( event:ActivityEvent ):void {
            _camera.removeEventListener( ActivityEvent.ACTIVITY, _activity );
            Security.loadPolicyFile( _CROSS_DOMAIN );
            var req:URLRequest = new URLRequest( _SOUND_FILE );
            _sound = new Sound();
            _sound.load( req , new SoundLoaderContext( 0 , true ) );
            _map = new SpectrumMap( _video.width , _video.height );
            
            _filter = new DisplacementMapFilter();
            _filter.componentX = BitmapDataChannel.BLUE;
            _filter.mapBitmap = _map;
            
            _channel = _sound.play();
            _channel.addEventListener( Event.SOUND_COMPLETE , _complete );
            addEventListener( Event.ENTER_FRAME , _loop );
        }
        
        private function _loop( event:Event ):void {
            _map.update();
            _filter.scaleX = int( 40 / _map.volume );
            if( _map.diff > 0.1 ){
                _video.x += _video.scaleX * _video.width;
                _video.scaleX = -_video.scaleX;
            }
            _video.filters = [ _filter ];
            _filter.mapBitmap = _map;
        }
        
        private function _complete( event:Event ):void {
            _sound.play();
        }
    }
}
import flash.display.BitmapData;
import flash.filters.BlurFilter;
import flash.geom.*;
import flash.media.SoundMixer;
import flash.utils.ByteArray;

class SpectrumMap extends BitmapData {
    
    private var _lineRect:Rectangle;
    private var _fillRect:Rectangle;
    private var _point:Point;
    private var _bmd:BitmapData;
    private var _filter:BlurFilter;
    private var _volume:Number;
    private var _maximum:int;
    public function get volume():Number{ 
        return _volume;
    };
    private var _diff:Number = 0;
    public function get diff():Number{ 
        return _diff;
    };
    
    public function SpectrumMap( width:int , height:int ){
        super( width , height , true , 0x0 );
        _maximum = 0;
        _fillRect = new Rectangle( 0, 0, width , height );
        _lineRect = new Rectangle( 0, 0, width , 1 );
        _point = new Point( 0,0 );
        _filter = new BlurFilter( 0 , 8 , 4 );
        
        fillRect( _fillRect , 0xFF000000 );
        _volume = 0;
        lock();
    }
    public function update():void{
        var bytes:ByteArray = new ByteArray();
        SoundMixer.computeSpectrum( bytes , true , 0 );
        var quotient:int = int( bytes.length / height ) / 2;
        var sum:int = 0;
        var n:int = height;
        for( var i:int = 0 ; i < n ; i++ ){
            var value:int = ( bytes[ i * quotient ] ) * .5;
            if( value > _maximum ){ _maximum = value; }
            sum += value;
            _lineRect.y = i;
            fillRect( _lineRect , 0xFF000080 + value );
        }
        applyFilter( this , _fillRect , _point , _filter );
        var newValue:Number = sum / 0x80 / n;
        _diff = Math.abs( _volume - newValue );
        _volume = newValue;
    }
}
