/**
 * Copyright heart_thai ( http://wonderfl.net/user/heart_thai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rx9o
 */

// forked from Event's Human Clock
package {
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.display.Sprite;
    
    public class HumanClock extends Sprite {
        
        private var h:HandNumber;
        private var m:HandNumber;
        private var s:HandNumber;
        private var cnt:int = 0;
        
        public function HumanClock() {
             Wonderfl.capture_delay(30); 
            initView();
        }
        
        private function initView():void {
            h = new HandNumber();
            m = new HandNumber();
            s = new HandNumber();
            h.addEventListener( Event.COMPLETE , countComplete );
            s.addEventListener( Event.COMPLETE , countComplete )
            m.addEventListener( Event.COMPLETE , countComplete )
        }
        private function countComplete(e:Event):void{
            if(++cnt == 3){
                addChild( h );
               addChild(m);
               addChild(s);
               
               h.scaleX = h.scaleY = 0.5;
               m.scaleX = m.scaleY = 0.5;
               s.scaleX = s.scaleY = 0.3;
               
               h.y = 90;
               m.y = 90;
               s.y = 120;
               m.x = 180;
               s.x = 350;
            
                var timer:Timer = new Timer(100);
                timer.addEventListener(TimerEvent.TIMER, onTimer);
                timer.start();   
            }

        }

        
        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            h.setNumber(time.getHours());
            m.setNumber( time.getMinutes());
            s.setNumber(time.getSeconds());
        }
        
    }
}
import flash.net.URLRequest;
//==================Hand Number
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.events.Event;
import flash.system.Security;
import flash.display.BitmapData;
class HandNumber extends Sprite{
       
    private var img:Vector.<BitmapData>;
    private var count:int = 0;
    private var digit0:Bitmap;
    private var digit1:Bitmap;
    
    public function HandNumber(){
       
        Security.loadPolicyFile("http://www.howdoflash.net/crossdomain.xml");
        img = new Vector.<BitmapData>();
       loadImage();
    }
    private function loadImage():void{
        var ld:Loader = new Loader();
        ld.contentLoaderInfo.addEventListener(Event.COMPLETE , loaded );
        ld.load( new URLRequest("http://www.howdoflash.net/hand/"+(count++)+".png") );
    }
    public function setNumber(n:int):void{
        digit0.bitmapData = null;
        digit1.bitmapData = null;
        
        if(n < 10){
           digit0.bitmapData = img[0];
           digit1.bitmapData = img[n];
        }else{
           digit0.bitmapData = img[ Math.floor(n/10) ];
           digit1.bitmapData = img[ n%10 ]; 
        }
 


    }

    private function loaded(e:Event):void{ 
    e.target.content.smoothing = true;
        img.push( e.target.content.bitmapData as BitmapData );
        if(count==10){
            digit0 = new Bitmap();
            digit1 = new Bitmap();
            addChild(digit0);
            addChild(digit1);
            digit1.x = 150;
            
            dispatchEvent( new Event(Event.COMPLETE) )
            return;            
        }
        loadImage();
    }

}

//==============