/**
 * Copyright wondermame ( http://wonderfl.net/user/wondermame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rx2A
 */

package {
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.display.Sprite;
  import flash.display.Graphics;

  public class main extends Sprite {
    private var map:Object = new Object();
    private var size:int = 0;
    private var count:int;
    private var prev_scale:Number, current_scale:Number;

    public function main() {
      stage.align = "TL";
      stage.scaleMode = "noScale";
      scaleX = stage.stageWidth / 5;

      var i:int;
      for (i = 0; i < 7; i++) extend();

      addChild(new Ball(0, 0, 0, 0, split));
      map["0,0"] = true;

      addEventListener(Event.ENTER_FRAME, animate);
    }

    private function split(x:int, y:int, b:Ball):void {
      var id0:String = "" + x + "," + y;
      var id1:String = "" + (x + 1) + "," + y;
      var id2:String = "" + x + "," + (y + 1);

      if (map[id1] == null && map[id2] == null) {
        delete map[id0];
        map[id1] = map[id2] = true;
        if (x + 2 == size || y + 2 == size) extend();
        removeChild(b);
        addChild(new Ball(x + 1, y, 1, 0, split));
        addChild(new Ball(x, y + 1, 0, 1, split));
      }
      else {
        b.flutter(map[id1] ? 1 : 0, map[id2] ? 1 : 0);
      }
    }

    private function extend():void {
      var i:int;
      for (i = 0; i < size; i++) {
        addChild(new Cell(size, i));
        addChild(new Cell(i, size));
      }
      addChild(new Cell(size, size));
      size++;
      
      var sw:int = stage.stageWidth;
      var sh:int = stage.stageHeight;
      prev_scale = scaleX;
      current_scale = (sw < sh ? sw : sh) / (size - 0.5);
      count = 4;
    }

    private function animate(e:Event):void {
      if (count >= 0) {
        var scale:Number;
        scale = current_scale + (prev_scale - current_scale) * count / 4;
        scaleX = scaleY = scale;
        count--;
      }
    }
  }
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.Sprite;
import flash.display.Graphics;

class Cell extends Sprite {
  public function Cell(_x:int, _y:int) {
    var g:Graphics = this.graphics;
    x = _x;
    y = _y;
    g.beginFill(0xffffff);
    g.drawRect(0, 0, 1, 1);
    g.endFill();
    g.beginFill(_x + _y <= 2 ? 0x3333cc : 0x333333);
    g.drawRect(0.1, 0.1, 0.9, 0.9);
    g.endFill();
  }
}

class Ball extends Sprite {
  private var lx:int, ly:int, dx:int, dy:int;
  private var split:Function;
  private var count:int;
  private var fluttering:Boolean = false;

  public function Ball(_lx:int, _ly:int, _dx:int, _dy:int, _split:Function) {
    lx = _lx; dx = _dx; x = lx - dx;
    ly = _ly; dy = _dy; y = ly - dy;
    split = _split; count = 4;

    var g:Graphics = this.graphics;
    g.beginFill(0xffff66);
    g.drawCircle(0.55, 0.55, 0.4);
    g.endFill();

    addEventListener(Event.ENTER_FRAME, animate);
    addEventListener(MouseEvent.CLICK, on_click);
    buttonMode = true;
    useHandCursor = true;
  }

  public function flutter(_dx:int, _dy:int):void {
    count = 8;
    dx = _dx; dy = _dy;
    fluttering = true;
    addEventListener(Event.ENTER_FRAME, animate);
  }

  private function on_click(e:MouseEvent):void {
    split(lx, ly, this);
  }

  private function animate(e:Event):void {
    if (fluttering) {
      var s1:Number = (4 - Math.abs(4 - count)) / 8;
      var s2:Number = count * count / 128;
      x = lx + dx * s1 / 8 + (Math.random() - 0.5) * s2;
      y = ly + dy * s1 / 8 + (Math.random() - 0.5) * s2;
    }
    else {
      x = lx - dx * count * count / 16;
      y = ly - dy * count * count / 16;
    }
    if (count-- == 0) {
      removeEventListener(Event.ENTER_FRAME, animate);
    }
  }
}