/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rx11
 */

// forked from Nicolas's アップロードした画像はBitmap化できない？
// forked from Nicolas's Wonderflで使いたい画像を簡単にアップロード
//Wonderflでの画像アップロードテスト
//bitmap化できない…
/**
 * あつかましい解説シリーズ。
 *
 * Flashのセキュリティーポリシーにより
 * ロードしたコンテンツに対するBitmapインスタンスのdrawメソッドは、
 *「ロードされたメディアへのデータとしてのアクセス」と見なされます。
 * 以下参照
 * http://help.adobe.com/ja_JP/ActionScript/3.0_ProgrammingAS3/WS5b3ccc516d4fbf351e63e3d118a9b90204-7d23.html
 * 
 * このとき、ロード元のコンテンツを配信しているドメイン(今回はswf.wonderfl.net)と、
 * ロードしたコンテンツを配信しているドメイン(wonderfl.net)が別の場合は
 * ロードしたコンテンツにポリシーファイルが必要となります。
 * 
 * 例えば、wonderfl.net/crossdomain.xmlに
 * <allow-access-from domain="swf.wonderfl.net" />
 * が含まれている必要がありますが、存在しない為
 * Bitmapインスタンスのdrawメソッドが失敗しています。
 * 
 * ただし、現在は対応済みっぽいです。
 * http://wonderfl.net/code/72480f4fd725547130314ba3b29dde496a574965
 * 
 * 現在は、アップロードしたファイルはassets.wonderfl.netドメインに
 * 置かれるようです。
 * http://assets.wonderfl.net/crossdomain.xmlをみると
 * 許可されているのが分かりますね。
 *
 * なおローカルの、Security.sandboxType:　localTrustedの状況では
 * ポリシーファイルは必要ないのでローカルだと動くことになります。
 * 
 * 稚拙で恐縮ですが、ポリシーファイルに関してこちらにまとめてあります。
 * http://fla.la/archives/64
 *
 * なんか、偉そうに解説してますが、間違っていたら教えて下さい！＞＜
 */
 
package {
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    public class FlashTest extends Sprite {
        public var bmp:Bitmap;
        public var bmd:BitmapData;
        public var loader:Loader;

        public function FlashTest() {
            var txtField:TextField = new TextField();
            txtField.width = 465;
            txtField.height = 0;
            txtField.autoSize = TextFieldAutoSize.LEFT;
            txtField.wordWrap = true;
            txtField.text = "Security.sandboxType:" + Security.sandboxType + "\n";
            
            
            // swfはどこにあるのかな？
            txtField.appendText("swf:" + loaderInfo.url + "\n");
            addChild(txtField);
            
            //　取得したい画像だよ
            var url:String = "http://wonderfl.net/static/tmp/related_images/7631be20fea2b992f1193ca6319abfc716fe388am"
            
            //後は普通に。
            var urlReq:URLRequest = new URLRequest(url);
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(event:Event):void
            {
                txtField.appendText("loader:" + loader.contentLoaderInfo.url + "\n\n");
                
                //Bitmap化して表示したいができない
                bmp = new Bitmap();
                bmd = new BitmapData(100, 100, true, 0x000000);
                try
                {
                    bmd.draw(loader); 
                }
                catch (error:SecurityError)
                {
                    txtField.appendText(error.message);
                }
                bmp.bitmapData = bmd;
                bmp.y = txtField.height;
                addChild(bmp);
            });
            // Loaderインスタンスのloadメソッドは基本、「コンテンツのロード」
            // として扱われるのでポリシーファイルを明示的に読み込む為に、
            // 第二引数にポリシーファイルの読み込みをtrueにした
            // LoaderContextインスタンスを指定する
            loader.load(urlReq, new LoaderContext(true));
            //addChild(loader);
            
            
        }
   }
}