/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rwtk
 */

// forked from siouxcitizen's 前回ソースから散るサクラをハート型に変更してみました
//
//前回ソースの散る葉をサクラから楓＆紅葉に変更してみました
//
//以下コードを参考にさせていただきました
//
//かえで
//http://wonderfl.net/c/djMk/read
//↑使用している楓＆紅葉画像は上記コードからのものを使用させていただきました
//
//前回ソースからキャプチャ機能つけてエディターっぽいものに戻しました
//http://wonderfl.net/c/tbWc
//↑自分の前につくったコードの画像読み込み部分も参考にしました
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.filters.GlowFilter;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;

    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#66CCFF")]
 
    public class MoviePlane extends Sprite
    {
        private var container : Sprite;
        private var viewport  : Viewport3D;
        private var scene     : Scene3D;
        private var camera    : Camera3D;
        private var renderer  : BasicRenderEngine;

        private var pixelArr        :Array  = [];     // パーティクルを格納する配列
        private const PIXEL_NUM : int = 5;     // 縦・横のピクセル数
        private const PLANE_SIZE : int = 200;//Planeオブジェクト1辺の長さ
        private const PLANE_SEGMENT   : int = 1;  //面の分割数

        private var filterList : Array;
        private var loader : Loader;
        private var bmp : Bitmap;
        private var bmd : BitmapData;
        private var imgLoadingCount : int = 0;    //読み込んだ画像数
        private var images : Array;    // 読み込んだBitmap画像保持用配列
        private const IMAGE_URL:Array =
        [
            "http://assets.wonderfl.net/images/related_images/2/2b/2b27/2b2786cdf19f4c69bf6ab81fe1f2b144eab834f7", //furl
            "http://assets.wonderfl.net/images/related_images/e/e5/e541/e54190ff73f718a4fac555ddde64b0d7fcf396c0"  //burl
        ]; //Bitmap画像URL配列

        //MoviePlaneクラスのコンストラクタ
        public function MoviePlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x333333;

            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //フィルターの準備
            filterList = new Array();
            var glowFilter : GlowFilter = new GlowFilter(0xFFFFFF, 1, 32, 32, 2, 1, false, false); 
            filterList.push(glowFilter);

            //画像を読み込んで3DPlaneオブジェクトに貼り付け
            images = new Array(IMAGE_URL.length);
            for (var i:int = 0; i < IMAGE_URL.length; i++) {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImgLoadingComplete);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }

            //カメラ設定
            camera = new Camera3D();
            camera.x = PLANE_SIZE * (PIXEL_NUM / 2);
            camera.y = 1000;
            camera.z = -PLANE_SIZE;
            camera.focus = 50;
            camera.zoom = 1;
 
            //フレーム毎の処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, _enterframe);
        }
        private function onImgLoadingComplete(e:Event):void {
            bmp = new Bitmap();
            bmd = new BitmapData(e.currentTarget.loader.width, e.currentTarget.loader.height, true, 0x000000)
            bmd.draw(e.currentTarget.loader);
            bmp.bitmapData = bmd;
            images[e.currentTarget.loader.name] = bmp;           
            if (++imgLoadingCount == IMAGE_URL.length) initPlaneWithBitmap();
        }
        //3DPlaneオブジェクトに紅葉画像を貼りつけ
        private function initPlaneWithBitmap():void { 
            var imgIndex : int = 0;
            pixelArr = [];
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                pixelArr[i] = [];
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    // Planeインスタンスを作成して画像をテクスチャとして貼りつけ
                    imgIndex = Math.random() * IMAGE_URL.length;
                    var textureBitmap:Bitmap = images[imgIndex];
                    var textureMaterial : BitmapMaterial = new BitmapMaterial(textureBitmap.bitmapData, true);
                    textureMaterial.doubleSided = true;

                    var o:Plane = new Plane(textureMaterial, PLANE_SIZE, PLANE_SIZE, PLANE_SEGMENT, PLANE_SEGMENT);
                    o.useOwnContainer = true; //フィルター使用のために設定
                    o.filters = filterList; //フィルター使用のために設定
                    scene.addChild(o);
                    pixelArr[i][j] = o;
                    
                    // 座標
                    o.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    o.y = Math.random()*5000;
                    o.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                }
            }

            //imgLoadingState = true;
            //if (imgLoadingState&&daeLoadingState) dispTitleScrnStartBtn();
        }

        //フレーム毎の処理
        private function _enterframe(e:Event):void{
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    var p:DisplayObject3D = pixelArr[i][j];
                    if (p.y > 0) {
                        p.rotationX += Math.random() * 10; 
                        p.rotationY += Math.random() * 10;
                        //p.y -= 10;
                        //p.y -= Math.random() * 10; 
                        p.y -= (Math.random() * 20 + 1) - (180 - (p.rotationX % 180)) * .008;
                    } else {
                        p.x = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                        p.y = Math.random()*5000;
                        p.z = Math.random()*(PIXEL_NUM*PLANE_SIZE);
                    }
                }
            }
            renderer.renderScene(scene, camera, viewport);
        }
    }
}
