/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rwce
 */

// forked from elmortem's forked from: Tab Component for MinimalComps
// forked from imajuk's Tab Component for MinimalComps
package
{
    import flash.events.MouseEvent;
    import com.bit101.components.Label;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;

    import flash.display.Sprite;

    /**
     * MinimalCompsにTabってないですね。
     * 個人的に必要だったのでやっつけで作ってみました。
     * 
     * @author imajuk
     */
    public class MinimalCompsTabTest extends Sprite
    {
        private var tab:Tab;
        
        public function MinimalCompsTabTest()
        {
            tab = new Tab(this, 70, 120);
            tab.width = 300;
            tab.height = 200;

            //to add new page.
            var a:Panel = new Panel();
            new Label(a, 0, 0, "Hellow World!");
            tab.addPage("A", a);
            
            //to add a blank page.
            tab.addPage("B");
            
            //to add a blank page.
            tab.addPage("Test 1");
            tab.addPage("Test 2");
            tab.addPage("Test 3");
            tab.addPage("Test 4");
            tab.addPage("Test 6");
            
            
            //to add a element to a page.
            tab.addChildToPage(1, new Label(null, 0, 0, "Foo Bar"));
            tab.addChildToPage(4, new Label(null, 0, 0, "Test 3 Text!"));
            
            var vBox:VBox = new VBox();
            addChild(vBox);
            
            var btn:PushButton = new PushButton(null, 0, 0, "Add");
            vBox.addChildAt(btn, 0);
            btn.addEventListener(MouseEvent.CLICK, onAddClick);
            
            btn = new PushButton(null, 0, 0, "Remove");
            vBox.addChildAt(btn, 1);
            btn.addEventListener(MouseEvent.CLICK, onRemoveClick);
        }
        
        private function onRemoveClick(event:MouseEvent):void
        {
            tab.removePage(0);
        }
        private function onAddClick(event:MouseEvent):void
        {
            tab.addPage("Tab "+int(Math.random()*100));
        }

    }
}

import com.bit101.components.Component;
import com.bit101.components.Label;
import com.bit101.components.Panel;

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.ColorMatrixFilter;

[Event(name="select", type="flash.events.Event")]
class Tab extends Component
{
    protected var _color:int = -1;
    protected var _shadow:Boolean = true;
    protected var _draggable:Boolean = false;
    protected var _tabs : Array;
    protected var _contents : Array;
    protected var _labels : Array;
    protected var _labelTexts : Array;
    protected var _current : int = 0;
    protected var _darkness : ColorMatrixFilter = 
                                new ColorMatrixFilter([
                                    1, 0, 0, 0, -10, 
                                    0, 1, 0, 0, -10, 
                                    0, 0, 1, 0, -10, 
                                    0, 0, 0, 1, 0
                                ]);

    
    /**
     * Constructor
     * @param parent The parent DisplayObjectContainer on which to add this Panel.
     * @param xpos The x position to place this component.
     * @param ypos The y position to place this component.
     */
    public function Tab(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0)
    {
        super(parent, xpos, ypos);
    }
    
    /**
     * Initializes the component.
     */
    override protected function init():void
    {
        super.init();
        setSize(100, 100);
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    override protected function addChildren():void
    {
        _tabs = [];
        _contents = [];
        _labels = [];
        _labelTexts = [];
        
        filters = [getShadow(4, false)];
    }

    
    ///////////////////////////////////
    // public methods
    ///////////////////////////////////
    
    /**
     * Overridden to add new child to current content.
     */
    public override function addChild(child:DisplayObject):DisplayObject
    {
        getContent(_current).addChild(child);
        return child;
    }
    
    /**
     * Access to super.addChild
     */
    public function addRawChild(child:DisplayObject):DisplayObject
    {
        super.addChild(child);
        return child;
    }
    
    /**
     * add new page
     * @param label a label text of the page.
     * @param panel new page. if it's omitted a Panel object will be created automatically for new page.
     */
    public function addPage(label : String, panel : Panel = null) : int
    {
        var tab : Panel = new Panel();
        tab.filters = [];
        tab.buttonMode = true;
        tab.useHandCursor = true;
        tab.mouseChildren = false;
        tab.addEventListener(MouseEvent.MOUSE_DOWN, onMouseGoDown);
        tab.height = 20;
        tab.tag = _tabs.length;
        super.addChild(tab);

        _labels.push(new Label(tab.content, 5, 1, label));
        _labelTexts.push(label);
        _tabs.push(tab);
        
        if (!panel) panel = new Panel();
        panel.y = 20;
        _contents.push(panel);
        
        invalidate();
        
        return tab.tag; 
    }
    
    public function removePage(index:int):void {
        //trace("Removing "+index+" tab.");
        
        if(_contents[index].parent) {
            _contents[index].parent.removeChild(_contents[index]);
        }
        super.removeChild(_tabs[index]);
        
        _contents.splice(index, 1);
        
        _tabs[index].removeEventListener(MouseEvent.MOUSE_DOWN, onMouseGoDown);
        _tabs.splice(index, 1);
        _labelTexts.splice(index, 1);
        _labels.splice(index, 1);
        
        for(var i:int = 0; i < _tabs.length; i++) _tabs[i].tag = i;
        
        if(_current >= index) _current--;
        if(_current < 0) _current = 0;
        
        invalidate();
    }


    /**
     * add new element to a page.
     * @param   index 0 base index of pages.
     * @param   child element you want to add to.
     * @return  added element.
     */
    public function addChildToPage(index : int, child : DisplayObject) : DisplayObject
    {
        getContent(index).addChild(child);
        return child;
    }
    
    
    /**
     * Draws the visual ui of the component.
     */
    override public function draw():void
    {
        super.draw();
        
        _labels.forEach(function(label : Label, idx : int, ...param) : void
        {
            label.text = _labelTexts[idx];
            label.alpha = idx == _current ? 1 : .4;
        });
        var w:Number = (_width-10) / _tabs.length;
        _tabs.forEach(function(tab : Panel, idx : int, ...param) : void
        {
            tab.x = 5 + idx * w;
            tab.width = w;
            tab.color = _color;
            tab.filters = idx == _current ? [] : [_darkness];
            tab.draw();
        });
        _contents.forEach(function(content : Panel, ...param) : void
        {
            content.color = _color;
            content.setSize(_width, _height - 20);
            content.draw();
            if (content.parent)
                content.parent.removeChild(content);
        });
        super.addChild(_contents[_current]);
        
    }


    ///////////////////////////////////
    // event handlers
    ///////////////////////////////////
    
    /**
     * Internal mouseDown handler. Starts a drag.
     * @param event The MouseEvent passed by the system.
     */
    protected function onMouseGoDown(event:MouseEvent):void
    {
        if(_draggable)
        {
            this.startDrag();
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseGoUp);
            parent.addChild(this); // move to top
        }
        var tab:Panel = event.target as Panel;
        if (tab)
        {
            super.addChild(tab);
            _current = tab.tag; 
            invalidate();
        }
        dispatchEvent(new Event(Event.SELECT));
    }
    
    /**
     * Internal mouseUp handler. Stops the drag.
     * @param event The MouseEvent passed by the system.
     */
    protected function onMouseGoUp(event:MouseEvent):void
    {
        this.stopDrag();
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseGoUp);
    }
    
    ///////////////////////////////////
    // getter/setters
    ///////////////////////////////////
    
    /**
     * Gets / sets whether or not this Window will have a drop shadow.
     */
    public function set shadow(b:Boolean):void
    {
        _shadow = b;
        if(_shadow)
        {
            filters = [getShadow(4, false)];
        }
        else
        {
            filters = [];
        }
    }
    public function get shadow():Boolean
    {
        return _shadow;
    }
    
    /**
     * Gets / sets the background color of this panel.
     */
    public function set color(c:int):void
    {
        _color = c;
        invalidate();
    }
    public function get color():int
    {
        return _color;
    }
    
    /**
     * Current container for content added to this panel. This is just a reference to the content of the internal Panel, which is masked, so best to add children to content, rather than directly to the window.
     */
    public function get content():DisplayObjectContainer
    {
        return getContent(_current);
    }
    
    /**
     * Container for content added to this panel. This is just a reference to the content of the internal Panel, which is masked, so best to add children to content, rather than directly to the window.
     */
    public function getContent(index:int):DisplayObjectContainer
    {
        return Panel(_contents[index]).content;
    }
    
    /**
     * Sets / gets whether or not the window will be draggable by the title bar.
     */
    public function set draggable(b:Boolean):void
    {
        _draggable = b;
        _tabs.forEach(function(tab : Panel, ...param) : void
        {
            tab.buttonMode = _draggable;
            tab.useHandCursor = _draggable;
        });
    }
    
    public function get draggable():Boolean
    {
        return _draggable;
    }

    /**
     * gets index of current active page.
     */
    public function get current() : int
    {
        return _current;
    }
}
