/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rwbs
 */

package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;


      [SWF (backgroundColor=0x666666)]
      

       public class Bez extends MovieClip {
		private var verts:Vector.<Number>;
		private var tVerts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var cmds:Vector.<int>;
		private var igraph:Vector.<IGraphicsData>;
		private var tVect:Vector3D;
		private var m:Matrix3D;
		private var perspective:PerspectiveProjection;
		private var trans:Matrix3D;
		private var proj:Matrix3D;
		private var dx:Number;
		private var dy:Number;


               public function Bez(){
                  // init
			x = stage.stageWidth / 2;
			y = stage.stageHeight / 2;
			verts  = new Vector.<Number>();
			tVerts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			uvts = new Vector.<Number>();
			cmds = new Vector.<int>();
			
			igraph = new Vector.<IGraphicsData>();
			
			tVect = new Vector3D();
			m = new Matrix3D();
			for (var i:int = 0; i<200; i++){
				for (var j:int = 0; j<3; j++){
					tVect.x = Math.random() * 0.15;
					m.identity();
					m.appendRotation(Math.random()*360, Vector3D.X_AXIS);
					m.appendRotation(Math.random()*360, Vector3D.Y_AXIS);
					m.appendRotation(Math.random()*360, Vector3D.Z_AXIS);
					tVect = m.transformVector(tVect);
				    verts.push(tVect.x, tVect.y, tVect.z);
				}
				
				
				cmds.push(1);
				cmds.push(3);
				var stroke:GraphicsStroke = new GraphicsStroke();
				
				var col:int = [0xFFFFFF, 0x000000, 0xFFCC00, 0xFF0000][int(Math.random() * 4)];
				
			    stroke.thickness = 2+(Math.random()*Math.random())*8;
				var mg:Matrix = new Matrix();
				mg.createGradientBox(350+Math.random()*20-10, 350+Math.random()*20-10, 0, -270+i/2,-240+i/2);
				stroke.fill = new GraphicsGradientFill(GradientType.RADIAL, [0xFFFFFF,0x444444], [1, 1], [30, 255], mg);
			
				var bez:GraphicsPath = new GraphicsPath();
				bez.commands = Vector.<int>([1, 3]);
				igraph.push(stroke);
			    igraph.push(bez);
			}
			
			perspective = new PerspectiveProjection();
			perspective.fieldOfView = 45;
			trans = new Matrix3D();
			proj = perspective.toMatrix3D();
			dx = 0, dy = 0;
			
			addEventListener(Event.ENTER_FRAME, onLoop);
			
				 
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			dx += (mouseX - dx) / 4;
			dy += (mouseY - dy) / 4;
			   
			trans.identity();
			trans.appendRotation(dy, Vector3D.X_AXIS);
			trans.appendRotation(dx, Vector3D.Y_AXIS);
			trans.appendTranslation(0,0,0.5);
			trans.transformVectors(verts, tVerts);
			Utils3D.projectVectors(proj, tVerts, pVerts, uvts);
			
			var inc:int = 0;
			for (var i:int = 1; i<igraph.length; i+=2){
				GraphicsPath(igraph[i]).data = pVerts.slice(inc, inc + 6);
				inc += 6;
			}
			 
			graphics.clear();
			graphics.drawGraphicsData(igraph);
		}
		

       }

}