/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rwCf
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        private var length: Number = 50;
        
        private var path: Array;
        
        private function degreesToRadians(degrees: Number): Number {
            return degrees * Math.PI / 180;
        }
        
        public function FlashTest() {
            // write as3 code here..
            
            x = stage.stageWidth / 4;
            y = stage.stageHeight / 2;
            
            addEventListener(Event.ENTER_FRAME, nextFrame);
        }
        
        private function nextFrame(event: Event): void {
            
            var point1: Object = {x:              0, y:       0};
            var point2: Object = {x:     length / 4, y:       0};
            var point3: Object = {x:         mouseX, y: -mouseY};
            var point4: Object = {x: length * 3 / 4, y:       0};
            var point5: Object = {x:         length, y:       0};
            
            
            path = [];
            path.push({radians: Math.atan2(point2.y - point1.y, point2.x - point1.x), x: point1.x, y: point1.y});
            path.push({radians: Math.atan2(point2.y - point1.y, point2.x - point1.x), x: point2.x, y: point2.y});
            path.push({radians: Math.atan2(point3.y - point2.y, point3.x - point2.x), x: point2.x, y: point2.y});
            path.push({radians: Math.atan2(point3.y - point2.y, point3.x - point2.x), x: point3.x, y: point3.y});
            path.push({radians: Math.atan2(point4.y - point3.y, point4.x - point3.x), x: point3.x, y: point3.y});
            path.push({radians: Math.atan2(point4.y - point3.y, point4.x - point3.x), x: point4.x, y: point4.y});
            path.push({radians: Math.atan2(point5.y - point4.y, point5.x - point4.x), x: point4.x, y: point4.y});
            path.push({radians: Math.atan2(point5.y - point4.y, point5.x - point4.x), x: point5.x, y: point5.y});
            var index: int = 0;
            while(path.length < 2000) {
                var start: Object = path[index];
                var end: Object = path[index + 1];
                var offset: Object = {x: end.x - start.x, y: end.y - start.y};
                var distance: Number = Math.sqrt(offset.x * offset.x + offset.y * offset.y);
                var angle: Number = end.radians - start.radians;
                while (angle > Math.PI) angle -= 2 * Math.PI;
                while (angle < -Math.PI) angle += 2 * Math.PI;
                var steps: int = Math.max(1, Math.ceil(Math.abs(angle) / degreesToRadians(2)));
                
                for (var i: int = 0; i <= steps; i++) {
                    var progress: Number = i / steps;
                    var rearWheelPos: Object = {x: start.x + offset.x * progress, y: start.y + offset.y * progress};
                    var currentAngle: Number = start.radians + angle * progress;
                    var frontWheelVelocity: Object = {x: offset.x / steps - length * angle * Math.sin(currentAngle), y: offset.y / steps + length * angle * Math.cos(currentAngle)};
                    
                    path.push({radians: Math.atan2(frontWheelVelocity.y, frontWheelVelocity.x), x: rearWheelPos.x + length * Math.cos(currentAngle), y: rearWheelPos.y + length * Math.sin(currentAngle)});
                }
                index++;
            }
            
            graphics.clear();
            
            graphics.lineStyle(0, 0xbbbbbb);
            graphics.moveTo(0, 100);
            graphics.lineTo(0, -100);
            graphics.moveTo(length, 100);
            graphics.lineTo(length, -100);
            graphics.moveTo(length * 2, 100);
            graphics.lineTo(length * 2, -100);
            graphics.lineStyle();
            
            graphics.lineStyle(0, 0x0000ff);
            graphics.moveTo(0, 0);
            for each (var point: Object in path) {
                graphics.lineTo(point.x, -point.y);
            }
            graphics.lineStyle();
            
            /*
            graphics.lineStyle(0);
            graphics.moveTo(0, 0);
            graphics.lineTo(10, 0);
            graphics.lineStyle();
            */
        }
    }
}